/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.frameworks.react.ReactAttributeDescriptor;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.html.dtd.HtmlAttributeDescriptorImpl;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactAttributeDescriptorImpl
extends BasicXmlAttributeDescriptor
implements ReactAttributeDescriptor {
    private final String myAttributeName;
    @Nullable
    private final PsiElement myDeclaration;
    @Nullable
    private final JSType myType;
    private final boolean myForceOptional;

    private ReactAttributeDescriptorImpl(String attributeName, @Nullable PsiElement declaration, @Nullable JSType type, boolean forceOptional) {
        this.myAttributeName = attributeName;
        this.myDeclaration = declaration;
        this.myType = type;
        this.myForceOptional = forceOptional;
    }

    @Override
    @Nullable
    public JSType getValueType() {
        return this.myType;
    }

    @NotNull
    public static XmlAttributeDescriptor create(@NotNull String name, @Nullable PsiElement declaration, @Nullable JSType type, boolean forceOptional) {
        if (name == null) {
            ReactAttributeDescriptorImpl.$$$reportNull$$$0(0);
        }
        ReactHtmlAttributeDescriptorImpl reactHtmlAttributeDescriptorImpl = new ReactHtmlAttributeDescriptorImpl(name, declaration, type, forceOptional);
        if (reactHtmlAttributeDescriptorImpl == null) {
            ReactAttributeDescriptorImpl.$$$reportNull$$$0(1);
        }
        return reactHtmlAttributeDescriptorImpl;
    }

    public boolean isRequired() {
        if (this.myForceOptional) {
            return false;
        }
        PsiElement declaration = this.getDeclaration();
        if (declaration instanceof JSImplicitElement) {
            return "r".equals(((JSImplicitElement)declaration).getUserString());
        }
        if (declaration instanceof JSRecordType.PropertySignature) {
            return !((JSRecordType.PropertySignature)declaration).isOptional();
        }
        return false;
    }

    public boolean hasIdType() {
        return false;
    }

    public boolean hasIdRefType() {
        return false;
    }

    public boolean isEnumerated() {
        String[] values = this.getEnumeratedValues();
        return values != null && values.length > 0;
    }

    protected PsiElement getEnumeratedValueDeclaration(XmlElement xmlElement, String value) {
        return xmlElement;
    }

    @Nullable
    public PsiElement getDeclaration() {
        return this.myDeclaration;
    }

    public String getName() {
        return this.myAttributeName;
    }

    public void init(PsiElement element) {
    }

    public boolean isFixed() {
        return false;
    }

    public String getDefaultValue() {
        return null;
    }

    public String[] getEnumeratedValues() {
        JSType type = this.myType;
        if (type instanceof JSBooleanType) {
            return new String[]{this.myAttributeName};
        }
        ArrayList results = new ArrayList();
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            if (t instanceof JSStringLiteralTypeImpl) {
                results.add(((JSStringLiteralTypeImpl)t).getLiteral());
            }
            return true;
        }), type, false, true, true);
        if (results.size() > 0) {
            return ArrayUtilRt.toStringArray(results);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/ReactAttributeDescriptorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactAttributeDescriptorImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ReactHtmlAttributeDescriptorImpl
    extends HtmlAttributeDescriptorImpl
    implements ReactAttributeDescriptor,
    PsiPresentableMetaData {
        private final JSType myType;

        ReactHtmlAttributeDescriptorImpl(String name, PsiElement declaration, @Nullable JSType type, boolean forceOptional) {
            super((XmlAttributeDescriptor)new ReactAttributeDescriptorImpl(name, declaration, type, forceOptional), true);
            this.myType = type;
        }

        ReactHtmlAttributeDescriptorImpl(@NotNull XmlAttributeDescriptor _delegate) {
            if (_delegate == null) {
                ReactHtmlAttributeDescriptorImpl.$$$reportNull$$$0(0);
            }
            super(_delegate, true);
            this.myType = null;
        }

        public String getTypeName() {
            JSType type = this.myType;
            if (type == null || JSTypeUtils.hasTypes(type, JSEvaluableType.class)) {
                return null;
            }
            return type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        }

        @Nullable
        public Icon getIcon() {
            return JavaScriptLanguageIcons.Logos.Jsx_16;
        }

        @Override
        @Nullable
        public JSType getValueType() {
            return this.myType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_delegate", "com/intellij/lang/javascript/frameworks/react/ReactAttributeDescriptorImpl$ReactHtmlAttributeDescriptorImpl", "<init>"));
        }
    }
}

