/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.modules.JSModuleNameInfoImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCompletionUtil {
    private static final Integer DEFAULT_PROXIMITY_VALUE = 0;
    private static final Integer DEFAULT_PRIORITY_VALUE = 0;
    public static final Key<Integer> PRIORITY = Key.create((String)"js.several.definitions.element.priority");
    public static final Key<Integer> PROXIMITY = Key.create((String)"js.several.definitions.element.proximity");

    @Nullable
    public static LookupElement createLookupElementForJSModule(@Nullable PsiElement psiElement, boolean insertRelativePrefix) {
        PsiFile psiFile = (PsiFile)ObjectUtils.tryCast((Object)psiElement, PsiFile.class);
        if (psiFile == null || !psiFile.isPhysical()) {
            return null;
        }
        String fileName = psiFile.getName();
        String fixedName = JSModuleNameInfoImpl.getModuleName(fileName, psiFile.getVirtualFile(), psiElement);
        if (!fixedName.equals(fileName) || insertRelativePrefix) {
            LookupElementBuilder item = LookupElementBuilder.create((Object)psiFile, (String)fixedName).withIcon(psiFile.getIcon(0)).withPresentableText(fileName);
            if (insertRelativePrefix) {
                item = item.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                        if (context == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (item == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        int offset = context.getStartOffset();
                        context.getDocument().insertString(offset, (CharSequence)"./");
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "item";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/lang/javascript/completion/JSCompletionUtil$1";
                        objectArray[2] = "handleInsert";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            return item;
        }
        return null;
    }

    @NotNull
    public static LookupElement withJSLookupPriority(@NotNull LookupElement element, @NotNull JSLookupPriority priority) {
        if (element == null) {
            JSCompletionUtil.$$$reportNull$$$0(0);
        }
        if (priority == null) {
            JSCompletionUtil.$$$reportNull$$$0(1);
        }
        element = PrioritizedLookupElement.withPriority((LookupElement)element, (double)priority.getPriorityValue());
        if (priority.getProximityValue() != 0 || element instanceof PrioritizedLookupElement && ((PrioritizedLookupElement)element).getExplicitProximity() != 0) {
            element = PrioritizedLookupElement.withExplicitProximity((LookupElement)element, (int)priority.getProximityValue());
        }
        LookupElement lookupElement = element;
        if (lookupElement == null) {
            JSCompletionUtil.$$$reportNull$$$0(2);
        }
        return lookupElement;
    }

    public static double getLookupElementPriority(@NotNull LookupElement element) {
        if (element == null) {
            JSCompletionUtil.$$$reportNull$$$0(3);
        }
        if (element instanceof PrioritizedLookupElement) {
            return ((PrioritizedLookupElement)element).getPriority();
        }
        Integer data = (Integer)element.getUserData(PRIORITY);
        return ((Integer)ObjectUtils.notNull((Object)data, (Object)DEFAULT_PRIORITY_VALUE)).intValue();
    }

    public static int getLookupElementProximity(LookupElement element) {
        if (element instanceof PrioritizedLookupElement) {
            return ((PrioritizedLookupElement)element).getExplicitProximity();
        }
        Integer proximity = (Integer)element.getUserData(PROXIMITY);
        return (Integer)ObjectUtils.notNull((Object)proximity, (Object)DEFAULT_PROXIMITY_VALUE);
    }

    public static int getCompletionLimit() {
        return Registry.intValue((String)"ide.completion.variant.limit") / 2;
    }

    public static void handleOverflow(@NotNull CompletionResultSet resultSet) {
        if (resultSet == null) {
            JSCompletionUtil.$$$reportNull$$$0(4);
        }
        resultSet.restartCompletionOnAnyPrefixChange();
        resultSet.addLookupAdvertisement("Not all variants are shown, please type more letters to see the rest");
    }

    @NotNull
    public static Collection<LookupElement> pushVariants(@NotNull Collection<LookupElement> variants, Set<String> populatedVariants, @NotNull CompletionResultSet result2) {
        if (variants == null) {
            JSCompletionUtil.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            JSCompletionUtil.$$$reportNull$$$0(6);
        }
        ArrayList<Object> elementsToAdd = new ArrayList<Object>();
        for (LookupElement element : variants) {
            LookupElementBuilder lookupItem;
            if (populatedVariants.contains(element.getLookupString())) continue;
            if (element instanceof LookupElementBuilder && (lookupItem = (LookupElementBuilder)element).getInsertHandler() == null) {
                elementsToAdd.add(lookupItem.withInsertHandler(JSInsertHandler.DEFAULT));
                continue;
            }
            elementsToAdd.add(element);
        }
        result2.addAllElements(elementsToAdd);
        Collection<LookupElement> collection = variants;
        if (collection == null) {
            JSCompletionUtil.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSCompletionUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSCompletionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withJSLookupPriority";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "pushVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withJSLookupPriority";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElementPriority";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleOverflow";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pushVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

