/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.validation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSThrowExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6DecoratorDeclaration;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.JavaScriptAnnotatingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.annotations.NotNull;

public class ES6AnnotatingVisitor
extends JavaScriptAnnotatingVisitor {
    public ES6AnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            ES6AnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ES6AnnotatingVisitor.$$$reportNull$$$0(1);
        }
        super(psiElement, holder);
    }

    public void visitJSTypeDeclaration(JSTypeDeclaration type) {
        super.visitJSTypeDeclaration(type);
        this.checkElementInCurrentLanguageLevel((PsiElement)type, JSLanguageFeature.TYPES);
    }

    public void visitJSThrowExpression(JSThrowExpression node) {
        super.visitJSPrefixExpression((JSPrefixExpression)node);
        this.checkElementInCurrentLanguageLevel(node.getFirstChild(), JSLanguageFeature.THROW_EXPRESSIONS);
    }

    public void visitES6DecoratorDeclaration(ES6DecoratorDeclaration node) {
        super.visitES6DecoratorDeclaration(node);
        PsiElement identifier = node.getNameIdentifier();
        if (identifier != null) {
            this.checkElementInCurrentLanguageLevel(identifier, JSLanguageFeature.DECORATOR_DECLARATIONS);
        }
    }

    @Override
    public void visitJSAttributeList(JSAttributeList attributeList) {
        super.visitJSAttributeList(attributeList);
        PsiElement accessType = attributeList.findAccessTypeElement();
        if (JSUtils.isMember(attributeList.getParent()) && accessType != null) {
            boolean isPrivateSharp = accessType instanceof LeafPsiElement && ((LeafPsiElement)accessType).getElementType() == JSTokenTypes.SHARP;
            this.checkElementInCurrentLanguageLevel(accessType, isPrivateSharp ? JSLanguageFeature.PRIVATE_SHARP_SYNTAX : JSLanguageFeature.VISIBILITY_MODIFIERS);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/ecmascript6/validation/ES6AnnotatingVisitor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

