/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.actionscript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.actionscript.parsing.ActionScriptParser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.psi.tree.IElementType;

public class ActionScriptExpressionParser
extends ExpressionParser<ActionScriptParser> {
    protected ActionScriptExpressionParser(ActionScriptParser parser) {
        super(parser);
    }

    @Override
    protected boolean isPropertyStart(IElementType elementType) {
        return JSKeywordSets.AS_IDENTIFIER_TOKENS_SET.contains(elementType) || elementType == JSTokenTypes.STRING_LITERAL || elementType == JSTokenTypes.NUMERIC_LITERAL || elementType == JSTokenTypes.LPAR;
    }

    @Override
    public boolean isPropertyNameStart(IElementType elementType) {
        return JSKeywordSets.PROPERTY_NAMES.contains(elementType);
    }

    @Override
    protected boolean isFunctionPropertyStart() {
        IElementType token = this.builder.getTokenType();
        return token == JSTokenTypes.GET_KEYWORD || token == JSTokenTypes.SET_KEYWORD;
    }

    @Override
    protected boolean parsePropertyNoMarker(PsiBuilder.Marker property) {
        if (this.builder.getTokenType() == JSTokenTypes.LPAR) {
            this.parseParenthesizedExpression();
            this.parsePropertyInitializer(false);
            property.done(JSStubElementTypes.PROPERTY);
            property.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            return true;
        }
        return super.parsePropertyNoMarker(property);
    }

    @Override
    protected boolean isReferenceQualifierSeparator(IElementType tokenType) {
        return tokenType == JSTokenTypes.DOT || tokenType == JSTokenTypes.COLON_COLON || tokenType == JSTokenTypes.DOT_DOT;
    }

    @Override
    public boolean parsePrimaryExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.AT) {
            PsiBuilder.Marker attrReferenceStartMarker = this.builder.mark();
            this.builder.advanceLexer();
            PsiBuilder.Marker possibleNamespaceStartMarker = this.builder.mark();
            if (!this.builder.eof()) {
                IElementType tokenType = this.builder.getTokenType();
                if (tokenType == JSTokenTypes.ANY_IDENTIFIER || this.isIdentifierToken(tokenType)) {
                    this.builder.advanceLexer();
                    if (this.builder.getTokenType() == JSTokenTypes.COLON_COLON) {
                        possibleNamespaceStartMarker.done(JSElementTypes.REFERENCE_EXPRESSION);
                        possibleNamespaceStartMarker = possibleNamespaceStartMarker.precede();
                        this.proceedWithNamespaceReference(possibleNamespaceStartMarker, true);
                        possibleNamespaceStartMarker = null;
                    }
                } else if (tokenType == JSTokenTypes.LBRACKET) {
                    this.builder.advanceLexer();
                    this.parseExpression();
                    ActionScriptExpressionParser.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket");
                } else {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
                }
            }
            if (possibleNamespaceStartMarker != null) {
                possibleNamespaceStartMarker.drop();
            }
            attrReferenceStartMarker.done(JSElementTypes.REFERENCE_EXPRESSION);
            return true;
        }
        return super.parsePrimaryExpression();
    }
}

