/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.protractor.ProtractorConsoleFilter;
import com.intellij.javascript.protractor.ProtractorConsoleProperties;
import com.intellij.javascript.protractor.ProtractorFailedTest;
import com.intellij.javascript.protractor.ProtractorRunConfiguration;
import com.intellij.javascript.protractor.ProtractorRunSettings;
import com.intellij.javascript.protractor.ProtractorUtil;
import com.intellij.javascript.protractor.scope.ProtractorScopeKind;
import com.intellij.javascript.testFramework.navigation.JSTestLocationProvider;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtractorRunState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    public static final String FRAMEWORK_NAME = "ProtractorJavaScriptTestRunner";
    private static final String INTELLIJ_CONFIG_FILE_PATH = "protractor-intellij/lib/protractor-intellij-config.js";
    private final Project myProject;
    private final ProtractorRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myEnvironment;
    private final NodePackage myProtractorPackage;
    private final ProtractorRunSettings myRunSettings;
    private final ConsoleCommandLineFolder myFolder;
    private List<ProtractorFailedTest> myFailedTests;

    public ProtractorRunState(@NotNull ProtractorRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull NodePackage protractorPackage) {
        if (runConfiguration == null) {
            ProtractorRunState.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            ProtractorRunState.$$$reportNull$$$0(1);
        }
        if (protractorPackage == null) {
            ProtractorRunState.$$$reportNull$$$0(2);
        }
        this.myFolder = new ConsoleCommandLineFolder(new String[0]);
        this.myProject = runConfiguration.getProject();
        this.myRunConfiguration = runConfiguration;
        this.myEnvironment = environment;
        this.myProtractorPackage = protractorPackage;
        this.myRunSettings = runConfiguration.getRunSettings();
    }

    @Override
    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveNotNull(this.myProject);
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, debugPort);
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, false);
        ProtractorConsoleProperties consoleProperties = new ProtractorConsoleProperties(this.myRunConfiguration, this.myEnvironment.getExecutor(), (SMTestLocator)new JSTestLocationProvider());
        ConsoleView consoleView = this.createSmtRunnerConsoleView(commandLine.getWorkDirectory(), consoleProperties);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        consoleView.attachToProcess((ProcessHandler)processHandler);
        this.foldCommandLine(consoleView, (ProcessHandler)processHandler);
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)processHandler);
        executionResult.setRestartActions(new AnAction[]{consoleProperties.createRerunFailedTestsAction(consoleView), new ToggleAutoTestAction()});
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            ProtractorRunState.$$$reportNull$$$0(3);
        }
        return defaultExecutionResult;
    }

    @NotNull
    private ConsoleView createSmtRunnerConsoleView(@Nullable File workingDirectory, @NotNull ProtractorConsoleProperties consoleProperties) {
        if (consoleProperties == null) {
            ProtractorRunState.$$$reportNull$$$0(4);
        }
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole((String)FRAMEWORK_NAME, (TestConsoleProperties)consoleProperties);
        consoleProperties.addStackTraceFilter((Filter)new ProtractorConsoleFilter(this.myProject, workingDirectory));
        for (Filter filter : consoleProperties.getStackTrackFilters()) {
            consoleView.addMessageFilter(filter);
        }
        Disposer.register((Disposable)this.myProject, (Disposable)consoleView);
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = consoleView;
        if (baseTestsOutputConsoleView == null) {
            ProtractorRunState.$$$reportNull$$$0(5);
        }
        return baseTestsOutputConsoleView;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            ProtractorRunState.$$$reportNull$$$0(6);
        }
        if (processHandler == null) {
            ProtractorRunState.$$$reportNull$$$0(7);
        }
        this.myFolder.foldCommandLine(consoleView, processHandler);
    }

    @NotNull
    private GeneralCommandLine createCommandLine(@NotNull NodeJsInterpreter interpreter, int debugPort) throws ExecutionException {
        String testNamePattern;
        File intellijConfigFile;
        if (interpreter == null) {
            ProtractorRunState.$$$reportNull$$$0(8);
        }
        NodeCommandLineConfigurator configurator = NodeCommandLineConfigurator.find(interpreter);
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setCharset(StandardCharsets.UTF_8);
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        String originalConfigFilePath = this.myRunSettings.getConfigFileSystemDependentPath();
        commandLine.setWorkDirectory(PathUtil.getParentPath((String)originalConfigFilePath));
        NodeCommandLineUtil.addNodeOptionsForDebugging(commandLine, Collections.emptyList(), debugPort, true, interpreter, true);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        commandLine.addParameter(ProtractorUtil.getProtractorMainJsFile(this.myProtractorPackage).getAbsolutePath());
        this.myFolder.addPlaceholderText(this.myProtractorPackage.getName());
        try {
            intellijConfigFile = HelperFilesLocator.getFileRelativeToHelpersDir(INTELLIJ_CONFIG_FILE_PATH);
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot locate wrapper config file", (Throwable)e);
        }
        commandLine.addParameter(intellijConfigFile.getAbsolutePath());
        this.myFolder.addPlaceholderText(PathUtil.getFileName((String)originalConfigFilePath));
        List options = ParametersListUtil.parse((String)this.myRunSettings.getProtractorOptions());
        commandLine.addParameters(options);
        this.myFolder.addPlaceholderTexts(options);
        commandLine.addParameter("--intellijOriginalConfigFile=" + configurator.convertLocalPathToRemote(originalConfigFilePath));
        commandLine.addParameter("--disableChecks");
        String testFile = this.getTestFile();
        if (testFile != null) {
            commandLine.addParameter("--specs");
            commandLine.addParameter(testFile);
            this.myFolder.addPlaceholderTexts("--specs=" + PathUtil.getFileName((String)testFile));
        }
        if ((testNamePattern = this.getTestNamePattern(this.myRunSettings.getScopeKind())) != null) {
            commandLine.addParameter("--grep=" + testNamePattern);
            ProtractorFailedTest failedTest = (ProtractorFailedTest)ContainerUtil.getFirstItem(this.myFailedTests);
            List<String> anyTestName = failedTest != null ? failedTest.getTestNames() : this.myRunSettings.getTestNames();
            String extra = this.myFailedTests != null && this.myFailedTests.size() > 1 ? "|..." : "";
            this.myFolder.addPlaceholderTexts("--grep=" + StringUtil.join(anyTestName, (String)" ") + extra);
        }
        configurator.configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            ProtractorRunState.$$$reportNull$$$0(9);
        }
        return generalCommandLine;
    }

    @Nullable
    private String getTestFile() {
        if (this.myRunSettings.getScopeKind() == ProtractorScopeKind.TEST_FILE || this.myRunSettings.getScopeKind() == ProtractorScopeKind.SUITE || this.myRunSettings.getScopeKind() == ProtractorScopeKind.TEST) {
            return this.myRunSettings.getTestFileSystemDependentPath();
        }
        return null;
    }

    @Nullable
    private String getTestNamePattern(@NotNull ProtractorScopeKind testKind) {
        if (testKind == null) {
            ProtractorRunState.$$$reportNull$$$0(10);
        }
        if (this.myFailedTests != null) {
            return ProtractorRunState.getTestNamesPattern(ContainerUtil.map(this.myFailedTests, test -> test.getTestNames()), false);
        }
        if (testKind == ProtractorScopeKind.SUITE || testKind == ProtractorScopeKind.TEST) {
            return ProtractorRunState.getTestNamesPattern(Collections.singletonList(this.myRunSettings.getTestNames()), testKind == ProtractorScopeKind.SUITE);
        }
        return null;
    }

    void setFailedTests(@NotNull List<ProtractorFailedTest> failedTests) {
        if (failedTests == null) {
            ProtractorRunState.$$$reportNull$$$0(11);
        }
        this.myFailedTests = failedTests;
    }

    @NotNull
    private static String getTestNamesPattern(@NotNull List<List<String>> testNames, boolean suite) {
        List patterns;
        if (testNames == null) {
            ProtractorRunState.$$$reportNull$$$0(12);
        }
        if ((patterns = ContainerUtil.map(testNames, testFqn -> {
            List escaped = ContainerUtil.mapNotNull((Collection)testFqn, s -> JestUtil.escapeJavaScriptRegexp(s));
            return StringUtil.join((Collection)escaped, (String)" ");
        })).isEmpty()) {
            if ("$^" == null) {
                ProtractorRunState.$$$reportNull$$$0(13);
            }
            return "$^";
        }
        String result2 = patterns.size() == 1 ? (String)patterns.get(0) : "(" + StringUtil.join((Collection)patterns, (String)"|") + ")";
        String string = "^" + result2 + (suite ? " " : "$");
        if (string == null) {
            ProtractorRunState.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protractorPackage";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/protractor/ProtractorRunState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testKind";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedTests";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/protractor/ProtractorRunState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmtRunnerConsoleView";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNamesPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSmtRunnerConsoleView";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "foldCommandLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamePattern";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setFailedTests";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamesPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

