/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.settings;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.settings.NodeSettingsView;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    public static final String ID = "settings.nodejs";
    private final Project myProject;
    private final VirtualFile myRequestor;
    private final boolean myOneClickConfiguration;
    private NodeSettingsView myView;
    private final NodeJsInterpreterManager myInterpreterManager;
    private final NpmManager myNpmManager;

    public NodeSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            NodeSettingsConfigurable.$$$reportNull$$$0(0);
        }
        this(project, null, false);
    }

    public NodeSettingsConfigurable(@NotNull Project project, @Nullable VirtualFile requestor, boolean oneClickConfiguration) {
        if (project == null) {
            NodeSettingsConfigurable.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myRequestor = requestor;
        this.myOneClickConfiguration = oneClickConfiguration;
        this.myInterpreterManager = NodeJsInterpreterManager.getInstance(project);
        this.myNpmManager = NpmManager.getInstance(project);
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            NodeSettingsConfigurable.$$$reportNull$$$0(2);
        }
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return JSBundle.message((String)"settings.nodejs.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return this.getId();
    }

    public JComponent createComponent() {
        NodeSettingsView view;
        this.myView = view = new NodeSettingsView(this.myProject, this.myRequestor, this.myOneClickConfiguration);
        return view.getComponent();
    }

    public boolean isModified() {
        NodeSettingsView view = this.myView;
        if (view == null) {
            return false;
        }
        NodeJsInterpreterRef prevInterpreter = this.myInterpreterManager.getInterpreterRef();
        NodeJsInterpreterRef nextInterpreter = view.getInterpreterRef();
        NodePackageRef prevPmPackageRef = this.myNpmManager.getPackageRef();
        NodePackageRef nextPmPackageRef = view.getPackageManagerPackageRef();
        return !prevInterpreter.equals(nextInterpreter) || !prevPmPackageRef.equals(nextPmPackageRef);
    }

    public void apply() {
        NodeSettingsView view = this.myView;
        if (view != null) {
            NodeJsInterpreterRef prevInterpreter = this.myInterpreterManager.getInterpreterRef();
            NodeJsInterpreterRef nextInterpreter = view.getInterpreterRef();
            this.myInterpreterManager.setInterpreterRef(nextInterpreter);
            if (!prevInterpreter.equals(nextInterpreter)) {
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            }
            this.myNpmManager.setPackageRef(view.getPackageManagerPackageRef());
        }
    }

    public void reset() {
        NodeSettingsView view = this.myView;
        if (view != null) {
            view.setInterpreterRef(this.myInterpreterManager.getInterpreterRef());
            view.setPackageManagerPackageRef(this.myNpmManager.getPackageRef());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/settings/NodeSettingsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/settings/NodeSettingsConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

