/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.google.common.collect.ImmutableList;
import com.intellij.javascript.nodejs.library.core.NodeCoreModulesCatalog;
import com.intellij.javascript.nodejs.library.core.NodeCoreSourcesSnapshot;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeCoreLibraryManager {
    public static final String LIBRARY_NAME = "Node.js Core";
    private static final RegistryValue USE_TYPINGS = Registry.get((String)"nodejs.core.library.use.typings");
    private final Project myProject;
    private JSLibraryMappings myMappings;
    @Nullable
    private volatile NodeCoreSourcesSnapshot mySnapshot;

    public NodeCoreLibraryManager(@NotNull Project project) {
        if (project == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(0);
        }
        this.myMappings = null;
        this.myProject = project;
        USE_TYPINGS.addListener((RegistryValueListener)new RegistryValueListener.Adapter(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    TransactionGuard.getInstance().submitTransactionLater((Disposable)NodeCoreLibraryManager.this.myProject, () -> WriteAction.run(() -> JSLibraryManager.getInstance(NodeCoreLibraryManager.this.myProject).commitChanges()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryManager$1", "afterValueChanged"));
            }
        }, (Disposable)this.myProject);
    }

    @NotNull
    public static NodeCoreLibraryManager getInstance(@NotNull Project project) {
        if (project == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(1);
        }
        NodeCoreLibraryManager nodeCoreLibraryManager = (NodeCoreLibraryManager)ServiceManager.getService((Project)project, NodeCoreLibraryManager.class);
        if (nodeCoreLibraryManager == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(2);
        }
        return nodeCoreLibraryManager;
    }

    public void setSnapshot(@Nullable NodeCoreSourcesSnapshot snapshot) {
        this.mySnapshot = snapshot;
    }

    public static boolean isCoreModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(3);
        }
        return NodeCoreModulesCatalog.INSTANCE.isPublicCoreModule(moduleName);
    }

    public boolean isCoreLibraryConfigured() {
        return this.mySnapshot != null;
    }

    public boolean isCoreModuleLibraryFile(@NotNull VirtualFile virtualFile) {
        NodeCoreSourcesSnapshot snapshot;
        if (virtualFile == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(4);
        }
        return (snapshot = this.mySnapshot) != null && snapshot.isCoreModuleFile(virtualFile);
    }

    @NotNull
    public Collection<String> listCoreModuleNames() {
        ImmutableList<String> immutableList = NodeCoreModulesCatalog.INSTANCE.getPublicCoreModules();
        if (immutableList == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(5);
        }
        return immutableList;
    }

    @Nullable
    public VirtualFile findCoreModuleFileByName(@NotNull String moduleName) {
        NodeCoreSourcesSnapshot snapshot;
        if (moduleName == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(6);
        }
        return (snapshot = this.mySnapshot) != null ? snapshot.getFileByModuleName(moduleName) : null;
    }

    public static boolean isAssociatedWithNodeCoreLibrary(@NotNull PsiFile psiFile) {
        VirtualFile virtualFile;
        if (psiFile == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(7);
        }
        if ((virtualFile = psiFile.getVirtualFile()) == null) {
            return false;
        }
        return NodeCoreLibraryManager.isAssociatedWithNodeCoreLibrary(psiFile.getProject(), virtualFile);
    }

    public static boolean isAssociatedWithNodeCoreLibrary(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(9);
        }
        NodeCoreLibraryManager manager2 = NodeCoreLibraryManager.getInstance(project);
        return manager2.isAssociatedWithNodeCoreLibrary(file2);
    }

    public boolean isAssociatedWithNodeCoreLibrary(@NotNull VirtualFile file2) {
        if (file2 == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(10);
        }
        JSLibraryMappings mappings = this.getLibraryMappings();
        return mappings.isLibraryInScopeFor(file2, LIBRARY_NAME);
    }

    public boolean hasAssociatedRoots() {
        JSLibraryMappings mappings = this.getLibraryMappings();
        return !mappings.getMappingsByLibraryName(LIBRARY_NAME).isEmpty();
    }

    @NotNull
    public List<VirtualFile> getAssociatedRoots() {
        JSLibraryMappings mappings = this.getLibraryMappings();
        List list2 = mappings.getMappingsByLibraryName(LIBRARY_NAME);
        if (list2 == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @NotNull
    private JSLibraryMappings getLibraryMappings() {
        JSLibraryMappings mappings = this.myMappings;
        if (mappings == null) {
            this.myMappings = mappings = JSLibraryMappings.getInstance(this.myProject);
        }
        JSLibraryMappings jSLibraryMappings = mappings;
        if (jSLibraryMappings == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(12);
        }
        return jSLibraryMappings;
    }

    public static boolean shouldUseNodeTypings() {
        return USE_TYPINGS.asBoolean();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryManager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "listCoreModuleNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedRoots";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCoreModuleName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCoreModuleLibraryFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findCoreModuleFileByName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAssociatedWithNodeCoreLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

