/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi.references;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.ide.libraries.PuppetLibraryUtil;
import com.intellij.lang.puppet.ide.navigation.plugins.ruby.PuppetRubyPluginsIndex;
import com.intellij.lang.puppet.psi.references.PuppetPolyVariantCachingReferenceWithFullQualifiedName;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetFunctionsStubsIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.ResolveResult;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PuppetFunctionReference
extends PuppetPolyVariantCachingReferenceWithFullQualifiedName<PsiElement> {
    public PuppetFunctionReference(PsiElement psiElement, TextRange range, String fullQualifiedName) {
        super(psiElement, range, fullQualifiedName);
    }

    @Override
    @NotNull
    protected ResolveResult[] resolveInner(boolean incompleteCode) {
        ArrayList<Object> elements = new ArrayList<Object>();
        ArrayList<PsiElement> stubElements = new ArrayList<PsiElement>();
        PsiElement element = this.getElement();
        for (PsiElement rubyElement : PuppetRubyPluginsIndex.findElementsByKey(PuppetRubyPluginsIndex.SymbolType.FUNCTION, this.myFullQualifiedName, element.getProject(), element.getResolveScope())) {
            if (PuppetLibraryUtil.isFunctionStubElement(rubyElement)) {
                stubElements.add(rubyElement);
                continue;
            }
            elements.add(rubyElement);
        }
        if (elements.isEmpty()) {
            elements.addAll(stubElements);
        }
        elements.addAll(PuppetFunctionsStubsIndex.getInstance().find(this.myFullQualifiedName, this.myElement));
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(elements);
        if (resolveResultArray == null) {
            PuppetFunctionReference.$$$reportNull$$$0(0);
        }
        return resolveResultArray;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = PuppetBundle.message("puppet.type.names.function_definition", new Object[0]);
        if (string == null) {
            PuppetFunctionReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/puppet/psi/references/PuppetFunctionReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

