/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.xml.util;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.html.impl.util.MicrodataUtil;
import com.intellij.htmltools.xml.util.ColorReference;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.AttributeValueSelfReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.IdRefReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.index.ImageInfoIndex;
import org.intellij.images.util.ImageInfoReader;
import org.intellij.images.vfs.IfsUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlReferenceProvider
extends PsiReferenceProvider {
    @NonNls
    private static final String NAME_ATTR_LOCAL_NAME = "name";
    @NonNls
    private static final String USEMAP_ATTR_NAME = "usemap";
    @NonNls
    private static final String FOR_ATTR_NAME = "for";
    @NonNls
    private static final String HREF_ATTRIBUTE_NAME = "href";
    @NonNls
    private static final String SRC_ATTR_NAME = "src";
    @NonNls
    private static final String JAVASCRIPT_PREFIX = "javascript:";
    private static final FileType[] IMAGE_FILE_TYPES = new FileType[]{ImageFileTypeManager.getInstance().getImageFileType()};
    public static final String LABELLEDBY = "aria-labelledby";

    public static ElementFilter getFilter() {
        return new ElementFilter(){

            public boolean isAcceptable(Object _element, PsiElement context) {
                PsiElement element = (PsiElement)_element;
                PsiFile file = element.getContainingFile();
                return (HtmlUtil.hasHtml((PsiFile)file) || HtmlUtil.supportsXmlTypedHandlers((PsiFile)file)) && HtmlReferenceProvider.isAcceptableAttributeValue(element);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        };
    }

    protected static boolean isAcceptableAttributeValue(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof XmlAttribute) {
            XmlAttribute xmlAttribute = (XmlAttribute)parent;
            String attrName = xmlAttribute.getName();
            XmlTag tag = xmlAttribute.getParent();
            if (tag == null) {
                return false;
            }
            String tagName = tag.getName();
            return attrName.equalsIgnoreCase(SRC_ATTR_NAME) && (tagName.equalsIgnoreCase("img") || tagName.equalsIgnoreCase("script") || tagName.equalsIgnoreCase("frame") || tagName.equalsIgnoreCase("iframe") || tagName.equalsIgnoreCase("video") || tagName.equalsIgnoreCase("audio") || tagName.equalsIgnoreCase("track") || tagName.equalsIgnoreCase("source") || tagName.equalsIgnoreCase("embed") || tagName.equalsIgnoreCase("input") && tag.getAttributeValue("type") != null && "image".equalsIgnoreCase(tag.getAttributeValue("type"))) || attrName.equalsIgnoreCase(HREF_ATTRIBUTE_NAME) && (tagName.equalsIgnoreCase("a") || tagName.equalsIgnoreCase("area") || tagName.equalsIgnoreCase("link")) || attrName.equalsIgnoreCase(USEMAP_ATTR_NAME) && (tagName.equalsIgnoreCase("img") || tagName.equalsIgnoreCase("object")) || attrName.equalsIgnoreCase("action") && tagName.equalsIgnoreCase("form") || attrName.equalsIgnoreCase("background") || (attrName.equalsIgnoreCase(NAME_ATTR_LOCAL_NAME) || attrName.equalsIgnoreCase("id") || attrName.equalsIgnoreCase("class")) && tag.getNamespacePrefix().length() == 0 || (attrName.equalsIgnoreCase("width") || attrName.equalsIgnoreCase("height")) && tagName.equalsIgnoreCase("img") || attrName.equalsIgnoreCase("type") && (tagName.equalsIgnoreCase("style") || tagName.equalsIgnoreCase("script")) || attrName.equalsIgnoreCase("bgcolor") && ColorReference.ourBgColorTagNames.contains(StringUtil.toLowerCase((String)tagName)) || attrName.equalsIgnoreCase("color") && (tagName.equalsIgnoreCase("basefont") || tagName.equalsIgnoreCase("font")) || tagName.equalsIgnoreCase("body") && (attrName.equalsIgnoreCase("text") || attrName.equalsIgnoreCase("link") || attrName.equalsIgnoreCase("vlink") || attrName.equalsIgnoreCase("alink")) || tagName.equalsIgnoreCase("label") && attrName.equalsIgnoreCase(FOR_ATTR_NAME) || attrName.equalsIgnoreCase("itemref") && tag.getAttribute("itemscope") != null || attrName.equalsIgnoreCase("data") && tagName.equalsIgnoreCase("object") || attrName.equalsIgnoreCase("poster") && tagName.equalsIgnoreCase("video") || attrName.equalsIgnoreCase("srcset") && (tagName.equalsIgnoreCase("img") || tagName.equals("source")) || attrName.equalsIgnoreCase(LABELLEDBY);
        }
        return false;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiElement parent;
        if (element == null) {
            HtmlReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            HtmlReferenceProvider.$$$reportNull$$$0(1);
        }
        if (!((parent = element.getParent()) instanceof XmlAttribute)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                HtmlReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        XmlAttribute attribute = (XmlAttribute)parent;
        String localName = attribute.getLocalName();
        if (element instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)element))) {
            if (PsiReference.EMPTY_ARRAY == null) {
                HtmlReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String text = ElementManipulators.getValueText((PsiElement)element);
        int offset = ElementManipulators.getValueTextRange((PsiElement)element).getStartOffset();
        XmlTag tag = attribute.getParent();
        PsiReference[] refs = PsiReference.EMPTY_ARRAY;
        if (FOR_ATTR_NAME.equalsIgnoreCase(localName) || LABELLEDBY.equals(localName)) {
            refs = new PsiReference[]{new HtmlIdRefReference(element, offset)};
        } else if ("itemref".equalsIgnoreCase(localName)) {
            XmlAttributeValue value = attribute.getValueElement();
            refs = MicrodataUtil.getReferencesForAttributeValue((XmlAttributeValue)value, (token, offset1) -> new HtmlIdRefReference((PsiElement)value, (int)offset1));
        } else if ("bgcolor".equalsIgnoreCase(localName) || "color".equalsIgnoreCase(localName) || "text".equalsIgnoreCase(localName) || "link".equalsIgnoreCase(localName) || "vlink".equalsIgnoreCase(localName) || "alink".equalsIgnoreCase(localName)) {
            refs = new PsiReference[]{new ColorReference(element, offset)};
        } else if ("type".equalsIgnoreCase(localName)) {
            refs = new PsiReference[]{new ContentTypeReference(element)};
        } else if ("width".equalsIgnoreCase(localName) || "height".equalsIgnoreCase(localName)) {
            refs = new PsiReference[]{new SizeReference(element, offset)};
        } else if ("id".equalsIgnoreCase(localName)) {
            refs = new PsiReference[]{new HtmlIdSelfReference(element, offset)};
        } else if (NAME_ATTR_LOCAL_NAME.equalsIgnoreCase(localName)) {
            refs = new PsiReference[]{new AttributeValueSelfReference(element, offset)};
        } else if ("class".equalsIgnoreCase(localName)) {
            ArrayList<AttributeValueSelfReference> references = new ArrayList<AttributeValueSelfReference>(1);
            int ndx = 0;
            for (String token2 : HtmlUtil.splitClassNames((String)text)) {
                ndx = text.indexOf(token2, ndx);
                references.add(new AttributeValueSelfReference(element, new TextRange(offset + ndx, offset + ndx + token2.length())));
                ndx += token2.length();
            }
            refs = new PsiReference[references.size()];
            references.toArray(refs);
        } else if (SRC_ATTR_NAME.equalsIgnoreCase(localName) && "img".equalsIgnoreCase(tag.getName())) {
            refs = PathReferenceManager.getInstance().createReferences(element, false, false, true, IMAGE_FILE_TYPES, new PathReferenceProvider[0]);
        } else if ("srcset".equalsIgnoreCase(localName) && ("img".equalsIgnoreCase(tag.getName()) || "source".equals(tag.getName())) && PsiTreeUtil.getChildOfType((PsiElement)element, OuterLanguageElement.class) == null) {
            ArrayList result = new ArrayList();
            int index = offset;
            for (String imageAndSize : StringUtil.tokenize((String)text, (String)",")) {
                int innerIndex;
                for (innerIndex = 0; innerIndex < imageAndSize.length() && Character.isWhitespace(imageAndSize.charAt(innerIndex)); ++innerIndex) {
                }
                if (innerIndex < imageAndSize.length()) {
                    String image = imageAndSize.substring(innerIndex).split(" ", 2)[0];
                    Collections.addAll(result, new FileReferenceSet(image, element, index + innerIndex, null, true, false, IMAGE_FILE_TYPES).getAllReferences());
                }
                index += imageAndSize.length() + 1;
            }
            refs = result.toArray(PsiReference.EMPTY_ARRAY);
        } else if ("data".equals(localName) && "object".equalsIgnoreCase(tag.getName()) || "poster".equals(localName) && "video".equalsIgnoreCase(tag.getName())) {
            refs = PathReferenceManager.getInstance().createReferences(element, false, false, true, new PathReferenceProvider[0]);
        } else if (HREF_ATTRIBUTE_NAME.equalsIgnoreCase(localName) && "link".equalsIgnoreCase(tag.getName())) {
            FileType[] fileTypes = HtmlReferenceProvider.findFileTypeByRel(tag.getAttributeValue("rel"));
            String typeValue = tag.getAttributeValue("type");
            FileType[] fileTypeArray = fileTypes == null ? HtmlReferenceProvider.findFileType(typeValue == null ? "text/css" : typeValue) : (fileTypes = fileTypes);
            if (!text.startsWith("data:")) {
                refs = PathReferenceManager.getInstance().createReferences(element, false, false, true, fileTypes, new PathReferenceProvider[0]);
            }
        } else if (SRC_ATTR_NAME.equalsIgnoreCase(localName) && HtmlUtil.isScriptTag((XmlTag)tag)) {
            if (!HtmlUtil.hasHtmlPrefix((String)text)) {
                String typeValue = tag.getAttributeValue("type");
                refs = PathReferenceManager.getInstance().createReferences(element, false, false, true, HtmlReferenceProvider.findFileType(typeValue), new PathReferenceProvider[0]);
            }
        } else if (!StringUtil.startsWithIgnoreCase((String)text, (String)JAVASCRIPT_PREFIX) && !GlobalPathReferenceProvider.startsWithAllowedPrefix((String)text)) {
            refs = PathReferenceManager.getInstance().createReferences(element, false, false, true, new PathReferenceProvider[0]);
        }
        if (refs == null) {
            HtmlReferenceProvider.$$$reportNull$$$0(4);
        }
        return refs;
    }

    private static FileType[] findFileTypeByRel(@Nullable String rel) {
        if (rel == null) {
            return null;
        }
        for (String type : rel.split(" ")) {
            if ("stylesheet".equalsIgnoreCase(type)) {
                return HtmlReferenceProvider.findFileType("text/css");
            }
            if (!type.contains("icon") && !type.contains("image")) continue;
            return IMAGE_FILE_TYPES;
        }
        return null;
    }

    private static FileType[] findFileType(@Nullable String mimeType) {
        FileType[] fileTypeArray;
        Collection languages = Language.findInstancesByMimeType((String)(mimeType != null ? mimeType.trim() : null));
        FileType fileType = (FileType)ContainerUtil.find((Object[])FileTypeManager.getInstance().getRegisteredFileTypes(), type -> type instanceof LanguageFileType && languages.contains(((LanguageFileType)type).getLanguage()));
        if (fileType == null) {
            fileTypeArray = null;
        } else {
            FileType[] fileTypeArray2 = new FileType[1];
            fileTypeArray = fileTypeArray2;
            fileTypeArray2[0] = fileType;
        }
        return fileTypeArray;
    }

    public static String[] getAttributeValues() {
        return new String[]{SRC_ATTR_NAME, HREF_ATTRIBUTE_NAME, USEMAP_ATTR_NAME, "action", "background", "width", "height", "type", "bgcolor", "color", "vlink", "link", "alink", "text", NAME_ATTR_LOCAL_NAME, "id", "class", FOR_ATTR_NAME, "itemref", "data", "poster", "srcset", LABELLEDBY};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/xml/util/HtmlReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/xml/util/HtmlReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class HtmlIdRefReference
    extends IdRefReference {
        public HtmlIdRefReference(PsiElement element, int offset) {
            super(element, offset, true);
        }

        public boolean isSoft() {
            return true;
        }
    }

    private static class HtmlIdSelfReference
    extends AttributeValueSelfReference {
        HtmlIdSelfReference(PsiElement element, int offset) {
            super(element, offset);
        }

        @NotNull
        public Object[] getVariants() {
            final LinkedList result = new LinkedList();
            IdRefReference.process((PsiElementProcessor)new PsiElementProcessor<PsiElement>(){

                public boolean execute(@NotNull PsiElement element) {
                    String forValue;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element instanceof XmlTag && (forValue = ((XmlTag)element).getAttributeValue(HtmlReferenceProvider.FOR_ATTR_NAME)) != null) {
                        result.add(forValue);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/htmltools/xml/util/HtmlReferenceProvider$HtmlIdSelfReference$1", "execute"));
                }
            }, (PsiFile)this.myElement.getContainingFile());
            Object[] objectArray = ArrayUtil.toObjectArray(result);
            if (objectArray == null) {
                HtmlIdSelfReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/htmltools/xml/util/HtmlReferenceProvider$HtmlIdSelfReference", "getVariants"));
        }
    }

    public static class SizeReference
    extends BasicAttributeValueReference {
        @NonNls
        static final String WIDTH_ATTR_NAME = "width";
        @NonNls
        static final String HEIGHT_ATTR_NAME = "height";
        @NonNls
        static final String IMAGE_TAG_NAME = "img";
        private final boolean myIsWidth;

        public SizeReference(PsiElement element, int offset) {
            super(element, offset);
            XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
            assert (xmlAttribute != null);
            this.myIsWidth = WIDTH_ATTR_NAME.equalsIgnoreCase(xmlAttribute.getName());
        }

        @Nullable
        public PsiElement resolve() {
            ImageInfoReader.Info info = this.getImageInfo();
            if (info != null && info.width != 0 && info.height != 0) {
                String text = this.getCanonicalText();
                if (!HtmlUtil.isHtml5Context((XmlElement)((XmlElement)this.myElement)) && StringUtil.endsWithChar((CharSequence)text, (char)'%')) {
                    return this.myElement;
                }
                int myValue = SizeReference.getSizeValue(text, (XmlElement)this.myElement);
                if (this.myIsWidth && info.width != myValue || !this.myIsWidth && info.height != myValue) {
                    return null;
                }
            }
            return this.myElement;
        }

        static int getSizeValue(@Nullable String value, @NotNull XmlElement context) {
            if (context == null) {
                SizeReference.$$$reportNull$$$0(0);
            }
            if (value == null) {
                return 0;
            }
            if (!HtmlUtil.isHtml5Context((XmlElement)context)) {
                value = StringUtil.trimEnd((String)value, (String)"px").trim();
            }
            return StringUtil.parseInt((String)value, (int)0);
        }

        @Nullable
        ImageInfoReader.Info getImageInfo() {
            XmlTag tag = (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myElement, (Class[])new Class[]{XmlTag.class});
            return tag != null ? SizeReference.getImageInfo(tag) : null;
        }

        @Nullable
        public static ImageInfoReader.Info getImageInfo(@NotNull XmlTag tag) {
            if (tag == null) {
                SizeReference.$$$reportNull$$$0(1);
            }
            return (ImageInfoReader.Info)CachedValuesManager.getCachedValue((PsiElement)tag, () -> {
                XmlAttribute src = tag.getAttribute(HtmlReferenceProvider.SRC_ATTR_NAME, null);
                if (src != null) {
                    byte[] bytesFromDataUri;
                    VirtualFile virtualFile;
                    PsiFile psiFile = FileReferenceUtil.findFile((PsiElement)src.getValueElement());
                    if (psiFile != null && (virtualFile = psiFile.getVirtualFile()) instanceof VirtualFileWithId) {
                        int[] widthAndHeightAndBpp = new int[3];
                        ImageInfoIndex.processValues((VirtualFile)virtualFile, (file, value) -> {
                            widthAndHeightAndBpp[0] = value.width;
                            widthAndHeightAndBpp[1] = value.height;
                            widthAndHeightAndBpp[2] = value.bpp;
                            return false;
                        }, (Project)tag.getProject());
                        return CachedValueProvider.Result.create((Object)new ImageInfoReader.Info(widthAndHeightAndBpp[0], widthAndHeightAndBpp[1], widthAndHeightAndBpp[2], IfsUtil.isSVG((VirtualFile)virtualFile)), (Object[])new Object[]{src, virtualFile});
                    }
                    String srcValue = src.getValue();
                    if (srcValue != null && URLUtil.isDataUri((String)srcValue) && (bytesFromDataUri = URLUtil.getBytesFromDataUri((String)srcValue)) != null) {
                        try {
                            ImageInfoReader.Info info = ImageInfoReader.getInfo((byte[])bytesFromDataUri);
                            if (info != null) {
                                return CachedValueProvider.Result.create((Object)info, (Object[])new Object[]{src});
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{tag});
            });
        }

        @NotNull
        public Object[] getVariants() {
            ImageInfoReader.Info info = this.getImageInfo();
            if (this.myIsWidth && info != null && info.width != 0) {
                Object[] objectArray = new Object[]{AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)LookupElementBuilder.create((String)String.valueOf(info.width)))};
                if (objectArray == null) {
                    SizeReference.$$$reportNull$$$0(2);
                }
                return objectArray;
            }
            if (!this.myIsWidth && info != null && info.height != 0) {
                Object[] objectArray = new Object[]{AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)LookupElementBuilder.create((String)String.valueOf(info.height)))};
                if (objectArray == null) {
                    SizeReference.$$$reportNull$$$0(3);
                }
                return objectArray;
            }
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                SizeReference.$$$reportNull$$$0(4);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/htmltools/xml/util/HtmlReferenceProvider$SizeReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/htmltools/xml/util/HtmlReferenceProvider$SizeReference";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSizeValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getImageInfo";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ContentTypeReference
    extends BasicAttributeValueReference {
        @NonNls
        private static final String ourStyleContentType = "text/css";
        @NonNls
        static final String TYPE_ATTR_NAME = "type";

        ContentTypeReference(PsiElement element) {
            super(element);
        }

        @Nullable
        public PsiElement resolve() {
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class);
            if (tag != null) {
                if ("script".equalsIgnoreCase(tag.getName())) {
                    ArrayList mimeTypes = new ArrayList();
                    for (Language language : Language.getRegisteredLanguages()) {
                        Collections.addAll(mimeTypes, language.getMimeTypes());
                    }
                    Collections.sort(mimeTypes);
                    mimeTypes.remove("module");
                    Object[] objectArray = mimeTypes.toArray();
                    if (objectArray == null) {
                        ContentTypeReference.$$$reportNull$$$0(0);
                    }
                    return objectArray;
                }
                if ("style".equalsIgnoreCase(tag.getName())) {
                    Object[] objectArray = new LookupElement[]{AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)LookupElementBuilder.create((String)ourStyleContentType))};
                    if (objectArray == null) {
                        ContentTypeReference.$$$reportNull$$$0(1);
                    }
                    return objectArray;
                }
            }
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                ContentTypeReference.$$$reportNull$$$0(2);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/htmltools/xml/util/HtmlReferenceProvider$ContentTypeReference", "getVariants"));
        }
    }
}

