/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.openapi.progress.ProgressManager;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSRecursiveTypeVisitor {
    @NotNull
    private final Set<Object> myVisited;
    private final boolean myCheckResolved;

    public JSRecursiveTypeVisitor() {
        this(false);
    }

    public JSRecursiveTypeVisitor(boolean checkResolved) {
        this.myCheckResolved = checkResolved;
        this.myVisited = new THashSet();
    }

    public void visitJSTypeImpl(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(0);
        }
        this.visitJSTypeBaseImpl(type);
    }

    public void visitJSRecordType(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(1);
        }
        this.visitJSTypeBaseImpl(type);
    }

    public void visitJSCompositeBaseType(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(2);
        }
        this.visitJSTypeBaseImpl(type);
    }

    public void visitJSFunctionType(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(3);
        }
        this.visitJSTypeBaseImpl(type);
    }

    public void visitJSDecoratedType(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(4);
        }
        this.visitJSTypeBaseImpl(type);
    }

    public void visitJSGenericType(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(5);
        }
        this.visitJSTypeBaseImpl(type);
    }

    public void visitJSTypeBaseImpl(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(6);
        }
        this.visitFor(type);
    }

    public void visitJSGenericParameter(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(7);
        }
        this.visitJSTypeBaseImpl(type);
    }

    public void visitTypeScriptThisGenericType(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(8);
        }
        this.visitJSTypeBaseImpl(type);
    }

    protected final void visitFor(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(9);
        }
        if (this.myVisited.add(this.myCheckResolved ? type.getResolvedTypeId() : type)) {
            ProgressManager.checkCanceled();
            this.visitJSType(type);
        }
    }

    public void visitJSType(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(10);
        }
        type.acceptChildren(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "type";
        objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecursiveTypeVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSTypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSRecordType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSCompositeBaseType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSDecoratedType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSGenericType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSTypeBaseImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSGenericParameter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeScriptThisGenericType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

