/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.psi.PsiLiteralValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSLiteralExpression
extends JSExpression,
JSImplicitElementProvider,
PsiLiteralValue {
    @Nullable
    public Object getValue();

    @Nullable
    default public String getStringValue() {
        Object value = this.getValue();
        return value instanceof String ? (String)value : null;
    }

    @Nullable
    public String getValueAsPropertyName();

    @Nullable
    public String getSignificantValue();

    @NotNull
    default public JSLiteralExpressionKind getExpressionKind(boolean computeExactNumericKind) {
        JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.QUOTED;
        if (jSLiteralExpressionKind == null) {
            JSLiteralExpression.$$$reportNull$$$0(0);
        }
        return jSLiteralExpressionKind;
    }

    default public boolean isNumericLiteral() {
        return this.getExpressionKind(false).isNumeric();
    }

    default public boolean isQuotedLiteral() {
        JSLiteralExpressionKind kind = this.getExpressionKind(false);
        return JSLiteralExpression.isQuotedLiteral(kind);
    }

    public static boolean isQuotedLiteral(@NotNull JSLiteralExpressionKind kind) {
        if (kind == null) {
            JSLiteralExpression.$$$reportNull$$$0(1);
        }
        return kind == JSLiteralExpressionKind.QUOTED || kind == JSLiteralExpressionKind.TEMPLATE_WITH_ARGS || kind == JSLiteralExpressionKind.TEMPLATE_NO_ARGS;
    }

    default public boolean isStringLiteral() {
        return this.getExpressionKind(false) == JSLiteralExpressionKind.QUOTED;
    }

    default public boolean isBooleanLiteral() {
        return this.getExpressionKind(false).isBoolean();
    }

    default public boolean isOctalLiteral() {
        return this.getExpressionKind(true).isOct();
    }

    default public boolean isHexLiteral() {
        return this.getExpressionKind(true).isHex();
    }

    default public boolean isBinaryLiteral() {
        return this.getExpressionKind(true).isBin();
    }

    default public boolean isBigInteger() {
        return this.getExpressionKind(true).isBigInteger();
    }

    default public boolean isRegExpLiteral() {
        return this.getExpressionKind(false) == JSLiteralExpressionKind.REGEXP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSLiteralExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSLiteralExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedLiteral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

