/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NotNull;

public class JSSimplifyIfElseIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        SimplifyIfElsePredicate simplifyIfElsePredicate = new SimplifyIfElsePredicate();
        if (simplifyIfElsePredicate == null) {
            JSSimplifyIfElseIntention.$$$reportNull$$$0(0);
        }
        return simplifyIfElsePredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSSimplifyIfElseIntention.$$$reportNull$$$0(1);
        }
        PsiElement statement = element.getParent() instanceof JSIfStatement ? element.getParent() : element;
        ConditionalUtils.replaceAssignmentOrReturnIfSimplifiable((JSIfStatement)statement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/trivialif/JSSimplifyIfElseIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/trivialif/JSSimplifyIfElseIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SimplifyIfElsePredicate
    implements JSElementPredicate {
        private SimplifyIfElsePredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                SimplifyIfElsePredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSElement)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSIfStatement)) {
                if (element instanceof JSIfStatement) {
                    parent = element;
                } else {
                    return false;
                }
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)parent)) {
                return false;
            }
            JSIfStatement ifStatement = (JSIfStatement)parent;
            JSExpression condition = ifStatement.getCondition();
            if (condition == null || !condition.isValid()) {
                return false;
            }
            return ConditionalUtils.isSimplifiableAssignment(ifStatement, false) || ConditionalUtils.isSimplifiableAssignment(ifStatement, true) || ConditionalUtils.isSimplifiableReturn(ifStatement, false) || ConditionalUtils.isSimplifiableReturn(ifStatement, true) || ConditionalUtils.isSimplifiableImplicitReturn(ifStatement, false) || ConditionalUtils.isSimplifiableImplicitReturn(ifStatement, true) || ConditionalUtils.isSimplifiableImplicitAssignment(ifStatement, false) || ConditionalUtils.isSimplifiableImplicitAssignment(ifStatement, true) || ConditionalUtils.isSimplifiableEmptyBranches(ifStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSSimplifyIfElseIntention$SimplifyIfElsePredicate", "satisfiedBy"));
        }
    }
}

