/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.number;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;

class ShiftUtils {
    static final Map<IElementType, Pair<String, String>> shiftOperators = ShiftUtils.createShiftOperatorsMap();
    static final Map<IElementType, Pair<String, String>> multiplyOperators = ShiftUtils.createMultiplyOperatorsMap();

    private ShiftUtils() {
    }

    private static Map<IElementType, Pair<String, String>> createShiftOperatorsMap() {
        HashMap<IElementType, Pair<String, String>> operators = new HashMap<IElementType, Pair<String, String>>(4);
        ShiftUtils.addRow(operators, JSTokenTypes.LTLTEQ, "<<=", "*=");
        ShiftUtils.addRow(operators, JSTokenTypes.GTGTEQ, ">>=", "/=");
        ShiftUtils.addRow(operators, JSTokenTypes.LTLT, "<<", "*");
        ShiftUtils.addRow(operators, JSTokenTypes.GTGT, ">>", "/");
        return operators;
    }

    private static Map<IElementType, Pair<String, String>> createMultiplyOperatorsMap() {
        HashMap<IElementType, Pair<String, String>> operators = new HashMap<IElementType, Pair<String, String>>(4);
        ShiftUtils.addRow(operators, JSTokenTypes.MULTEQ, "*=", "<<=");
        ShiftUtils.addRow(operators, JSTokenTypes.DIVEQ, "/=", ">>=");
        ShiftUtils.addRow(operators, JSTokenTypes.MULT, "*", "<<");
        ShiftUtils.addRow(operators, JSTokenTypes.DIV, "/", ">>");
        return operators;
    }

    private static void addRow(Map<IElementType, Pair<String, String>> operators, IElementType elementType, String ownText, String transformedText) {
        operators.put(elementType, (Pair<String, String>)Pair.create((Object)ownText, (Object)transformedText));
    }

    public static boolean isPowerOfTwo(JSExpression expression) {
        long intValue;
        if (!(expression instanceof JSLiteralExpression)) {
            return false;
        }
        String value = expression.getText();
        try {
            intValue = Integer.decode(value).longValue();
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (intValue <= 0L) {
            return false;
        }
        while ((intValue & 1L) == 0L) {
            intValue >>= 1;
        }
        return intValue == 1L;
    }

    public static int getLogBase2(JSExpression rhs) {
        long intValue;
        String value = rhs.getText();
        try {
            intValue = Integer.decode(value).longValue();
        }
        catch (NumberFormatException e) {
            assert (false);
            return 0;
        }
        int log = 0;
        while ((intValue & 1L) == 0L) {
            intValue >>= 1;
            ++log;
        }
        return log;
    }

    public static int getExpBase2(JSExpression rhs) {
        long intValue;
        String value = rhs.getText();
        try {
            intValue = Integer.decode(value).longValue();
        }
        catch (NumberFormatException e) {
            assert (false);
            return 0;
        }
        int exp = 1;
        int i = 0;
        while ((long)i < intValue) {
            exp <<= 1;
            ++i;
        }
        return exp;
    }

    public static boolean isIntLiteral(JSExpression expression) {
        if (!(expression instanceof JSLiteralExpression)) {
            return false;
        }
        String value = expression.getText();
        try {
            Integer.decode(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

