/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.jetbrains.plugins.vagrant.VagrantMutableRemoteCredentials;
import org.jetbrains.annotations.NotNull;

public final class VagrantSshConfig {
    private String myHost;
    private String myUser;
    private String myPort;
    private String myUserKnownHostsFile;
    private boolean myStringHostKeyChecking;
    private boolean myPasswordAuthentication;
    private String myIdentityFilePath;
    private boolean myIdentitiesOnly;
    private final String myInstanceFolder;

    public VagrantSshConfig(String instanceFolder) {
        this.myInstanceFolder = instanceFolder;
    }

    public String getInstanceFolder() {
        return this.myInstanceFolder;
    }

    public static RemoteCredentials createRemoteCredentials(VagrantSshConfig config) {
        VagrantMutableRemoteCredentials credentials = new VagrantMutableRemoteCredentials();
        credentials.setHost(config.getHost());
        credentials.setPort(StringUtil.parseInt((String)config.getPort(), (int)0));
        credentials.setUserName(config.getUser());
        credentials.setAuthType(config.isPasswordAuthentication() ? AuthType.PASSWORD : AuthType.KEY_PAIR);
        credentials.setPrivateKeyFile(config.getIdentityFilePath());
        return credentials;
    }

    public String getHost() {
        return this.myHost;
    }

    public void setHost(String host) {
        this.myHost = host;
    }

    public String getUser() {
        return this.myUser;
    }

    public void setUser(String user) {
        this.myUser = user;
    }

    public String getPort() {
        return this.myPort;
    }

    public void setPort(String port) {
        this.myPort = port;
    }

    public String getUserKnownHostsFile() {
        return this.myUserKnownHostsFile;
    }

    public void setUserKnownHostsFile(String userKnownHostsFile) {
        this.myUserKnownHostsFile = userKnownHostsFile;
    }

    public boolean isStringHostKeyChecking() {
        return this.myStringHostKeyChecking;
    }

    public void setStringHostKeyChecking(boolean stringHostKeyChecking) {
        this.myStringHostKeyChecking = stringHostKeyChecking;
    }

    public boolean isPasswordAuthentication() {
        return this.myPasswordAuthentication;
    }

    public void setPasswordAuthentication(boolean passwordAuthentication) {
        this.myPasswordAuthentication = passwordAuthentication;
    }

    public String getIdentityFilePath() {
        return this.myIdentityFilePath;
    }

    public void setIdentityFilePath(String identityFilePath) {
        this.myIdentityFilePath = identityFilePath;
    }

    public boolean isIdentitiesOnly() {
        return this.myIdentitiesOnly;
    }

    public void setIdentitiesOnly(boolean identitiesOnly) {
        this.myIdentitiesOnly = identitiesOnly;
    }

    @NotNull
    public RemoteCredentials toRemoteCredentials() {
        RemoteCredentials remoteCredentials = VagrantSshConfig.createRemoteCredentials(this);
        if (remoteCredentials == null) {
            VagrantSshConfig.$$$reportNull$$$0(0);
        }
        return remoteCredentials;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantSshConfig", "toRemoteCredentials"));
    }
}

