/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ssh.AnalyzeKeyPairResult;
import com.intellij.ssh.InvalidKeyPair;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.ValidKeyPair;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.ErrorMessageAndField;
import com.jetbrains.plugins.webDeployment.connections.SftpUtil;
import com.jetbrains.plugins.webDeployment.ui.Util;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

public class RemoteCredentialsVerifiableHolder
extends RemoteCredentialsHolder
implements Cloneable {
    private static final Logger LOG = Logger.getInstance(RemoteCredentialsVerifiableHolder.class);

    @Nullable
    public ErrorMessageAndField verify(boolean checkSsh, String accessTypeName, boolean fast, long msTimeout, boolean checkUserName) throws TimeoutException {
        return RemoteCredentialsVerifiableHolder.verify(checkSsh, accessTypeName, fast, msTimeout, checkUserName, this.getHost(), this.getPort(), this.getUserName(), this.getAuthType(), this.getPrivateKeyFile());
    }

    @Nullable
    public static ErrorMessageAndField verify(boolean checkSsh, String accessTypeName, boolean fast, long msTimeout, String host, int port, AuthType authType, String privateKeyFile) throws TimeoutException {
        return RemoteCredentialsVerifiableHolder.verify(checkSsh, accessTypeName, fast, msTimeout, false, host, port, null, authType, privateKeyFile);
    }

    @Nullable
    private static ErrorMessageAndField verify(boolean checkSsh, String accessTypeName, boolean fast, long msTimeout, boolean checkUserName, String host, int port, String username, AuthType authType, String privateKeyFile) throws TimeoutException {
        URI uri;
        if (StringUtil.isEmpty((String)host)) {
            return new ErrorMessageAndField(WDBundle.message("host.is.empty", accessTypeName), "HOST");
        }
        String patchedHost = host.replaceAll("_", "a");
        if (!patchedHost.startsWith("[")) {
            uri = RemoteCredentialsVerifiableHolder.tryURI(patchedHost);
            if (uri == null || uri.getScheme() == null) {
                uri = RemoteCredentialsVerifiableHolder.tryURI("ftp://" + patchedHost);
            }
        } else {
            uri = RemoteCredentialsVerifiableHolder.tryURI("ftp://" + patchedHost);
            if (uri == null || uri.getScheme() == null) {
                uri = RemoteCredentialsVerifiableHolder.tryURI(patchedHost);
            }
        }
        if (uri == null || uri.getHost() == null || !"ftp".equalsIgnoreCase(uri.getScheme()) && !"sftp".equalsIgnoreCase(uri.getScheme()) && !"ftps".equalsIgnoreCase(uri.getScheme())) {
            if (host.contains(":")) {
                boolean ipv6 = true;
                for (int i = 0; i < host.length(); ++i) {
                    char ch = host.charAt(i);
                    if (ch >= '0' && ch <= '9' || ch == ':' || ch == '[' || ch == ']') continue;
                    ipv6 = false;
                    break;
                }
                if (ipv6) {
                    return new ErrorMessageAndField(WDBundle.message("host.is.invalid.try.ip6", accessTypeName), "HOST");
                }
            }
            if (!StringUtils.isAsciiPrintable((String)host)) {
                return new ErrorMessageAndField(WDBundle.message("host.is.invalid.try.type", accessTypeName), "HOST");
            }
            return new ErrorMessageAndField(WDBundle.message("host.is.invalid", accessTypeName), "HOST");
        }
        if (port <= 0) {
            return new ErrorMessageAndField(WDBundle.message("port.is.invalid", accessTypeName), "PORT");
        }
        if (checkUserName && StringUtil.isEmpty((String)username)) {
            return new ErrorMessageAndField(WDBundle.message("username.is.empty", new Object[0]), "USERNAME");
        }
        if (checkSsh && authType == AuthType.KEY_PAIR) {
            if (StringUtil.isEmpty((String)privateKeyFile)) {
                return new ErrorMessageAndField(WDBundle.message("private.key.empty", new Object[0]), "PRIVATE_KEY_FILE");
            }
            if (!fast) {
                return (ErrorMessageAndField)((Object)Util.runWithTimeout(msTimeout, () -> RemoteCredentialsVerifiableHolder.doSshSlowCheck(privateKeyFile)));
            }
        }
        return null;
    }

    @Nullable
    private static ErrorMessageAndField doSshSlowCheck(String privateKeyFile) {
        File privateKey = new File(privateKeyFile);
        if (!privateKey.isFile() || !privateKey.canRead()) {
            return new ErrorMessageAndField(WDBundle.message("private.key.file.not.found", privateKeyFile), "PRIVATE_KEY_FILE");
        }
        AnalyzeKeyPairResult checkResult = Ssh.analyzeKeyPair((File)privateKey, (SshBackendLibrary)SftpUtil.getSshBackendLibraryForWebDeployment());
        if (checkResult instanceof ValidKeyPair) {
            return null;
        }
        String message = ((InvalidKeyPair)checkResult).getErrorMessage();
        if (message != null) {
            return new ErrorMessageAndField(WDBundle.message("invalid.keypair.massage", privateKeyFile, message), "PRIVATE_KEY_FILE");
        }
        return new ErrorMessageAndField(WDBundle.message("invalid.keypair", privateKeyFile), "PRIVATE_KEY_FILE");
    }

    private static URI tryURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            LOG.info("Invalid URI " + uri + ": " + e.getMessage());
            return null;
        }
    }

    protected RemoteCredentialsVerifiableHolder clone() {
        try {
            return (RemoteCredentialsVerifiableHolder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

