/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.UploadCommitOptions;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import com.jetbrains.plugins.webDeployment.ui.config.ServerOrGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadCheckinHandlerFactory
extends CheckinHandlerFactory {
    private static final Logger LOG = Logger.getInstance(UploadCheckinHandlerFactory.class);

    @NotNull
    public CheckinHandler createHandler(final @NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        if (panel == null) {
            UploadCheckinHandlerFactory.$$$reportNull$$$0(0);
        }
        if (commitContext == null) {
            UploadCheckinHandlerFactory.$$$reportNull$$$0(1);
        }
        final PublishConfig publishConfig = PublishConfig.getInstance(panel.getProject());
        CheckinHandler checkinHandler = new CheckinHandler(){
            private final ServerOrGroup myTempSelected = new ServerOrGroup();

            public RefreshableOnComponent getAfterCheckinConfigurationPanel(Disposable parentDisposable) {
                return new UploadCommitOptions(panel.getProject(), publishConfig, this.myTempSelected);
            }

            public void checkinSuccessful() {
                Pair<WebServerGroupingWrap, WebServerConfig> serverAndGroup;
                ServerOrGroup idAndName = publishConfig.isPersistUploadOnCheckin() ? publishConfig.getUploadOnCheckin() : this.myTempSelected;
                if (idAndName.hasServer()) {
                    WebServerConfig server = GroupedServersConfigManager.getInstance(panel.getProject()).findServer(idAndName.getServerId());
                    this.tryToUpload(server);
                } else if (idAndName.hasGroup() && (serverAndGroup = GroupedServersConfigManager.getInstance(panel.getProject()).findByName(idAndName.getGroupName())) != null && serverAndGroup.first != null) {
                    for (WebServerConfig server : ((WebServerGroupingWrap)serverAndGroup.getFirst()).getServers()) {
                        this.tryToUpload(server);
                    }
                }
            }

            private void tryToUpload(@Nullable WebServerConfig server) {
                if (server == null || !server.needsTransfer()) {
                    return;
                }
                String error = server.getFileTransferConfig().validateFast();
                if (error != null) {
                    FileTransferToolWindow.printWithTimestamp(panel.getProject(), server, WDBundle.message("upload.on.commit", server.getName(), panel.getCommitMessage()) + "\n failed:" + error, ConsoleViewContentType.ERROR_OUTPUT, publishConfig.getTraceLevel());
                    return;
                }
                FileTransferToolWindow.printWithTimestamp(panel.getProject(), server, WDBundle.message("upload.on.commit", server.getName(), panel.getCommitMessage()), ConsoleViewContentType.SYSTEM_OUTPUT, publishConfig.getTraceLevel());
                final Collection changes = panel.getSelectedChanges();
                ApplicationManager.getApplication().invokeLater(() -> {
                    Project project = panel.getProject();
                    ProgressManager.getInstance().run((Task)new TransferTask.ListBased(project, ConnectionOwnerFactory.createConnectionOwner(project), true, publishConfig, Deployable.create(server), WDBundle.message("upload.to", server.getName()), true, true, true, ProjectDeploymentRevisionTracker.getInstance(project)){

                        @Override
                        protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                            return UploadCheckinHandlerFactory.doScanFiles(context, changes);
                        }
                    });
                });
            }
        };
        if (checkinHandler == null) {
            UploadCheckinHandlerFactory.$$$reportNull$$$0(2);
        }
        return checkinHandler;
    }

    public static TransferTask.ListBased.ResultWithErrors doScanFiles(ExecutionContext context, Collection<? extends Change> changes) throws FileSystemException {
        ArrayList<ChangeInfo> changeInfos = new ArrayList<ChangeInfo>(changes.size());
        for (Change change : changes) {
            changeInfos.add(new ChangeInfo(change));
        }
        Collections.sort(changeInfos);
        ArrayList<TransferOperation> result = new ArrayList<TransferOperation>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ChangeInfo change : changeInfos) {
            context.getProgressIndicator().checkCanceled();
            String itemPath = change.beforePath != null && !context.getConfig().isExcludedByName(change.beforePath) ? change.beforePath : change.afterPath;
            context.getProgressIndicator().setText(WDBundle.message("processing.0", itemPath));
            try {
                UploadCheckinHandlerFactory.processChange(change, context, result);
            }
            catch (FileSystemException e) {
                if (context.getConfig().isStopOnFirstError() || changeInfos.size() == 1 || PublishUtils.isFatal(e)) {
                    throw e;
                }
                LOG.warn((Throwable)e);
                arrayList.add(WDBundle.message("failed.to.process.change", itemPath, PublishUtils.getMessage(e, false)));
            }
        }
        return new TransferTask.ListBased.ResultWithErrors(result, DeploymentPathUtils.ErrorsAndExclusions.reportErrors(arrayList));
    }

    private static void processChange(ChangeInfo change, ExecutionContext context, List<TransferOperation> result) throws FileSystemException {
        if (change.beforePath == null || context.getConfig().isExcludedByName(change.beforePath)) {
            UploadCheckinHandlerFactory.processCreate(context, result, change.afterPath, change.isDirectory);
        } else if (change.afterPath == null || context.getConfig().isExcludedByName(change.afterPath)) {
            UploadCheckinHandlerFactory.processDelete(context, result, change.beforePath, change.isDirectory);
        } else {
            DeploymentPathMapping mappingBefore = (DeploymentPathMapping)context.getConfig().getNearestMappingForLocal(change.beforePath, false, true, false, (Mappable)context.getServer()).getFirst();
            DeploymentPathMapping mappingAfter = (DeploymentPathMapping)context.getConfig().getNearestMappingForLocal(change.afterPath, false, true, false, (Mappable)context.getServer()).getFirst();
            if (mappingBefore != null && mappingAfter != null) {
                WebServerConfig.RemotePath targetBefore = mappingBefore.mapToDeployPath(change.beforePath, (Mappable)context.getServer());
                WebServerConfig.RemotePath targetAfter = mappingAfter.mapToDeployPath(change.afterPath, (Mappable)context.getServer());
                if (change.isDirectory) {
                    if (!(change.beforePath.equals(change.afterPath) || UploadCheckinHandlerFactory.isEmptyDirectory(change.afterPath) && !context.getConfig().isCreateEmptyDirectories())) {
                        result.add(new TransferOperation.RemoteMoveOrUpload(change.afterPath, targetBefore, targetAfter, true));
                    }
                } else {
                    FileObject sourceAfter = DeploymentPathUtils.getLocalFile(change.afterPath);
                    if (targetBefore.equals(targetAfter)) {
                        result.add(new TransferOperation.Copy(sourceAfter, targetAfter));
                    } else {
                        result.add(new TransferOperation.RemoteMoveOrUpload(change.afterPath, targetBefore, targetAfter, false));
                    }
                }
            } else if (mappingBefore != null) {
                UploadCheckinHandlerFactory.processCreate(context, result, change.afterPath, true);
            } else if (mappingAfter != null) {
                UploadCheckinHandlerFactory.processDelete(context, result, change.beforePath, change.isDirectory);
            }
        }
    }

    private static void processCreate(ExecutionContext context, List<TransferOperation> result, String path, boolean isDirectory) throws FileSystemException {
        if (isDirectory) {
            DeploymentPathMapping mapping;
            if (context.getConfig().isCreateEmptyDirectories() && (mapping = (DeploymentPathMapping)context.getConfig().getNearestMappingForLocal(path, false, true, false, (Mappable)context.getServer()).getFirst()) != null && UploadCheckinHandlerFactory.isEmptyDirectory(path)) {
                WebServerConfig.RemotePath targetPath = mapping.mapToDeployPath(path, (Mappable)context.getServer());
                result.add(new TransferOperation.CreateFolder(context.findRemoteFile(targetPath, true)));
            }
        } else {
            DeploymentPathMapping mapping = (DeploymentPathMapping)context.getConfig().getNearestMappingForLocal(path, false, true, false, (Mappable)context.getServer()).getFirst();
            if (mapping != null) {
                FileObject source = DeploymentPathUtils.getLocalFile(path);
                FileObject target = context.findRemoteFile(mapping.mapToDeployPath(path, (Mappable)context.getServer()), true);
                result.add(new TransferOperation.Copy(source, target));
            }
        }
    }

    private static void processDelete(ExecutionContext context, List<TransferOperation> result, String path, boolean isDirectory) throws FileSystemException {
        DeploymentPathMapping mapping = (DeploymentPathMapping)context.getConfig().getNearestMappingForLocal(path, false, true, false, (Mappable)context.getServer()).getFirst();
        if (mapping != null) {
            FileObject target = context.findRemoteFile(mapping.mapToDeployPath(path, (Mappable)context.getServer()), true);
            result.add(new TransferOperation.Delete(target, isDirectory, true));
        }
    }

    private static boolean isEmptyDirectory(String path) {
        return new File(path).list().length == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/UploadCheckinHandlerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/UploadCheckinHandlerFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChangeInfo
    implements Comparable<ChangeInfo> {
        @Nullable
        public String beforePath;
        @Nullable
        public String afterPath;
        public final boolean isDirectory;

        private ChangeInfo(Change change) {
            ContentRevision before = change.getBeforeRevision();
            ContentRevision after = change.getAfterRevision();
            this.beforePath = before != null ? before.getFile().getPresentableUrl() : null;
            this.afterPath = after != null ? after.getFile().getPresentableUrl() : null;
            this.isDirectory = before != null ? before.getFile().isDirectory() : after.getFile().isDirectory();
        }

        @Override
        public int compareTo(@NotNull ChangeInfo o) {
            if (o == null) {
                ChangeInfo.$$$reportNull$$$0(0);
            }
            return StringUtil.compare((String)this.beforePath, (String)o.beforePath, (boolean)SystemInfo.isFileSystemCaseSensitive);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/plugins/webDeployment/UploadCheckinHandlerFactory$ChangeInfo", "compareTo"));
        }
    }
}

