/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.UploadBeforeRunTask;
import com.jetbrains.plugins.webDeployment.UploadableRunConfigurationsFilter;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import com.jetbrains.plugins.webDeployment.ui.UploadBeforeRunTaskDialog;
import com.jetbrains.plugins.webDeployment.ui.config.ServerOrGroup;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadBeforeRunTaskProvider
extends BeforeRunTaskProvider<UploadBeforeRunTask> {
    private static final Logger LOG = Logger.getInstance(UploadBeforeRunTaskProvider.class);
    public static final Key<UploadBeforeRunTask> ID = Key.create((String)"FtpUpload");

    public Key<UploadBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return WDBundle.message("upload.before.run.step.description", WDBundle.message("web.server.capitalized", new Object[0]));
    }

    public String getDescription(UploadBeforeRunTask task) {
        ServerOrGroup serverOrGroup = task.getServerOrGroup();
        if (serverOrGroup.hasGroup()) {
            return WDBundle.message("upload.before.run.step.description", serverOrGroup.getGroupName());
        }
        if (!StringUtil.isEmptyOrSpaces((String)serverOrGroup.getServerName())) {
            return WDBundle.message("upload.before.run.step.description", serverOrGroup.getServerName());
        }
        return WDBundle.message("upload.before.run.step.description", WDBundle.message("web.server.capitalized", new Object[0]));
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public UploadBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            UploadBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        for (UploadableRunConfigurationsFilter filter : UploadableRunConfigurationsFilter.EP_NAME.getExtensionList()) {
            if (!filter.isUploadBeforeRunEnabled(runConfiguration)) continue;
            return new UploadBeforeRunTask();
        }
        return null;
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull UploadBeforeRunTask task) {
        if (runConfiguration == null) {
            UploadBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        if (task == null) {
            UploadBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        UploadBeforeRunTaskDialog d = new UploadBeforeRunTaskDialog(runConfiguration.getProject(), task);
        return d.showAndGet();
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull UploadBeforeRunTask task) {
        if (configuration == null) {
            UploadBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        if (task == null) {
            UploadBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        if (task.getRoots().isEmpty()) {
            return false;
        }
        ServerOrGroup serverOrGroup = task.getServerOrGroup();
        return serverOrGroup.hasServer() || serverOrGroup.hasGroup();
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull UploadBeforeRunTask task) {
        if (context == null) {
            UploadBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            UploadBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        if (env == null) {
            UploadBeforeRunTaskProvider.$$$reportNull$$$0(7);
        }
        if (task == null) {
            UploadBeforeRunTaskProvider.$$$reportNull$$$0(8);
        }
        Semaphore done = new Semaphore();
        Ref result = new Ref((Object)false);
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                Project project = (Project)CommonDataKeys.PROJECT.getData(context);
                if (project == null || project.isDisposed() || project.isDefault()) {
                    return;
                }
                PublishConfig publishConfig = PublishConfig.getInstance(project);
                ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(task.getRoots().size());
                for (String path : task.getRoots()) {
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
                    if (file == null || !file.isValid()) continue;
                    files.add(file);
                }
                VfsUtilCore.DistinctVFilesRootsCollection roots = new VfsUtilCore.DistinctVFilesRootsCollection(files);
                AutoUploadComponent.saveDocumentsSilently(project, (Collection<VirtualFile>)roots);
                ServerOrGroup serverOrGroup = task.getServerOrGroup();
                if (serverOrGroup.hasGroup()) {
                    Pair<WebServerGroupingWrap, WebServerConfig> serverConfigPair = GroupedServersConfigManager.getInstance(project).findByName(serverOrGroup.getGroupName());
                    if (serverConfigPair == null || serverConfigPair.first == null) {
                        UploadBeforeRunTaskProvider.report(project, null, WDBundle.message("group.not.exists", serverOrGroup.getGroupName()), true);
                        return;
                    }
                    done.down();
                    try {
                        for (WebServerConfig server : ((WebServerGroupingWrap)serverConfigPair.first).getServers()) {
                            UploadBeforeRunTaskProvider.uploadToServer(configuration, done, (Ref<Boolean>)result, project, publishConfig, (Collection<VirtualFile>)roots, server);
                        }
                    }
                    finally {
                        done.up();
                    }
                } else {
                    if (StringUtil.isEmpty((String)serverOrGroup.getServerId()) && StringUtil.isEmpty((String)serverOrGroup.getServerName())) {
                        UploadBeforeRunTaskProvider.report(project, null, WDBundle.message("server.is.not.specified", new Object[0]), true);
                        return;
                    }
                    WebServerConfig server = GroupedServersConfigManager.getInstance(project).findServer(serverOrGroup.getServerId());
                    if (server == null) {
                        UploadBeforeRunTaskProvider.report(project, null, WDBundle.message("server.not.exists", serverOrGroup.getServerName()), true);
                        return;
                    }
                    UploadBeforeRunTaskProvider.uploadToServer(configuration, done, (Ref<Boolean>)result, project, publishConfig, (Collection<VirtualFile>)roots, server);
                }
            }, ModalityState.NON_MODAL);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return false;
        }
        done.waitFor();
        return (Boolean)result.get();
    }

    private static void uploadToServer(@NotNull RunConfiguration configuration, final Semaphore done, final Ref<Boolean> result, Project project, PublishConfig publishConfig, final Collection<VirtualFile> roots, WebServerConfig server) {
        String error;
        if (configuration == null) {
            UploadBeforeRunTaskProvider.$$$reportNull$$$0(9);
        }
        if ((error = server.validateFast()) != null) {
            UploadBeforeRunTaskProvider.report(project, server, WDBundle.message("server.invalid", server.getName(), error), true);
            return;
        }
        if (!server.needsTransfer()) {
            UploadBeforeRunTaskProvider.report(project, server, WDBundle.message("server.is.local", server.getName()), false);
            result.set((Object)true);
            return;
        }
        FileTransferToolWindow.printWithTimestamp(project, server, WDBundle.message("upload.on.run", server.getName(), configuration.getName()), ConsoleViewContentType.SYSTEM_OUTPUT, publishConfig.getTraceLevel());
        done.down();
        new TransferTask.ListBased(project, ConnectionOwnerFactory.createConnectionOwner(project), true, publishConfig, Deployable.create(server), WDBundle.message("upload.to", server.getName()), true, true, true, ProjectDeploymentRevisionTracker.getInstance(project)){

            @Override
            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    result.set((Object)this.doRun(pi));
                }
                finally {
                    done.up();
                }
            }

            @Override
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context1) throws FileSystemException {
                return PublishActionUtil.scanFiles(context1, roots);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/UploadBeforeRunTaskProvider$1", "run"));
            }
        }.queue();
    }

    private static void report(Project project, @Nullable WebServerConfig server, String message, boolean error) {
        FileTransferToolWindow.printWithTimestamp(project, server, message, error ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.SYSTEM_OUTPUT);
        ApplicationManager.getApplication().invokeLater(() -> DeploymentNotifier.notifyWithBalloon(null, message, error ? NotificationType.ERROR : NotificationType.WARNING, null, project, FileTransferToolWindow.ID_PROVIDER));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/UploadBeforeRunTaskProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTask";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "configureTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canExecuteTask";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTask";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "uploadToServer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

