/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.CommitExecutorBase;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.CloudGitApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.CloudBundle;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentRuntime;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.Semaphore;
import git4idea.GitUtil;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudGitDeploymentRuntime
extends CloudDeploymentRuntime {
    private static final Logger LOG = Logger.getInstance(CloudGitDeploymentRuntime.class);
    private static final String COMMIT_MESSAGE = "Deploy";
    private static final CommitSession NO_COMMIT = new CommitSession(){

        public void execute(@NotNull Collection<Change> changes, @Nullable String commitMessage) {
            if (changes == null) {
                1.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/remoteServer/util/CloudGitDeploymentRuntime$1", "execute"));
        }
    };
    private static final List<CommitExecutor> ourCommitExecutors = Arrays.asList(new CommitExecutor(){

        @NotNull
        @Nls
        public String getActionText() {
            if ("Commit and Push" == null) {
                2.$$$reportNull$$$0(0);
            }
            return "Commit and Push";
        }

        public boolean supportsPartialCommit() {
            return true;
        }

        @NotNull
        public CommitSession createCommitSession(@NotNull CommitContext commitContext) {
            if (commitContext == null) {
                2.$$$reportNull$$$0(1);
            }
            CommitSession commitSession = CommitSession.VCS_COMMIT;
            if (commitSession == null) {
                2.$$$reportNull$$$0(2);
            }
            return commitSession;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/util/CloudGitDeploymentRuntime$2";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/util/CloudGitDeploymentRuntime$2";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCommitSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createCommitSession";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }, new CommitExecutorBase(){

        @NotNull
        @Nls
        public String getActionText() {
            if ("Push without Commit" == null) {
                3.$$$reportNull$$$0(0);
            }
            return "Push without Commit";
        }

        @NotNull
        public CommitSession createCommitSession(@NotNull CommitContext commitContext) {
            if (commitContext == null) {
                3.$$$reportNull$$$0(1);
            }
            CommitSession commitSession = NO_COMMIT;
            if (commitSession == null) {
                3.$$$reportNull$$$0(2);
            }
            return commitSession;
        }

        public boolean areChangesRequired() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/util/CloudGitDeploymentRuntime$3";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/util/CloudGitDeploymentRuntime$3";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCommitSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createCommitSession";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    });
    private final GitRepositoryManager myGitRepositoryManager;
    private final Git myGit;
    private final VirtualFile myContentRoot;
    private final File myRepositoryRootFile;
    private final String myDefaultRemoteName;
    private final ChangeListManagerEx myChangeListManager;
    private String myRemoteName;
    private final String myCloudName;
    private GitRepository myRepository;

    public CloudGitDeploymentRuntime(CloudMultiSourceServerRuntimeInstance serverRuntime, DeploymentSource source, File repositoryRoot, DeploymentTask<? extends CloudDeploymentNameConfiguration> task, DeploymentLogManager logManager, String defaultRemoteName, String cloudName) throws ServerRuntimeException {
        super(serverRuntime, source, task, logManager);
        this.myDefaultRemoteName = defaultRemoteName;
        this.myCloudName = cloudName;
        this.myRepositoryRootFile = repositoryRoot;
        VirtualFile contentRoot = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myRepositoryRootFile);
        LOG.assertTrue(contentRoot != null, (Object)"Repository root is not found");
        this.myContentRoot = contentRoot;
        Project project = this.getProject();
        this.myGitRepositoryManager = GitUtil.getRepositoryManager((Project)project);
        this.myGit = (Git)ServiceManager.getService(Git.class);
        if (this.myGit == null) {
            throw new ServerRuntimeException("Can't initialize GIT");
        }
        this.myChangeListManager = ChangeListManagerImpl.getInstanceImpl((Project)project);
    }

    public CloudGitApplication deploy() throws ServerRuntimeException {
        CloudGitApplication application = this.findOrCreateApplication();
        this.deployApplication(application);
        return application;
    }

    private void deployApplication(CloudGitApplication application) throws ServerRuntimeException {
        boolean firstDeploy = this.findRepository() == null;
        GitRepository repository = this.findOrCreateRepository();
        this.addOrResetGitRemote(application, repository);
        LocalChangeList activeChangeList = this.myChangeListManager.getDefaultChangeList();
        if (activeChangeList != null && !firstDeploy) {
            this.commitWithChangesDialog(activeChangeList);
        } else {
            this.add();
            this.commit();
        }
        repository.update();
        this.pushApplication(application);
    }

    protected void commitWithChangesDialog(@NotNull LocalChangeList activeChangeList) throws ServerRuntimeException {
        if (activeChangeList == null) {
            CloudGitDeploymentRuntime.$$$reportNull$$$0(0);
        }
        Collection changes = activeChangeList.getChanges();
        ArrayList<Change> relevantChanges = new ArrayList<Change>();
        for (Change change : changes) {
            if (!this.isRelevant(change.getBeforeRevision()) && !this.isRelevant(change.getAfterRevision())) continue;
            relevantChanges.add(change);
        }
        final Semaphore commitSemaphore = new Semaphore();
        commitSemaphore.down();
        final Ref commitSucceeded = new Ref((Object)false);
        Boolean commitStarted = (Boolean)CloudGitDeploymentRuntime.runOnEdt(() -> CommitChangeListDialog.commitChanges((Project)this.getProject(), (List)relevantChanges, (LocalChangeList)activeChangeList, ourCommitExecutors, (boolean)false, (String)COMMIT_MESSAGE, (CommitResultHandler)new CommitResultHandler(){

            public void onSuccess(@NotNull String commitMessage) {
                if (commitMessage == null) {
                    4.$$$reportNull$$$0(0);
                }
                commitSucceeded.set((Object)true);
                commitSemaphore.up();
            }

            public void onFailure() {
                commitSemaphore.up();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "com/intellij/remoteServer/util/CloudGitDeploymentRuntime$4", "onSuccess"));
            }
        }, (boolean)false));
        if (commitStarted != null && commitStarted.booleanValue()) {
            commitSemaphore.waitFor();
            if (!((Boolean)commitSucceeded.get()).booleanValue()) {
                this.getRepository().update();
                throw new ServerRuntimeException("Commit failed");
            }
        } else {
            throw new ServerRuntimeException("Deploy interrupted");
        }
    }

    private boolean isRelevant(ContentRevision contentRevision) throws ServerRuntimeException {
        if (contentRevision == null) {
            return false;
        }
        GitRepository repository = this.getRepository();
        VirtualFile affectedFile = contentRevision.getFile().getVirtualFile();
        return affectedFile != null && VfsUtilCore.isAncestor((VirtualFile)repository.getRoot(), (VirtualFile)affectedFile, (boolean)false);
    }

    private static <T> T runOnEdt(Computable<T> computable) {
        Ref result = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> result.set(computable.compute()));
        return (T)result.get();
    }

    public boolean isDeployed() throws ServerRuntimeException {
        return this.findApplication() != null;
    }

    public CloudGitApplication findOrCreateApplication() throws ServerRuntimeException {
        CloudGitApplication application = this.findApplication();
        if (application == null) {
            application = this.createApplication();
        }
        return application;
    }

    public void addOrResetGitRemote(CloudGitApplication application, GitRepository repository) throws ServerRuntimeException {
        GitRemote gitRemote;
        String gitUrl = application.getGitUrl();
        if (this.myRemoteName == null) {
            for (GitRemote gitRemote2 : repository.getRemotes()) {
                if (!gitRemote2.getUrls().contains(gitUrl)) continue;
                this.myRemoteName = gitRemote2.getName();
                return;
            }
        }
        if ((gitRemote = GitUtil.findRemoteByName((GitRepository)repository, (String)this.getRemoteName())) == null) {
            this.addGitRemote(application);
        } else if (!gitRemote.getUrls().contains(gitUrl)) {
            this.resetGitRemote(application);
        }
    }

    public GitRepository findOrCreateRepository() throws ServerRuntimeException {
        GitRepository repository = this.findRepository();
        if (repository == null) {
            this.getLoggingHandler().println("Initializing git repository...");
            GitCommandResult gitInitResult = this.getGit().init(this.getProject(), this.getRepositoryRoot(), new GitLineHandlerListener[]{this.createGitLineHandlerListener()});
            CloudGitDeploymentRuntime.checkGitResult(gitInitResult);
            this.refreshApplicationRepository();
            repository = this.getRepository();
        }
        return repository;
    }

    public void downloadExistingApplication() throws ServerRuntimeException {
        new CloneJobWithRemote().cloneToModule(this.getApplication().getGitUrl());
        this.getRepository().update();
        this.refreshContentRoot();
    }

    protected Git getGit() {
        return this.myGit;
    }

    protected VirtualFile getRepositoryRoot() {
        return this.myContentRoot;
    }

    protected File getRepositoryRootFile() {
        return this.myRepositoryRootFile;
    }

    protected static void checkGitResult(GitCommandResult commandResult) throws ServerRuntimeException {
        if (!commandResult.success()) {
            throw new ServerRuntimeException(commandResult.getErrorOutputAsJoinedString());
        }
    }

    protected GitLineHandlerListener createGitLineHandlerListener() {
        return new GitLineHandlerListener(){

            public void onLineAvailable(String line, Key outputType) {
                CloudGitDeploymentRuntime.this.getLoggingHandler().println(line);
            }
        };
    }

    protected CloudAgentLoggingHandler getLoggingHandler() {
        return super.getLoggingHandler();
    }

    protected void addGitRemote(CloudGitApplication application) throws ServerRuntimeException {
        this.doGitRemote(this.getRemoteName(), application, "add", CloudBundle.getText((String)"failed.add.remote", (Object[])new Object[]{this.getRemoteName()}));
    }

    protected void resetGitRemote(CloudGitApplication application) throws ServerRuntimeException {
        this.doGitRemote(this.getRemoteName(), application, "set-url", CloudBundle.getText((String)"failed.reset.remote", (Object[])new Object[]{this.getRemoteName()}));
    }

    protected void doGitRemote(String remoteName, CloudGitApplication application, String subCommand, String failMessage) throws ServerRuntimeException {
        try {
            GitLineHandler handler = new GitLineHandler(this.getProject(), this.myContentRoot, GitCommand.REMOTE);
            handler.setSilent(false);
            handler.addParameters(new String[]{subCommand, remoteName, application.getGitUrl()});
            GitCommandResult result = this.myGit.runCommand(handler);
            result.throwOnError(new int[0]);
            this.getRepository().update();
            if (result.getExitCode() != 0) {
                throw new ServerRuntimeException(failMessage);
            }
        }
        catch (VcsException e) {
            throw new ServerRuntimeException((Throwable)e);
        }
    }

    @Nullable
    protected GitRepository findRepository() {
        if (this.myRepository != null) {
            return this.myRepository;
        }
        this.myRepository = (GitRepository)this.myGitRepositoryManager.getRepositoryForRoot(this.myContentRoot);
        return this.myRepository;
    }

    protected void refreshApplicationRepository() {
        Project project = this.getProject();
        GitInit.refreshAndConfigureVcsMappings((Project)project, (VirtualFile)this.getRepositoryRoot(), (String)this.getRepositoryRootFile().getAbsolutePath());
    }

    protected void pushApplication(@NotNull CloudGitApplication application) throws ServerRuntimeException {
        if (application == null) {
            CloudGitDeploymentRuntime.$$$reportNull$$$0(1);
        }
        this.push(application, this.getRepository(), this.getRemoteName());
    }

    protected void push(@NotNull CloudGitApplication application, @NotNull GitRepository repository, @NotNull String remote) throws ServerRuntimeException {
        if (application == null) {
            CloudGitDeploymentRuntime.$$$reportNull$$$0(2);
        }
        if (repository == null) {
            CloudGitDeploymentRuntime.$$$reportNull$$$0(3);
        }
        if (remote == null) {
            CloudGitDeploymentRuntime.$$$reportNull$$$0(4);
        }
        GitCommandResult gitPushResult = this.getGit().push(repository, remote, application.getGitUrl(), "master:master", false, new GitLineHandlerListener[]{this.createGitLineHandlerListener()});
        CloudGitDeploymentRuntime.checkGitResult(gitPushResult);
    }

    @NotNull
    protected GitRepository getRepository() throws ServerRuntimeException {
        GitRepository repository = this.findRepository();
        if (repository == null) {
            throw new ServerRuntimeException("Unable to find GIT repository for module root: " + this.myContentRoot);
        }
        GitRepository gitRepository = repository;
        if (gitRepository == null) {
            CloudGitDeploymentRuntime.$$$reportNull$$$0(5);
        }
        return gitRepository;
    }

    protected void fetch() throws ServerRuntimeException {
        VirtualFile contentRoot = this.getRepositoryRoot();
        GitRepository repository = this.getRepository();
        GitLineHandler fetchHandler = new GitLineHandler(this.getProject(), contentRoot, GitCommand.FETCH);
        fetchHandler.setUrl(this.getApplication().getGitUrl());
        fetchHandler.setSilent(false);
        fetchHandler.addParameters(new String[]{this.getRemoteName()});
        fetchHandler.addLineListener(this.createGitLineHandlerListener());
        this.performRemoteGitTask(fetchHandler, CloudBundle.getText((String)"fetching.application", (Object[])new Object[]{this.getCloudName()}));
        repository.update();
    }

    protected void add() throws ServerRuntimeException {
        try {
            GitFileUtils.addFiles((Project)this.getProject(), (VirtualFile)this.myContentRoot, (VirtualFile[])new VirtualFile[]{this.myContentRoot});
        }
        catch (VcsException e) {
            throw new ServerRuntimeException((Throwable)e);
        }
    }

    protected void commit() throws ServerRuntimeException {
        this.commit(COMMIT_MESSAGE);
    }

    protected void commit(String message) throws ServerRuntimeException {
        try {
            if (GitUtil.hasLocalChanges((boolean)true, (Project)this.getProject(), (VirtualFile)this.myContentRoot)) {
                GitLineHandler handler = new GitLineHandler(this.getProject(), this.myContentRoot, GitCommand.COMMIT);
                handler.setSilent(false);
                handler.setStdoutSuppressed(false);
                handler.addParameters(new String[]{"-m", message});
                handler.endOptions();
                Git.getInstance().runCommand(handler).throwOnError(new int[0]);
            }
        }
        catch (VcsException e) {
            throw new ServerRuntimeException((Throwable)e);
        }
    }

    protected void performRemoteGitTask(GitLineHandler handler, String title) throws ServerRuntimeException {
        GitCommandResult result;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(title);
            handler.addLineListener(GitStandardProgressAnalyzer.createListener((ProgressIndicator)indicator));
        }
        if (!(result = this.myGit.runCommand(handler)).success()) {
            this.getLoggingHandler().println(result.getErrorOutputAsJoinedString());
            throw new ServerRuntimeException(result.getErrorOutputAsJoinedString());
        }
    }

    protected void refreshContentRoot() {
        ApplicationManager.getApplication().invokeLater(() -> this.getRepositoryRoot().refresh(false, true));
    }

    public void fetchAndRefresh() throws ServerRuntimeException {
        this.fetch();
        this.refreshContentRoot();
    }

    private String getRemoteName() {
        if (this.myRemoteName == null) {
            this.myRemoteName = this.myDefaultRemoteName;
        }
        return this.myRemoteName;
    }

    private String getCloudName() {
        return this.myCloudName;
    }

    protected CloudGitApplication findApplication() throws ServerRuntimeException {
        return (CloudGitApplication)this.getAgentTaskExecutor().execute(() -> this.getDeployment().findApplication());
    }

    protected CloudGitApplication getApplication() throws ServerRuntimeException {
        CloudGitApplication application = this.findApplication();
        if (application == null) {
            throw new ServerRuntimeException("Can't find the application: " + this.getApplicationName());
        }
        return application;
    }

    protected CloudGitApplication createApplication() throws ServerRuntimeException {
        return (CloudGitApplication)this.getAgentTaskExecutor().execute(() -> this.getDeployment().createApplication());
    }

    public CloudGitApplication findApplication4Repository() throws ServerRuntimeException {
        ArrayList repositoryUrls = new ArrayList();
        for (GitRemote remote : this.getRepository().getRemotes()) {
            repositoryUrls.addAll(remote.getUrls());
        }
        return (CloudGitApplication)this.getAgentTaskExecutor().execute(() -> this.getDeployment().findApplication4Repository(ArrayUtilRt.toStringArray((Collection)repositoryUrls)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeChangeList";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/util/CloudGitDeploymentRuntime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/util/CloudGitDeploymentRuntime";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "commitWithChangesDialog";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "pushApplication";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class CloneJobWithRemote
    extends CloneJob {
        @Override
        public void doClone(File cloneDirParent, String cloneDirName, String gitUrl) throws ServerRuntimeException {
            GitLineHandler handler = new GitLineHandler(CloudGitDeploymentRuntime.this.getProject(), cloneDirParent, GitCommand.CLONE);
            handler.setSilent(false);
            handler.setStdoutSuppressed(false);
            handler.setUrl(gitUrl);
            handler.addParameters(new String[]{"--progress"});
            handler.addParameters(new String[]{gitUrl});
            handler.addParameters(new String[]{cloneDirName});
            handler.addParameters(new String[]{"-o"});
            handler.addParameters(new String[]{CloudGitDeploymentRuntime.this.getRemoteName()});
            handler.addLineListener(CloudGitDeploymentRuntime.this.createGitLineHandlerListener());
            CloudGitDeploymentRuntime.this.performRemoteGitTask(handler, CloudBundle.getText((String)"cloning.existing.application", (Object[])new Object[]{CloudGitDeploymentRuntime.this.getCloudName()}));
        }
    }

    public class CloneJob {
        public File cloneToTemp(String gitUrl) throws ServerRuntimeException {
            File cloneDir;
            try {
                cloneDir = FileUtil.createTempDirectory((String)"cloud", (String)"clone");
            }
            catch (IOException e) {
                throw new ServerRuntimeException((Throwable)e);
            }
            File cloneDirParent = cloneDir.getParentFile();
            String cloneDirName = cloneDir.getName();
            this.doClone(cloneDirParent, cloneDirName, gitUrl);
            return cloneDir;
        }

        public void cloneToModule(String gitUrl) throws ServerRuntimeException {
            File cloneDir = this.cloneToTemp(gitUrl);
            try {
                FileUtil.copyDir((File)cloneDir, (File)CloudGitDeploymentRuntime.this.getRepositoryRootFile());
            }
            catch (IOException e) {
                throw new ServerRuntimeException((Throwable)e);
            }
            CloudGitDeploymentRuntime.this.refreshApplicationRepository();
        }

        public void doClone(File cloneDirParent, String cloneDirName, String gitUrl) throws ServerRuntimeException {
            GitCommandResult gitCloneResult = CloudGitDeploymentRuntime.this.getGit().clone(CloudGitDeploymentRuntime.this.getProject(), cloneDirParent, gitUrl, cloneDirName, new GitLineHandlerListener[]{CloudGitDeploymentRuntime.this.createGitLineHandlerListener()});
            CloudGitDeploymentRuntime.checkGitResult(gitCloneResult);
        }
    }
}

