/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.settings.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.JBIntSpinner;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.Row;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterSettingsChangeListener;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterSettingsChangeListenerKt;
import org.jetbrains.plugins.notebooks.jupyter.settings.JupyterSettings;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\fH\u0016J\b\u0010\u0016\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/settings/ui/JupyterSettingsConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "()V", "mainPanel", "Ljavax/swing/JPanel;", "showInlineValues", "Lcom/intellij/ui/components/JBCheckBox;", "showLineSeparators", "showValuesCheckBox", "sourceCodeLineSpan", "Lcom/intellij/ui/JBIntSpinner;", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "getDisplayName", "", "getHelpTopic", "getId", "isModified", "", "reset", "settingsChanged", "intellij.python.jupyter"})
public final class JupyterSettingsConfigurable
implements SearchableConfigurable {
    private final JPanel mainPanel;
    private final JBCheckBox showValuesCheckBox = new JBCheckBox("Show Variables Values in the Jupyter Tool Window");
    private final JBCheckBox showLineSeparators = new JBCheckBox("Show Cell Line Separators in the Editor");
    private final JBIntSpinner sourceCodeLineSpan = new JBIntSpinner(JupyterSettings.Companion.getInstance().getSourceCodeLineSpan(), 0, 3);
    private final JBCheckBox showInlineValues = new JBCheckBox("Show Inline Values in the Editor");

    public void reset() {
        this.showValuesCheckBox.setSelected(JupyterSettings.Companion.getInstance().getShowVariablesView());
        this.showLineSeparators.setSelected(JupyterSettings.Companion.getInstance().getShowLineSeparators());
        this.sourceCodeLineSpan.setNumber(JupyterSettings.Companion.getInstance().getSourceCodeLineSpan());
        this.showInlineValues.setSelected(JupyterSettings.Companion.getInstance().getShowInlineValues());
    }

    public boolean isModified() {
        return this.showValuesCheckBox.isSelected() != JupyterSettings.Companion.getInstance().getShowVariablesView() || this.showLineSeparators.isSelected() != JupyterSettings.Companion.getInstance().getShowLineSeparators() || this.sourceCodeLineSpan.getNumber() != JupyterSettings.Companion.getInstance().getSourceCodeLineSpan() || this.showInlineValues.isSelected() != JupyterSettings.Companion.getInstance().getShowInlineValues();
    }

    @NotNull
    public String getId() {
        return "Jupyter Settings";
    }

    @NotNull
    public String getDisplayName() {
        return "Jupyter";
    }

    @Nullable
    public JComponent createComponent() {
        return this.mainPanel;
    }

    @NotNull
    public String getHelpTopic() {
        return "settings.build.execution.deployment.jupyter";
    }

    public void apply() {
        JupyterSettings.Companion.getInstance().setShowVariablesView(this.showValuesCheckBox.isSelected());
        JupyterSettings.Companion.getInstance().setShowLineSeparators(this.showLineSeparators.isSelected());
        JupyterSettings.Companion.getInstance().setSourceCodeLineSpan(this.sourceCodeLineSpan.getNumber());
        JupyterSettings.Companion.getInstance().setShowInlineValues(this.showInlineValues.isSelected());
        this.settingsChanged();
    }

    private final void settingsChanged() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        ((JupyterSettingsChangeListener)application.getMessageBus().syncPublisher(JupyterSettingsChangeListenerKt.getJUPYTER_SETTINGS_TOPIC())).settingsChanged(JupyterSettings.Companion.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    public JupyterSettingsConfigurable() {
        void this_$iv$iv;
        Row row$iv$iv;
        Row row$iv;
        void constraints$iv;
        LayoutBuilder builder$iv;
        LCFlags[] lCFlagsArray = new LCFlags[]{};
        JupyterSettingsConfigurable jupyterSettingsConfigurable = this;
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder((!ArraysKt.contains((Object[])constraints$iv, (Object)LCFlags.disableMagic) ? 1 : 0) != 0);
        boolean bl = false;
        LayoutBuilder this_$iv = $this$panel;
        Object label$iv = null;
        boolean separated$iv = false;
        boolean $i$f$row = false;
        Row $this$row = row$iv = this_$iv.getBuilder().newRow((JLabel)label$iv, this_$iv.getButtonGroup(), separated$iv);
        boolean bl2 = false;
        Cell.invoke$default((Cell)$this$row, (JComponent)((JComponent)this.showValuesCheckBox), (CCFlags[])new CCFlags[0], (int)0, null, null, (int)14, null);
        this_$iv = $this$panel;
        label$iv = null;
        separated$iv = false;
        $i$f$row = false;
        $this$row = row$iv = this_$iv.getBuilder().newRow((JLabel)label$iv, this_$iv.getButtonGroup(), separated$iv);
        boolean bl3 = false;
        Cell.invoke$default((Cell)$this$row, (JComponent)((JComponent)this.showLineSeparators), (CCFlags[])new CCFlags[0], (int)0, null, null, (int)14, null);
        this_$iv = $this$panel;
        label$iv = "Number of Virtual Lines in Code Cell Start/End";
        boolean $i$f$row2 = false;
        LayoutBuilder $i$f$row22 = this_$iv;
        JLabel label$iv$iv = ComponentsKt.Label$default((String)label$iv, null, null, (boolean)false, (int)14, null);
        boolean separated$iv$iv = false;
        boolean $i$f$row3 = false;
        Row $this$row2 = row$iv$iv = this_$iv$iv.getBuilder().newRow(label$iv$iv, this_$iv$iv.getButtonGroup(), separated$iv$iv);
        boolean bl4 = false;
        Cell.invoke$default((Cell)$this$row2, (JComponent)((JComponent)this.sourceCodeLineSpan), (CCFlags[])new CCFlags[0], (int)0, null, null, (int)14, null);
        this_$iv = $this$panel;
        label$iv = null;
        separated$iv = false;
        $i$f$row = false;
        $this$row = row$iv = this_$iv.getBuilder().newRow((JLabel)label$iv, this_$iv.getButtonGroup(), separated$iv);
        boolean bl5 = false;
        Cell.invoke$default((Cell)$this$row, (JComponent)((JComponent)this.showInlineValues), (CCFlags[])new CCFlags[0], (int)0, null, null, (int)14, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, (LCFlags[])constraints$iv);
        panel$iv.setPreferredFocusedComponent(builder$iv.getBuilder().getPreferredFocusedComponent());
        panel$iv.setValidateCallbacks(builder$iv.getBuilder().getValidateCallbacks());
        panel$iv.setApplyCallbacks(builder$iv.getBuilder().getApplyCallbacks());
        panel$iv.setResetCallbacks(builder$iv.getBuilder().getResetCallbacks());
        panel$iv.setModifiedCallbacks(builder$iv.getBuilder().isModifiedCallbacks());
        DialogPanel dialogPanel = panel$iv;
        jupyterSettingsConfigurable.mainPanel = (JPanel)dialogPanel;
    }
}

