/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.server;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParameters;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterNotebookProcessHandler;
import org.jetbrains.plugins.notebooks.jupyter.connections.ManagedServerJupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.management.JupyterCommand;
import org.jetbrains.plugins.notebooks.jupyter.connections.management.JupyterServerCommandsKt;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerExecution;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerFinished;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStarted;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStarting;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerState;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStateListener;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStopped;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\rH\u0002J&\u0010\u001f\u001a\u00020\u001b2\u0010\b\u0002\u0010 \u001a\n\u0018\u00010!j\u0004\u0018\u0001`\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0014\u0010&\u001a\u00020\u001b2\n\u0010 \u001a\u00060!j\u0002`\"H\u0002J_\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001b0-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b0-2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001b002\b\u00101\u001a\u0004\u0018\u000102H\u0000\u00a2\u0006\u0002\b3J\f\u00104\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u00065"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/server/JupyterServerExecutionImpl;", "Lorg/jetbrains/plugins/notebooks/jupyter/server/JupyterServerExecution;", "()V", "_connectionFuture", "Lcom/google/common/util/concurrent/SettableFuture;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "connectionFuture", "Ljava/util/concurrent/Future;", "getConnectionFuture", "()Ljava/util/concurrent/Future;", "managedConnectionHandler", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterNotebookProcessHandler;", "value", "Lorg/jetbrains/plugins/notebooks/jupyter/server/JupyterServerState;", "state", "getState", "()Lorg/jetbrains/plugins/notebooks/jupyter/server/JupyterServerState;", "setState$intellij_python_jupyter", "(Lorg/jetbrains/plugins/notebooks/jupyter/server/JupyterServerState;)V", "stateListeners", "", "Lorg/jetbrains/plugins/notebooks/jupyter/server/JupyterServerStateListener;", "getStateListeners", "()Ljava/util/List;", "setStateListeners", "(Ljava/util/List;)V", "addStateListener", "", "listener", "notifyStateListeners", "newState", "setJupyterServerFinishedState", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handler", "setJupyterServerStartedState", "connectionParameters", "setRetrieveConnectionParametersException", "startServer", "module", "Lcom/intellij/openapi/module/Module;", "settings", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/ManagedServerJupyterModuleConnectionSettings;", "onBeforeStartNotify", "Lkotlin/Function1;", "onServerInit", "onServerTerminated", "Lkotlin/Function0;", "ip", "", "startServer$intellij_python_jupyter", "stopServer", "intellij.python.jupyter"})
public final class JupyterServerExecutionImpl
implements JupyterServerExecution {
    private JupyterNotebookProcessHandler managedConnectionHandler;
    private final SettableFuture<JupyterConnectionParameters> _connectionFuture;
    @NotNull
    private JupyterServerState state;
    @NotNull
    private List<JupyterServerStateListener> stateListeners;

    @Override
    @NotNull
    public Future<JupyterConnectionParameters> getConnectionFuture() {
        return (Future)this._connectionFuture;
    }

    @Override
    @NotNull
    public JupyterServerState getState() {
        return this.state;
    }

    public void setState$intellij_python_jupyter(@NotNull JupyterServerState value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.state = value;
        this.notifyStateListeners(value);
    }

    @NotNull
    public final List<JupyterServerStateListener> getStateListeners() {
        return this.stateListeners;
    }

    public final void setStateListeners(@NotNull List<JupyterServerStateListener> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.stateListeners = list;
    }

    private final void setJupyterServerStartedState(JupyterConnectionParameters connectionParameters) {
        this.setState$intellij_python_jupyter(new JupyterServerStarted(connectionParameters));
        this._connectionFuture.set((Object)connectionParameters);
    }

    private final void setRetrieveConnectionParametersException(Exception e) {
        this._connectionFuture.setException((Throwable)e);
    }

    private final void setJupyterServerFinishedState(Exception e, JupyterNotebookProcessHandler handler) {
        Throwable throwable;
        this.setState$intellij_python_jupyter(new JupyterServerFinished());
        Exception exception = e;
        if (exception != null) {
            throwable = exception;
        } else {
            JupyterNotebookProcessHandler jupyterNotebookProcessHandler = handler;
            throwable = new IllegalStateException("Jupyter server process finished" + (jupyterNotebookProcessHandler != null ? jupyterNotebookProcessHandler.collectErrorData() : null));
        }
        this._connectionFuture.setException(throwable);
    }

    static /* synthetic */ void setJupyterServerFinishedState$default(JupyterServerExecutionImpl jupyterServerExecutionImpl, Exception exception, JupyterNotebookProcessHandler jupyterNotebookProcessHandler, int n, Object object) {
        if ((n & 1) != 0) {
            exception = null;
        }
        if ((n & 2) != 0) {
            jupyterNotebookProcessHandler = null;
        }
        jupyterServerExecutionImpl.setJupyterServerFinishedState(exception, jupyterNotebookProcessHandler);
    }

    @Override
    public void addStateListener(@NotNull JupyterServerStateListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.stateListeners.add(listener);
    }

    private final void notifyStateListeners(JupyterServerState newState) {
        Iterable $this$forEach$iv = this.stateListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterServerStateListener it = (JupyterServerStateListener)element$iv;
            boolean bl = false;
            it.stateChanged(newState);
        }
    }

    public final void startServer$intellij_python_jupyter(@NotNull Module module, @Nullable ManagedServerJupyterModuleConnectionSettings settings, @NotNull Function1<? super JupyterNotebookProcessHandler, Unit> onBeforeStartNotify, @NotNull Function1<? super JupyterConnectionParameters, Unit> onServerInit, @NotNull Function0<Unit> onServerTerminated, @Nullable String ip) {
        JupyterNotebookProcessHandler processHandler2;
        JupyterNotebookProcessHandler jupyterNotebookProcessHandler;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull(onBeforeStartNotify, (String)"onBeforeStartNotify");
        Intrinsics.checkParameterIsNotNull(onServerInit, (String)"onServerInit");
        Intrinsics.checkParameterIsNotNull(onServerTerminated, (String)"onServerTerminated");
        try {
            GeneralCommandLine commandLine = JupyterServerCommandsKt.createJupyterCommandLine(module, settings, JupyterCommand.START, ip);
            String string = commandLine.getExePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commandLine.exePath");
            String jupyterExecutablePath = string;
            jupyterNotebookProcessHandler = new JupyterNotebookProcessHandler(commandLine, (Function1<? super JupyterNotebookProcessHandler, Unit>)((Function1)new Function1<JupyterNotebookProcessHandler, Unit>(this, jupyterExecutablePath, onServerInit){
                final /* synthetic */ JupyterServerExecutionImpl this$0;
                final /* synthetic */ String $jupyterExecutablePath;
                final /* synthetic */ Function1 $onServerInit;

                public final void invoke(@NotNull JupyterNotebookProcessHandler handler) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)handler), (String)"handler");
                    JupyterConnectionParameters jupyterConnectionParameters = handler.getConnectionParameters();
                    boolean bl = false;
                    boolean bl2 = false;
                    JupyterConnectionParameters it = jupyterConnectionParameters;
                    boolean bl3 = false;
                    if (it == null) {
                        JupyterServerExecutionImpl.access$setRetrieveConnectionParametersException(this.this$0, new IllegalStateException("Managed Jupyter Server connection parameters must not be null"));
                    } else {
                        it.setExecutablePath(this.$jupyterExecutablePath);
                        this.$onServerInit.invoke((Object)it);
                        JupyterServerExecutionImpl.access$setJupyterServerStartedState(this.this$0, it);
                    }
                }
                {
                    this.this$0 = jupyterServerExecutionImpl;
                    this.$jupyterExecutablePath = string;
                    this.$onServerInit = function1;
                    super(1);
                }
            }), (Function2<? super JupyterNotebookProcessHandler, ? super ProcessEvent, Unit>)((Function2)new Function2<JupyterNotebookProcessHandler, ProcessEvent, Unit>(this, onServerTerminated){
                final /* synthetic */ JupyterServerExecutionImpl this$0;
                final /* synthetic */ Function0 $onServerTerminated;

                public final void invoke(@NotNull JupyterNotebookProcessHandler handler, @NotNull ProcessEvent $noName_1) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)handler), (String)"handler");
                    Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                    JupyterServerExecutionImpl.access$setJupyterServerFinishedState(this.this$0, null, handler);
                    this.$onServerTerminated.invoke();
                }
                {
                    this.this$0 = jupyterServerExecutionImpl;
                    this.$onServerTerminated = function0;
                    super(2);
                }
            }), (Function2<? super Exception, ? super JupyterNotebookProcessHandler, Unit>)((Function2)new Function2<Exception, JupyterNotebookProcessHandler, Unit>(this){
                final /* synthetic */ JupyterServerExecutionImpl this$0;

                public final void invoke(@NotNull Exception exception, @NotNull JupyterNotebookProcessHandler $noName_1) {
                    Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$noName_1), (String)"<anonymous parameter 1>");
                    JupyterServerExecutionImpl.access$setRetrieveConnectionParametersException(this.this$0, exception);
                }
                {
                    this.this$0 = jupyterServerExecutionImpl;
                    super(2);
                }
            }));
        }
        catch (Exception e) {
            JupyterServerExecutionImpl.setJupyterServerFinishedState$default(this, e, null, 2, null);
            return;
        }
        this.managedConnectionHandler = processHandler2 = jupyterNotebookProcessHandler;
        this.setState$intellij_python_jupyter(new JupyterServerStarting());
        ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)processHandler2), (Project)module.getProject());
        ApplicationManager.getApplication().invokeLater(new Runnable(onBeforeStartNotify, processHandler2){
            final /* synthetic */ Function1 $onBeforeStartNotify;
            final /* synthetic */ JupyterNotebookProcessHandler $processHandler;

            public final void run() {
                this.$onBeforeStartNotify.invoke((Object)((Object)this.$processHandler));
                this.$processHandler.startNotify();
            }
            {
                this.$onBeforeStartNotify = function1;
                this.$processHandler = jupyterNotebookProcessHandler;
            }
        });
    }

    @Override
    @NotNull
    public Future<?> stopServer() {
        Object object;
        block3: {
            block2: {
                this._connectionFuture.cancel(false);
                object = this.managedConnectionHandler;
                if (object == null) break block2;
                JupyterNotebookProcessHandler jupyterNotebookProcessHandler = object;
                boolean bl = false;
                boolean bl2 = false;
                JupyterNotebookProcessHandler $this$run = jupyterNotebookProcessHandler;
                boolean bl3 = false;
                Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Runnable($this$run){
                    final /* synthetic */ JupyterNotebookProcessHandler $this_run;

                    public final void run() {
                        this.$this_run.destroyProcess();
                    }
                    {
                        this.$this_run = jupyterNotebookProcessHandler;
                    }
                });
                object = future2;
                if (future2 != null) break block3;
            }
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            Intrinsics.checkExpressionValueIsNotNull((Object)listenableFuture, (String)"Futures.immediateFuture(null)");
            object = (Future)listenableFuture;
        }
        return object;
    }

    public JupyterServerExecutionImpl() {
        List list;
        SettableFuture settableFuture = SettableFuture.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)settableFuture, (String)"SettableFuture.create()");
        this._connectionFuture = settableFuture;
        this.state = new JupyterServerStopped();
        JupyterServerExecutionImpl jupyterServerExecutionImpl = this;
        boolean bl = false;
        jupyterServerExecutionImpl.stateListeners = list = (List)new ArrayList();
    }

    public static final /* synthetic */ void access$setRetrieveConnectionParametersException(JupyterServerExecutionImpl $this, Exception e) {
        $this.setRetrieveConnectionParametersException(e);
    }

    public static final /* synthetic */ void access$setJupyterServerStartedState(JupyterServerExecutionImpl $this, JupyterConnectionParameters connectionParameters) {
        $this.setJupyterServerStartedState(connectionParameters);
    }

    public static final /* synthetic */ void access$setJupyterServerFinishedState(JupyterServerExecutionImpl $this, Exception e, JupyterNotebookProcessHandler handler) {
        $this.setJupyterServerFinishedState(e, handler);
    }
}

