/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.debugger.CellSourcePosition;
import org.jetbrains.plugins.notebooks.jupyter.editor.IndexedCell;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterTextEditorWithPreview;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterFile;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterSource;
import org.jetbrains.plugins.notebooks.jupyter.settings.JupyterSettings;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001e\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\rH\u0002\u001a\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0000\u001a\u0017\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\u0010\u0019\u001a \u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\"\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0000\u001a\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0015H\u0000\u001a\"\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\rH\u0000\u001a$\u0010%\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\rH\u0000\u001a\u0012\u0010&\u001a\u0004\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020\u0015H\u0000\u001a\u001a\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0015H\u0000\u001a\u0012\u0010)\u001a\u0004\u0018\u00010\u00062\u0006\u0010\"\u001a\u00020\u0015H\u0000\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0004\u00a8\u0006*"}, d2={"JUPYTER_EDITOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/editor/Editor;", "getJUPYTER_EDITOR_KEY", "()Lcom/intellij/openapi/util/Key;", "JUPYTER_VIRTUAL_FILE_KEY", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterVirtualFile;", "getJUPYTER_VIRTUAL_FILE_KEY", "addExtraLines", "", "source", "", "getCellIndex", "", "psiCells", "", "Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;", "offset", "getCellPositionForJupyterCell", "Lorg/jetbrains/plugins/notebooks/jupyter/debugger/CellSourcePosition;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "cell", "getCellSelectionOffset", "psiCell", "(Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;)Ljava/lang/Integer;", "getCells", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "jupyterVirtualFile", "getDocumentByOriginalVirtualFile", "Lcom/intellij/openapi/editor/Document;", "virtualFile", "getIndexedJupyterCellByOffset", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/IndexedCell;", "getJupyterCellByOffset", "getJupyterEditorByOriginalVirtualFile", "getJupyterFileEditorByOriginalVirtualFile", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterTextEditorWithPreview;", "getJupyterVirtualFileByOriginalVirtualFile", "intellij.python.jupyter"})
public final class JupyterCellUtilKt {
    @NotNull
    private static final Key<Editor> JUPYTER_EDITOR_KEY;
    @NotNull
    private static final Key<JupyterVirtualFile> JUPYTER_VIRTUAL_FILE_KEY;

    @NotNull
    public static final Key<Editor> getJUPYTER_EDITOR_KEY() {
        return JUPYTER_EDITOR_KEY;
    }

    @NotNull
    public static final Key<JupyterVirtualFile> getJUPYTER_VIRTUAL_FILE_KEY() {
        return JUPYTER_VIRTUAL_FILE_KEY;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<JupyterCell> getCells(@NotNull Project project, @Nullable JupyterVirtualFile jupyterVirtualFile) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (jupyterVirtualFile == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile((VirtualFile)jupyterVirtualFile);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.notebooks.jupyter.psi.JupyterFile");
        }
        JupyterFile jupyterFile = (JupyterFile)psiFile;
        boolean bl = false;
        boolean bl2 = false;
        JupyterFile $this$run = jupyterFile;
        boolean bl3 = false;
        PsiElement psiElement = $this$run.getFirstChild();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"firstChild");
        PsiElement[] psiElementArray = psiElement.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"firstChild.children");
        PsiElement[] $this$filterIsInstance$iv = psiElementArray;
        boolean $i$f$filterIsInstance = false;
        PsiElement[] psiElementArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JupyterCell)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final List<JupyterCell> getCells(@NotNull Project project, @NotNull TextEditor editor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        VirtualFile virtualFile2 = editor.getFile();
        if (virtualFile2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"editor.file ?: return null");
        VirtualFile virtualFile3 = virtualFile2;
        VirtualFile virtualFile4 = virtualFile3;
        if (!(virtualFile4 instanceof JupyterVirtualFile)) {
            virtualFile4 = null;
        }
        return JupyterCellUtilKt.getCells(project, (JupyterVirtualFile)virtualFile4);
    }

    @Nullable
    public static final CellSourcePosition getCellPositionForJupyterCell(@NotNull VirtualFile file, @NotNull JupyterCell cell) {
        Editor editor;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)cell, (String)"cell");
                Editor editor2 = JupyterCellUtilKt.getJupyterEditorByOriginalVirtualFile(file);
                editor = editor2;
                if (editor == null) break block2;
                TextRange textRange = cell.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"cell.textRange");
                if ((editor = editor.offsetToLogicalPosition(textRange.getStartOffset())) != null) break block3;
            }
            return null;
        }
        int line = editor.line;
        XSourcePosition startSourcePosition = XDebuggerUtil.getInstance().createPosition(file, line);
        return startSourcePosition != null ? new CellSourcePosition(startSourcePosition) : null;
    }

    @Nullable
    public static final IndexedCell getIndexedJupyterCellByOffset(@NotNull Project project, @NotNull TextEditor editor, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        List<JupyterCell> list = JupyterCellUtilKt.getCells(project, editor);
        if (list == null) {
            return null;
        }
        List<JupyterCell> psiCells = list;
        int activeCellIndex = JupyterCellUtilKt.getCellIndex(psiCells, offset);
        return activeCellIndex < 0 ? null : new IndexedCell(activeCellIndex, psiCells.get(activeCellIndex), activeCellIndex == psiCells.size() - 1);
    }

    @Nullable
    public static final JupyterCell getJupyterCellByOffset(@NotNull Project project, @Nullable JupyterVirtualFile virtualFile2, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List<JupyterCell> list = JupyterCellUtilKt.getCells(project, virtualFile2);
        if (list == null) {
            return null;
        }
        List<JupyterCell> psiCells = list;
        int activeCellIndex = JupyterCellUtilKt.getCellIndex(psiCells, offset);
        return activeCellIndex < 0 ? null : psiCells.get(activeCellIndex);
    }

    private static final int getCellIndex(List<? extends JupyterCell> psiCells, int offset) {
        return SequencesKt.lastIndexOf((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)psiCells), (Function1)((Function1)new Function1<JupyterCell, Boolean>(offset){
            final /* synthetic */ int $offset;

            public final boolean invoke(@NotNull JupyterCell it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.getTextOffset() <= this.$offset;
            }
            {
                this.$offset = n;
                super(1);
            }
        })), (Object)true);
    }

    @Nullable
    public static final Editor getJupyterEditorByOriginalVirtualFile(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        return (Editor)virtualFile2.getUserData(JUPYTER_EDITOR_KEY);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final JupyterTextEditorWithPreview getJupyterFileEditorByOriginalVirtualFile(@NotNull Project project, @NotNull VirtualFile virtualFile2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).getAllEditors(virtualFile2);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorArray, (String)"FileEditorManager.getIns\u2026etAllEditors(virtualFile)");
        FileEditor[] $this$mapNotNull$iv = fileEditorArray;
        boolean $i$f$mapNotNull = false;
        FileEditor[] fileEditorArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_9 = $this$forEach$iv$iv$iv;
        int n = ((void)var9_9).length;
        for (int i = 0; i < n; ++i) {
            JupyterTextEditorWithPreview jupyterTextEditorWithPreview;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var9_9[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            Object v1 = it;
            if (!(v1 instanceof JupyterTextEditorWithPreview)) {
                v1 = null;
            }
            if ((JupyterTextEditorWithPreview)v1 == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            JupyterTextEditorWithPreview it$iv$iv = jupyterTextEditorWithPreview;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (JupyterTextEditorWithPreview)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
    }

    @Nullable
    public static final Document getDocumentByOriginalVirtualFile(@NotNull VirtualFile virtualFile2) {
        Editor editor;
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        Editor editor2 = editor = JupyterCellUtilKt.getJupyterEditorByOriginalVirtualFile(virtualFile2);
        return editor2 != null ? editor2.getDocument() : null;
    }

    @Nullable
    public static final JupyterVirtualFile getJupyterVirtualFileByOriginalVirtualFile(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        return (JupyterVirtualFile)((Object)virtualFile2.getUserData(JUPYTER_VIRTUAL_FILE_KEY));
    }

    @NotNull
    public static final String addExtraLines(@NotNull CharSequence source2) {
        Intrinsics.checkParameterIsNotNull((Object)source2, (String)"source");
        String span = StringsKt.repeat((CharSequence)"\n", (int)JupyterSettings.Companion.getInstance().getSourceCodeLineSpan());
        return span + source2 + span;
    }

    @Nullable
    public static final Integer getCellSelectionOffset(@NotNull JupyterCell psiCell) {
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)psiCell, (String)"psiCell");
        JupyterSource jupyterSource = (JupyterSource)PsiTreeUtil.getChildOfType((PsiElement)psiCell, JupyterSource.class);
        if (jupyterSource != null) {
            JupyterSource jupyterSource2 = jupyterSource;
            boolean bl = false;
            boolean bl2 = false;
            JupyterSource it = jupyterSource2;
            boolean bl3 = false;
            JupyterSource jupyterSource3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jupyterSource3, (String)"it");
            int n2 = it.getTextLength();
            int n3 = JupyterSettings.Companion.getInstance().getSourceCodeLineSpan();
            int n4 = jupyterSource3.getTextOffset();
            boolean bl4 = false;
            int n5 = Math.min(n2, n3);
            n = n4 + n5;
        } else {
            n = null;
        }
        return n;
    }

    static {
        Key key = Key.create((String)"JUPYTER_EDITOR_KEY");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"JUPYTER_EDITOR_KEY\")");
        JUPYTER_EDITOR_KEY = key;
        Key key2 = Key.create((String)"JUPYTER_VIRTUAL_FILE_KEY");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create(\"JUPYTER_VIRTUAL_FILE_KEY\")");
        JUPYTER_VIRTUAL_FILE_KEY = key2;
    }
}

