/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssMediaExpression;
import com.intellij.psi.css.CssMediaQuery;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssMediaQueryImpl
extends CssElementImpl
implements CssMediaQuery {
    CssMediaQueryImpl() {
        super(CssElementTypes.CSS_MEDIA_QUERY);
    }

    @Nullable
    public PsiElement getMediaTypeElement() {
        ArrayList<PsiElement> identifiers = new ArrayList<PsiElement>();
        PsiElement child = this.getFirstChild();
        while (child instanceof LeafElement && ((LeafElement)child).getElementType() == CssElementTypes.CSS_IDENT) {
            identifiers.add(child);
            child = PsiTreeUtil.nextVisibleLeaf((PsiElement)child);
        }
        if (identifiers.isEmpty()) {
            return null;
        }
        PsiElement first = (PsiElement)identifiers.get(0);
        if (identifiers.size() == 1) {
            return first;
        }
        String elementText = first.getText();
        if ("not".equals(elementText) || "only".equals(elementText)) {
            return (PsiElement)identifiers.get(1);
        }
        return first;
    }

    @Nullable
    public CssMediaType getMediaType() {
        PsiElement element = this.getMediaTypeElement();
        return element != null ? CssMediaType.fromString((String)element.getText()) : null;
    }

    @NotNull
    public CssMediaExpression[] getExpressions() {
        PsiElement expressionList = this.findPsiChildByType(CssElementTypes.CSS_MEDIA_EXPRESSION_LIST);
        CssMediaExpression[] result = (CssMediaExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)expressionList, CssMediaExpression.class);
        CssMediaExpression[] cssMediaExpressionArray = (CssMediaExpression[])ObjectUtils.notNull((Object)result, (Object)CssMediaExpression.EMPTY_ARRAY);
        if (cssMediaExpressionArray == null) {
            CssMediaQueryImpl.$$$reportNull$$$0(0);
        }
        return cssMediaExpressionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssMediaQueryImpl", "getExpressions"));
    }
}

