/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.command.BuildImageCmd;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.cli.CliParserBase;
import com.intellij.docker.agent.cli.DockerBuildCliParserBase;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;

public class DockerBuildCliParser
extends DockerBuildCliParserBase<BuildImageCmd> {
    public void parse(BuildImageCmd cmd, String[] optionsLine) throws ApiTaskException {
        try {
            super.doParse((Object)cmd, optionsLine);
        }
        catch (CliParserBase.IllegalOptionException | ParseException e) {
            throw new ApiTaskException((Exception)e);
        }
    }

    protected CliParserBase.LabelListHandler<BuildImageCmd> buildArgs(Option option) {
        return new CliParserBase.LabelListHandler<BuildImageCmd>(option){

            protected void handleLabelsMap(Map<String, String> parsedMap) {
                if (parsedMap == null) {
                    return;
                }
                for (Map.Entry<String, String> entry : parsedMap.entrySet()) {
                    ((BuildImageCmd)this.getCmd()).withBuildArg(entry.getKey(), entry.getValue());
                }
            }
        };
    }

    protected DockerBuildCliParserBase.CommaSeparatedListHandler<BuildImageCmd> cacheFrom(Option option) {
        return new DockerBuildCliParserBase.CommaSeparatedListHandler(option, (cmd, strings) -> cmd.withCacheFrom(new LinkedHashSet<String>(Arrays.asList(strings))));
    }

    protected CliParserBase.EachValueHandler<BuildImageCmd> cpuShares(Option option) {
        return new CliParserBase.EachValueHandler(option, BuildImageCmd::withCpushares);
    }

    protected CliParserBase.SingleValueHandler<BuildImageCmd> cpusetCpus(Option option) {
        return new CliParserBase.EachValueHandler(option, BuildImageCmd::withCpusetcpus);
    }

    protected CliParserBase.BooleanOptionHandler<BuildImageCmd> forceRm(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl(option, BuildImageCmd::withForcerm);
    }

    protected CliParserBase.LabelListHandler<BuildImageCmd> label(Option option) {
        return new CliParserBase.LabelListHandlerImpl(option, BuildImageCmd::getLabels, BuildImageCmd::withLabels);
    }

    protected CliParserBase.MemoryOptionHandler<BuildImageCmd> memory(Option option) {
        return new CliParserBase.MemoryOptionHandler(option, BuildImageCmd::withMemory);
    }

    protected CliParserBase.MemoryOptionHandler<BuildImageCmd> memorySwap(Option option) {
        return new CliParserBase.MemoryOptionHandler(option, BuildImageCmd::withMemswap);
    }

    protected CliParserBase.MemoryOptionHandler<BuildImageCmd> shmSize(Option option) {
        return new CliParserBase.MemoryOptionHandler(option, BuildImageCmd::withShmsize);
    }

    protected CliParserBase.SingleValueHandler<BuildImageCmd> network(Option option) {
        return new CliParserBase.EachValueHandler(option, BuildImageCmd::withNetworkMode);
    }

    protected CliParserBase.BooleanOptionHandler<BuildImageCmd> noCache(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl(option, BuildImageCmd::withNoCache);
    }

    protected CliParserBase.BooleanOptionHandler<BuildImageCmd> pull(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl(option, BuildImageCmd::withPull);
    }

    protected CliParserBase.BooleanOptionHandler<BuildImageCmd> quiet(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl(option, BuildImageCmd::withQuiet);
    }

    protected CliParserBase.BooleanOptionHandler<BuildImageCmd> rm(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl(option, BuildImageCmd::withRemove);
    }
}

