/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.sh.run.ShRunner;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.jediterm.terminal.ProcessTtyConnector;
import com.pty4j.PtyProcess;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.TerminalView;

public class ShTerminalRunner
extends ShRunner {
    private static final Logger LOG = Logger.getInstance(LocalTerminalDirectRunner.class);

    protected ShTerminalRunner(@NotNull Project project) {
        if (project == null) {
            ShTerminalRunner.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @Override
    public void run(final @NotNull String command) {
        if (command == null) {
            ShTerminalRunner.$$$reportNull$$$0(1);
        }
        TerminalView terminalView = TerminalView.getInstance((Project)this.myProject);
        ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Terminal");
        if (window == null) {
            return;
        }
        ContentManager contentManager = window.getContentManager();
        Pair<Content, Process> pair = ShTerminalRunner.getSuitableProcess(contentManager);
        if (pair != null) {
            try {
                window.activate(null);
                contentManager.setSelectedContent((Content)pair.first);
                ShTerminalRunner.runCommand((Process)pair.second, command);
            }
            catch (ExecutionException e) {
                LOG.warn("Error running terminal", (Throwable)e);
            }
        } else {
            terminalView.createNewSession((AbstractTerminalRunner)new LocalTerminalDirectRunner(this.myProject){

                protected PtyProcess createProcess(@Nullable String directory, @Nullable String commandHistoryFilePath) throws ExecutionException {
                    PtyProcess process = super.createProcess(directory, commandHistoryFilePath);
                    ShTerminalRunner.runCommand((Process)process, command);
                    return process;
                }
            });
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project) {
        ToolWindow window;
        if (project == null) {
            ShTerminalRunner.$$$reportNull$$$0(2);
        }
        return (window = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal")) != null && window.isAvailable();
    }

    @Nullable
    private static Pair<Content, Process> getSuitableProcess(@NotNull ContentManager contentManager) {
        Pair<Content, Process> pair;
        Content selectedContent;
        if (contentManager == null) {
            ShTerminalRunner.$$$reportNull$$$0(3);
        }
        if ((selectedContent = contentManager.getSelectedContent()) != null && (pair = ShTerminalRunner.getSuitableProcess(selectedContent)) != null) {
            return pair;
        }
        return Arrays.stream(contentManager.getContents()).map(ShTerminalRunner::getSuitableProcess).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    private static Pair<Content, Process> getSuitableProcess(@NotNull Content content) {
        ProcessTtyConnector ttyConnector;
        JBTerminalWidget widget;
        if (content == null) {
            ShTerminalRunner.$$$reportNull$$$0(4);
        }
        if ((widget = TerminalView.getWidgetByContent((Content)content)) == null) {
            return null;
        }
        if (widget.getTtyConnector() instanceof ProcessTtyConnector && !TerminalUtil.hasRunningCommands((ProcessTtyConnector)(ttyConnector = (ProcessTtyConnector)widget.getTtyConnector()))) {
            return Pair.create((Object)content, (Object)ttyConnector.getProcess());
        }
        return null;
    }

    private static void runCommand(@NotNull Process process, @Nullable String command) throws ExecutionException {
        if (process == null) {
            ShTerminalRunner.$$$reportNull$$$0(5);
        }
        if (command != null) {
            try {
                process.getOutputStream().write(command.getBytes(CharsetToolkit.UTF8_CHARSET));
            }
            catch (IOException ex) {
                throw new ExecutionException("Fail to start " + command, ex);
            }
        } else {
            throw new ExecutionException("Cannot run command:" + command, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sh/run/ShTerminalRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitableProcess";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "runCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

