/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.util.Case;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Casing {
    public final Case plain;
    public final Case quoted;
    public static final Casing EXACT = Casing.create(Case.EXACT, Case.EXACT);

    @NotNull
    public static Casing create(@NotNull Case plain, @NotNull Case quoted) {
        if (plain == null) {
            Casing.$$$reportNull$$$0(0);
        }
        if (quoted == null) {
            Casing.$$$reportNull$$$0(1);
        }
        Casing casing = new Casing(plain, quoted);
        if (casing == null) {
            Casing.$$$reportNull$$$0(2);
        }
        return casing;
    }

    private Casing(@NotNull Case plain, @NotNull Case quoted) {
        if (plain == null) {
            Casing.$$$reportNull$$$0(3);
        }
        if (quoted == null) {
            Casing.$$$reportNull$$$0(4);
        }
        this.plain = plain;
        this.quoted = quoted;
    }

    @NotNull
    public Case choose(boolean isPlain) {
        Case case_ = isPlain ? this.plain : this.quoted;
        if (case_ == null) {
            Casing.$$$reportNull$$$0(5);
        }
        return case_;
    }

    @NotNull
    public String specification() {
        if (this.quoted == Case.EXACT) {
            String string = Casing.caseToString(this.plain);
            if (string == null) {
                Casing.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = Casing.caseToString(this.plain) + '/' + Casing.caseToString(this.quoted);
        if (string == null) {
            Casing.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static Casing of(@Nullable String str) {
        if (str == null) {
            Casing casing = EXACT;
            if (casing == null) {
                Casing.$$$reportNull$$$0(8);
            }
            return casing;
        }
        String[] items = str.split("/");
        int n = items.length;
        Case c1 = n >= 1 ? Casing.caseFromString(items[0]) : Case.EXACT;
        Case c2 = n >= 2 ? Casing.caseFromString(items[1]) : Case.EXACT;
        Casing casing = Casing.create(c1, c2);
        if (casing == null) {
            Casing.$$$reportNull$$$0(9);
        }
        return casing;
    }

    @NotNull
    private static String caseToString(@NotNull Case caze) {
        if (caze == null) {
            Casing.$$$reportNull$$$0(10);
        }
        String string = StringUtil.toLowerCase((String)caze.name());
        if (string == null) {
            Casing.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static Case caseFromString(@NotNull String str) {
        if (str == null) {
            Casing.$$$reportNull$$$0(12);
        }
        char c = str.length() >= 1 ? Character.toLowerCase(str.charAt(0)) : (char)'\u0000';
        switch (c) {
            case 'm': {
                Case case_ = Case.MIXED;
                if (case_ == null) {
                    Casing.$$$reportNull$$$0(13);
                }
                return case_;
            }
            case 'u': {
                Case case_ = Case.UPPER;
                if (case_ == null) {
                    Casing.$$$reportNull$$$0(14);
                }
                return case_;
            }
            case 'l': {
                Case case_ = Case.LOWER;
                if (case_ == null) {
                    Casing.$$$reportNull$$$0(15);
                }
                return case_;
            }
        }
        Case case_ = Case.EXACT;
        if (case_ == null) {
            Casing.$$$reportNull$$$0(16);
        }
        return case_;
    }

    public String toString() {
        return this.specification();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Casing casing = (Casing)o;
        return this.plain == casing.plain && this.quoted == casing.quoted;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.plain, this.quoted});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plain";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoted";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/Casing";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caze";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/Casing";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "choose";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "specification";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "caseToString";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "caseFromString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "caseToString";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "caseFromString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

