/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.model.RawConnectionConfig;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Dbms
implements Comparable<Dbms> {
    private static final Logger LOG = Logger.getInstance(Dbms.class);
    private static final ConcurrentMap<String, Dbms> ourValues = ContainerUtil.newConcurrentMap();
    private static final List<Pair<Pattern, Dbms>> ourDetectors = new CopyOnWriteArrayList<Pair<Pattern, Dbms>>();
    public static final Dbms UNKNOWN = Dbms.create("UNKNOWN", DatabaseIcons.Dbms);
    public static final Dbms ORACLE = Dbms.create("Oracle", AllIcons.Providers.Oracle);
    public static final Dbms MEMSQL = Dbms.create("MemSQL", AllIcons.Providers.Mysql);
    public static final Dbms MARIA = Dbms.create("MariaDB", AllIcons.Providers.Mariadb);
    public static final Dbms MYSQL = Dbms.create("MySQL", AllIcons.Providers.Mysql);
    public static final Dbms GITBASE = Dbms.create("gitbase", DatabaseIcons.DriverRed4);
    public static final Dbms POSTGRES = Dbms.create("POSTGRES", "PostgreSQL", AllIcons.Providers.Postgresql);
    public static final Dbms REDSHIFT = Dbms.create("REDSHIFT", "Amazon Redshift", AllIcons.Providers.Redshift);
    public static final Dbms GREENPLUM = Dbms.create("GREENPLUM", "Greenplum", AllIcons.Providers.Greenplum);
    public static final Dbms SYBASE = Dbms.create("SYBASE", "Sybase ASE", AllIcons.Providers.Sybase, Dbms.defaultPattern("sybase|adaptive server") + "|ase.*");
    public static final Dbms MSSQL = Dbms.create("MSSQL", "Microsoft SQL Server", AllIcons.Providers.SqlServer, Dbms.defaultPattern("microsoft|sqlserver|jtds"));
    public static final Dbms AZURE = Dbms.create("AZURE", "Azure SQL Database", AllIcons.Providers.Azure);
    public static final Dbms DB2_LUW = Dbms.create("DB2_LUW", "IBM Db2 LUW", AllIcons.Providers.DB2);
    public static final Dbms DB2_IS = Dbms.create("DB2_IS", "IBM Db2 iSeries", AllIcons.Providers.DB2);
    public static final Dbms DB2_ZOS = Dbms.create("DB2_ZOS", "IBM Db2 z/OS", AllIcons.Providers.DB2);
    public static final Dbms DB2 = Dbms.create("DB2", "IBM Db2", AllIcons.Providers.DB2, "(?i).*(?:\\bDB2|[:.]as400[:.]).*");
    public static final Dbms SQLITE = Dbms.create("SQLite", AllIcons.Providers.Sqlite);
    public static final Dbms HSQL = Dbms.create("HSQLDB", "HSQLDB", AllIcons.Providers.Hsqldb, Dbms.defaultPattern("hsql"));
    public static final Dbms H2 = Dbms.create("H2", AllIcons.Providers.H2);
    public static final Dbms DERBY = Dbms.create("DERBY", "Apache Derby", AllIcons.Providers.ApacheDerby);
    public static final Dbms EXASOL = Dbms.create("EXASOL", "Exasol", AllIcons.Providers.Exasol, Dbms.defaultPattern("exasol|exa"));
    public static final Dbms CLICKHOUSE = Dbms.create("ClickHouse", AllIcons.Providers.ClickHouse);
    public static final Dbms CASSANDRA = Dbms.create("CASSANDRA", "Apache Cassandra", AllIcons.Providers.Cassandra);
    public static final Dbms VERTICA = Dbms.create("Vertica", AllIcons.Providers.Vertica);
    public static final Dbms HIVE = Dbms.create("HIVE", "Apache Hive", AllIcons.Providers.Hive);
    public static final Dbms SPARK = Dbms.create("SPARK", "Apache Spark", AllIcons.Providers.Spark);
    public static final Dbms SNOWFLAKE = Dbms.create("Snowflake", AllIcons.Providers.Snowflake);
    public static final Dbms HANA = Dbms.create("HANA", "HANA", AllIcons.Providers.HANA, Dbms.defaultPattern("sap|hana"));
    public static final Dbms FIREBIRD = Dbms.create("Firebird", AllIcons.Providers.Firebird);
    public static final Dbms PRESTO = Dbms.create("Presto", AllIcons.Providers.Presto);
    public static final Dbms INFORMIX = Dbms.create("INFORMIX", "Informix", AllIcons.Providers.Informix, Dbms.defaultPattern("informix") + "|ids.*");
    public static final Dbms IMPALA = Dbms.create("Impala", DatabaseIcons.DriverBlue1);
    public static final Dbms NETEZZA = Dbms.create("Netezza", DatabaseIcons.DriverGreen2);
    public static final Dbms PHOENIX = Dbms.create("Phoenix", DatabaseIcons.DriverPink3);
    public static final Dbms INGRES = Dbms.create("Ingres", DatabaseIcons.DriverRed4);
    public static final Dbms TERADATA = Dbms.create("Teradata", AllIcons.Providers.Teradata);
    public static final Dbms OPENEDGE = Dbms.create("OpenEdge", DatabaseIcons.DriverBlue2);
    public static final Dbms TIBERO = Dbms.create("Tibero", DatabaseIcons.DriverBlue1);
    public static final Dbms FILEMAKER = Dbms.create("FileMaker", DatabaseIcons.DriverGreen3);
    public static final Dbms FRONTBASE = Dbms.create("FrontBase", DatabaseIcons.DriverPink4);
    public static final Dbms MONGO = Dbms.create("MONGO", "MongoDB", DatabaseIcons.DriverGreen4);
    public static final Dbms IGNITE = Dbms.create("IGNITE", "Apache Ignite", DatabaseIcons.DriverRed4);
    public static final Dbms COCKROACH = Dbms.create("COCKROACH", "CockroachDB", AllIcons.Providers.CockroachDB);
    private final String myName;
    private final String myDisplayName;
    private final Icon myIcon;

    @NotNull
    public static Dbms create(@NotNull String displayName, @NotNull Icon icon) {
        if (displayName == null) {
            Dbms.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            Dbms.$$$reportNull$$$0(1);
        }
        Dbms dbms = Dbms.create(displayName, displayName, icon);
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(2);
        }
        return dbms;
    }

    @NotNull
    public static Dbms create(@NotNull String name, @NotNull String displayName, @NotNull Icon icon) {
        if (name == null) {
            Dbms.$$$reportNull$$$0(3);
        }
        if (displayName == null) {
            Dbms.$$$reportNull$$$0(4);
        }
        if (icon == null) {
            Dbms.$$$reportNull$$$0(5);
        }
        Dbms dbms = Dbms.create(name, displayName, icon, null);
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(6);
        }
        return dbms;
    }

    @NotNull
    public static Dbms create(@NotNull String name, @NotNull String displayName, @NotNull Icon icon, @RegExp @Nullable String detectPattern) {
        Dbms existing;
        if (name == null) {
            Dbms.$$$reportNull$$$0(7);
        }
        if (displayName == null) {
            Dbms.$$$reportNull$$$0(8);
        }
        if (icon == null) {
            Dbms.$$$reportNull$$$0(9);
        }
        if ((existing = (Dbms)ourValues.get(name = StringUtil.toUpperCase((String)name))) != null) {
            Dbms dbms = existing;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(10);
            }
            return dbms;
        }
        Dbms proposed = new Dbms(name, displayName, icon);
        Dbms result = (Dbms)ConcurrencyUtil.cacheOrGet(ourValues, (Object)name, (Object)proposed);
        if (proposed == result) {
            String pattern = detectPattern == null ? Dbms.defaultPattern(name) : detectPattern;
            ourDetectors.add((Pair<Pattern, Dbms>)Pair.create((Object)Pattern.compile(pattern), (Object)result));
        }
        Dbms dbms = result;
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(11);
        }
        return dbms;
    }

    private static String defaultPattern(@NotNull String name) {
        if (name == null) {
            Dbms.$$$reportNull$$$0(12);
        }
        return String.format("(?i).*\\b(?:%s).*", name);
    }

    private Dbms(@NotNull String name, @NotNull String displayName, @NotNull Icon icon) {
        if (name == null) {
            Dbms.$$$reportNull$$$0(13);
        }
        if (displayName == null) {
            Dbms.$$$reportNull$$$0(14);
        }
        if (icon == null) {
            Dbms.$$$reportNull$$$0(15);
        }
        this.myName = name;
        this.myDisplayName = displayName;
        this.myIcon = icon;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            Dbms.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            Dbms.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            Dbms.$$$reportNull$$$0(18);
        }
        return icon;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isOracle() {
        return this == ORACLE;
    }

    public boolean isMysql() {
        return this == MYSQL || this == MARIA || this == MEMSQL || this == GITBASE;
    }

    public boolean isPostgres() {
        return this == POSTGRES || this == REDSHIFT || this == GREENPLUM || this == COCKROACH;
    }

    public boolean isRedshift() {
        return this == REDSHIFT;
    }

    public boolean isGreenplum() {
        return this == GREENPLUM;
    }

    public boolean isVertica() {
        return this == VERTICA;
    }

    public boolean isMicrosoft() {
        return this == MSSQL || this == AZURE;
    }

    public boolean isSybase() {
        return this == SYBASE;
    }

    public boolean isDb2() {
        return this == DB2_LUW || this == DB2_IS || this == DB2_ZOS || this == DB2;
    }

    public boolean isHsqldb() {
        return this == HSQL;
    }

    public boolean isH2() {
        return this == H2;
    }

    public boolean isDerby() {
        return this == DERBY;
    }

    public boolean isSqlite() {
        return this == SQLITE;
    }

    public boolean isTransactSql() {
        return this.isMicrosoft() || this.isSybase();
    }

    public boolean isExasol() {
        return this == EXASOL;
    }

    public boolean isClickHouse() {
        return this == CLICKHOUSE;
    }

    public boolean isCassandra() {
        return this == CASSANDRA;
    }

    public boolean isHive() {
        return this == HIVE;
    }

    public boolean isSpark() {
        return this == SPARK;
    }

    public boolean isSnowflake() {
        return this == SNOWFLAKE;
    }

    @NotNull
    public static Dbms forConnection(@Nullable RawConnectionConfig o) {
        if (o == null) {
            Dbms dbms = UNKNOWN;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(19);
            }
            return dbms;
        }
        Dbms result = Dbms.fromString(o.getUrl());
        if (result != UNKNOWN) {
            Dbms dbms = result;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(20);
            }
            return dbms;
        }
        Dbms dbms = Dbms.fromString(o.getDriverClass());
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(21);
        }
        return dbms;
    }

    @NotNull
    public static Dbms fromString(@Nullable String text) {
        if (text == null) {
            Dbms dbms = UNKNOWN;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(22);
            }
            return dbms;
        }
        for (Pair<Pattern, Dbms> detector : ourDetectors) {
            if (!((Pattern)detector.first).matcher(text).matches()) continue;
            Dbms dbms = (Dbms)detector.second;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(23);
            }
            return dbms;
        }
        String pattern = "(?i).*\\b(?:%s).*";
        for (Dbms dbms : Dbms.allValues()) {
            if (!text.matches(String.format(pattern, dbms.getName()))) continue;
            Dbms dbms2 = dbms;
            if (dbms2 == null) {
                Dbms.$$$reportNull$$$0(24);
            }
            return dbms2;
        }
        Dbms dbms = UNKNOWN;
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(25);
        }
        return dbms;
    }

    @Nullable
    public static Dbms byName(@NotNull String name) {
        if (name == null) {
            Dbms.$$$reportNull$$$0(26);
        }
        return (Dbms)LazyData.allDbms().get(name);
    }

    @NotNull
    public static Collection<Dbms> allValues() {
        Collection<Dbms> collection = LazyData.allDbms().values();
        if (collection == null) {
            Dbms.$$$reportNull$$$0(27);
        }
        return collection;
    }

    @Override
    public int compareTo(@NotNull Dbms o) {
        if (o == null) {
            Dbms.$$$reportNull$$$0(28);
        }
        return Comparing.compare((Comparable)((Object)this.getName()), (Comparable)((Object)o.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/Dbms";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 13: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/Dbms";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "forConnection";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "allValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "defaultPattern";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "byName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LazyData {
        private static final ExtensionPointName<DbmsBean> CONFIG_EP = ExtensionPointName.create((String)"com.intellij.database.dbms");

        private LazyData() {
        }

        private static Map<String, Dbms> allDbms() {
            return ourValues;
        }

        static {
            for (DbmsBean bean : CONFIG_EP.getExtensionsIfPointIsRegistered()) {
                int dotIdx = bean.instance.lastIndexOf(46);
                if (dotIdx < 0) {
                    LOG.warn("Class field reference should contain `.` in: " + bean.instance + "[" + bean.getPluginId() + "]");
                    continue;
                }
                try {
                    Class<?> holder = Class.forName(bean.instance.substring(0, dotIdx), true, bean.getLoaderForClass());
                    Dbms dbms = (Dbms)ReflectionUtil.getStaticFieldValue(holder, Dbms.class, (String)bean.instance.substring(dotIdx + 1));
                    if (dbms == null) {
                        LOG.warn("Static field not found: " + bean.instance + "[" + bean.getPluginId() + "]");
                        continue;
                    }
                    assert (ourValues.get(dbms.getName()) == dbms);
                }
                catch (Exception e) {
                    LOG.warn("Unable to find dbms: " + bean.instance + "[" + bean.getPluginId() + "]", (Throwable)e);
                }
            }
        }
    }

    public static class DbmsBean
    extends AbstractExtensionPointBean {
        @Attribute(value="instance")
        public String instance;
    }
}

