/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusPanel
extends JBPanel {
    private final ReentrantLock myLock = new ReentrantLock();
    @Nullable
    private String myError;
    @Nullable
    private Action myCurrentAction;

    public StatusPanel() {
        super((LayoutManager)new BorderLayout());
        this.setVisible(false);
    }

    public void resetState() {
        this.myLock.lock();
        try {
            this.cancelCurrentAction();
            this.clearUI();
        }
        finally {
            this.myLock.unlock();
        }
    }

    @NotNull
    public Action progress(@NotNull String message) {
        if (message == null) {
            StatusPanel.$$$reportNull$$$0(0);
        }
        Action action = this.progress(message, true);
        if (action == null) {
            StatusPanel.$$$reportNull$$$0(1);
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Action progress(@NotNull String message, boolean addProgressIconBelow) {
        Action action;
        if (message == null) {
            StatusPanel.$$$reportNull$$$0(2);
        }
        this.myLock.lock();
        this.cancelCurrentAction();
        this.myCurrentAction = action = new Action();
        this.invokeLater(() -> {
            this.clearUI();
            if (addProgressIconBelow) {
                AsyncProcessIcon asyncProcessIcon = new AsyncProcessIcon(message);
                this.add((Component)asyncProcessIcon, "Center");
                this.setVisible(true);
                asyncProcessIcon.resume();
            }
            this.refreshUI();
        });
        Action action2 = action;
        Action action3 = action2;
        if (action3 == null) {
            StatusPanel.$$$reportNull$$$0(3);
        }
        return action3;
        finally {
            this.myLock.unlock();
        }
    }

    private void cancelCurrentAction() {
        if (this.myCurrentAction != null) {
            this.myCurrentAction.cancel();
            this.myCurrentAction = null;
        }
    }

    private void clearUI() {
        this.myError = null;
        this.removeAll();
        this.setVisible(false);
        this.refreshUI();
    }

    private void refreshUI() {
        this.revalidate();
        this.repaint();
    }

    private void showMessage(@NotNull String message, @NotNull JBColor color, @Nullable Icon statusIcon) {
        if (message == null) {
            StatusPanel.$$$reportNull$$$0(4);
        }
        if (color == null) {
            StatusPanel.$$$reportNull$$$0(5);
        }
        this.removeAll();
        this.setVisible(true);
        JBLabel label = new JBLabel(message);
        label.setText(XmlStringUtil.wrapInHtml((CharSequence)("<font color='#" + ColorUtil.toHex((Color)color) + "'><left>" + message + "</left></b></font>")));
        label.setIcon(statusIcon);
        label.setBorder((Border)new EmptyBorder(4, 10, 0, 2));
        this.add((Component)label, "Center");
        this.refreshUI();
    }

    private void invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            StatusPanel.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.stateForComponent((Component)((Object)this)));
    }

    @Nullable
    public String getError() {
        return this.myError;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/ui/StatusPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/StatusPanel";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "progress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "progress";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class Action {
        private volatile boolean myCancelled = false;
        private final AtomicBoolean myCompleted = new AtomicBoolean(false);

        private boolean checkIsInProgressAndComplete() {
            return this.myCompleted.compareAndSet(false, true) && !this.myCancelled;
        }

        private void cancel() {
            this.myCancelled = true;
        }

        public void done() {
            if (this.checkIsInProgressAndComplete()) {
                StatusPanel.this.invokeLater(() -> {
                    StatusPanel.this.myLock.lock();
                    try {
                        if (!this.myCancelled) {
                            StatusPanel.this.clearUI();
                        }
                    }
                    finally {
                        StatusPanel.this.myLock.unlock();
                    }
                });
            }
        }

        public void doneWithResult(@NotNull String message) {
            if (message == null) {
                Action.$$$reportNull$$$0(0);
            }
            this.showMessageOnce(message, false);
        }

        public void failed(@Nullable String message) {
            this.showMessageOnce(message, true);
        }

        private void showMessageOnce(@Nullable String message, boolean isError) {
            if (this.checkIsInProgressAndComplete()) {
                StatusPanel.this.invokeLater(() -> {
                    StatusPanel.this.myLock.lock();
                    try {
                        if (!this.myCancelled) {
                            JBColor color = isError ? JBColor.RED : JBColor.DARK_GRAY;
                            Icon statusIcon = isError ? AllIcons.Actions.Lightning : AllIcons.General.InspectionsOK;
                            StatusPanel.this.myError = isError ? message : null;
                            StatusPanel.this.showMessage(StringUtil.notNullize((String)message), color, statusIcon);
                        }
                    }
                    finally {
                        StatusPanel.this.myLock.unlock();
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/plugins/remotesdk/ui/StatusPanel$Action", "doneWithResult"));
        }
    }
}

