/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.ContainerUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.push.GitPushOperation;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GitPusher;
import git4idea.push.GroupedPushResult;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateResult;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitPushResultNotification
extends Notification {
    public static final String VIEW_FILES_UPDATED_DURING_THE_PUSH = "View files updated during the push";
    public static final String UPDATE_WITH_RESOLVED_CONFLICTS = "push has been cancelled, because there were conflicts during update.<br/>Check that conflicts were resolved correctly, and invoke push again.";
    public static final String INCOMPLETE_UPDATE = "push has been cancelled, because not all conflicts were resolved during update.<br/>Resolve the conflicts and invoke push again.";
    public static final String UPDATE_WITH_ERRORS = "push was rejected, and update failed with error.";
    public static final String UPDATE_CANCELLED = "push was rejected, and update was cancelled.";
    private static final Logger LOG = Logger.getInstance(GitPushResultNotification.class);

    private GitPushResultNotification(@NotNull String groupDisplayId, @NotNull String title, @NotNull String content, @NotNull NotificationType type) {
        if (groupDisplayId == null) {
            GitPushResultNotification.$$$reportNull$$$0(0);
        }
        if (title == null) {
            GitPushResultNotification.$$$reportNull$$$0(1);
        }
        if (content == null) {
            GitPushResultNotification.$$$reportNull$$$0(2);
        }
        if (type == null) {
            GitPushResultNotification.$$$reportNull$$$0(3);
        }
        super(groupDisplayId, title, content, type);
    }

    @NotNull
    static GitPushResultNotification create(@NotNull Project project, @NotNull GitPushResult pushResult, @Nullable GitPushOperation pushOperation, boolean multiRepoProject) {
        NotificationType type;
        String title;
        if (project == null) {
            GitPushResultNotification.$$$reportNull$$$0(4);
        }
        if (pushResult == null) {
            GitPushResultNotification.$$$reportNull$$$0(5);
        }
        GroupedPushResult grouped = GroupedPushResult.group(pushResult.getResults());
        if (!grouped.errors.isEmpty()) {
            title = !grouped.successful.isEmpty() ? "Push partially failed" : "Push failed";
            type = NotificationType.ERROR;
        } else if (!grouped.rejected.isEmpty() || !grouped.customRejected.isEmpty()) {
            title = !grouped.successful.isEmpty() ? "Push partially rejected" : "Push rejected";
            type = NotificationType.WARNING;
        } else {
            title = "Push successful";
            type = NotificationType.INFORMATION;
        }
        String description = GitPushResultNotification.formDescription(pushResult.getResults(), multiRepoProject);
        NotificationGroup group = type == NotificationType.INFORMATION ? VcsNotifier.STANDARD_NOTIFICATION : VcsNotifier.IMPORTANT_ERROR_NOTIFICATION;
        GitPushResultNotification notification = new GitPushResultNotification(group.getDisplayId(), title, description, type);
        List staleInfoRejected = EntryStream.of(pushResult.getResults()).filterValues(result2 -> result2.getType() == GitPushRepoResult.Type.REJECTED_STALE_INFO).keys().toList();
        if (!staleInfoRejected.isEmpty()) {
            notification.setContextHelpAction(new AnAction("What is force-with-lease?", "Force-with-lease push prevents overriding remote changes that are unknown to local repository.<br>Fetch latest changes to verify that they can be safely discarded and repeat push operation.", null){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/push/GitPushResultNotification$1", "actionPerformed"));
                }
            });
            if (pushOperation != null) {
                notification.addAction((AnAction)new ForcePushNotificationAction(project, pushOperation, staleInfoRejected));
            }
        }
        GitPushResultNotification gitPushResultNotification = notification;
        if (gitPushResultNotification == null) {
            GitPushResultNotification.$$$reportNull$$$0(6);
        }
        return gitPushResultNotification;
    }

    private static String formDescription(@NotNull Map<GitRepository, GitPushRepoResult> results, boolean multiRepoProject) {
        if (results == null) {
            GitPushResultNotification.$$$reportNull$$$0(7);
        }
        List entries = ContainerUtil.sorted(results.entrySet(), (o1, o2) -> {
            int compareResultTypes = GitPushRepoResult.TYPE_COMPARATOR.compare(((GitPushRepoResult)o1.getValue()).getType(), ((GitPushRepoResult)o2.getValue()).getType());
            if (compareResultTypes != 0) {
                return compareResultTypes;
            }
            return DvcsUtil.REPOSITORY_COMPARATOR.compare(o1.getKey(), o2.getKey());
        });
        return StringUtil.join((Collection)entries, entry -> {
            GitRepository repository = (GitRepository)entry.getKey();
            GitPushRepoResult result2 = (GitPushRepoResult)entry.getValue();
            String description = GitPushResultNotification.formRepoDescription(result2);
            description = !multiRepoProject ? StringUtil.capitalize((String)description) : DvcsUtil.getShortRepositoryName((Repository)repository) + ": " + description;
            return description;
        }, (String)"<br/>");
    }

    private static String formRepoDescription(@NotNull GitPushRepoResult result2) {
        String description;
        if (result2 == null) {
            GitPushResultNotification.$$$reportNull$$$0(8);
        }
        String sourceBranch = GitBranchUtil.stripRefsPrefix(result2.getSourceBranch());
        String targetBranch = GitBranchUtil.stripRefsPrefix(result2.getTargetBranch());
        String tagDescription = GitPushResultNotification.formTagDescription(result2.getPushedTags(), result2.getTargetRemote());
        switch (result2.getType()) {
            case SUCCESS: {
                int commitNum = result2.getNumberOfPushedCommits();
                String commits2 = StringUtil.pluralize((String)"commit", (int)commitNum);
                description = String.format("pushed %d %s to %s", commitNum, commits2, targetBranch);
                if (tagDescription == null) break;
                description = description + ", and " + tagDescription;
                break;
            }
            case NEW_BRANCH: {
                description = String.format("pushed %s to new branch %s", sourceBranch, targetBranch);
                if (tagDescription == null) break;
                description = description + ", and " + tagDescription;
                break;
            }
            case UP_TO_DATE: {
                if (tagDescription != null) {
                    description = "pushed " + tagDescription;
                    break;
                }
                description = "everything is up-to-date";
                break;
            }
            case FORCED: {
                description = String.format("force pushed %s to %s", sourceBranch, targetBranch);
                break;
            }
            case REJECTED_NO_FF: {
                description = GitPushResultNotification.formDescriptionBasedOnUpdateResult(result2.getUpdateResult(), targetBranch);
                break;
            }
            case REJECTED_STALE_INFO: {
                description = String.format("force-with-lease push %s to %s was rejected", sourceBranch, targetBranch);
                break;
            }
            case REJECTED_OTHER: {
                description = String.format("push %s to %s was rejected by remote", sourceBranch, targetBranch);
                break;
            }
            case ERROR: {
                description = result2.getError();
                break;
            }
            default: {
                LOG.error("Unexpected push result: " + result2);
                description = "";
            }
        }
        return description;
    }

    @Nullable
    private static String formTagDescription(@NotNull List<String> pushedTags, @NotNull String remoteName) {
        if (pushedTags == null) {
            GitPushResultNotification.$$$reportNull$$$0(9);
        }
        if (remoteName == null) {
            GitPushResultNotification.$$$reportNull$$$0(10);
        }
        if (pushedTags.isEmpty()) {
            return null;
        }
        if (pushedTags.size() == 1) {
            return "tag " + GitBranchUtil.stripRefsPrefix(pushedTags.get(0)) + " to " + remoteName;
        }
        return pushedTags.size() + " tags to " + remoteName;
    }

    private static String formDescriptionBasedOnUpdateResult(GitUpdateResult updateResult, String targetBranch) {
        if (updateResult == null || updateResult == GitUpdateResult.SUCCESS || updateResult == GitUpdateResult.NOTHING_TO_UPDATE) {
            return String.format("push to %s was rejected", targetBranch);
        }
        if (updateResult == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) {
            return UPDATE_WITH_RESOLVED_CONFLICTS;
        }
        if (updateResult == GitUpdateResult.INCOMPLETE) {
            return INCOMPLETE_UPDATE;
        }
        if (updateResult == GitUpdateResult.CANCEL) {
            return UPDATE_CANCELLED;
        }
        return UPDATE_WITH_ERRORS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupDisplayId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushResult";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitPushResultNotification";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushedTags";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitPushResultNotification";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formDescription";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "formRepoDescription";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "formTagDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ForcePushNotificationAction
    extends NotificationAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitPushOperation myOperation;
        @NotNull
        private final List<GitRepository> myRepositories;

        private ForcePushNotificationAction(@NotNull Project project, @NotNull GitPushOperation pushOperation, @NotNull List<GitRepository> repositories) {
            if (project == null) {
                ForcePushNotificationAction.$$$reportNull$$$0(0);
            }
            if (pushOperation == null) {
                ForcePushNotificationAction.$$$reportNull$$$0(1);
            }
            if (repositories == null) {
                ForcePushNotificationAction.$$$reportNull$$$0(2);
            }
            super("Force Push Anyway");
            this.myProject = project;
            this.myOperation = pushOperation;
            this.myRepositories = repositories;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            if (e == null) {
                ForcePushNotificationAction.$$$reportNull$$$0(3);
            }
            if (notification == null) {
                ForcePushNotificationAction.$$$reportNull$$$0(4);
            }
            notification.expire();
            final Project project = this.myProject;
            new Task.Backgroundable(project, "Pushing...", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    GitPushOperation forcePushOperation = myOperation.deriveForceWithoutLease(myRepositories);
                    GitPusher.pushAndNotify(project, forcePushOperation);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/push/GitPushResultNotification$ForcePushNotificationAction$1", "run"));
                }
            }.queue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pushOperation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "git4idea/push/GitPushResultNotification$ForcePushNotificationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

