/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRepository;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeChangeCollector {
    @NotNull
    private final HashSet<String> myUnmergedPaths;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final GitRevisionNumber myStart;
    @NotNull
    private final GitRepository myRepository;

    public MergeChangeCollector(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitRevisionNumber start) {
        if (project == null) {
            MergeChangeCollector.$$$reportNull$$$0(0);
        }
        if (root == null) {
            MergeChangeCollector.$$$reportNull$$$0(1);
        }
        if (start == null) {
            MergeChangeCollector.$$$reportNull$$$0(2);
        }
        this.myUnmergedPaths = new HashSet();
        this.myStart = start;
        this.myProject = project;
        this.myRoot = root;
        this.myRepository = (GitRepository)ObjectUtils.assertNotNull((Object)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root));
    }

    public void collect(@NotNull UpdatedFiles updatedFiles) throws VcsException {
        if (updatedFiles == null) {
            MergeChangeCollector.$$$reportNull$$$0(3);
        }
        Set<String> paths = this.getUnmergedPaths();
        MergeChangeCollector.addAll(updatedFiles, "MERGED_WITH_CONFLICTS", paths);
        TreeSet<String> updated = new TreeSet<String>();
        TreeSet<String> created = new TreeSet<String>();
        TreeSet<String> removed = new TreeSet<String>();
        String revisionsForDiff = this.getRevisionsForDiff();
        if (revisionsForDiff == null) {
            return;
        }
        this.getChangedFilesExceptUnmerged(updated, created, removed, revisionsForDiff);
        MergeChangeCollector.addAll(updatedFiles, "UPDATED", updated);
        MergeChangeCollector.addAll(updatedFiles, "CREATED", created);
        MergeChangeCollector.addAll(updatedFiles, "REMOVED_FROM_REPOSITORY", removed);
    }

    @Deprecated
    public void collect(@NotNull UpdatedFiles updatedFiles, List<? super VcsException> exceptions) {
        if (updatedFiles == null) {
            MergeChangeCollector.$$$reportNull$$$0(4);
        }
        try {
            this.collect(updatedFiles);
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
    }

    public int calcUpdatedFilesCount() throws VcsException {
        String revisionsForDiff = this.getRevisionsForDiff();
        if (revisionsForDiff == null) {
            return 0;
        }
        HashSet updated = new HashSet();
        this.getChangedFilesExceptUnmerged(updated, updated, updated, revisionsForDiff);
        return updated.size() + this.getUnmergedPaths().size();
    }

    @NotNull
    private Set<String> getUnmergedPaths() throws VcsException {
        String root = this.myRoot.getPath();
        GitLineHandler h = new GitLineHandler(this.myProject, this.myRoot, GitCommand.LS_FILES);
        h.setSilent(true);
        h.addParameters("--unmerged");
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        HashSet<String> paths = new HashSet<String>();
        StringScanner s = new StringScanner(output);
        while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            s.boundedToken('\t');
            String relative = s.line();
            if (!this.myUnmergedPaths.add(relative)) continue;
            String path = root + "/" + GitUtil.unescapePath(relative);
            paths.add(path);
        }
        HashSet<String> hashSet = paths;
        if (hashSet == null) {
            MergeChangeCollector.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public String getRevisionsForDiff() throws VcsException {
        GitRevisionNumber currentHead = GitRevisionNumber.resolve(this.myProject, this.myRoot, "HEAD");
        if (!currentHead.equals(this.myStart)) return this.myStart.getRev() + "..HEAD";
        File mergeHeadsFile = this.myRepository.getRepositoryFiles().getMergeHeadFile();
        try {
            if (!mergeHeadsFile.exists()) return null;
            String mergeHeads = new String(FileUtil.loadFileText((File)mergeHeadsFile, (String)"UTF-8"));
            StringScanner s = new StringScanner(mergeHeads);
            while (s.hasMoreData()) {
                String head = s.line();
                if (head.length() == 0) continue;
                return this.myStart.getRev() + "..." + head;
            }
            return null;
        }
        catch (IOException e) {
            throw new VcsException("Unable to read the file " + mergeHeadsFile + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private void getChangedFilesExceptUnmerged(@NotNull Collection<? super String> updated, @NotNull Collection<? super String> created, @NotNull Collection<? super String> removed, @NotNull String revisions) throws VcsException {
        if (updated == null) {
            MergeChangeCollector.$$$reportNull$$$0(6);
        }
        if (created == null) {
            MergeChangeCollector.$$$reportNull$$$0(7);
        }
        if (removed == null) {
            MergeChangeCollector.$$$reportNull$$$0(8);
        }
        if (revisions == null) {
            MergeChangeCollector.$$$reportNull$$$0(9);
        }
        String root = this.myRoot.getPath();
        GitLineHandler h = new GitLineHandler(this.myProject, this.myRoot, GitCommand.DIFF);
        h.setSilent(true);
        h.addParameters("--name-status", "--diff-filter=ADMRUX", "--no-renames", revisions);
        StringScanner s = new StringScanner(Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]));
        block5: while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            char status = s.peek();
            s.boundedToken('\t');
            String relative = s.line();
            if (this.myUnmergedPaths.contains(relative)) continue;
            String path = root + "/" + GitUtil.unescapePath(relative);
            switch (status) {
                case 'M': {
                    updated.add(path);
                    continue block5;
                }
                case 'A': {
                    created.add(path);
                    continue block5;
                }
                case 'D': {
                    removed.add(path);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unexpected status: " + status);
        }
    }

    private static void addAll(@NotNull UpdatedFiles updates, @NotNull String groupId, @NotNull Set<String> paths) {
        if (updates == null) {
            MergeChangeCollector.$$$reportNull$$$0(10);
        }
        if (groupId == null) {
            MergeChangeCollector.$$$reportNull$$$0(11);
        }
        if (paths == null) {
            MergeChangeCollector.$$$reportNull$$$0(12);
        }
        FileGroup fileGroup = updates.getGroupById(groupId);
        for (String path : paths) {
            fileGroup.add(path, GitVcs.getKey(), null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedFiles";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/merge/MergeChangeCollector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updated";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "created";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removed";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updates";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/merge/MergeChangeCollector";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnmergedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getChangedFilesExceptUnmerged";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

