/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.VcsLogFileHistoryHandler;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogProviderRequirementsEx;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogSorter;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.impl.VcsIndexableLogProvider;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.UserNameRegex;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUserRegistry;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogHistoryHandler;
import git4idea.history.GitLogUtil;
import git4idea.log.GitBekParentFixer;
import git4idea.log.GitLogDiffHandler;
import git4idea.log.GitLogIndexer;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmodule;
import git4idea.repo.GitSubmoduleKt;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogProvider
implements VcsLogProvider,
VcsIndexableLogProvider {
    private static final Logger LOG = Logger.getInstance(GitLogProvider.class);
    public static final Function<VcsRef, String> GET_TAG_NAME = ref -> ref.getType() == GitRefManager.TAG ? ref.getName() : null;
    public static final TObjectHashingStrategy<VcsRef> DONT_CONSIDER_SHA = new TObjectHashingStrategy<VcsRef>(){

        public int computeHashCode(@NotNull VcsRef ref) {
            if (ref == null) {
                1.$$$reportNull$$$0(0);
            }
            return 31 * ref.getName().hashCode() + ref.getType().hashCode();
        }

        public boolean equals(@NotNull VcsRef ref1, @NotNull VcsRef ref2) {
            if (ref1 == null) {
                1.$$$reportNull$$$0(1);
            }
            if (ref2 == null) {
                1.$$$reportNull$$$0(2);
            }
            return ref1.getName().equals(ref2.getName()) && ref1.getType().equals(ref2.getType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref2";
                    break;
                }
            }
            objectArray2[1] = "git4idea/log/GitLogProvider$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeHashCode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "equals";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final VcsLogRefManager myRefSorter;
    @NotNull
    private final VcsLogObjectsFactory myVcsObjectsFactory;

    public GitLogProvider(@NotNull Project project) {
        if (project == null) {
            GitLogProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myRepositoryManager = GitRepositoryManager.getInstance(project);
        this.myRefSorter = new GitRefManager(this.myProject, (RepositoryManager<GitRepository>)this.myRepositoryManager);
        this.myVcsObjectsFactory = (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
        this.myVcs = GitVcs.getInstance(project);
    }

    @NotNull
    public VcsLogProvider.DetailedLogData readFirstBlock(@NotNull VirtualFile root, @NotNull VcsLogProvider.Requirements requirements) throws VcsException {
        Collection<Object> allDetails;
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(1);
        }
        if (requirements == null) {
            GitLogProvider.$$$reportNull$$$0(2);
        }
        if (!this.isRepositoryReady(root)) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                GitLogProvider.$$$reportNull$$$0(3);
            }
            return logDataImpl;
        }
        GitRepository repository = (GitRepository)ObjectUtils.assertNotNull((Object)this.myRepositoryManager.getRepositoryForRoot(root));
        int commitCount = requirements.getCommitCount() * 2;
        String[] params = new String[]{"HEAD", "--branches", "--remotes", "--max-count=" + commitCount};
        boolean refresh = requirements instanceof VcsLogProviderRequirementsEx && ((VcsLogProviderRequirementsEx)requirements).isRefresh();
        VcsLogProvider.DetailedLogData data = GitLogUtil.collectMetadata(this.myProject, root, params);
        Set safeRefs = data.getRefs();
        OpenTHashSet allRefs = new OpenTHashSet((Collection)safeRefs, DONT_CONSIDER_SHA);
        Set<VcsRef> branches2 = this.readBranches(repository);
        GitLogProvider.addNewElements(allRefs, branches2);
        Set<String> currentTagNames = null;
        VcsLogProvider.DetailedLogData commitsFromTags = null;
        if (!refresh) {
            allDetails = data.getCommits();
        } else {
            VcsLogProviderRequirementsEx rex = (VcsLogProviderRequirementsEx)requirements;
            currentTagNames = this.readCurrentTagNames(root);
            GitLogProvider.addOldStillExistingTags((Set<? super VcsRef>)allRefs, currentTagNames, rex.getPreviousRefs());
            allDetails = GitLogProvider.newHashSet(data.getCommits());
            Set previousTags = GitLogProvider.newHashSet(ContainerUtil.mapNotNull((Collection)rex.getPreviousRefs(), GET_TAG_NAME));
            Set safeTags = GitLogProvider.newHashSet(ContainerUtil.mapNotNull((Collection)safeRefs, GET_TAG_NAME));
            Set<String> newUnmatchedTags = GitLogProvider.remove(currentTagNames, previousTags, safeTags);
            if (!newUnmatchedTags.isEmpty()) {
                commitsFromTags = this.loadSomeCommitsOnTaggedBranches(root, commitCount, newUnmatchedTags);
                GitLogProvider.addNewElements(allDetails, commitsFromTags.getCommits());
                GitLogProvider.addNewElements(allRefs, commitsFromTags.getRefs());
            }
        }
        StopWatch sw = StopWatch.start((String)("sorting commits in " + root.getName()));
        List sortedCommits = VcsLogSorter.sortByDateTopoOrder((Collection)allDetails);
        sortedCommits = ContainerUtil.getFirstItems((List)sortedCommits, (int)requirements.getCommitCount());
        sw.report();
        if (LOG.isDebugEnabled()) {
            GitLogProvider.validateDataAndReportError(root, (Set<? extends VcsRef>)allRefs, sortedCommits, data, branches2, currentTagNames, commitsFromTags);
        }
        LogDataImpl logDataImpl = new LogDataImpl((Set)allRefs, GitBekParentFixer.fixCommits(sortedCommits));
        if (logDataImpl == null) {
            GitLogProvider.$$$reportNull$$$0(4);
        }
        return logDataImpl;
    }

    private static void validateDataAndReportError(final @NotNull VirtualFile root, final @NotNull Set<? extends VcsRef> allRefs, final @NotNull List<? extends VcsCommitMetadata> sortedCommits, final @NotNull VcsLogProvider.DetailedLogData firstBlockSyncData, final @NotNull Set<? extends VcsRef> manuallyReadBranches, final @Nullable Set<String> currentTagNames, final @Nullable VcsLogProvider.DetailedLogData commitsFromTags) {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(5);
        }
        if (allRefs == null) {
            GitLogProvider.$$$reportNull$$$0(6);
        }
        if (sortedCommits == null) {
            GitLogProvider.$$$reportNull$$$0(7);
        }
        if (firstBlockSyncData == null) {
            GitLogProvider.$$$reportNull$$$0(8);
        }
        if (manuallyReadBranches == null) {
            GitLogProvider.$$$reportNull$$$0(9);
        }
        StopWatch sw = StopWatch.start((String)("validating data in " + root.getName()));
        final Set refs = ContainerUtil.map2Set(allRefs, VcsRef::getCommitHash);
        PermanentGraphImpl.newInstance(sortedCommits, (GraphColorManager)new GraphColorManager<Hash>(){

            public int getColorOfBranch(@NotNull Hash headCommit) {
                if (headCommit == null) {
                    2.$$$reportNull$$$0(0);
                }
                return 0;
            }

            public int getColorOfFragment(@NotNull Hash headCommit, int magicIndex) {
                if (headCommit == null) {
                    2.$$$reportNull$$$0(1);
                }
                return 0;
            }

            public int compareHeads(@NotNull Hash head1, @NotNull Hash head2) {
                if (head1 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (head2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (!refs.contains(head1) || !refs.contains(head2)) {
                    LOG.error("GitLogProvider returned inconsistent data", new Attachment[]{new Attachment("error-details.txt", GitLogProvider.printErrorDetails(root, allRefs, sortedCommits, firstBlockSyncData, manuallyReadBranches, currentTagNames, commitsFromTags))});
                }
                return 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "headCommit";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "head1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "head2";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/log/GitLogProvider$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getColorOfBranch";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getColorOfFragment";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "compareHeads";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Set)refs);
        sw.report();
    }

    private static String printErrorDetails(@NotNull VirtualFile root, @NotNull Set<? extends VcsRef> allRefs, @NotNull List<? extends VcsCommitMetadata> sortedCommits, @NotNull VcsLogProvider.DetailedLogData firstBlockSyncData, @NotNull Set<? extends VcsRef> manuallyReadBranches, @Nullable Set<String> currentTagNames, @Nullable VcsLogProvider.DetailedLogData commitsFromTags) {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(10);
        }
        if (allRefs == null) {
            GitLogProvider.$$$reportNull$$$0(11);
        }
        if (sortedCommits == null) {
            GitLogProvider.$$$reportNull$$$0(12);
        }
        if (firstBlockSyncData == null) {
            GitLogProvider.$$$reportNull$$$0(13);
        }
        if (manuallyReadBranches == null) {
            GitLogProvider.$$$reportNull$$$0(14);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[" + root.getName() + "]\n");
        sb.append("First block data from Git:\n");
        sb.append(GitLogProvider.printLogData(firstBlockSyncData));
        sb.append("\n\nManually read refs:\n");
        sb.append(GitLogProvider.printRefs(manuallyReadBranches));
        sb.append("\n\nCurrent tag names:\n");
        if (currentTagNames != null) {
            sb.append(StringUtil.join(currentTagNames, (String)", "));
            if (commitsFromTags != null) {
                sb.append(GitLogProvider.printLogData(commitsFromTags));
            } else {
                sb.append("\n\nCommits from new tags were not read.\n");
            }
        } else {
            sb.append("\n\nCurrent tags were not read\n");
        }
        sb.append("\n\nResult:\n");
        sb.append("\nCommits (last 100): \n");
        sb.append(GitLogProvider.printCommits(sortedCommits));
        sb.append("\nAll refs:\n");
        sb.append(GitLogProvider.printRefs(allRefs));
        return sb.toString();
    }

    @NotNull
    private static String printLogData(@NotNull VcsLogProvider.DetailedLogData firstBlockSyncData) {
        if (firstBlockSyncData == null) {
            GitLogProvider.$$$reportNull$$$0(15);
        }
        String string = String.format("Last 100 commits:\n%s\nRefs:\n%s", GitLogProvider.printCommits(firstBlockSyncData.getCommits()), GitLogProvider.printRefs(firstBlockSyncData.getRefs()));
        if (string == null) {
            GitLogProvider.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String printCommits(@NotNull List<? extends VcsCommitMetadata> commits2) {
        if (commits2 == null) {
            GitLogProvider.$$$reportNull$$$0(17);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(commits2.size(), 100); ++i) {
            GraphCommit commit2 = (GraphCommit)commits2.get(i);
            sb.append(String.format("%s -> %s\n", ((Hash)commit2.getId()).toShortString(), StringUtil.join((Collection)commit2.getParents(), Hash::toShortString, (String)", ")));
        }
        String string = sb.toString();
        if (string == null) {
            GitLogProvider.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String printRefs(@NotNull Set<? extends VcsRef> refs) {
        if (refs == null) {
            GitLogProvider.$$$reportNull$$$0(19);
        }
        String string = StringUtil.join(refs, ref -> ref.getCommitHash().toShortString() + " : " + ref.getName(), (String)"\n");
        if (string == null) {
            GitLogProvider.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static void addOldStillExistingTags(@NotNull Set<? super VcsRef> allRefs, @NotNull Set<String> currentTags, @NotNull Collection<? extends VcsRef> previousRefs) {
        if (allRefs == null) {
            GitLogProvider.$$$reportNull$$$0(21);
        }
        if (currentTags == null) {
            GitLogProvider.$$$reportNull$$$0(22);
        }
        if (previousRefs == null) {
            GitLogProvider.$$$reportNull$$$0(23);
        }
        for (VcsRef vcsRef : previousRefs) {
            if (allRefs.contains(vcsRef) || !currentTags.contains(vcsRef.getName())) continue;
            allRefs.add((VcsRef)vcsRef);
        }
    }

    @NotNull
    private Set<String> readCurrentTagNames(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(24);
        }
        StopWatch sw = StopWatch.start((String)("reading tags in " + root.getName()));
        Set<String> tags = GitLogProvider.newHashSet();
        tags.addAll(GitBranchUtil.getAllTags(this.myProject, root));
        sw.report();
        Set<String> set = tags;
        if (set == null) {
            GitLogProvider.$$$reportNull$$$0(25);
        }
        return set;
    }

    @NotNull
    private static <T> Set<T> remove(@NotNull Set<? extends T> original, Set<T> ... toRemove) {
        if (original == null) {
            GitLogProvider.$$$reportNull$$$0(26);
        }
        if (toRemove == null) {
            GitLogProvider.$$$reportNull$$$0(27);
        }
        Set<T> result2 = GitLogProvider.newHashSet(original);
        for (Set<T> set : toRemove) {
            result2.removeAll(set);
        }
        Set<T> set = result2;
        if (set == null) {
            GitLogProvider.$$$reportNull$$$0(28);
        }
        return set;
    }

    private static <T> void addNewElements(@NotNull Collection<? super T> original, @NotNull Collection<? extends T> toAdd) {
        if (original == null) {
            GitLogProvider.$$$reportNull$$$0(29);
        }
        if (toAdd == null) {
            GitLogProvider.$$$reportNull$$$0(30);
        }
        for (T item : toAdd) {
            if (original.contains(item)) continue;
            original.add(item);
        }
    }

    @NotNull
    private VcsLogProvider.DetailedLogData loadSomeCommitsOnTaggedBranches(@NotNull VirtualFile root, int commitCount, @NotNull Collection<String> unmatchedTags) throws VcsException {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(31);
        }
        if (unmatchedTags == null) {
            GitLogProvider.$$$reportNull$$$0(32);
        }
        StopWatch sw = StopWatch.start((String)("loading commits on tagged branch in " + root.getName()));
        ArrayList<String> params = new ArrayList<String>();
        params.add("--max-count=" + commitCount);
        HashSet refs = new HashSet();
        HashSet commits2 = new HashSet();
        VcsFileUtil.foreachChunk(new ArrayList<String>(unmatchedTags), (int)1, tagsChunk -> {
            String[] parameters = ArrayUtilRt.toStringArray((Collection)ContainerUtil.concat((List)params, (List)tagsChunk));
            VcsLogProvider.DetailedLogData logData = GitLogUtil.collectMetadata(this.myProject, root, parameters);
            refs.addAll(logData.getRefs());
            commits2.addAll(logData.getCommits());
        });
        sw.report();
        LogDataImpl logDataImpl = new LogDataImpl(refs, new ArrayList(commits2));
        if (logDataImpl == null) {
            GitLogProvider.$$$reportNull$$$0(33);
        }
        return logDataImpl;
    }

    @NotNull
    public VcsLogProvider.LogData readAllHashes(@NotNull VirtualFile root, @NotNull Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(34);
        }
        if (commitConsumer == null) {
            GitLogProvider.$$$reportNull$$$0(35);
        }
        if (!this.isRepositoryReady(root)) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                GitLogProvider.$$$reportNull$$$0(36);
            }
            return logDataImpl;
        }
        ArrayList<String> parameters = new ArrayList<String>(GitLogUtil.LOG_ALL);
        parameters.add("--date-order");
        GitBekParentFixer parentFixer = GitBekParentFixer.prepare(this.myProject, root);
        Set userRegistry = GitLogProvider.newHashSet();
        Set refs = GitLogProvider.newHashSet();
        GitLogUtil.readTimedCommits(this.myProject, root, parameters, (Consumer<? super VcsUser>)new CollectConsumer(userRegistry), (Consumer<? super VcsRef>)new CollectConsumer(refs), (Consumer<? super TimedVcsCommit>)((Consumer)commit2 -> commitConsumer.consume((Object)parentFixer.fixCommit((TimedVcsCommit)commit2))));
        LogDataImpl logDataImpl = new LogDataImpl(refs, userRegistry);
        if (logDataImpl == null) {
            GitLogProvider.$$$reportNull$$$0(37);
        }
        return logDataImpl;
    }

    public void readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes2, @NotNull Consumer<? super VcsFullCommitDetails> commitConsumer) throws VcsException {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(38);
        }
        if (hashes2 == null) {
            GitLogProvider.$$$reportNull$$$0(39);
        }
        if (commitConsumer == null) {
            GitLogProvider.$$$reportNull$$$0(40);
        }
        if (!this.isRepositoryReady(root)) {
            return;
        }
        GitCommitRequirements requirements = new GitCommitRequirements(GitLogProvider.shouldIncludeRootChanges(this.myRepositoryManager, root), GitCommitRequirements.DiffRenameLimit.GIT_CONFIG, GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS);
        GitLogUtil.readFullDetailsForHashes(this.myProject, root, hashes2, requirements, commitConsumer);
    }

    static boolean shouldIncludeRootChanges(@NotNull GitRepositoryManager manager, @NotNull VirtualFile root) {
        GitRepository repository;
        if (manager == null) {
            GitLogProvider.$$$reportNull$$$0(41);
        }
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(42);
        }
        if ((repository = (GitRepository)manager.getRepositoryForRoot(root)) == null) {
            return true;
        }
        return !repository.getInfo().isShallow();
    }

    @NotNull
    public List<? extends VcsCommitMetadata> readMetadata(@NotNull VirtualFile root, @NotNull List<String> hashes2) throws VcsException {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(43);
        }
        if (hashes2 == null) {
            GitLogProvider.$$$reportNull$$$0(44);
        }
        List<? extends VcsCommitMetadata> list = GitLogUtil.collectMetadata(this.myProject, this.myVcs, root, hashes2);
        if (list == null) {
            GitLogProvider.$$$reportNull$$$0(45);
        }
        return list;
    }

    @NotNull
    private Set<VcsRef> readBranches(@NotNull GitRepository repository) {
        Hash hash;
        if (repository == null) {
            GitLogProvider.$$$reportNull$$$0(46);
        }
        StopWatch sw = StopWatch.start((String)("readBranches in " + repository.getRoot().getName()));
        VirtualFile root = repository.getRoot();
        repository.update();
        GitBranchesCollection branches2 = repository.getBranches();
        Collection<GitLocalBranch> localBranches = branches2.getLocalBranches();
        Collection<GitRemoteBranch> remoteBranches = branches2.getRemoteBranches();
        THashSet refs = new THashSet(localBranches.size() + remoteBranches.size());
        for (GitLocalBranch localBranch : localBranches) {
            hash = branches2.getHash(localBranch);
            assert (hash != null);
            refs.add(this.myVcsObjectsFactory.createRef(hash, localBranch.getName(), GitRefManager.LOCAL_BRANCH, root));
        }
        for (GitRemoteBranch remoteBranch : remoteBranches) {
            hash = branches2.getHash(remoteBranch);
            assert (hash != null);
            refs.add(this.myVcsObjectsFactory.createRef(hash, remoteBranch.getNameForLocalOperations(), GitRefManager.REMOTE_BRANCH, root));
        }
        String currentRevision = repository.getCurrentRevision();
        if (currentRevision != null) {
            refs.add(this.myVcsObjectsFactory.createRef(HashImpl.build((String)currentRevision), "HEAD", GitRefManager.HEAD, root));
        }
        sw.report();
        THashSet tHashSet = refs;
        if (tHashSet == null) {
            GitLogProvider.$$$reportNull$$$0(47);
        }
        return tHashSet;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        if (vcsKey == null) {
            GitLogProvider.$$$reportNull$$$0(48);
        }
        return vcsKey;
    }

    @NotNull
    public VcsLogRefManager getReferenceManager() {
        VcsLogRefManager vcsLogRefManager = this.myRefSorter;
        if (vcsLogRefManager == null) {
            GitLogProvider.$$$reportNull$$$0(49);
        }
        return vcsLogRefManager;
    }

    @NotNull
    public Disposable subscribeToRootRefreshEvents(@NotNull Collection<? extends VirtualFile> roots, @NotNull VcsLogRefresher refresher) {
        if (roots == null) {
            GitLogProvider.$$$reportNull$$$0(50);
        }
        if (refresher == null) {
            GitLogProvider.$$$reportNull$$$0(51);
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(GitRepository.GIT_REPO_CHANGE, repository -> {
            VirtualFile root = repository.getRoot();
            if (roots.contains(root)) {
                refresher.refresh(root);
            }
        });
        MessageBusConnection messageBusConnection = connection;
        if (messageBusConnection == null) {
            GitLogProvider.$$$reportNull$$$0(52);
        }
        return messageBusConnection;
    }

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        VcsLogRangeFilter rangeFilter;
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(53);
        }
        if (filterCollection == null) {
            GitLogProvider.$$$reportNull$$$0(54);
        }
        if ((rangeFilter = (VcsLogRangeFilter)filterCollection.get(VcsLogFilterCollection.RANGE_FILTER)) == null) {
            List<TimedVcsCommit> list = this.getCommitsMatchingFilter(root, filterCollection, null, maxCount);
            if (list == null) {
                GitLogProvider.$$$reportNull$$$0(55);
            }
            return list;
        }
        LinkedHashSet<TimedVcsCommit> commits2 = new LinkedHashSet<TimedVcsCommit>();
        if (filterCollection.get(VcsLogFilterCollection.BRANCH_FILTER) != null || filterCollection.get(VcsLogFilterCollection.REVISION_FILTER) != null) {
            commits2.addAll(this.getCommitsMatchingFilter(root, filterCollection, null, maxCount));
            filterCollection = VcsLogFiltersKt.without((VcsLogFilterCollection)VcsLogFiltersKt.without((VcsLogFilterCollection)filterCollection, (VcsLogFilterCollection.FilterKey)VcsLogFilterCollection.BRANCH_FILTER), (VcsLogFilterCollection.FilterKey)VcsLogFilterCollection.REVISION_FILTER);
        }
        for (VcsLogRangeFilter.RefRange range : rangeFilter.getRanges()) {
            commits2.addAll(this.getCommitsMatchingFilter(root, filterCollection, range, maxCount));
        }
        ArrayList<TimedVcsCommit> arrayList = new ArrayList<TimedVcsCommit>(commits2);
        if (arrayList == null) {
            GitLogProvider.$$$reportNull$$$0(56);
        }
        return arrayList;
    }

    @NotNull
    private List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, @Nullable VcsLogRangeFilter.RefRange range, int maxCount) throws VcsException {
        Collection files;
        VcsLogStructureFilter structureFilter;
        VcsLogTextFilter textFilter;
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(57);
        }
        if (filterCollection == null) {
            GitLogProvider.$$$reportNull$$$0(58);
        }
        if (!this.isRepositoryReady(root)) {
            List<TimedVcsCommit> list = Collections.emptyList();
            if (list == null) {
                GitLogProvider.$$$reportNull$$$0(59);
            }
            return list;
        }
        ArrayList<String> filterParameters = new ArrayList<String>();
        VcsLogBranchFilter branchFilter = (VcsLogBranchFilter)filterCollection.get(VcsLogFilterCollection.BRANCH_FILTER);
        VcsLogRevisionFilter revisionFilter = (VcsLogRevisionFilter)filterCollection.get(VcsLogFilterCollection.REVISION_FILTER);
        if (branchFilter != null || revisionFilter != null || range != null) {
            boolean atLeastOneBranchExists = false;
            if (branchFilter != null) {
                GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
                assert (repository != null) : "repository is null for root " + root + " but was previously reported as 'ready'";
                ArrayList branches2 = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{repository.getBranches().getLocalBranches(), repository.getBranches().getRemoteBranches()}));
                Collection<String> branchNames = GitBranchUtil.convertBranchesToNames(branches2);
                List<String> predefinedNames = Collections.singletonList("HEAD");
                for (String branchName : ContainerUtil.concat((Iterable[])new Iterable[]{branchNames, predefinedNames})) {
                    if (!branchFilter.matches(branchName)) continue;
                    filterParameters.add(branchName);
                    atLeastOneBranchExists = true;
                }
            }
            if (revisionFilter != null) {
                for (CommitId commit2 : revisionFilter.getHeads()) {
                    if (!commit2.getRoot().equals(root)) continue;
                    filterParameters.add(commit2.getHash().asString());
                    atLeastOneBranchExists = true;
                }
            }
            if (range != null) {
                filterParameters.add(range.getExclusiveRef() + ".." + range.getInclusiveRef());
            }
            if (range == null && !atLeastOneBranchExists) {
                List<TimedVcsCommit> list = Collections.emptyList();
                if (list == null) {
                    GitLogProvider.$$$reportNull$$$0(60);
                }
                return list;
            }
        } else {
            filterParameters.addAll(GitLogUtil.LOG_ALL);
        }
        VcsLogDateFilter dateFilter = (VcsLogDateFilter)filterCollection.get(VcsLogFilterCollection.DATE_FILTER);
        if (dateFilter != null) {
            if (dateFilter.getAfter() != null) {
                filterParameters.add(GitLogProvider.prepareParameter("after", dateFilter.getAfter().toString()));
            }
            if (dateFilter.getBefore() != null) {
                filterParameters.add(GitLogProvider.prepareParameter("before", dateFilter.getBefore().toString()));
            }
        }
        String text = (textFilter = (VcsLogTextFilter)filterCollection.get(VcsLogFilterCollection.TEXT_FILTER)) != null ? textFilter.getText() : null;
        boolean regexp = textFilter == null || textFilter.isRegex();
        boolean caseSensitive = textFilter != null && textFilter.matchesCase();
        GitLogProvider.appendTextFilterParameters(text, regexp, caseSensitive, filterParameters);
        VcsLogUserFilter userFilter = (VcsLogUserFilter)filterCollection.get(VcsLogFilterCollection.USER_FILTER);
        if (userFilter != null) {
            List names = ContainerUtil.map((Collection)userFilter.getUsers(root), VcsUserUtil::toExactString);
            if (regexp) {
                List authors = ContainerUtil.map((Collection)names, (Function)UserNameRegex.EXTENDED_INSTANCE);
                if (GitVersionSpecialty.LOG_AUTHOR_FILTER_SUPPORTS_VERTICAL_BAR.existsIn(this.myVcs)) {
                    filterParameters.add(GitLogProvider.prepareParameter("author", StringUtil.join((Collection)authors, (String)"|")));
                } else {
                    filterParameters.addAll(ContainerUtil.map((Collection)authors, a -> GitLogProvider.prepareParameter("author", a)));
                }
            } else {
                filterParameters.addAll(ContainerUtil.map((Collection)names, a -> GitLogProvider.prepareParameter("author", StringUtil.escapeBackSlashes((String)a))));
            }
        }
        if (maxCount > 0) {
            filterParameters.add(GitLogProvider.prepareParameter("max-count", String.valueOf(maxCount)));
        }
        if ((structureFilter = (VcsLogStructureFilter)filterCollection.get(VcsLogFilterCollection.STRUCTURE_FILTER)) != null && !(files = structureFilter.getFiles()).isEmpty()) {
            filterParameters.add("--full-history");
            filterParameters.add("--simplify-merges");
            filterParameters.add("--");
            for (FilePath file : files) {
                filterParameters.add(VcsFileUtil.relativePath((VirtualFile)root, (FilePath)file));
            }
        }
        ArrayList<TimedVcsCommit> commits2 = new ArrayList<TimedVcsCommit>();
        GitLogUtil.readTimedCommits(this.myProject, root, filterParameters, (Consumer<? super VcsUser>)EmptyConsumer.getInstance(), (Consumer<? super VcsRef>)EmptyConsumer.getInstance(), (Consumer<? super TimedVcsCommit>)new CollectConsumer(commits2));
        ArrayList<TimedVcsCommit> arrayList = commits2;
        if (arrayList == null) {
            GitLogProvider.$$$reportNull$$$0(61);
        }
        return arrayList;
    }

    public static void appendTextFilterParameters(@Nullable String text, boolean regexp, boolean caseSensitive, @NotNull List<? super String> filterParameters) {
        if (filterParameters == null) {
            GitLogProvider.$$$reportNull$$$0(62);
        }
        if (text != null) {
            filterParameters.add(GitLogProvider.prepareParameter("grep", text));
        }
        filterParameters.add(regexp ? "--extended-regexp" : "--fixed-strings");
        if (!caseSensitive) {
            filterParameters.add("--regexp-ignore-case");
        }
    }

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile root) {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(63);
        }
        return GitUserRegistry.getInstance(this.myProject).getOrReadUser(root);
    }

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile root, @NotNull Hash commitHash) throws VcsException {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(64);
        }
        if (commitHash == null) {
            GitLogProvider.$$$reportNull$$$0(65);
        }
        Collection<String> collection = GitBranchUtil.getBranches(this.myProject, root, true, true, commitHash.asString());
        if (collection == null) {
            GitLogProvider.$$$reportNull$$$0(66);
        }
        return collection;
    }

    @Nullable
    public String getCurrentBranch(@NotNull VirtualFile root) {
        GitRepository repository;
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(67);
        }
        if ((repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root)) == null) {
            return null;
        }
        String currentBranchName = repository.getCurrentBranchName();
        if (currentBranchName == null && repository.getCurrentRevision() != null) {
            return "HEAD";
        }
        return currentBranchName;
    }

    @Nullable
    public VcsLogDiffHandler getDiffHandler() {
        return new GitLogDiffHandler(this.myProject);
    }

    @Nullable
    public VcsLogFileHistoryHandler getFileHistoryHandler() {
        return new GitLogHistoryHandler(this.myProject);
    }

    @Nullable
    public Hash resolveReference(@NotNull String ref, @NotNull VirtualFile root) {
        if (ref == null) {
            GitLogProvider.$$$reportNull$$$0(68);
        }
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(69);
        }
        GitLineHandler handler = new GitLineHandler(this.myProject, root, GitCommand.REV_PARSE);
        handler.addParameters("--verify");
        handler.addParameters(ref + "^{commit}");
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        String output = result2.getOutputAsJoinedString();
        if (result2.success()) {
            if (VcsLogUtil.HASH_REGEX.matcher(output).matches()) {
                return HashImpl.build((String)output);
            }
            LOG.error("Invalid output for git rev-parse " + ref + " in " + root + ": " + output);
            return null;
        }
        LOG.debug("Reference [" + ref + "] is unknown to Git in " + root);
        return null;
    }

    @Nullable
    public VirtualFile getVcsRoot(@NotNull Project project, @NotNull VirtualFile detectedRoot, @NotNull FilePath path) {
        GitSubmodule submodule;
        GitRepository repository;
        if (project == null) {
            GitLogProvider.$$$reportNull$$$0(70);
        }
        if (detectedRoot == null) {
            GitLogProvider.$$$reportNull$$$0(71);
        }
        if (path == null) {
            GitLogProvider.$$$reportNull$$$0(72);
        }
        if (detectedRoot.equals(path.getVirtualFile()) && (repository = (GitRepository)this.myRepositoryManager.getRepositoryForRootQuick(detectedRoot)) != null && (submodule = GitSubmoduleKt.asSubmodule(repository)) != null) {
            return submodule.getParent().getRoot();
        }
        return detectedRoot;
    }

    @Nullable
    public <T> T getPropertyValue(VcsLogProperties.VcsLogProperty<T> property) {
        if (property == VcsLogProperties.LIGHTWEIGHT_BRANCHES) {
            return (T)Boolean.TRUE;
        }
        if (property == VcsLogProperties.SUPPORTS_INDEXING) {
            return (T)Boolean.valueOf(GitLogProvider.isIndexingOn());
        }
        if (property == VcsLogProperties.SUPPORTS_LOG_DIRECTORY_HISTORY) {
            return (T)Boolean.TRUE;
        }
        return null;
    }

    @NotNull
    public VcsLogIndexer getIndexer() {
        GitLogIndexer gitLogIndexer = new GitLogIndexer(this.myProject, this.myRepositoryManager);
        if (gitLogIndexer == null) {
            GitLogProvider.$$$reportNull$$$0(73);
        }
        return gitLogIndexer;
    }

    public static boolean isIndexingOn() {
        return Registry.is((String)"vcs.log.index.git");
    }

    private static String prepareParameter(String paramName, String value) {
        return "--" + paramName + "=" + value;
    }

    private boolean isRepositoryReady(@NotNull VirtualFile root) {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(74);
        }
        return GitLogProvider.isRepositoryReady(this.myRepositoryManager, root);
    }

    static boolean isRepositoryReady(@NotNull GitRepositoryManager manager, @NotNull VirtualFile root) {
        GitRepository repository;
        if (manager == null) {
            GitLogProvider.$$$reportNull$$$0(75);
        }
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(76);
        }
        if ((repository = (GitRepository)manager.getRepositoryForRoot(root)) == null) {
            LOG.error("Repository not found for root " + root);
            return false;
        }
        if (repository.isFresh()) {
            LOG.info("Fresh repository: " + root);
            return false;
        }
        return true;
    }

    @NotNull
    private static <T> Set<T> newHashSet() {
        THashSet tHashSet = new THashSet();
        if (tHashSet == null) {
            GitLogProvider.$$$reportNull$$$0(77);
        }
        return tHashSet;
    }

    @NotNull
    private static <T> Set<T> newHashSet(@NotNull Collection<? extends T> initialCollection) {
        if (initialCollection == null) {
            GitLogProvider.$$$reportNull$$$0(78);
        }
        THashSet tHashSet = new THashSet(initialCollection);
        if (tHashSet == null) {
            GitLogProvider.$$$reportNull$$$0(79);
        }
        return tHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 28: 
            case 33: 
            case 36: 
            case 37: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 66: 
            case 73: 
            case 77: 
            case 79: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 28: 
            case 33: 
            case 36: 
            case 37: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 66: 
            case 73: 
            case 77: 
            case 79: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 24: 
            case 31: 
            case 34: 
            case 38: 
            case 42: 
            case 43: 
            case 53: 
            case 57: 
            case 63: 
            case 64: 
            case 67: 
            case 69: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 3: 
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 28: 
            case 33: 
            case 36: 
            case 37: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 66: 
            case 73: 
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/log/GitLogProvider";
                break;
            }
            case 6: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRefs";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortedCommits";
                break;
            }
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstBlockSyncData";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manuallyReadBranches";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTags";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousRefs";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unmatchedTags";
                break;
            }
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitConsumer";
                break;
            }
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 41: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterCollection";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterParameters";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitHash";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedRoot";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/log/GitLogProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readFirstBlock";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "printLogData";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "printCommits";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "printRefs";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "readCurrentTagNames";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSomeCommitsOnTaggedBranches";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "readAllHashes";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "readMetadata";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "readBranches";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedVcs";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceManager";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "subscribeToRootRefreshEvents";
                break;
            }
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsMatchingFilter";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingBranches";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 77: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readFirstBlock";
                break;
            }
            case 3: 
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 28: 
            case 33: 
            case 36: 
            case 37: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 66: 
            case 73: 
            case 77: 
            case 79: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateDataAndReportError";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "printErrorDetails";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "printLogData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "printCommits";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "printRefs";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addOldStillExistingTags";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readCurrentTagNames";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addNewElements";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "loadSomeCommitsOnTaggedBranches";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "readAllHashes";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetails";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "shouldIncludeRootChanges";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "readMetadata";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "readBranches";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "subscribeToRootRefreshEvents";
                break;
            }
            case 53: 
            case 54: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsMatchingFilter";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "appendTextFilterParameters";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentUser";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranches";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranch";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRoot";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isRepositoryReady";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "newHashSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 28: 
            case 33: 
            case 36: 
            case 37: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 66: 
            case 73: 
            case 77: 
            case 79: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

