/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class VertJdbcHelper
extends JdbcHelperImpl {
    public VertJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(UnknownDatabase.RDBMS, version, connection);
    }

    public VertJdbcHelper() {
        this(null, null);
    }

    @Override
    @NotNull
    public String getDbmsName() {
        if ("VERTICA" == null) {
            VertJdbcHelper.$$$reportNull$$$0(0);
        }
        return "VERTICA";
    }

    @Override
    public boolean isZonedTimestampColumn(@Nullable String typeName, int jdbcType) {
        if (typeName != null && "timestamptz".equalsIgnoreCase(typeName)) {
            return true;
        }
        return super.isZonedTimestampColumn(typeName, jdbcType);
    }

    @Override
    public boolean isZonedTimeColumn(@Nullable String typeName) {
        if (typeName != null && "timetz".equalsIgnoreCase(typeName)) {
            return true;
        }
        return super.isZonedTimeColumn(typeName);
    }

    @Override
    public int fixScale(int type, int precision, int scale) {
        if (type == 92) {
            return precision - 9;
        }
        return super.fixScale(type, precision, scale);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return VertJdbcHelper.extractVersion(version);
    }

    @Nullable
    public static String extractVersion(@Nullable String version) {
        return JdbcNativeUtil.findVersion(version, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) {
        if (!JdbcNativeUtil.detectString(product, "vertica")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return VertJdbcHelper.create(delegate, productVer);
    }

    @NotNull
    static VertJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        VertJdbcHelper vertJdbcHelper = new VertJdbcHelper(VertJdbcHelper.extractVersion(productVer), delegate);
        if (vertJdbcHelper == null) {
            VertJdbcHelper.$$$reportNull$$$0(1);
        }
        return vertJdbcHelper;
    }

    @Override
    public boolean supportsIlike() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/remote/jdbc/helpers/VertJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbmsName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

