/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class SFlakeJdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> SFLAKE_UNLIMITED_TYPES = ContainerUtilRt.newHashSet((Object[])new String[]{"DOUBLE", "ARRAY", "OBJECT", "VARIANT", "BOOLEAN", "DATE", "BINARY"});
    private static final Set<String> SFLAKE_TIME_TYPES = ContainerUtilRt.newHashSet((Object[])new String[]{"TIME", "TIMESTAMPTZ", "TIMESTAMPLTZ", "TIMESTAMPNTZ"});

    public SFlakeJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Rdbms.of((String)"SNOWFLAKE"), version, connection);
    }

    public SFlakeJdbcHelper() {
        this(null, null);
    }

    @Override
    public void setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            SFlakeJdbcHelper.$$$reportNull$$$0(0);
        }
        if (columnInfo == null) {
            SFlakeJdbcHelper.$$$reportNull$$$0(1);
        }
        if (columnInfo.getType() == 93 && value instanceof Timestamp && "TIMESTAMPNTZ".equals(columnInfo.getTypeName())) {
            statement.setString(idx, value.toString());
        } else {
            super.setStatementParameter(statement, value, columnInfo, needsEscaping, idx);
        }
    }

    @Override
    public boolean isZonedTimestampColumn(@Nullable String typeName, int jdbcType) {
        if ("TIMESTAMPTZ".equals(typeName) || "TIMESTAMPLTZ".equals(typeName)) {
            return true;
        }
        return super.isZonedTimestampColumn(typeName, jdbcType);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            SFlakeJdbcHelper.$$$reportNull$$$0(2);
        }
        if (e.typeName != null && SFLAKE_UNLIMITED_TYPES.contains(e.typeName)) {
            e.length = -1;
        } else if (e.typeName != null && SFLAKE_TIME_TYPES.contains(e.typeName)) {
            e.length = e.scale;
            e.scale = 0;
        }
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) {
        if (!JdbcNativeUtil.detectString(product, "snowflake")) {
            return null;
        }
        return SFlakeJdbcHelper.create(delegate, productVer);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return SFlakeJdbcHelper.extractVersion(version);
    }

    @NotNull
    protected static SFlakeJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        SFlakeJdbcHelper sFlakeJdbcHelper = new SFlakeJdbcHelper(SFlakeJdbcHelper.extractVersion(productVer), delegate);
        if (sFlakeJdbcHelper == null) {
            SFlakeJdbcHelper.$$$reportNull$$$0(3);
        }
        return sFlakeJdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean supportsIlike() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/SFlakeJdbcHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/SFlakeJdbcHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setStatementParameter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

