/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.cassandra.RemoteCassConnectionImpl;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Cassandra;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.CassandraExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.CassandraIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;

public class CassJdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> TYPES_WITHOUT_CODEC = new HashSet<String>();

    public CassJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Cassandra.RDBMS, version, connection);
    }

    public CassJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return CassJdbcHelper.extractVersion(version);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource ds) {
        if (ds == null) {
            CassJdbcHelper.$$$reportNull$$$0(0);
        }
        CassandraIntermediateFacade cassandraIntermediateFacade = new CassandraIntermediateFacade(ds, 1, false, (DBExceptionRecognizer)CassandraExceptionRecognizer.INSTANCE);
        if (cassandraIntermediateFacade == null) {
            CassJdbcHelper.$$$reportNull$$$0(1);
        }
        return cassandraIntermediateFacade;
    }

    @Override
    protected void setTimestamp(@NotNull RemotePreparedStatement statement, int idx, Timestamp timestamp) throws Exception {
        if (statement == null) {
            CassJdbcHelper.$$$reportNull$$$0(2);
        }
        statement.setTimestamp(idx, timestamp);
    }

    @Override
    protected void setTime(@NotNull RemotePreparedStatement statement, int idx, Time time) throws RemoteException, SQLException {
        if (statement == null) {
            CassJdbcHelper.$$$reportNull$$$0(3);
        }
        statement.setTime(idx, time);
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "Cassandra")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return CassJdbcHelper.create(delegate, productVer);
    }

    @NotNull
    private static JdbcHelperImpl create(@Nullable Connection delegate, @Nullable String productVer) throws Exception {
        String versionStr = delegate == null ? productVer : JdbcNativeUtil.getString(delegate, "select release_version from system.local");
        JdbcNativeUtil.logInfo("release_version: " + versionStr);
        CassJdbcHelper cassJdbcHelper = new CassJdbcHelper(CassJdbcHelper.extractVersion(versionStr), delegate);
        if (cassJdbcHelper == null) {
            CassJdbcHelper.$$$reportNull$$$0(4);
        }
        return cassJdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public JdbcHelper.LikeSupport getLikeSupport() {
        return JdbcHelper.LikeSupport.NONE;
    }

    @Override
    public boolean getAutoCommit(Connection delegate) {
        return true;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public RemoteConnection wrap(Connection connection) {
        return new RemoteCassConnectionImpl(connection, (JdbcHelperImpl)this);
    }

    @Override
    public int fixUpdateCount(int update) {
        if (update == 0) {
            return -2;
        }
        return update;
    }

    @Override
    public Object wrapIfNeeded(@NotNull JdbcRemoteObject exporter, Object o) throws RemoteException, SQLException {
        if (exporter == null) {
            CassJdbcHelper.$$$reportNull$$$0(5);
        }
        if (o == null) {
            return null;
        }
        if (o.getClass().getName().equals("com.datastax.driver.core.UDTValue")) {
            return new CassUdtValueWrapper(o.toString());
        }
        return super.wrapIfNeeded(exporter, o);
    }

    public static String toValidLiteral(Object object) {
        if (object instanceof Set) {
            StringBuilder sb = new StringBuilder("{");
            boolean first = true;
            for (Object value : (Set)object) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(CassJdbcHelper.toValidLiteral(value));
            }
            return sb.append("}").toString();
        }
        if (object instanceof Map) {
            StringBuilder sb = new StringBuilder("{");
            boolean first = true;
            Map map = (Map)object;
            for (Object key : map.keySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(CassJdbcHelper.toValidLiteral(key)).append(": ").append(CassJdbcHelper.toValidLiteral(map.get(key)));
            }
            return sb.append("}").toString();
        }
        if (object instanceof List) {
            StringBuilder sb = new StringBuilder("[");
            boolean first = true;
            for (Object value : (List)object) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(CassJdbcHelper.toValidLiteral(value));
            }
            return sb.append("]").toString();
        }
        if (object instanceof String) {
            return CassJdbcHelper.quote((String)object);
        }
        return object.toString();
    }

    private static String quote(String string) {
        return "'" + string.replaceAll("'", "''") + "'";
    }

    public static boolean hasCodec(@NotNull String typeName) {
        if (typeName == null) {
            CassJdbcHelper.$$$reportNull$$$0(6);
        }
        return !TYPES_WITHOUT_CODEC.contains(typeName.toLowerCase());
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            CassJdbcHelper.$$$reportNull$$$0(7);
        }
        return CassJdbcHelper.classNameContains(driver, "Cassandra");
    }

    @Override
    public JdbcSettings.SslMode[] supportedSslModes() {
        return new JdbcSettings.SslMode[]{JdbcSettings.SslMode.VERIFY_CA};
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            CassJdbcHelper.$$$reportNull$$$0(8);
        }
        if (properties == null) {
            CassJdbcHelper.$$$reportNull$$$0(9);
        }
        if (sslMode == null) {
            CassJdbcHelper.$$$reportNull$$$0(10);
        }
        properties.setProperty("sslenabled", "true");
    }

    static {
        TYPES_WITHOUT_CODEC.add("set");
        TYPES_WITHOUT_CODEC.add("map");
        TYPES_WITHOUT_CODEC.add("list");
        TYPES_WITHOUT_CODEC.add("tuple");
        TYPES_WITHOUT_CODEC.add("udt");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/CassJdbcHelper";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/CassJdbcHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacade";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTime";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrapIfNeeded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasCodec";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "enableSsl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CassUdtValueWrapper
    implements Serializable {
        private final String myValue;

        public CassUdtValueWrapper(String value) {
            this.myValue = value;
        }

        public String toString() {
            return this.myValue;
        }
    }
}

