/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgGPlumJdbcHelperBase;
import java.sql.Connection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Postgres;

public class CRoachJdbcHelper
extends PgGPlumJdbcHelperBase {
    private static final Pattern CR_VERSION_PATTERN = Pattern.compile(" v(\\d+(?:\\.\\d+)*)", 2);

    public CRoachJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Postgres.RDBMS, version, connection);
    }

    public CRoachJdbcHelper() {
        this(null, null);
    }

    @Override
    @NotNull
    public String getDbmsName() {
        if ("COCKROACHDB" == null) {
            CRoachJdbcHelper.$$$reportNull$$$0(0);
        }
        return "COCKROACHDB";
    }

    @Override
    public boolean supportsLimitMaxRows() {
        return false;
    }

    @Override
    @Nullable
    public Boolean supportsSavepoints() {
        return false;
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return CRoachJdbcHelper.extractVersion(version);
    }

    @NotNull
    protected static CRoachJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        String version = CRoachJdbcHelper.extractVersion(productVer);
        CRoachJdbcHelper cRoachJdbcHelper = new CRoachJdbcHelper(version, delegate);
        if (cRoachJdbcHelper == null) {
            CRoachJdbcHelper.$$$reportNull$$$0(1);
        }
        return cRoachJdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, CR_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/remote/jdbc/helpers/CRoachJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbmsName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

