/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointAvailabilityListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyedExtensionCollector<T, KeyT>
implements ModificationTracker {
    private static final Logger LOG = Logger.getInstance(KeyedExtensionCollector.class);
    protected final String myLock;
    private Map<String, List<T>> myExplicitExtensions;
    private final ConcurrentMap<String, List<T>> myCache;
    private final String myEpName;
    private final SimpleModificationTracker myTracker;
    private final ExtensionPointAndAreaListener<KeyedLazyInstance<T>> myListener;

    public KeyedExtensionCollector(@NotNull String epName) {
        if (epName == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(0);
        }
        this(epName, null);
    }

    public KeyedExtensionCollector(final @NotNull String epName, final @Nullable Disposable parentDisposable) {
        if (epName == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(1);
        }
        this.myExplicitExtensions = Collections.emptyMap();
        this.myCache = ContainerUtil.newConcurrentMap();
        this.myTracker = new SimpleModificationTracker();
        this.myListener = new ExtensionPointAndAreaListener<KeyedLazyInstance<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void extensionAdded(@NotNull KeyedLazyInstance<T> bean, @Nullable PluginDescriptor pluginDescriptor) {
                if (bean == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = KeyedExtensionCollector.this.myLock;
                synchronized (string) {
                    if (bean.getKey() == null) {
                        if (pluginDescriptor != null) {
                            throw new PluginException("No key specified for extension of class " + bean.getInstance().getClass(), pluginDescriptor.getPluginId());
                        }
                        LOG.error("No key specified for extension of class " + bean.getInstance().getClass());
                        return;
                    }
                    KeyedExtensionCollector.this.myCache.remove(bean.getKey());
                    KeyedExtensionCollector.this.myTracker.incModificationCount();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void extensionRemoved(@NotNull KeyedLazyInstance<T> bean, @Nullable PluginDescriptor pluginDescriptor) {
                if (bean == null) {
                    1.$$$reportNull$$$0(1);
                }
                String string = KeyedExtensionCollector.this.myLock;
                synchronized (string) {
                    KeyedExtensionCollector.this.myCache.remove(bean.getKey());
                    KeyedExtensionCollector.this.myTracker.incModificationCount();
                }
            }

            public void areaReplaced(@NotNull ExtensionsArea area) {
                if (area == null) {
                    1.$$$reportNull$$$0(2);
                }
                KeyedExtensionCollector.this.myCache.clear();
                KeyedExtensionCollector.this.myTracker.incModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "bean";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "area";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionCollector$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "areaReplaced";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myEpName = epName;
        this.myLock = "lock for KeyedExtensionCollector " + epName;
        Extensions.getRootArea().addAvailabilityListener(epName, new ExtensionPointAvailabilityListener(){

            public void extensionPointRegistered(@NotNull ExtensionPoint extensionPoint) {
                if (extensionPoint == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (extensionPoint.getName().equals(epName)) {
                    extensionPoint.addExtensionPointListener((ExtensionPointListener)KeyedExtensionCollector.this.myListener, false, parentDisposable);
                    KeyedExtensionCollector.this.myCache.clear();
                    KeyedExtensionCollector.this.myTracker.incModificationCount();
                }
            }

            public void extensionPointRemoved(@NotNull ExtensionPoint extensionPoint) {
                if (extensionPoint == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "extensionPoint";
                objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionCollector$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionPointRegistered";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionPointRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(2);
        }
        if (t == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(3);
        }
        String string = this.myLock;
        synchronized (string) {
            String stringKey = this.keyToString(key);
            if (this.myExplicitExtensions == Collections.emptyMap()) {
                this.myExplicitExtensions = new THashMap();
            }
            List list = this.myExplicitExtensions.computeIfAbsent(stringKey, __ -> new SmartList());
            list.add(t);
            this.myCache.remove(stringKey);
            this.myTracker.incModificationCount();
        }
    }

    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t, @NotNull Disposable parentDisposable) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(4);
        }
        if (t == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(6);
        }
        this.addExplicitExtension(key, t);
        Disposer.register((Disposable)parentDisposable, () -> this.removeExplicitExtension(key, t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(7);
        }
        if (t == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(8);
        }
        String string = this.myLock;
        synchronized (string) {
            String stringKey = this.keyToString(key);
            List<T> list = this.myExplicitExtensions.get(stringKey);
            if (list != null) {
                list.remove(t);
                if (list.isEmpty()) {
                    this.myExplicitExtensions.remove(stringKey);
                }
            }
            this.myCache.remove(stringKey);
            this.myTracker.incModificationCount();
        }
    }

    @NotNull
    protected String keyToString(@NotNull KeyT key) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(9);
        }
        String string = key.toString();
        if (string == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public List<T> forKey(@NotNull KeyT key) {
        String stringKey;
        Object cached;
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(11);
        }
        if ((cached = (ImmutableList)this.myCache.get(stringKey = this.keyToString(key))) == null) {
            List<T> list = this.buildExtensions(stringKey, key);
            cached = list.isEmpty() ? Collections.emptyList() : (list.size() == 1 ? ContainerUtil.immutableSingletonList(list.get(0)) : ContainerUtil.immutableList((Object[])list.toArray()));
            cached = (List)ConcurrencyUtil.cacheOrGet(this.myCache, (Object)stringKey, cached);
        }
        ImmutableList immutableList = cached;
        if (immutableList == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(12);
        }
        return immutableList;
    }

    public T findSingle(@NotNull KeyT key) {
        List<T> list;
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(13);
        }
        return (list = this.forKey(key)).isEmpty() ? null : (T)list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull KeyT key) {
        if (stringKey == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(14);
        }
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(15);
        }
        List<KeyedLazyInstance<T>> extensions = this.getExtensions();
        String string = this.myLock;
        // MONITORENTER : string
        List<T> list2 = this.myExplicitExtensions.get(stringKey);
        ArrayList<T> arrayList = list2 != null ? new ArrayList<T>(list2) : null;
        List<T> list3 = this.buildExtensionsFromExtensionPoint(arrayList, bean -> stringKey.equals(bean.getKey()), extensions);
        List list = ContainerUtil.notNullize(list3);
        // MONITOREXIT : string
        if (list != null) return list;
        KeyedExtensionCollector.$$$reportNull$$$0(16);
        return list;
    }

    @NotNull
    protected final List<KeyedLazyInstance<T>> getExtensions() {
        ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
        List list = point == null ? Collections.emptyList() : point.getExtensionList();
        if (list == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    protected final List<T> buildExtensionsFromExtensionPoint(@Nullable List<T> result, @NotNull Predicate<? super KeyedLazyInstance<T>> isMyBean, @NotNull List<KeyedLazyInstance<T>> extensions) {
        if (isMyBean == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(18);
        }
        if (extensions == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(19);
        }
        for (KeyedLazyInstance<T> bean : extensions) {
            T instance;
            if (!isMyBean.test(bean)) continue;
            try {
                instance = bean.getInstance();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (ExtensionNotApplicableException ignore) {
                continue;
            }
            catch (Exception | LinkageError e) {
                LOG.error(e);
                continue;
            }
            if (result == null) {
                result = new SmartList();
            }
            result.add(instance);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected List<T> buildExtensions(@NotNull Set<String> keys) {
        if (keys == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(20);
        }
        List<KeyedLazyInstance<T>> extensions = this.getExtensions();
        String string = this.myLock;
        // MONITORENTER : string
        List<T> result = this.buildExtensionsFromExplicitRegistration(null, key -> keys.contains(key));
        result = this.buildExtensionsFromExtensionPoint(result, bean -> keys.contains(bean.getKey()), extensions);
        List list = ContainerUtil.notNullize(result);
        // MONITOREXIT : string
        if (list != null) return list;
        KeyedExtensionCollector.$$$reportNull$$$0(21);
        return list;
    }

    @Nullable
    protected List<T> buildExtensionsFromExplicitRegistration(@Nullable List<T> result, @NotNull Predicate<? super String> isMyBean) {
        if (isMyBean == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(22);
        }
        for (Map.Entry<String, List<T>> entry : this.myExplicitExtensions.entrySet()) {
            String key = entry.getKey();
            if (!isMyBean.test(key)) continue;
            List<T> list = entry.getValue();
            if (result == null) {
                result = new ArrayList<T>(list);
                continue;
            }
            result.addAll(list);
        }
        return result;
    }

    @Nullable
    @ApiStatus.Internal
    public ExtensionPoint<KeyedLazyInstance<T>> getPoint() {
        return Extensions.getRootArea().getExtensionPointIfRegistered(this.myEpName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyExtensions() {
        String string = this.myLock;
        synchronized (string) {
            if (!this.myExplicitExtensions.isEmpty()) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
            return point != null && point.hasAnyExtensions();
        }
    }

    @NotNull
    public String getName() {
        String string = this.myEpName;
        if (string == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Override
    public long getModificationCount() {
        return this.myTracker.getModificationCount();
    }

    protected void ensureValuesLoaded() {
        ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
        if (point != null) {
            for (KeyedLazyInstance bean : point.getExtensionList()) {
                bean.getInstance();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/KeyedExtensionCollector";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringKey";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isMyBean";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionCollector";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "keyToString";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "forKey";
                break;
            }
            case 16: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeExplicitExtension";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "keyToString";
                break;
            }
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forKey";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findSingle";
                break;
            }
            case 14: 
            case 15: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensionsFromExtensionPoint";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensionsFromExplicitRegistration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

