/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.google.common.collect.BiMap;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JSFileFinderBase;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.LocalFileSystemFileFinder;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.execution.JSLocalFilesMappingPanel;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PortField;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.debugger.wip.BrowserChromeDebugProcess;
import com.jetbrains.debugger.wip.HttpInetSocketAddress;
import com.jetbrains.debugger.wip.JSRemoteDebugConfiguration;
import com.jetbrains.debugger.wip.JSRemoteDebugConfigurationKt;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.debugger.wip.WipWithExclusiveWebsocketChannelVmConnection;
import com.jetbrains.nodeJs.NodeJSFileFinder;
import com.jetbrains.nodeJs.NodeJsDebugProcess;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.DebuggableRunConfiguration;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.v8.StandaloneV8Vm;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.wip.WipVm;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005:\u0001DB\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J*\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020*2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u000205H\u0016J\"\u00106\u001a\u0002072\u0006\u0010/\u001a\u00020*2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u0002J\"\u00108\u001a\u0002092\u0006\u0010/\u001a\u00020*2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u0002J\u0010\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0;H\u0016J\u001a\u0010<\u001a\u0004\u0018\u00010,2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u000205H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0002H\u0016J\u0010\u0010C\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0002H\u0016R*\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0015\"\u0004\b\u0016\u0010\u0017R,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u00020\u001f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001e\u0010$\u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0015\"\u0004\b&\u0010\u0017\u00a8\u0006E"}, d2={"Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lorg/jdom/Element;", "Lcom/intellij/execution/runners/RunConfigurationWithSuppressedDefaultRunAction;", "Lcom/intellij/javascript/JSRunProfileWithCompileBeforeLaunchOption;", "Lorg/jetbrains/debugger/DebuggableRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "value", "host", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "isV8Legacy", "", "()Z", "setV8Legacy", "(Z)V", "<set-?>", "", "Lcom/intellij/javascript/debugger/execution/RemoteUrlMappingBean;", "mappings", "getMappings", "()Ljava/util/List;", "port", "", "getPort", "()I", "setPort", "(I)V", "restartOnDisconnect", "getRestartOnDisconnect", "setRestartOnDisconnect", "clone", "Lcom/intellij/execution/configurations/RunConfiguration;", "computeDebugAddress", "Ljava/net/InetSocketAddress;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "createDebugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "socketAddress", "session", "Lcom/intellij/xdebugger/XDebugSession;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "createV8LegacyDebugProcess", "Lcom/jetbrains/nodeJs/NodeJsDebugProcess;", "createWipDebugProcess", "Lcom/jetbrains/debugger/wip/BrowserChromeDebugProcess;", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "getState", "executor", "Lcom/intellij/execution/Executor;", "env", "readExternal", "", "element", "writeExternal", "WipRemoteDebugConfigurationSettingsEditor", "intellij.javascript.chrome.connector"})
public final class JSRemoteDebugConfiguration
extends LocatableConfigurationBase<Element>
implements RunConfigurationWithSuppressedDefaultRunAction,
JSRunProfileWithCompileBeforeLaunchOption,
DebuggableRunConfiguration {
    @Attribute
    @Nullable
    private String host;
    @Attribute
    private int port;
    @Attribute
    private boolean isV8Legacy;
    @Attribute
    private boolean restartOnDisconnect;
    @Property(surroundWithTag=false)
    @XCollection
    @NotNull
    private List<RemoteUrlMappingBean> mappings;

    @Nullable
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@Nullable String value) {
        this.host = StringUtil.isEmpty((String)value) || Intrinsics.areEqual((Object)value, (Object)"localhost") || Intrinsics.areEqual((Object)value, (Object)"127.0.0.1") ? null : value;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    public final boolean isV8Legacy() {
        return this.isV8Legacy;
    }

    public final void setV8Legacy(boolean bl) {
        this.isV8Legacy = bl;
    }

    public final boolean getRestartOnDisconnect() {
        return this.restartOnDisconnect;
    }

    public final void setRestartOnDisconnect(boolean bl) {
        this.restartOnDisconnect = bl;
    }

    @NotNull
    public final List<RemoteUrlMappingBean> getMappings() {
        return this.mappings;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new WipRemoteDebugConfigurationSettingsEditor();
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        return EmptyRunProfileState.INSTANCE;
    }

    @NotNull
    public RunConfiguration clone() {
        RunConfiguration runConfiguration = super.clone();
        if (runConfiguration == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.debugger.wip.JSRemoteDebugConfiguration");
        }
        JSRemoteDebugConfiguration configuration = (JSRemoteDebugConfiguration)runConfiguration;
        configuration.setHost(this.host);
        configuration.port = this.port;
        configuration.isV8Legacy = this.isV8Legacy;
        configuration.restartOnDisconnect = this.restartOnDisconnect;
        configuration.mappings = (List)new SmartList((Collection)this.mappings);
        return (RunConfiguration)configuration;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)((Object)this), (Element)element);
        if (this.port <= 0) {
            this.port = 9229;
        }
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)((Object)this), (Element)element, (SerializationFilter)((SerializationFilter)JSRemoteDebugConfigurationKt.access$getSERIALIZATION_FILTER$p()));
    }

    @NotNull
    public InetSocketAddress computeDebugAddress(@NotNull RunProfileState state) {
        InetSocketAddress inetSocketAddress;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        String string = this.host;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            inetSocketAddress = new HttpInetSocketAddress(it, this.port);
        } else {
            InetAddress inetAddress = InetAddress.getLoopbackAddress();
            Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"InetAddress.getLoopbackAddress()");
            inetSocketAddress = new HttpInetSocketAddress(inetAddress, this.port);
        }
        return inetSocketAddress;
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        JavaScriptDebugProcess debugProcess;
        Intrinsics.checkParameterIsNotNull((Object)socketAddress, (String)"socketAddress");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        JavaScriptDebugProcess javaScriptDebugProcess = debugProcess = this.isV8Legacy ? (JavaScriptDebugProcess)this.createV8LegacyDebugProcess(socketAddress, session, executionResult) : (JavaScriptDebugProcess)this.createWipDebugProcess(socketAddress, session, executionResult);
        if (this.restartOnDisconnect) {
            debugProcess.getConnection().stateChanged((Function1)new Function1<ConnectionState, Unit>(session){
                final /* synthetic */ XDebugSession $session;

                public final void invoke(@NotNull ConnectionState it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (it.getStatus() == ConnectionStatus.DISCONNECTED) {
                        XDebugProcess xDebugProcess = this.$session.getDebugProcess();
                        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugProcess, (String)"session.debugProcess");
                        if (Intrinsics.areEqual((Object)((Boolean)xDebugProcess.getProcessHandler().getUserData(ProcessHandler.TERMINATION_REQUESTED)), (Object)true) ^ true) {
                            ExecutionUtil.restart((RunContentDescriptor)this.$session.getRunContentDescriptor());
                        }
                    }
                }
                {
                    this.$session = xDebugSession;
                    super(1);
                }
            });
        }
        return (XDebugProcess)debugProcess;
    }

    private final BrowserChromeDebugProcess createWipDebugProcess(InetSocketAddress socketAddress, XDebugSession session, ExecutionResult executionResult) {
        WipWithExclusiveWebsocketChannelVmConnection connection2 = new WipWithExclusiveWebsocketChannelVmConnection();
        RemoteDebuggingFileFinder finder = new RemoteDebuggingFileFinder(RemoteDebuggingFileFinderKt.createUrlToLocalMap(this.mappings), (JSFileFinderBase)new LocalFileSystemFileFinder(true));
        BrowserChromeDebugProcess process2 = new BrowserChromeDebugProcess(session, (DebuggableFileFinder)finder, (VmConnection<? extends WipVm>)((VmConnection)connection2), executionResult);
        RemoteVmConnection.open$default((RemoteVmConnection)connection2, (InetSocketAddress)socketAddress, null, (int)2, null);
        return process2;
    }

    private final NodeJsDebugProcess createV8LegacyDebugProcess(InetSocketAddress socketAddress, XDebugSession session, ExecutionResult executionResult) {
        RemoteVmConnection<Vm> connection2 = new RemoteVmConnection<Vm>(session){
            final /* synthetic */ XDebugSession $session;

            @NotNull
            public Bootstrap createBootstrap(@NotNull InetSocketAddress address, @NotNull AsyncPromise<Vm> vmResult) {
                Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
                Intrinsics.checkParameterIsNotNull(vmResult, (String)"vmResult");
                Bootstrap bootstrap = BuiltInServerManager.Companion.getInstance().createClientBootstrap();
                EventDispatcher dispatcher = this.getDispatcher();
                bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(this, dispatcher, vmResult, address){
                    final /* synthetic */ createV8LegacyDebugProcess.connection.1 this$0;
                    final /* synthetic */ EventDispatcher $dispatcher;
                    final /* synthetic */ AsyncPromise $vmResult;
                    final /* synthetic */ InetSocketAddress $address;

                    protected void initChannel(@NotNull Channel ch) {
                        Intrinsics.checkParameterIsNotNull((Object)ch, (String)"ch");
                        ScheduledFuture<?> connectToWip2 = AppExecutorUtil.getAppScheduledExecutorService().schedule(new Runnable(this){
                            final /* synthetic */ createV8LegacyDebugProcess.connection.createBootstrap.1 this$0;

                            public final void run() {
                                WipRemoteVmConnection wipConnection2 = new WipRemoteVmConnection(this){
                                    final /* synthetic */ createV8LegacyDebugProcess.connection.createBootstrap.initChannel.connectToWip.1 this$0;

                                    @NotNull
                                    public EventDispatcher<DebugEventListener> getDispatcher() {
                                        return this.this$0.this$0.$dispatcher;
                                    }
                                    {
                                        this.this$0 = $outer;
                                        super(null, null, 3, null);
                                    }
                                };
                                AsyncPromise wipResult = new AsyncPromise();
                                wipResult.then((Function)new Function<T, SUB_RESULT>(this){
                                    final /* synthetic */ createV8LegacyDebugProcess.connection.createBootstrap.initChannel.connectToWip.1 this$0;

                                    public final WipVm fun(WipVm vm) {
                                        String message = JSDebuggerBundle.message((String)"js.remote.debug.inspector.protocol.detected", (Object[])new Object[]{JSDebuggerBundle.message((String)"js.remote.debug.inspector.protocol", (Object[])new Object[0])});
                                        this.this$0.this$0.this$0.$session.reportMessage(message, MessageType.INFO);
                                        this.this$0.this$0.$vmResult.setResult((Object)((Object)vm));
                                        return vm;
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                });
                                Bootstrap wipBootstrap = wipConnection2.createBootstrap(this.this$0.$address, (AsyncPromise<WipVm>)wipResult);
                                NettyKt.connectRetrying$default((Bootstrap)wipBootstrap, (InetSocketAddress)this.this$0.$address, (int)2, null, (int)4, null);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }, 3L, TimeUnit.SECONDS);
                        AsyncPromise v8Attempt = new AsyncPromise();
                        v8Attempt.then((Function)new Function<T, SUB_RESULT>(this){
                            final /* synthetic */ createV8LegacyDebugProcess.connection.createBootstrap.1 this$0;

                            public final Vm fun(Vm vm) {
                                this.this$0.$vmResult.setResult((Object)vm);
                                return vm;
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }).onError((Consumer)new Consumer<Throwable>(this){
                            final /* synthetic */ createV8LegacyDebugProcess.connection.createBootstrap.1 this$0;

                            public final void accept(Throwable e) {
                                AsyncPromise asyncPromise = this.this$0.$vmResult;
                                Throwable throwable = e;
                                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"e");
                                asyncPromise.setError(throwable);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }).onProcessed((Consumer)new Consumer<Vm>(connectToWip2){
                            final /* synthetic */ ScheduledFuture $connectToWip;

                            public final void accept(Vm it) {
                                this.$connectToWip.cancel(true);
                            }
                            {
                                this.$connectToWip = scheduledFuture;
                            }
                        });
                        new StandaloneV8Vm(ch, createV8LegacyDebugProcess.connection.1.access$getDebugEventListener$p(this.this$0), (AsyncPromise<? super V8Vm>)v8Attempt, "");
                    }
                    {
                        this.this$0 = $outer;
                        this.$dispatcher = $captured_local_variable$1;
                        this.$vmResult = $captured_local_variable$2;
                        this.$address = $captured_local_variable$3;
                    }
                });
                return bootstrap;
            }
            {
                this.$session = $captured_local_variable$0;
            }

            public static final /* synthetic */ DebugEventListener access$getDebugEventListener$p(createV8LegacyDebugProcess.connection.1 $this) {
                return $this.getDebugEventListener();
            }
        };
        BiMap biMap = RemoteDebuggingFileFinderKt.createUrlToLocalMap(this.mappings);
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        RemoteDebuggingFileFinder finder = new RemoteDebuggingFileFinder(biMap, (JSFileFinderBase)new NodeJSFileFinder(project));
        NodeJsDebugProcess process2 = new NodeJsDebugProcess(session, (VmConnection<Vm>)((VmConnection)connection2), (DebuggableFileFinder)finder, false, executionResult);
        RemoteVmConnection.open$default((RemoteVmConnection)connection2, (InetSocketAddress)socketAddress, null, (int)2, null);
        return process2;
    }

    public JSRemoteDebugConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(project, factory, name);
        this.port = 9229;
        this.mappings = (List)new SmartList();
    }

    public static final /* synthetic */ List access$getMappings$p(JSRemoteDebugConfiguration $this) {
        return $this.mappings;
    }

    public static final /* synthetic */ void access$setMappings$p(JSRemoteDebugConfiguration $this, List list) {
        $this.mappings = list;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration$WipRemoteDebugConfigurationSettingsEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration;", "(Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration;)V", "filesMappingPanel", "Lcom/intellij/javascript/debugger/execution/JSLocalFilesMappingPanel;", "hostField", "Ljavax/swing/JTextField;", "kotlin.jvm.PlatformType", "portField", "Lcom/intellij/ui/PortField;", "restartOnDisconnectCheckbox", "Lcom/intellij/ui/components/JBCheckBox;", "v8RadioButton", "Lcom/intellij/ui/components/JBRadioButton;", "wipRadioButton", "applyEditorTo", "", "configuration", "createEditor", "Ljavax/swing/JComponent;", "resetEditorFrom", "intellij.javascript.chrome.connector"})
    private final class WipRemoteDebugConfigurationSettingsEditor
    extends SettingsEditor<JSRemoteDebugConfiguration> {
        private final JTextField hostField = GuiUtils.createUndoableTextField();
        private final PortField portField = new PortField(9229, 1024);
        private final JBRadioButton wipRadioButton = new JBRadioButton(JSDebuggerBundle.message((String)"js.remote.debug.inspector.protocol", (Object[])new Object[0]));
        private final JBRadioButton v8RadioButton = new JBRadioButton(JSDebuggerBundle.message((String)"js.remote.debug.node.protocol", (Object[])new Object[0]));
        private final JBCheckBox restartOnDisconnectCheckbox;
        private final JSLocalFilesMappingPanel filesMappingPanel;

        protected void resetEditorFrom(@NotNull JSRemoteDebugConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)configuration), (String)"configuration");
            JTextField jTextField = this.hostField;
            Intrinsics.checkExpressionValueIsNotNull((Object)jTextField, (String)"hostField");
            jTextField.setText(StringUtil.notNullize((String)configuration.getHost(), (String)"localhost"));
            this.portField.setNumber(configuration.getPort());
            this.wipRadioButton.setSelected(!configuration.isV8Legacy());
            this.v8RadioButton.setSelected(configuration.isV8Legacy());
            this.restartOnDisconnectCheckbox.setSelected(configuration.getRestartOnDisconnect());
            this.filesMappingPanel.resetEditorFrom(configuration.getMappings(), true);
        }

        protected void applyEditorTo(@NotNull JSRemoteDebugConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)configuration), (String)"configuration");
            JTextField jTextField = this.hostField;
            Intrinsics.checkExpressionValueIsNotNull((Object)jTextField, (String)"hostField");
            configuration.setHost(jTextField.getText());
            configuration.setPort(this.portField.getNumber());
            configuration.setV8Legacy(this.v8RadioButton.isSelected());
            configuration.setRestartOnDisconnect(this.restartOnDisconnectCheckbox.isSelected());
            this.filesMappingPanel.applyEditorTo(JSRemoteDebugConfiguration.this.getMappings(), (RunConfiguration)configuration);
        }

        @NotNull
        protected JComponent createEditor() {
            JPanel protocolPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
            protocolPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JSDebuggerBundle.message((String)"js.remote.debug.attach.to", (Object[])new Object[0])));
            protocolPanel.add((Component)this.wipRadioButton);
            protocolPanel.add((Component)this.v8RadioButton);
            this.filesMappingPanel.initUI();
            HideableTitledPanel mappingsPanel = new HideableTitledPanel(JSDebuggerBundle.message((String)"label.text.remote.urls.of.local.files", (Object[])new Object[0]), (JComponent)this.filesMappingPanel, true);
            FormBuilder formBuilder2 = FormBuilder.createFormBuilder().addLabeledComponent(JSDebuggerBundle.message((String)"js.remote.debug.host", (Object[])new Object[0]), (JComponent)this.hostField).addLabeledComponent(JSDebuggerBundle.message((String)"js.remote.debug.port", (Object[])new Object[0]), (JComponent)this.portField).addComponent((JComponent)protocolPanel, 7).addComponent((JComponent)this.restartOnDisconnectCheckbox).addComponentFillVertically((JComponent)mappingsPanel, 10);
            Intrinsics.checkExpressionValueIsNotNull((Object)formBuilder2, (String)"FormBuilder.createFormBu\u2026tLayout.DEFAULT_VGAP * 2)");
            JPanel jPanel = formBuilder2.getPanel();
            Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"FormBuilder.createFormBu\u2026_VGAP * 2)\n        .panel");
            return jPanel;
        }

        public WipRemoteDebugConfigurationSettingsEditor() {
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this.wipRadioButton);
            buttonGroup.add((AbstractButton)this.v8RadioButton);
            this.restartOnDisconnectCheckbox = new JBCheckBox(JSDebuggerBundle.message((String)"js.remote.debug.restart.on.disconnect", (Object[])new Object[0]));
            Project project = JSRemoteDebugConfiguration.this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            this.filesMappingPanel = new JSLocalFilesMappingPanel(project, new BorderLayout()){

                public void initUI() {
                    this.add(this.getMappingTreePanel());
                    super.initUI();
                }
            };
        }
    }
}

