/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.CommittedChangeListForRevision;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUtil {
    public static final int MAX_SELECTED_COMMITS = 1000;
    public static final int FULL_HASH_LENGTH = 40;
    public static final int SHORT_HASH_LENGTH = 8;
    public static final Pattern HASH_REGEX = Pattern.compile("[a-fA-F0-9]{7,40}");
    public static final String HEAD = "HEAD";

    @NotNull
    public static Map<VirtualFile, Set<VcsRef>> groupRefsByRoot(@NotNull Collection<? extends VcsRef> refs) {
        if (refs == null) {
            VcsLogUtil.$$$reportNull$$$0(0);
        }
        Map<VirtualFile, Set<VcsRef>> map2 = VcsLogUtil.groupByRoot(refs, VcsRef::getRoot);
        if (map2 == null) {
            VcsLogUtil.$$$reportNull$$$0(1);
        }
        return map2;
    }

    @NotNull
    private static <T> Map<VirtualFile, Set<T>> groupByRoot(@NotNull Collection<? extends T> items, @NotNull Function<? super T, ? extends VirtualFile> rootGetter) {
        if (items == null) {
            VcsLogUtil.$$$reportNull$$$0(2);
        }
        if (rootGetter == null) {
            VcsLogUtil.$$$reportNull$$$0(3);
        }
        TreeMap<VirtualFile, Set<T>> map2 = new TreeMap<VirtualFile, Set<T>>(Comparator.comparing(VirtualFile::getPresentableUrl));
        for (T item : items) {
            VirtualFile root = (VirtualFile)rootGetter.fun(item);
            map2.computeIfAbsent(root, k -> new HashSet()).add(item);
        }
        TreeMap<VirtualFile, Set<T>> treeMap = map2;
        if (treeMap == null) {
            VcsLogUtil.$$$reportNull$$$0(4);
        }
        return treeMap;
    }

    public static int compareRoots(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
        if (root1 == null) {
            VcsLogUtil.$$$reportNull$$$0(5);
        }
        if (root2 == null) {
            VcsLogUtil.$$$reportNull$$$0(6);
        }
        return root1.getPresentableUrl().compareTo(root2.getPresentableUrl());
    }

    @NotNull
    private static Set<VirtualFile> collectRoots(@NotNull Collection<? extends FilePath> files2, @NotNull Set<? extends VirtualFile> roots) {
        if (files2 == null) {
            VcsLogUtil.$$$reportNull$$$0(7);
        }
        if (roots == null) {
            VcsLogUtil.$$$reportNull$$$0(8);
        }
        HashSet<VirtualFile> selectedRoots = new HashSet<VirtualFile>();
        List sortedRoots = ContainerUtil.sorted(roots, Comparator.comparing(VirtualFile::getPath));
        for (FilePath filePath : files2) {
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile != null && roots.contains(virtualFile)) {
                selectedRoots.add(virtualFile);
            } else {
                VirtualFile candidateAncestorRoot = null;
                for (VirtualFile root : sortedRoots) {
                    if (!FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false)) continue;
                    candidateAncestorRoot = root;
                }
                if (candidateAncestorRoot != null) {
                    selectedRoots.add(candidateAncestorRoot);
                }
            }
            if (virtualFile == null) continue;
            for (VirtualFile virtualFile2 : roots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (boolean)false)) continue;
                selectedRoots.add(virtualFile2);
            }
        }
        HashSet<VirtualFile> hashSet = selectedRoots;
        if (hashSet == null) {
            VcsLogUtil.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    @NotNull
    public static Set<VirtualFile> getVisibleRoots(@NotNull VcsLogUi logUi) {
        if (logUi == null) {
            VcsLogUtil.$$$reportNull$$$0(10);
        }
        VcsLogFilterCollection filters = logUi.getFilterUi().getFilters();
        Set<VirtualFile> roots = logUi.getDataPack().getLogProviders().keySet();
        Set<VirtualFile> set = VcsLogUtil.getAllVisibleRoots(roots, filters);
        if (set == null) {
            VcsLogUtil.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getAllVisibleRoots(@NotNull Collection<VirtualFile> roots, @NotNull VcsLogFilterCollection filters) {
        if (roots == null) {
            VcsLogUtil.$$$reportNull$$$0(12);
        }
        if (filters == null) {
            VcsLogUtil.$$$reportNull$$$0(13);
        }
        Set<VirtualFile> set = VcsLogUtil.getAllVisibleRoots(roots, (VcsLogRootFilter)filters.get(VcsLogFilterCollection.ROOT_FILTER), (VcsLogStructureFilter)filters.get(VcsLogFilterCollection.STRUCTURE_FILTER));
        if (set == null) {
            VcsLogUtil.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getAllVisibleRoots(@NotNull Collection<VirtualFile> roots, @Nullable VcsLogRootFilter rootFilter, @Nullable VcsLogStructureFilter structureFilter) {
        if (roots == null) {
            VcsLogUtil.$$$reportNull$$$0(15);
        }
        if (rootFilter == null && structureFilter == null) {
            HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>(roots);
            if (hashSet == null) {
                VcsLogUtil.$$$reportNull$$$0(16);
            }
            return hashSet;
        }
        Set<VirtualFile> fromRootFilter = rootFilter != null ? rootFilter.getRoots() : roots;
        Set<VirtualFile> fromStructureFilter = structureFilter != null ? VcsLogUtil.collectRoots(structureFilter.getFiles(), new HashSet(roots)) : roots;
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>(ContainerUtil.intersection((Collection)fromRootFilter, (Collection)fromStructureFilter));
        if (hashSet == null) {
            VcsLogUtil.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    @NotNull
    public static Set<FilePath> getFilteredFilesForRoot(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection) {
        VcsLogStructureFilter structureFilter;
        if (root == null) {
            VcsLogUtil.$$$reportNull$$$0(18);
        }
        if (filterCollection == null) {
            VcsLogUtil.$$$reportNull$$$0(19);
        }
        if ((structureFilter = (VcsLogStructureFilter)filterCollection.get(VcsLogFilterCollection.STRUCTURE_FILTER)) == null) {
            Set<FilePath> set = Collections.emptySet();
            if (set == null) {
                VcsLogUtil.$$$reportNull$$$0(20);
            }
            return set;
        }
        Collection files2 = structureFilter.getFiles();
        HashSet<FilePath> hashSet = new HashSet<FilePath>(ContainerUtil.filter((Collection)files2, filePath -> {
            VirtualFile virtualFile = filePath.getVirtualFile();
            return root.equals(virtualFile) || FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false);
        }));
        if (hashSet == null) {
            VcsLogUtil.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    @Nullable
    public static String getSingleFilteredBranch(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogRefs refs) {
        VcsLogBranchFilter filter;
        if (filters == null) {
            VcsLogUtil.$$$reportNull$$$0(22);
        }
        if (refs == null) {
            VcsLogUtil.$$$reportNull$$$0(23);
        }
        if ((filter = (VcsLogBranchFilter)filters.get(VcsLogFilterCollection.BRANCH_FILTER)) == null) {
            return null;
        }
        String branchName = null;
        HashSet<VirtualFile> checkedRoots = new HashSet<VirtualFile>();
        for (VcsRef branch : refs.getBranches()) {
            if (!filter.matches(branch.getName())) continue;
            if (branchName == null) {
                branchName = branch.getName();
            } else if (!branch.getName().equals(branchName)) {
                return null;
            }
            if (checkedRoots.contains(branch.getRoot())) {
                return null;
            }
            checkedRoots.add(branch.getRoot());
        }
        return branchName;
    }

    public static boolean maybeRegexp(@NotNull String text) {
        if (text == null) {
            VcsLogUtil.$$$reportNull$$$0(24);
        }
        return StringUtil.containsAnyChar((String)text, (String)"()[]{}.*?+^$\\|");
    }

    @NotNull
    public static TextRevisionNumber convertToRevisionNumber(@NotNull Hash hash) {
        if (hash == null) {
            VcsLogUtil.$$$reportNull$$$0(25);
        }
        TextRevisionNumber textRevisionNumber = new TextRevisionNumber(hash.asString(), hash.toShortString());
        if (textRevisionNumber == null) {
            VcsLogUtil.$$$reportNull$$$0(26);
        }
        return textRevisionNumber;
    }

    @NotNull
    public static VcsFullCommitDetails getDetails(@NotNull VcsLogData data, @NotNull VirtualFile root, @NotNull Hash hash) throws VcsException {
        if (data == null) {
            VcsLogUtil.$$$reportNull$$$0(27);
        }
        if (root == null) {
            VcsLogUtil.$$$reportNull$$$0(28);
        }
        if (hash == null) {
            VcsLogUtil.$$$reportNull$$$0(29);
        }
        VcsFullCommitDetails vcsFullCommitDetails = (VcsFullCommitDetails)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(VcsLogUtil.getDetails(data.getLogProvider(root), root, Collections.singletonList(hash.asString()))));
        if (vcsFullCommitDetails == null) {
            VcsLogUtil.$$$reportNull$$$0(30);
        }
        return vcsFullCommitDetails;
    }

    @NotNull
    public static List<? extends VcsFullCommitDetails> getDetails(@NotNull VcsLogProvider logProvider, @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (logProvider == null) {
            VcsLogUtil.$$$reportNull$$$0(31);
        }
        if (root == null) {
            VcsLogUtil.$$$reportNull$$$0(32);
        }
        if (hashes == null) {
            VcsLogUtil.$$$reportNull$$$0(33);
        }
        ArrayList result2 = new ArrayList();
        logProvider.readFullDetails(root, hashes, result2::add);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            VcsLogUtil.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    public static CommittedChangeListForRevision createCommittedChangeList(@NotNull VcsFullCommitDetails detail) {
        if (detail == null) {
            VcsLogUtil.$$$reportNull$$$0(35);
        }
        CommittedChangeListForRevision committedChangeListForRevision = new CommittedChangeListForRevision(detail.getSubject(), detail.getFullMessage(), VcsUserUtil.getShortPresentation(detail.getCommitter()), new Date(detail.getCommitTime()), detail.getChanges(), (VcsRevisionNumber)VcsLogUtil.convertToRevisionNumber((Hash)detail.getId()));
        if (committedChangeListForRevision == null) {
            VcsLogUtil.$$$reportNull$$$0(36);
        }
        return committedChangeListForRevision;
    }

    public static void registerWithParentAndProject(@NotNull Disposable parent, @NotNull Project project, @NotNull Disposable disposable) {
        if (parent == null) {
            VcsLogUtil.$$$reportNull$$$0(37);
        }
        if (project == null) {
            VcsLogUtil.$$$reportNull$$$0(38);
        }
        if (disposable == null) {
            VcsLogUtil.$$$reportNull$$$0(39);
        }
        Disposer.register((Disposable)parent, () -> Disposer.dispose((Disposable)disposable));
        Disposer.register((Disposable)project, (Disposable)disposable);
    }

    @NotNull
    public static String getShortHash(@NotNull String hashString) {
        if (hashString == null) {
            VcsLogUtil.$$$reportNull$$$0(40);
        }
        String string = VcsLogUtil.getShortHash(hashString, 8);
        if (string == null) {
            VcsLogUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    public static String getShortHash(@NotNull String hashString, int shortHashLength) {
        if (hashString == null) {
            VcsLogUtil.$$$reportNull$$$0(42);
        }
        String string = hashString.substring(0, Math.min(shortHashLength, hashString.length()));
        if (string == null) {
            VcsLogUtil.$$$reportNull$$$0(43);
        }
        return string;
    }

    @Nullable
    public static VcsRef findBranch(@NotNull RefsModel refs, @NotNull VirtualFile root, @NotNull String branchName) {
        if (refs == null) {
            VcsLogUtil.$$$reportNull$$$0(44);
        }
        if (root == null) {
            VcsLogUtil.$$$reportNull$$$0(45);
        }
        if (branchName == null) {
            VcsLogUtil.$$$reportNull$$$0(46);
        }
        Stream<VcsRef> branches = refs.getAllRefsByRoot().get(root).streamBranches();
        return branches.filter(vcsRef -> vcsRef.getName().equals(branchName)).findFirst().orElse(null);
    }

    @NotNull
    public static List<Change> collectChanges(@NotNull List<? extends VcsFullCommitDetails> detailsList, @NotNull Function<? super VcsFullCommitDetails, ? extends Collection<Change>> getChanges) {
        if (detailsList == null) {
            VcsLogUtil.$$$reportNull$$$0(47);
        }
        if (getChanges == null) {
            VcsLogUtil.$$$reportNull$$$0(48);
        }
        ArrayList changes2 = new ArrayList();
        List detailsListReversed = ContainerUtil.reverse(detailsList);
        for (VcsFullCommitDetails details : detailsListReversed) {
            changes2.addAll((Collection)getChanges.fun((Object)details));
        }
        List<Change> list = CommittedChangesTreeBrowser.zipChanges(changes2);
        if (list == null) {
            VcsLogUtil.$$$reportNull$$$0(49);
        }
        return list;
    }

    @Nullable
    public static VirtualFile getActualRoot(@NotNull Project project, @NotNull FilePath path) {
        VcsRoot rootObject;
        if (project == null) {
            VcsLogUtil.$$$reportNull$$$0(50);
        }
        if (path == null) {
            VcsLogUtil.$$$reportNull$$$0(51);
        }
        if ((rootObject = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootObjectFor(path)) == null) {
            return null;
        }
        Map<VirtualFile, VcsLogProvider> providers = VcsLogManager.findLogProviders(Collections.singletonList(rootObject), project);
        if (providers.isEmpty()) {
            return null;
        }
        VcsLogProvider provider = (VcsLogProvider)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(providers.values()));
        return provider.getVcsRoot(project, rootObject.getPath(), path);
    }

    @Nullable
    public static Collection<FilePath> getAffectedPaths(@NotNull VcsLogUi logUi) {
        if (logUi == null) {
            VcsLogUtil.$$$reportNull$$$0(52);
        }
        return VcsLogUtil.getAffectedPaths(logUi.getDataPack());
    }

    @Nullable
    public static Collection<FilePath> getAffectedPaths(@NotNull VcsLogDataPack dataPack) {
        VcsLogStructureFilter structureFilter;
        if (dataPack == null) {
            VcsLogUtil.$$$reportNull$$$0(53);
        }
        if ((structureFilter = (VcsLogStructureFilter)dataPack.getFilters().get(VcsLogFilterCollection.STRUCTURE_FILTER)) != null) {
            return structureFilter.getFiles();
        }
        return null;
    }

    @Nullable
    public static Collection<FilePath> getAffectedPaths(@NotNull VirtualFile root, @NotNull AnActionEvent e) {
        if (root == null) {
            VcsLogUtil.$$$reportNull$$$0(54);
        }
        if (e == null) {
            VcsLogUtil.$$$reportNull$$$0(55);
        }
        if (!VcsLogUtil.isFolderHistoryShownInLog()) {
            return null;
        }
        VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        if (properties != null && properties.exists(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES) && properties.get(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES).booleanValue()) {
            Collection<FilePath> affectedFilePaths;
            VcsLogUi logUi = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
            Project project = e.getProject();
            if (logUi != null && project != null && (affectedFilePaths = VcsLogUtil.getAffectedPaths(logUi)) != null) {
                return ContainerUtil.filter(affectedFilePaths, path -> Objects.equals(VcsUtil.getVcsRootFor((Project)project, (FilePath)path), root));
            }
        }
        return null;
    }

    public static boolean isFolderHistoryShownInLog() {
        return Registry.is((String)"vcs.folder.history.in.log");
    }

    public static int getMaxSize(@NotNull List<? extends VcsFullCommitDetails> detailsList) {
        if (detailsList == null) {
            VcsLogUtil.$$$reportNull$$$0(56);
        }
        int maxSize = 0;
        for (VcsFullCommitDetails vcsFullCommitDetails : detailsList) {
            maxSize = Math.max(VcsLogUtil.getSize(vcsFullCommitDetails), maxSize);
        }
        return maxSize;
    }

    public static int getSize(@NotNull VcsFullCommitDetails details) {
        if (details == null) {
            VcsLogUtil.$$$reportNull$$$0(57);
        }
        if (details instanceof VcsChangesLazilyParsedDetails) {
            return ((VcsChangesLazilyParsedDetails)details).size();
        }
        int size = 0;
        for (int i = 0; i < details.getParents().size(); ++i) {
            size += details.getChanges(i).size();
        }
        return size;
    }

    public static int getShownChangesLimit() {
        return Registry.intValue((String)"vcs.log.max.changes.shown");
    }

    @NotNull
    public static String getSizeText(int maxSize) {
        if (maxSize < 1000) {
            String string = String.valueOf(maxSize);
            if (string == null) {
                VcsLogUtil.$$$reportNull$$$0(58);
            }
            return string;
        }
        DecimalFormat format = new DecimalFormat("#.#");
        format.setRoundingMode(RoundingMode.FLOOR);
        if (maxSize < 10000) {
            String string = format.format((double)maxSize / 1000.0) + "K";
            if (string == null) {
                VcsLogUtil.$$$reportNull$$$0(59);
            }
            return string;
        }
        if (maxSize < 1000000) {
            String string = maxSize / 1000 + "K";
            if (string == null) {
                VcsLogUtil.$$$reportNull$$$0(60);
            }
            return string;
        }
        if (maxSize < 10000000) {
            String string = format.format((double)maxSize / 1000000.0) + "M";
            if (string == null) {
                VcsLogUtil.$$$reportNull$$$0(61);
            }
            return string;
        }
        String string = maxSize / 1000000 + "M";
        if (string == null) {
            VcsLogUtil.$$$reportNull$$$0(62);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 26: 
            case 30: 
            case 34: 
            case 36: 
            case 41: 
            case 43: 
            case 49: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 26: 
            case 30: 
            case 34: 
            case 36: 
            case 41: 
            case 43: 
            case 49: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 26: 
            case 30: 
            case 34: 
            case 36: 
            case 41: 
            case 43: 
            case 49: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/util/VcsLogUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGetter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 10: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 18: 
            case 28: 
            case 32: 
            case 45: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterCollection";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProvider";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detail";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 38: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashString";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 47: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsList";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getChanges";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/util/VcsLogUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "groupRefsByRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByRoot";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleRoots";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVisibleRoots";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredFilesForRoot";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRevisionNumber";
                break;
            }
            case 30: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetails";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommittedChangeList";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortHash";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChanges";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getSizeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "groupRefsByRoot";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 26: 
            case 30: 
            case 34: 
            case 36: 
            case 41: 
            case 43: 
            case 49: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "groupByRoot";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compareRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectRoots";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleRoots";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAllVisibleRoots";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredFilesForRoot";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSingleFilteredBranch";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "maybeRegexp";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "convertToRevisionNumber";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDetails";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createCommittedChangeList";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "registerWithParentAndProject";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getShortHash";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findBranch";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "collectChanges";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getActualRoot";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedPaths";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getMaxSize";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 26: 
            case 30: 
            case 34: 
            case 36: 
            case 41: 
            case 43: 
            case 49: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

