/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import org.jetbrains.annotations.NotNull;

public class ColorGetterByLayoutIndex<CommitId> {
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private final PermanentGraphInfo<CommitId> myPermanentGraphInfo;
    @NotNull
    private final GraphColorManager<CommitId> myColorManager;

    public ColorGetterByLayoutIndex(@NotNull LinearGraph linearGraph, @NotNull PermanentGraphInfo<CommitId> permanentGraphInfo, @NotNull GraphColorManager<CommitId> colorManager) {
        if (linearGraph == null) {
            ColorGetterByLayoutIndex.$$$reportNull$$$0(0);
        }
        if (permanentGraphInfo == null) {
            ColorGetterByLayoutIndex.$$$reportNull$$$0(1);
        }
        if (colorManager == null) {
            ColorGetterByLayoutIndex.$$$reportNull$$$0(2);
        }
        this.myLinearGraph = linearGraph;
        this.myPermanentGraphInfo = permanentGraphInfo;
        this.myColorManager = colorManager;
    }

    public int getColorId(@NotNull GraphElement element) {
        int downLayoutIndex;
        if (element == null) {
            ColorGetterByLayoutIndex.$$$reportNull$$$0(3);
        }
        if (element instanceof GraphNode) {
            int nodeIndex = ((GraphNode)element).getNodeIndex();
            return this.getNodeColor(nodeIndex, this.getLayoutIndex(nodeIndex));
        }
        GraphEdge edge = (GraphEdge)element;
        NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(edge);
        if (normalEdge == null) {
            int nodeIndex = LinearGraphUtils.getNotNullNodeIndex(edge);
            return this.getNodeColor(nodeIndex, this.getLayoutIndex(nodeIndex));
        }
        int upLayoutIndex = this.getLayoutIndex(normalEdge.up);
        if (upLayoutIndex >= (downLayoutIndex = this.getLayoutIndex(normalEdge.down))) {
            return this.getNodeColor(normalEdge.up, upLayoutIndex);
        }
        return this.getNodeColor(normalEdge.down, downLayoutIndex);
    }

    protected int getNodeColor(int nodeIndex, int layoutIndex) {
        int headNodeId = this.getHeadNodeId(nodeIndex);
        CommitId headCommitId = this.myPermanentGraphInfo.getPermanentCommitsInfo().getCommitId(headNodeId);
        if (layoutIndex == this.myPermanentGraphInfo.getPermanentGraphLayout().getLayoutIndex(headNodeId)) {
            return this.myColorManager.getColorOfBranch(headCommitId);
        }
        return this.myColorManager.getColorOfFragment(headCommitId, layoutIndex);
    }

    private int getHeadNodeId(int upNodeIndex) {
        int nodeId = this.getNodeId(upNodeIndex);
        if (nodeId < 0) {
            return 0;
        }
        return this.myPermanentGraphInfo.getPermanentGraphLayout().getOneOfHeadNodeIndex(nodeId);
    }

    private int getLayoutIndex(int upNodeIndex) {
        int nodeId = this.getNodeId(upNodeIndex);
        if (nodeId < 0) {
            return nodeId;
        }
        return this.myPermanentGraphInfo.getPermanentGraphLayout().getLayoutIndex(nodeId);
    }

    private int getNodeId(int upNodeIndex) {
        return this.myLinearGraph.getNodeId(upNodeIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraphInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/graph/impl/print/ColorGetterByLayoutIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getColorId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

