/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.FileHistoryPanelImpl;
import com.intellij.openapi.vcs.history.StandardDiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import org.jetbrains.annotations.NotNull;

public class CompareRevisionsAction
implements AnActionExtensionProvider {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DiffFromHistoryHandler diffHandler;
        if (e == null) {
            CompareRevisionsAction.$$$reportNull$$$0(0);
        }
        VcsFileRevision[] revisions = (VcsFileRevision[])e.getRequiredData(VcsDataKeys.VCS_FILE_REVISIONS);
        FilePath filePath = (FilePath)e.getRequiredData(VcsDataKeys.FILE_PATH);
        VcsHistoryProvider provider = (VcsHistoryProvider)e.getRequiredData(VcsDataKeys.HISTORY_PROVIDER);
        DiffFromHistoryHandler customDiffHandler = provider.getHistoryDiffHandler();
        DiffFromHistoryHandler diffFromHistoryHandler = diffHandler = customDiffHandler == null ? new StandardDiffFromHistoryHandler() : customDiffHandler;
        if (revisions.length == 2) {
            diffHandler.showDiffForTwo((Project)e.getRequiredData(CommonDataKeys.PROJECT), filePath, revisions[1], revisions[0]);
        } else if (revisions.length == 1) {
            VcsFileRevision previousRevision = (VcsFileRevision)e.getRequiredData(FileHistoryPanelImpl.PREVIOUS_REVISION_FOR_DIFF);
            if (revisions[0] != null) {
                diffHandler.showDiffForOne(e, (Project)e.getRequiredData(CommonDataKeys.PROJECT), filePath, previousRevision, revisions[0]);
            }
        }
    }

    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareRevisionsAction.$$$reportNull$$$0(1);
        }
        return e.getData(VcsDataKeys.HISTORY_SESSION) != null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareRevisionsAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setText(VcsBundle.message((String)"action.name.compare", (Object[])new Object[0]));
        e.getPresentation().setDescription(VcsBundle.message((String)"action.description.compare", (Object[])new Object[0]));
        VcsFileRevision[] revisions = (VcsFileRevision[])e.getData(VcsDataKeys.VCS_FILE_REVISIONS);
        VcsHistorySession historySession = (VcsHistorySession)e.getData(VcsDataKeys.HISTORY_SESSION);
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        VcsHistoryProvider provider = (VcsHistoryProvider)e.getData(VcsDataKeys.HISTORY_PROVIDER);
        boolean isEnabled = revisions == null || historySession == null || filePath == null || provider == null ? false : (revisions.length == 1 ? historySession.isContentAvailable(revisions[0]) && e.getData(FileHistoryPanelImpl.PREVIOUS_REVISION_FOR_DIFF) != null : (revisions.length == 2 ? historySession.isContentAvailable(revisions[0]) && historySession.isContentAvailable(revisions[revisions.length - 1]) : false));
        e.getPresentation().setEnabled(isEnabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/vcs/history/actions/CompareRevisionsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isActive";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

