/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChangeListManagerSerialization {
    @NonNls
    private static final String ATT_ID = "id";
    @NonNls
    private static final String ATT_NAME = "name";
    @NonNls
    private static final String ATT_COMMENT = "comment";
    @NonNls
    private static final String ATT_DEFAULT = "default";
    @NonNls
    private static final String ATT_VALUE_TRUE = "true";
    @NonNls
    private static final String ATT_CHANGE_BEFORE_PATH = "beforePath";
    @NonNls
    private static final String ATT_CHANGE_AFTER_PATH = "afterPath";
    @NonNls
    private static final String ATT_CHANGE_BEFORE_PATH_ESCAPED = "beforePathEscaped";
    @NonNls
    private static final String ATT_CHANGE_AFTER_PATH_ESCAPED = "afterPathEscaped";
    @NonNls
    private static final String ATT_CHANGE_BEFORE_PATH_IS_DIR = "beforeDir";
    @NonNls
    private static final String ATT_CHANGE_AFTER_PATH_IS_DIR = "afterDir";
    @NonNls
    private static final String NODE_LIST = "list";
    @NonNls
    private static final String NODE_CHANGE = "change";

    ChangeListManagerSerialization() {
    }

    public static void writeExternal(@NotNull Element element, @NotNull ChangeListWorker worker) {
        if (element == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(0);
        }
        if (worker == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(1);
        }
        for (LocalChangeList list : worker.getChangeLists()) {
            element.addContent(ChangeListManagerSerialization.writeChangeList(list));
        }
    }

    public static void readExternal(@NotNull Element element, @NotNull ChangeListWorker worker) {
        if (element == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(2);
        }
        if (worker == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(3);
        }
        ArrayList<LocalChangeListImpl> lists = new ArrayList<LocalChangeListImpl>();
        for (Element listNode : element.getChildren(NODE_LIST)) {
            lists.add(ChangeListManagerSerialization.readChangeList(listNode, worker.getProject()));
        }
        worker.setChangeLists(ChangeListManagerSerialization.removeDuplicatedLists(lists));
    }

    @NotNull
    private static Collection<LocalChangeListImpl> removeDuplicatedLists(@NotNull List<LocalChangeListImpl> lists) {
        if (lists == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(4);
        }
        boolean hasDefault = false;
        HashMap<String, LocalChangeListImpl> map2 = new HashMap<String, LocalChangeListImpl>();
        for (LocalChangeListImpl list : lists) {
            if (list.isDefault() && hasDefault) {
                list = new LocalChangeListImpl.Builder(list).setDefault(false).build();
            }
            hasDefault |= list.isDefault();
            LocalChangeListImpl otherList = (LocalChangeListImpl)((Object)map2.get(list.getName()));
            if (otherList != null) {
                list = new LocalChangeListImpl.Builder(otherList).setChanges(ContainerUtil.union((Set)list.getChanges(), (Set)otherList.getChanges())).setDefault(list.isDefault() || otherList.isDefault()).build();
            }
            map2.put(list.getName(), list);
        }
        Collection<LocalChangeListImpl> collection = map2.values();
        if (collection == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    private static Element writeChangeList(@NotNull LocalChangeList list) {
        Object listData;
        if (list == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(6);
        }
        Element listNode = new Element(NODE_LIST);
        if (list.isDefault()) {
            listNode.setAttribute(ATT_DEFAULT, ATT_VALUE_TRUE);
        }
        listNode.setAttribute(ATT_ID, list.getId());
        listNode.setAttribute(ATT_NAME, list.getName());
        String comment = list.getComment();
        if (comment != null) {
            listNode.setAttribute(ATT_COMMENT, comment);
        }
        if ((listData = list.getData()) instanceof ChangeListData) {
            listNode.addContent(ChangeListData.writeExternal((ChangeListData)listData));
        }
        List changes2 = ContainerUtil.sorted((Collection)list.getChanges(), (Comparator)new ChangeComparator());
        for (Change change : changes2) {
            listNode.addContent(ChangeListManagerSerialization.writeChange(change));
        }
        Element element = listNode;
        if (element == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(7);
        }
        return element;
    }

    @NotNull
    private static LocalChangeListImpl readChangeList(@NotNull Element listNode, @NotNull Project project) {
        if (listNode == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(8);
        }
        if (project == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(9);
        }
        String id = listNode.getAttributeValue(ATT_ID);
        String name = StringUtil.notNullize((String)listNode.getAttributeValue(ATT_NAME), (String)LocalChangeList.DEFAULT_NAME);
        String comment = StringUtil.notNullize((String)listNode.getAttributeValue(ATT_COMMENT));
        ChangeListData data = ChangeListData.readExternal(listNode);
        boolean isDefault = ATT_VALUE_TRUE.equals(listNode.getAttributeValue(ATT_DEFAULT));
        ArrayList<Change> changes2 = new ArrayList<Change>();
        for (Element changeNode : listNode.getChildren(NODE_CHANGE)) {
            changes2.add(ChangeListManagerSerialization.readChange(changeNode));
        }
        LocalChangeListImpl localChangeListImpl = new LocalChangeListImpl.Builder(project, name).setId(id).setComment(comment).setChanges(changes2).setData(data).setDefault(isDefault).build();
        if (localChangeListImpl == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(10);
        }
        return localChangeListImpl;
    }

    @NotNull
    private static Element writeChange(@NotNull Change change) {
        if (change == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(11);
        }
        Element changeNode = new Element(NODE_CHANGE);
        ChangeListManagerSerialization.writeContentRevision(changeNode, change.getBeforeRevision(), RevisionSide.BEFORE);
        ChangeListManagerSerialization.writeContentRevision(changeNode, change.getAfterRevision(), RevisionSide.AFTER);
        Element element = changeNode;
        if (element == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(12);
        }
        return element;
    }

    @NotNull
    private static Change readChange(@NotNull Element changeNode) {
        if (changeNode == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(13);
        }
        FakeRevision bRev = ChangeListManagerSerialization.readContentRevision(changeNode, RevisionSide.BEFORE);
        FakeRevision aRev = ChangeListManagerSerialization.readContentRevision(changeNode, RevisionSide.AFTER);
        Change change = new Change((ContentRevision)bRev, (ContentRevision)aRev);
        if (change == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(14);
        }
        return change;
    }

    private static void writeContentRevision(@NotNull Element changeNode, @Nullable ContentRevision rev, @NotNull RevisionSide side) {
        if (changeNode == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(15);
        }
        if (side == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(16);
        }
        if (rev == null) {
            return;
        }
        FilePath filePath = rev.getFile();
        String path = filePath.getPath();
        if (ChangeListManagerSerialization.hasIllegalXmlChars(path)) {
            changeNode.setAttribute(side.getPathKey(), JDOMUtil.removeControlChars((String)path));
            changeNode.setAttribute(side.getEscapedPathKey(), XmlStringUtil.escapeIllegalXmlChars((String)path));
        } else {
            changeNode.setAttribute(side.getPathKey(), path);
        }
        changeNode.setAttribute(side.getIsDirKey(), String.valueOf(filePath.isDirectory()));
    }

    @Nullable
    private static FakeRevision readContentRevision(@NotNull Element changeNode, @NotNull RevisionSide side) {
        String path;
        if (changeNode == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(17);
        }
        if (side == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(18);
        }
        String plainPath = changeNode.getAttributeValue(side.getPathKey());
        String escapedPath = changeNode.getAttributeValue(side.getEscapedPathKey());
        String string = path = escapedPath != null ? XmlStringUtil.unescapeIllegalXmlChars((String)escapedPath) : plainPath;
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        String value = changeNode.getAttributeValue(side.getIsDirKey());
        if (value != null) {
            boolean isDirectory = Boolean.parseBoolean(value);
            return new FakeRevision(VcsUtil.getFilePath((String)path, (boolean)isDirectory));
        }
        return new FakeRevision(VcsUtil.getFilePath((String)path));
    }

    private static boolean hasIllegalXmlChars(@NotNull String text) {
        if (text == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(19);
        }
        return text.chars().anyMatch(c -> !Verifier.isXMLCharacter((int)c));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "worker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = NODE_LIST;
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = NODE_CHANGE;
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeNode";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatedLists";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "writeChangeList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readChangeList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "writeChange";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatedLists";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeChangeList";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readChangeList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeChange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readChange";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeContentRevision";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readContentRevision";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasIllegalXmlChars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum RevisionSide {
        BEFORE("beforePath", "beforePathEscaped", "beforeDir"),
        AFTER("afterPath", "afterPathEscaped", "afterDir");

        @NotNull
        private final String myPathKey;
        @NotNull
        private final String myEscapedPathKey;
        @NotNull
        private final String myIsDirKey;

        private RevisionSide(@NotNull String pathKey, String escapedPathKey, String isDirKey) {
            if (pathKey == null) {
                RevisionSide.$$$reportNull$$$0(0);
            }
            if (escapedPathKey == null) {
                RevisionSide.$$$reportNull$$$0(1);
            }
            if (isDirKey == null) {
                RevisionSide.$$$reportNull$$$0(2);
            }
            this.myPathKey = pathKey;
            this.myEscapedPathKey = escapedPathKey;
            this.myIsDirKey = isDirKey;
        }

        @NotNull
        public String getPathKey() {
            String string = this.myPathKey;
            if (string == null) {
                RevisionSide.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        String getEscapedPathKey() {
            String string = this.myEscapedPathKey;
            if (string == null) {
                RevisionSide.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getIsDirKey() {
            String string = this.myIsDirKey;
            if (string == null) {
                RevisionSide.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "escapedPathKey";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isDirKey";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization$RevisionSide";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization$RevisionSide";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathKey";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEscapedPathKey";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIsDirKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ChangeComparator
    implements Comparator<Change> {
        private ChangeComparator() {
        }

        @Override
        public int compare(Change o1, Change o2) {
            ContentRevision bRev2;
            ContentRevision bRev1 = o1.getBeforeRevision();
            int delta = ChangeComparator.compareRevisions(bRev1, bRev2 = o2.getBeforeRevision());
            if (delta != 0) {
                return delta;
            }
            ContentRevision aRev1 = o1.getAfterRevision();
            ContentRevision aRev2 = o2.getAfterRevision();
            return ChangeComparator.compareRevisions(aRev1, aRev2);
        }

        private static int compareRevisions(@Nullable ContentRevision bRev1, @Nullable ContentRevision bRev2) {
            if (bRev1 == null && bRev2 == null) {
                return 0;
            }
            if (bRev1 == null) {
                return -1;
            }
            if (bRev2 == null) {
                return 1;
            }
            String path1 = bRev1.getFile().getPath();
            String path2 = bRev2.getFile().getPath();
            return path1.compareTo(path2);
        }
    }
}

