/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client;

import com.google.common.base.Charsets;
import com.google.common.io.CountingInputStream;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IdeHttpClientHelpers;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.ws.http.request.cookies.CookieFullComparator;
import com.intellij.ws.http.request.run.HttpRequestHistoryManager;
import com.intellij.ws.rest.client.HttpClientRequestWithBody;
import com.intellij.ws.rest.client.RestClientAuthData;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientController;
import com.intellij.ws.rest.client.RestClientFormBodyPart;
import com.intellij.ws.rest.client.RestClientRequest;
import com.intellij.ws.rest.client.RestClientRequestProcessor;
import com.intellij.ws.rest.client.RestClientResponse;
import com.intellij.ws.rest.client.RestClientResponseImpl;
import com.intellij.ws.rest.client.RestClientResponseListener;
import com.intellij.ws.rest.client.RestClientSettings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.HTTP;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestClientControllerImpl
implements RestClientController {
    private static final Logger LOG = Logger.getInstance(RestClientControllerImpl.class);
    @NonNls
    private static final String EMPTY_RESPONSE = "<Response body is empty>";
    private final Project project;

    public RestClientControllerImpl(Project project) {
        this.project = project;
    }

    @Override
    public void onGoButtonClick(final RestClientRequest request, boolean withProgress, final RestClientResponseListener responseListener, final RestClientRequestProcessor ... processors) {
        EmptyProgressIndicator progressIndicator;
        for (RestClientRequestProcessor processor : processors) {
            processor.preProcessRequest(request);
        }
        responseListener.onStart();
        Task.Backgroundable task = new Task.Backgroundable(this.project, RestClientBundle.message("accessing.url", request.getURL()), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                BasicCookieStore store = new BasicCookieStore();
                try {
                    int len;
                    HttpEntity entity;
                    InputStream body;
                    Long length;
                    String url = request.getURL();
                    RestClientControllerImpl.biscuitsToCookies(request, store);
                    CloseableHttpClient client = RestClientControllerImpl.createHttpClient(url, (CookieStore)store, request.authData, request.config.isFollowRedirects());
                    HttpRequestBase method = RestClientControllerImpl.createHttpMethod(url, request);
                    RestClientControllerImpl.addHeaders(method, request);
                    RestClientControllerImpl.initParameters(method, request);
                    long start = System.currentTimeMillis();
                    CloseableHttpResponse response = client.execute((HttpUriRequest)method);
                    for (RestClientRequestProcessor processor : processors) {
                        processor.postProcessRequest(request, (CookieStore)store);
                    }
                    Header contentLength = response.getFirstHeader("Content-Length");
                    Long l = length = contentLength == null ? null : RestClientControllerImpl.fromString(contentLength.getValue());
                    if (length != null) {
                        indicator.setIndeterminate(false);
                        indicator.setText("Accessing resource");
                        indicator.setFraction(0.0);
                    }
                    InputStream inputStream = body = (entity = response.getEntity()) == null ? null : entity.getContent();
                    if (body == null) {
                        RestClientControllerImpl.invokeLaterIfNeeded(() -> this.lambda$run$0(request, (HttpResponse)response, responseListener, start, store));
                        return;
                    }
                    CountingInputStream countingInputStream = new CountingInputStream(body);
                    Charset charset = RestClientControllerImpl.getResponseCharset(entity);
                    InputStreamReader reader = new InputStreamReader((InputStream)countingInputStream, charset);
                    char[] b = new char[4096];
                    StringBuffer buf = new StringBuffer();
                    while ((len = reader.read(b)) != -1 && !indicator.isCanceled()) {
                        String out = new String(b, 0, len);
                        buf.append(charset == Charsets.UTF_8 ? StringUtil.replaceUnicodeEscapeSequences((String)out) : out);
                        if (length == null) continue;
                        indicator.setText(countingInputStream.getCount() / 1000L + " of " + length / 1000L + "Kb");
                        indicator.setFraction((double)countingInputStream.getCount() / (double)length.longValue());
                    }
                    RestClientControllerImpl.invokeLaterIfNeeded(() -> this.lambda$run$1(request, (HttpResponse)response, buf, responseListener, start, store));
                    if (!RestClientControllerImpl.this.project.isDisposed()) {
                        RestClientSettings.getInstance(RestClientControllerImpl.this.project).addToHistory(request);
                    }
                }
                catch (Exception ex) {
                    LOG.info((Throwable)ex);
                    for (RestClientRequestProcessor processor : processors) {
                        processor.postProcessRequest(request, (CookieStore)store);
                    }
                    RestClientControllerImpl.invokeLaterIfNeeded(() -> responseListener.onErrorResponse(ex.toString()));
                    RestClientControllerImpl.invokeLaterIfNeeded(() -> RestClientControllerImpl.this.addToHistory(RestClientControllerImpl.this.project, request, null));
                }
            }

            private /* synthetic */ void lambda$run$1(RestClientRequest request2, HttpResponse response, StringBuffer buf, RestClientResponseListener responseListener2, long start, BasicCookieStore store) {
                RestClientControllerImpl.this.onResponse(RestClientControllerImpl.this.project, request2, RestClientResponseImpl.createResponse(response, buf), responseListener2, start, (CookieStore)store);
            }

            private /* synthetic */ void lambda$run$0(RestClientRequest request2, HttpResponse response, RestClientResponseListener responseListener2, long start, BasicCookieStore store) {
                RestClientControllerImpl.this.onResponse(RestClientControllerImpl.this.project, request2, RestClientResponseImpl.createEmptyResponse(response), responseListener2, start, (CookieStore)store);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ws/rest/client/RestClientControllerImpl$1", "run"));
            }
        };
        Object object = progressIndicator = ApplicationManager.getApplication().isHeadlessEnvironment() || !withProgress ? new EmptyProgressIndicator() : new BackgroundableProcessIndicator(task);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)progressIndicator);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> RestClientControllerImpl.lambda$onGoButtonClick$0(task, (ProgressIndicator)progressIndicator), ModalityState.defaultModalityState());
        }
    }

    @NotNull
    private static Charset getResponseCharset(@NotNull HttpEntity entity) {
        ContentType contentType;
        if (entity == null) {
            RestClientControllerImpl.$$$reportNull$$$0(0);
        }
        if ((contentType = ContentType.getOrDefault((HttpEntity)entity)).getCharset() == null) {
            contentType = ContentType.getByMimeType((String)contentType.getMimeType());
        }
        Charset charset = contentType != null ? contentType.getCharset() : null;
        Charset charset2 = charset != null ? charset : HTTP.DEF_CONTENT_CHARSET;
        if (charset2 == null) {
            RestClientControllerImpl.$$$reportNull$$$0(1);
        }
        return charset2;
    }

    private static void biscuitsToCookies(RestClientRequest request, BasicCookieStore store) {
        for (RestClientRequest.Biscuit biscuit : request.biscuits) {
            BasicClientCookie cookie = new BasicClientCookie(biscuit.getName(), biscuit.getValue());
            if (biscuit.getDomain() != null) {
                cookie.setDomain(biscuit.getDomain());
            }
            if (biscuit.getPath() != null) {
                cookie.setPath(biscuit.getPath());
            }
            if (biscuit.getDate() != -1L) {
                cookie.setExpiryDate(new Date(biscuit.getDate()));
            }
            store.addCookie((Cookie)cookie);
        }
    }

    private static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        Application application;
        if (runnable == null) {
            RestClientControllerImpl.$$$reportNull$$$0(2);
        }
        if (!(application = ApplicationManager.getApplication()).isUnitTestMode()) {
            application.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void onResponse(@NotNull Project project, @NotNull RestClientRequest request, @NotNull RestClientResponse response, @NotNull RestClientResponseListener responseListener, long start, @NotNull CookieStore cookieStore) {
        if (project == null) {
            RestClientControllerImpl.$$$reportNull$$$0(3);
        }
        if (request == null) {
            RestClientControllerImpl.$$$reportNull$$$0(4);
        }
        if (response == null) {
            RestClientControllerImpl.$$$reportNull$$$0(5);
        }
        if (responseListener == null) {
            RestClientControllerImpl.$$$reportNull$$$0(6);
        }
        if (cookieStore == null) {
            RestClientControllerImpl.$$$reportNull$$$0(7);
        }
        if (project.isDisposed()) {
            return;
        }
        String headers = response.getStatusLine().toString() + "\n" + RestClientControllerImpl.toString(response.getAllHeaders());
        String status = RestClientControllerImpl.getStatusText(response, start) + "; Content length: " + response.getContentLength() + " bytes";
        if (response.getContentLength() == 0) {
            responseListener.onResponse(headers, EMPTY_RESPONSE, "text/plain", status);
        } else {
            responseListener.onResponse(headers, response.getContent(), response.getContentType().getMimeType(), status);
        }
        if (request.config.isSaveCookies()) {
            void cookies;
            responseListener.onSetCookies(RestClientControllerImpl.filterUpdatedCookies(request, (CookieStore)cookies));
        }
        this.addToHistory(project, request, response);
    }

    @NotNull
    private static List<Cookie> filterUpdatedCookies(@NotNull RestClientRequest request, @NotNull CookieStore cookieStore) {
        if (request == null) {
            RestClientControllerImpl.$$$reportNull$$$0(8);
        }
        if (cookieStore == null) {
            RestClientControllerImpl.$$$reportNull$$$0(9);
        }
        BasicCookieStore oldCookieStore = new BasicCookieStore();
        RestClientControllerImpl.biscuitsToCookies(request, oldCookieStore);
        TreeSet<Cookie> oldCookies = new TreeSet<Cookie>(new CookieFullComparator());
        oldCookies.addAll(oldCookieStore.getCookies());
        ArrayList<Cookie> updatedCookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookieStore.getCookies()) {
            if (oldCookies.contains(cookie)) continue;
            updatedCookies.add(cookie);
        }
        ArrayList<Cookie> arrayList = updatedCookies;
        if (arrayList == null) {
            RestClientControllerImpl.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    protected void addToHistory(@NotNull Project project, @NotNull RestClientRequest request, @Nullable RestClientResponse response) {
        if (project == null) {
            RestClientControllerImpl.$$$reportNull$$$0(11);
        }
        if (request == null) {
            RestClientControllerImpl.$$$reportNull$$$0(12);
        }
        if (request.config.isLogResponse()) {
            HttpRequestHistoryManager.getInstance(project).addToHistory(request, response);
        }
    }

    private static String getStatusText(@NotNull RestClientResponse response, long start) {
        if (response == null) {
            RestClientControllerImpl.$$$reportNull$$$0(13);
        }
        String text = "Response code: " + response.getStatusLine().getStatusCode();
        String status = response.getStatusLine().getReasonPhrase();
        if (status != null && status.length() > 0) {
            text = text + " (" + status + ")";
        }
        text = text + "; Time: " + (System.currentTimeMillis() - start) + "ms";
        return text;
    }

    private static void addHeaders(HttpRequestBase method, RestClientRequest request) {
        Credentials credentials;
        for (RestClientRequest.KeyValuePair header : request.headers) {
            method.addHeader(header.getKey(), header.getValue());
        }
        if (request.authData != null && request.authData.isSchemeEquals("Basic") && (credentials = request.authData.getAuthCredentials()) instanceof UsernamePasswordCredentials) {
            String decoded = ((UsernamePasswordCredentials)credentials).getUserName() + ":" + credentials.getPassword();
            String encoded = Base64.getEncoder().encodeToString(decoded.getBytes(StandardCharsets.UTF_8));
            method.addHeader("Authorization", "Basic " + encoded);
        }
    }

    private static String toString(Header[] headers) {
        StringBuilder builder = new StringBuilder();
        for (Header header : headers) {
            builder.append(header.toString()).append("\n");
        }
        return builder.toString();
    }

    private static CloseableHttpClient createHttpClient(String url, CookieStore cookieStore, @Nullable RestClientAuthData authData, boolean followRedirects) {
        HttpClientBuilder client = HttpClients.custom();
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        client.setDefaultCredentialsProvider((CredentialsProvider)provider);
        try {
            SSLConnectionSocketFactory factory = new SSLConnectionSocketFactory(CertificateManager.getInstance().getSslContext(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Registry registry = RegistryBuilder.create().register("https", (Object)factory).register("http", (Object)new PlainConnectionSocketFactory()).build();
            client.setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)registry));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        client.addInterceptorFirst((HttpResponseInterceptor)new ResponseContentEncoding());
        client.setDefaultCookieStore(cookieStore);
        try {
            InetSocketAddress address;
            URI uri = new URI(url);
            String userinfo = uri.getUserInfo();
            if (userinfo != null && userinfo.length() > 0) {
                provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userinfo));
            } else if (authData != null && !authData.isSchemeEquals("Basic")) {
                provider.setCredentials(authData.getScope(), authData.getAuthCredentials());
            }
            HttpConfigurable proxyConfigurable = HttpConfigurable.getInstance();
            List<Proxy> proxies = proxyConfigurable.getOnlyBySettingsSelector().select(uri);
            InetSocketAddress inetSocketAddress = address = proxies.size() > 0 ? (InetSocketAddress)proxies.get(0).address() : null;
            if (address != null) {
                client.setProxy(new HttpHost(address.getHostName(), address.getPort()));
                IdeHttpClientHelpers.ApacheHttpClient4.setProxyCredentialsIfEnabled((CredentialsProvider)provider);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (!followRedirects) {
            client.disableRedirectHandling();
        }
        return client.build();
    }

    private static void initParameters(HttpRequestBase httpMethod, RestClientRequest request) {
        if (httpMethod instanceof HttpEntityEnclosingRequestBase) {
            List<File> files;
            HttpEntityEnclosingRequestBase method = (HttpEntityEnclosingRequestBase)httpMethod;
            if (request.haveTextToSend) {
                ContentType contentType = ContentType.parse((String)RestClientControllerImpl.getContentType(request));
                if (contentType.getCharset() == null) {
                    contentType = contentType.withCharset(RestClientControllerImpl.getEncoding(request));
                }
                method.setEntity((HttpEntity)new StringEntity(request.textToSend, contentType));
            } else if (request.isFileUpload) {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                for (RestClientFormBodyPart part : request.formBodyPart) {
                    builder.addPart(part.toBodyPart());
                }
                if (StringUtil.isNotEmpty((String)request.multipartBoundary)) {
                    builder.setBoundary(request.multipartBoundary);
                }
                method.setEntity(builder.build());
            } else if (request.haveFileToSend && (files = request.getFiles()).size() > 0) {
                method.setEntity((HttpEntity)new FileEntity(files.get(0), ContentType.create((String)RestClientControllerImpl.getContentType(request))));
            }
        }
    }

    private static String getContentType(RestClientRequest request) {
        return request.getHeaderValue("Content-Type", "*/*");
    }

    private static String getEncoding(RestClientRequest request) {
        return request.getHeaderValue("Accept-Charset", "UTF-8");
    }

    @Override
    public boolean isValidURL(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static HttpRequestBase createHttpMethod(String uri, RestClientRequest request) {
        String query;
        if (request.parametersEnabled && StringUtil.isNotEmpty((String)(query = request.createQueryString()))) {
            uri = uri + (uri.contains("?") ? "&" : "?") + query;
        }
        if (!request.haveFileToSend && !request.haveTextToSend) {
            if ("GET".equals(request.httpMethod)) {
                return new HttpGet(uri);
            }
            if ("HEAD".equals(request.httpMethod)) {
                return new HttpHead(uri);
            }
            if ("DELETE".equals(request.httpMethod)) {
                return new HttpDelete(uri);
            }
            if ("OPTIONS".equals(request.httpMethod)) {
                return new HttpOptions(uri);
            }
        }
        if ("PUT".equals(request.httpMethod)) {
            return new HttpPut(uri);
        }
        if ("PATCH".equals(request.httpMethod)) {
            return new HttpPatch(uri);
        }
        if ("TRACE".equals(request.httpMethod)) {
            return new HttpTrace(uri);
        }
        if ("POST".equals(request.httpMethod)) {
            return new HttpPost(uri);
        }
        return new HttpClientRequestWithBody(request.httpMethod, uri);
    }

    @Override
    public void openResponseInBrowser(String response) {
        try {
            File file = FileUtil.createTempFile((String)"tmpRestClientResponse", (String)".html");
            FileWriter fw = new FileWriter(file);
            fw.write(response);
            fw.close();
            BrowserUtil.browse((URI)file.toURI());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    private static Long fromString(String num) {
        try {
            return new Long(num);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static /* synthetic */ void lambda$onGoButtonClick$0(Task.Backgroundable task, ProgressIndicator progressIndicator) {
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, progressIndicator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/client/RestClientControllerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseListener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookies";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookieStore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/client/RestClientControllerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseCharset";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUpdatedCookies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResponseCharset";
                break;
            }
            case 1: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onResponse";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterUpdatedCookies";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStatusText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

