/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import com.intellij.ws.http.request.HttpHeaderFieldPreprocessor;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.documentation.comments.HttpDocComment;
import com.intellij.ws.http.request.documentation.comments.psi.HttpDocNoCookieJarTag;
import com.intellij.ws.http.request.documentation.comments.psi.HttpDocNoLogResponseTag;
import com.intellij.ws.http.request.documentation.comments.psi.HttpDocNoRedirectTag;
import com.intellij.ws.http.request.psi.HttpFilePath;
import com.intellij.ws.http.request.psi.HttpHeaderField;
import com.intellij.ws.http.request.psi.HttpHeaderFieldValue;
import com.intellij.ws.http.request.psi.HttpInputFile;
import com.intellij.ws.http.request.psi.HttpMessageBody;
import com.intellij.ws.http.request.psi.HttpMultipartField;
import com.intellij.ws.http.request.psi.HttpMultipartMessage;
import com.intellij.ws.http.request.psi.HttpQuery;
import com.intellij.ws.http.request.psi.HttpQueryParameter;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestBody;
import com.intellij.ws.http.request.psi.HttpRequestMessage;
import com.intellij.ws.http.request.psi.HttpRequestMessagesGroup;
import com.intellij.ws.http.request.psi.HttpRequestTarget;
import com.intellij.ws.http.request.run.HttpRequestValidationException;
import com.intellij.ws.rest.client.HttpRequestConfig;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientFormBodyPart;
import com.intellij.ws.rest.client.RestClientRequest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestPsiConverter {
    private static final String DEFAULT_TMP_INPUT_FILE_NAME = "http_request_input_file";
    private static final String INPUT_SIGN = "< ";
    private static final String REQUEST_SEPARATOR = "###";

    @NotNull
    public static String getSeparator() {
        if (REQUEST_SEPARATOR == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(0);
        }
        return REQUEST_SEPARATOR;
    }

    @NotNull
    public static String toPsiHttpRequest(@NotNull RestClientRequest request) {
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(1);
        }
        String string = HttpRequestPsiConverter.toPsiHttpRequest(request, null);
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String toPsiHttpRequest(@NotNull RestClientRequest request, @Nullable String responseFileName) {
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(3);
        }
        StringBuilder result = new StringBuilder();
        HttpRequestPsiConverter.appendDocComment(result, request.config);
        result.append(StringUtil.notNullize((String)request.httpMethod));
        result.append(" ");
        result.append(request.getURL());
        if (request.parametersEnabled && !request.parameters.isEmpty()) {
            result.append("?");
            result.append(StringUtil.join(request.parameters, pair -> pair.getKey() + "=" + pair.getValue(), (String)"&"));
        }
        if (request.authData != null) {
            String scheme = request.authData.getScope().getScheme();
            Credentials credentials = request.authData.getAuthCredentials();
            if (StringUtil.isNotEmpty((String)scheme) && credentials instanceof UsernamePasswordCredentials) {
                result.append("\n");
                result.append("Authorization").append(": ");
                result.append(StringUtil.capitalize((String)StringUtil.toLowerCase((String)scheme))).append(" ");
                UsernamePasswordCredentials userCredentials = (UsernamePasswordCredentials)credentials;
                result.append(userCredentials.getUserName()).append(" ").append(userCredentials.getPassword());
            }
        }
        if (!request.headers.isEmpty()) {
            result.append("\n");
            result.append(StringUtil.join(request.headers, pair -> pair.getKey() + ": " + pair.getValue(), (String)"\n"));
        }
        if (request.isFileUpload && !request.formBodyPart.isEmpty()) {
            result.append("\n\n");
            for (RestClientFormBodyPart part : request.formBodyPart) {
                result.append("--").append(request.multipartBoundary);
                result.append("\n").append(part.toPsiRepresentation()).append("\n");
            }
            result.append("--").append(request.multipartBoundary).append("--");
        } else if (request.haveFileToSend && StringUtil.isNotEmpty((String)request.filesToSend)) {
            String inputFiles = StreamEx.of((Object[])request.filesToSend.split(File.pathSeparator)).map(path -> INPUT_SIGN + path).joining((CharSequence)"\n");
            result.append("\n\n");
            result.append(inputFiles);
        } else if (request.haveTextToSend && StringUtil.isNotEmpty((String)request.textToSend)) {
            result.append("\n\n");
            result.append(StringUtil.convertLineSeparators((String)request.textToSend));
        }
        if (StringUtil.isNotEmpty((String)responseFileName)) {
            result.append("\n\n");
            result.append("<> ").append(responseFileName);
        }
        result.append("\n\n").append(REQUEST_SEPARATOR).append("\n\n");
        String string = result.toString();
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void appendDocComment(@NotNull StringBuilder result, @NotNull HttpRequestConfig config) {
        if (result == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(5);
        }
        if (config == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(6);
        }
        if (!config.myFollowRedirects) {
            result.append("# ").append("@no-redirect").append("\n");
        }
        if (!config.myLogResponse) {
            result.append("# ").append("@no-log").append("\n");
        }
        if (!config.mySaveCookies) {
            result.append("# ").append("@no-cookie-jar").append("\n");
        }
    }

    @NotNull
    public static RestClientRequest toRestClientRequest(@NotNull HttpRequest element, @NotNull HttpRequestVariableSubstitutor substitutor) throws HttpRequestValidationException {
        HttpQuery query;
        if (element == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(7);
        }
        if (substitutor == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(8);
        }
        HttpRequestTarget target = element.getRequestTarget();
        String url = element.getHttpUrl(substitutor);
        if (StringUtil.isEmpty((String)url)) {
            throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.url.is.invalid", new Object[0]));
        }
        RestClientRequest request = new RestClientRequest();
        request.urlBase = url;
        request.httpMethod = element.getHttpMethod();
        request.urlPath = "";
        HttpQuery httpQuery = query = target != null ? target.getQuery() : null;
        if (query != null) {
            for (HttpQueryParameter parameter : query.getQueryParameterList()) {
                String key = parameter.getKey(substitutor);
                String value = parameter.getValue(substitutor);
                if (StringUtil.isNotEmpty((String)key)) {
                    request.parameters.add(new RestClientRequest.KeyValuePair(key, StringUtil.notNullize((String)value)));
                    continue;
                }
                throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.query.is.invalid", parameter.getText()));
            }
        }
        request.parametersEnabled = !request.parameters.isEmpty();
        for (HttpHeaderField field : element.getHeaderFieldList()) {
            String fieldName = field.getHeaderFieldName().getText();
            HttpHeaderFieldPreprocessor.create(fieldName).addHeader(request, field, substitutor);
        }
        request.textToSend = "";
        request.filesToSend = "";
        HttpRequestBody body = element.getRequestBody();
        if (body instanceof HttpRequestMessagesGroup) {
            List<HttpRequestMessage> messages = ((HttpRequestMessagesGroup)body).getRequestMessageList();
            if (!messages.isEmpty()) {
                if (messages.size() == 1 && messages.get(0) instanceof HttpInputFile) {
                    request.filesToSend = PathUtil.toSystemIndependentName((String)HttpRequestPsiConverter.getFileToSend((HttpInputFile)messages.get(0), substitutor).getPath());
                    request.haveFileToSend = StringUtil.isNotEmpty((String)request.filesToSend);
                } else {
                    request.textToSend = HttpRequestPsiConverter.getTextToSend(element.getContainingFile(), messages, substitutor);
                    request.haveTextToSend = StringUtil.isNotEmpty((String)request.textToSend);
                }
            }
        } else if (body instanceof HttpMultipartMessage) {
            request.isFileUpload = true;
            request.multipartBoundary = HttpRequestPsiConverter.getMultipartBoundary(element);
            request.formBodyPart = new ArrayList<RestClientFormBodyPart>();
            List<HttpMultipartField> fields = ((HttpMultipartMessage)body).getMultipartFieldList();
            for (int i = 0; i < fields.size(); ++i) {
                HttpMultipartField field = fields.get(i);
                RestClientFormBodyPart bodyPart = HttpRequestPsiConverter.newBodyPartBuilder(field, substitutor, i);
                for (HttpHeaderField header : field.getHeaderFieldList()) {
                    bodyPart.addHeader(header.getName(), header.getValue(substitutor));
                }
                request.formBodyPart.add(bodyPart);
            }
        }
        request.config = HttpRequestPsiConverter.toRequestConfig(HttpRequestPsiUtils.findDocComment(element));
        RestClientRequest restClientRequest = request;
        if (restClientRequest == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(9);
        }
        return restClientRequest;
    }

    @NotNull
    private static HttpRequestConfig toRequestConfig(@Nullable HttpDocComment docComment) {
        boolean followRedirects = docComment == null || docComment.getTags().stream().noneMatch(tag -> tag instanceof HttpDocNoRedirectTag);
        boolean logResponse = docComment == null || docComment.getTags().stream().noneMatch(tag -> tag instanceof HttpDocNoLogResponseTag);
        boolean saveCookies = docComment == null || docComment.getTags().stream().noneMatch(tag -> tag instanceof HttpDocNoCookieJarTag);
        HttpRequestConfig httpRequestConfig = new HttpRequestConfig(followRedirects, logResponse, saveCookies);
        if (httpRequestConfig == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(10);
        }
        return httpRequestConfig;
    }

    @Nullable
    private static String getMultipartBoundary(@NotNull HttpRequest request) {
        HttpHeaderField field;
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(11);
        }
        if ((field = request.getHeaderField("Content-Type")) != null) {
            HttpHeaderFieldValue contentType = field.getHeaderFieldValue();
            return contentType != null ? contentType.getHeaderFieldOption("boundary") : null;
        }
        return null;
    }

    @NotNull
    public static RestClientFormBodyPart newBodyPartBuilder(@NotNull HttpMultipartField field, @NotNull HttpRequestVariableSubstitutor substitutor, int index) throws HttpRequestValidationException {
        String filename;
        HttpHeaderFieldValue description;
        String name;
        if (field == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(12);
        }
        if (substitutor == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(13);
        }
        String string = name = (description = field.getMultipartFieldDescription()) != null ? description.getHeaderFieldOption("name") : String.valueOf(index);
        if (StringUtil.isEmpty((String)name)) {
            name = String.valueOf(index);
        }
        String string2 = filename = description != null ? description.getHeaderFieldOption("filename") : null;
        if (StringUtil.isNotEmpty((String)filename)) {
            File toUpload = HttpRequestPsiConverter.getFileToUpload(field, filename, substitutor);
            RestClientFormBodyPart restClientFormBodyPart = RestClientFormBodyPart.create(name, filename, toUpload, field.getContentType(substitutor));
            if (restClientFormBodyPart == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(14);
            }
            return restClientFormBodyPart;
        }
        String text = HttpRequestPsiConverter.getTextToSend(field.getContainingFile(), field.getRequestMessages(), substitutor);
        RestClientFormBodyPart restClientFormBodyPart = RestClientFormBodyPart.create(name, text, field.getContentType(substitutor));
        if (restClientFormBodyPart == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(15);
        }
        return restClientFormBodyPart;
    }

    @NotNull
    private static File getFileToUpload(@NotNull HttpMultipartField field, @NotNull String fieldName, @Nullable HttpRequestVariableSubstitutor substitutor) throws HttpRequestValidationException {
        File file;
        List<HttpRequestMessage> messages;
        if (field == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(16);
        }
        if (fieldName == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(17);
        }
        if ((messages = field.getRequestMessages()).size() == 1 && messages.get(0) instanceof HttpInputFile) {
            File file2 = HttpRequestPsiConverter.getFileToSend((HttpInputFile)messages.get(0), substitutor);
            if (file2 == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(18);
            }
            return file2;
        }
        try {
            File file3 = FileUtil.createTempFile((String)DEFAULT_TMP_INPUT_FILE_NAME, (String)".txt");
            FileUtil.writeToFile((File)file3, (String)HttpRequestPsiConverter.getTextToSend(field.getContainingFile(), messages, substitutor));
            file = file3;
        }
        catch (IOException e) {
            throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.cannot.create.file", fieldName));
        }
        if (file == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(19);
        }
        return file;
    }

    @NotNull
    private static String getTextToSend(@Nullable PsiFile file, @NotNull List<HttpRequestMessage> messages, @Nullable HttpRequestVariableSubstitutor substitutor) throws HttpRequestValidationException {
        if (messages == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(20);
        }
        String lineSeparator = file == null || messages.size() < 2 ? LineSeparator.getSystemLineSeparator().getSeparatorString() : FileDocumentManager.getInstance().getLineSeparator(file.getVirtualFile(), file.getProject());
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < messages.size(); ++i) {
            HttpRequestMessage message = messages.get(i);
            if (message instanceof HttpMessageBody) {
                result.append(HttpRequestPsiConverter.fillVariables(message.getText(), substitutor));
            } else if (message instanceof HttpInputFile) {
                result.append(HttpRequestPsiConverter.fillVariables(HttpRequestPsiConverter.loadFileContent(HttpRequestPsiConverter.resolveFileUrl((HttpInputFile)message)), substitutor));
            }
            if (i == messages.size() - 1) continue;
            result.append(lineSeparator);
        }
        String string = result.toString();
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static String fillVariables(@NotNull String messageBody, @Nullable HttpRequestVariableSubstitutor substitutor) {
        List<TextRange> variablesRanges;
        if (messageBody == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(22);
        }
        if (substitutor != null && !(variablesRanges = HttpRequestPsiUtils.collectVariablesRangesInMessageBody(messageBody)).isEmpty()) {
            StringBuilder result = new StringBuilder(messageBody.length());
            int lastVariableRangeEndOffset = 0;
            for (TextRange variableRange : variablesRanges) {
                result.append(messageBody, lastVariableRangeEndOffset, variableRange.getStartOffset());
                String variableValue = substitutor.getVariableValue(HttpRequestPsiUtils.getVariableNameRange(messageBody, variableRange).substring(messageBody), variableRange.substring(messageBody));
                result.append(variableValue);
                lastVariableRangeEndOffset = variableRange.getEndOffset();
            }
            result.append(messageBody, lastVariableRangeEndOffset, messageBody.length());
            String string = result.toString();
            if (string == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = messageBody;
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static boolean isTextFile(@NotNull File file) {
        if (file == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(25);
        }
        FileType fileType = !file.isDirectory() ? FileTypeManager.getInstance().getFileTypeByFileName(file.getName()) : null;
        return fileType != null && !fileType.isBinary();
    }

    @NotNull
    private static File getFileToSend(@NotNull HttpInputFile message, HttpRequestVariableSubstitutor substitutor) throws HttpRequestValidationException {
        String url;
        if (message == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(26);
        }
        if (!StringUtil.equals((CharSequence)VirtualFileManager.extractProtocol((String)(url = HttpRequestPsiConverter.resolveFileUrl(message))), (CharSequence)"jar")) {
            String path = VfsUtilCore.urlToPath((String)url);
            File file = new File(PathUtil.toSystemDependentName((String)path));
            if (HttpRequestPsiConverter.isTextFile(file)) {
                String fileContent = HttpRequestPsiConverter.loadFileContent(url);
                String extension = PathUtil.getFileExtension((String)file.getName());
                String fileContentWithVariables = HttpRequestPsiConverter.fillVariables(fileContent, substitutor);
                if (extension != null && !StringUtil.equals((CharSequence)fileContent, (CharSequence)fileContentWithVariables)) {
                    File file2 = HttpRequestPsiConverter.createTempFile(fileContentWithVariables, extension, FileUtilRt.getNameWithoutExtension((String)file.getName()));
                    if (file2 == null) {
                        HttpRequestPsiConverter.$$$reportNull$$$0(27);
                    }
                    return file2;
                }
            }
            File file3 = new File(path);
            if (file3 == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(28);
            }
            return file3;
        }
        File file = HttpRequestPsiConverter.createTempFile(HttpRequestPsiConverter.loadFileContent(url), "txt", DEFAULT_TMP_INPUT_FILE_NAME);
        if (file == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(29);
        }
        return file;
    }

    @NotNull
    private static File createTempFile(@NotNull String content, @NotNull String extension, @NotNull String filename) throws HttpRequestValidationException {
        File file;
        if (content == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(30);
        }
        if (extension == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(31);
        }
        if (filename == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(32);
        }
        try {
            File tmpFile = FileUtil.createTempFile((String)filename, (String)("." + extension));
            FileUtil.writeToFile((File)tmpFile, (String)content);
            file = tmpFile;
        }
        catch (IOException e) {
            throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.cannot.create.file.post", new Object[0]));
        }
        if (file == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(33);
        }
        return file;
    }

    @NotNull
    private static String resolveFileUrl(@NotNull HttpInputFile message) throws HttpRequestValidationException {
        HttpFilePath filePath;
        if (message == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(34);
        }
        if ((filePath = message.getFilePath()) == null) {
            throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.file.path.is.empty", new Object[0]));
        }
        PsiFile file = FileReferenceUtil.findFile((PsiElement)filePath);
        if (file != null) {
            String string = file.getVirtualFile().getUrl();
            if (string == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(35);
            }
            return string;
        }
        String path = filePath.getPresentablePath();
        if (FileUtil.isAbsolutePlatformIndependent((String)path)) {
            String string = VfsUtilCore.pathToUrl((String)path);
            if (string == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(36);
            }
            return string;
        }
        throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.file.path.is.invalid", path));
    }

    @NotNull
    private static String loadFileContent(@NotNull String url) throws HttpRequestValidationException {
        block6: {
            String string;
            if (url == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(37);
            }
            try {
                VirtualFile file;
                String protocol = VirtualFileManager.extractProtocol((String)url);
                if (StringUtil.equals((CharSequence)protocol, (CharSequence)"file") || (file = VirtualFileManager.getInstance().findFileByUrl(url)) == null) break block6;
                string = VfsUtilCore.loadText((VirtualFile)file);
            }
            catch (IOException e) {
                throw new HttpRequestValidationException(e.getMessage());
            }
            if (string == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(38);
            }
            return string;
        }
        String string = FileUtil.loadFile((File)new File(PathUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url))));
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(39);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/HttpRequestPsiConverter";
                break;
            }
            case 1: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBody";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparator";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/HttpRequestPsiConverter";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiHttpRequest";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toRestClientRequest";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toRequestConfig";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "newBodyPartBuilder";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToUpload";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextToSend";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "fillVariables";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToSend";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFileUrl";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileContent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toPsiHttpRequest";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendDocComment";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toRestClientRequest";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMultipartBoundary";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newBodyPartBuilder";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFileToUpload";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTextToSend";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fillVariables";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isTextFile";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFileToSend";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveFileUrl";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "loadFileContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

