/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.uml;

import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.uml.PyDummyFileClass;
import com.jetbrains.python.uml.PyDummyPackageClass;
import org.jetbrains.annotations.Nullable;

public class PyUmlVfsResolver
implements DiagramVfsResolver<PyClass> {
    @Nullable
    public String getQualifiedName(PyClass element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PyDummyFileClass) {
            VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
            return virtualFile != null ? "#" + virtualFile.getCanonicalPath() : "#";
        }
        if (element instanceof PyDummyPackageClass) {
            VirtualFile virtualFile = ((PyDummyPackageClass)element).getDirectory().getVirtualFile();
            return "#" + virtualFile.getCanonicalPath();
        }
        return element.getQualifiedName();
    }

    public PyClass resolveElementByFQN(String fqn, Project project) {
        try {
            if (fqn.startsWith("#")) {
                String filePath = fqn.substring(1);
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
                if (virtualFile != null) {
                    PsiFile file = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (file != null) {
                        return new PyDummyFileClass(file.getName(), project, (PyFile)file);
                    }
                    PsiDirectory dir = PsiManager.getInstance((Project)project).findDirectory(virtualFile);
                    if (dir != null) {
                        return new PyDummyPackageClass(project, dir);
                    }
                }
            }
            return PyClassNameIndex.findClass((String)fqn, (Project)project);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }
}

