/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibraryModel {
    public static final ScriptingLibraryModel[] EMPTY_ARRAY = new ScriptingLibraryModel[0];
    private String myName;
    private final Set<VirtualFilePointer> mySourceFilePointers;
    private final Set<VirtualFilePointer> myCompactFilePointers;
    private final Set<String> myDocUrls;
    private LibraryLevel myLibraryLevel;
    private ScriptingFrameworkDescriptor myFrameworkDescriptor;
    private Library myOriginalLibrary;
    private Set<Module> myAssociatedModules;
    private boolean myIsOnByDefault;

    public ScriptingLibraryModel(@NotNull String name, @NotNull VirtualFile[] sourceFiles, @NotNull VirtualFile[] compactFiles, @NotNull String[] docUrls, @NotNull LibraryLevel level, boolean isOnByDefault) {
        if (name == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(0);
        }
        if (sourceFiles == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(1);
        }
        if (compactFiles == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(2);
        }
        if (docUrls == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(3);
        }
        if (level == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(4);
        }
        this(name, level);
        this.setSourceFiles(sourceFiles);
        this.setCompactFiles(compactFiles);
        this.myDocUrls.addAll(Arrays.asList(docUrls));
        this.myIsOnByDefault = isOnByDefault;
    }

    public static ScriptingLibraryModel createPredefinedLibrary(String name, VirtualFile[] sourceFiles, boolean isOnByDefault) {
        return new ScriptingLibraryModel(name, sourceFiles, VirtualFile.EMPTY_ARRAY, ArrayUtilRt.EMPTY_STRING_ARRAY, LibraryLevel.PREDEFINED, isOnByDefault);
    }

    public static ScriptingLibraryModel createPredefinedLibrary(String name, VirtualFile[] sourceFiles, String extDocUrl, boolean isOnByDefault) {
        return new ScriptingLibraryModel(name, sourceFiles, VirtualFile.EMPTY_ARRAY, new String[]{extDocUrl}, LibraryLevel.PREDEFINED, isOnByDefault);
    }

    public ScriptingLibraryModel(@Nullable String name, LibraryLevel libraryLevel) {
        this.mySourceFilePointers = new HashSet<VirtualFilePointer>();
        this.myCompactFilePointers = new HashSet<VirtualFilePointer>();
        this.myDocUrls = new TreeSet<String>();
        this.myName = name;
        this.myLibraryLevel = libraryLevel;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @NotNull
    private static List<LightFilePointer> createPointersFromUrls(@NotNull Collection<String> urls) {
        if (urls == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(5);
        }
        List list = ContainerUtil.map(urls, url -> new LightFilePointer(url));
        if (list == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static List<LightFilePointer> createPointersFromFiles(@NotNull VirtualFile[] files) {
        if (files == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.map((Object[])files, file -> new LightFilePointer(file));
        if (list == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void setSourceFiles(@NotNull VirtualFile[] files) {
        if (files == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(9);
        }
        this.mySourceFilePointers.clear();
        this.mySourceFilePointers.addAll(ScriptingLibraryModel.createPointersFromFiles(files));
    }

    public void setSourceFileUrls(@NotNull Collection<String> sourceFileUrls) {
        if (sourceFileUrls == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(10);
        }
        this.mySourceFilePointers.clear();
        this.mySourceFilePointers.addAll(ScriptingLibraryModel.createPointersFromUrls(sourceFileUrls));
    }

    public void setCompactFiles(@NotNull VirtualFile[] files) {
        if (files == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(11);
        }
        this.myCompactFilePointers.clear();
        this.myCompactFilePointers.addAll(ScriptingLibraryModel.createPointersFromFiles(files));
    }

    public void setCompactFileUrls(@NotNull Collection<String> compactFileUrls) {
        if (compactFileUrls == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(12);
        }
        this.myCompactFilePointers.clear();
        this.myCompactFilePointers.addAll(ScriptingLibraryModel.createPointersFromUrls(compactFileUrls));
    }

    public void setDocUrls(String[] docUrls) {
        this.myDocUrls.clear();
        this.myDocUrls.addAll(Arrays.asList(docUrls));
    }

    @NotNull
    public Set<VirtualFile> getSourceFiles() {
        Set set = ContainerUtil.map2SetNotNull(this.mySourceFilePointers, pointer -> pointer.getFile());
        if (set == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFilePointer> getSourceFilePointers() {
        Set<VirtualFilePointer> set = this.mySourceFilePointers;
        if (set == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    public Set<String> getSourceFileUrls() {
        Set set = ContainerUtil.map2SetNotNull(this.mySourceFilePointers, pointer -> pointer.getUrl());
        if (set == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(15);
        }
        return set;
    }

    public Set<VirtualFile> getCompactFiles() {
        return ContainerUtil.map2SetNotNull(this.myCompactFilePointers, pointer -> pointer.getFile());
    }

    @NotNull
    public Set<VirtualFilePointer> getCompactFilePointers() {
        Set<VirtualFilePointer> set = this.myCompactFilePointers;
        if (set == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(16);
        }
        return set;
    }

    public Set<String> getDocUrls() {
        return this.myDocUrls;
    }

    @NotNull
    public Set<VirtualFile> getAllFiles() {
        HashSet<VirtualFile> compactAndSourceFiles = new HashSet<VirtualFile>(this.getSourceFiles());
        compactAndSourceFiles.addAll(this.getCompactFiles());
        HashSet<VirtualFile> hashSet = compactAndSourceFiles;
        if (hashSet == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    @NotNull
    private static List<String> getFileUrls(@NotNull Collection<VirtualFilePointer> pointers) {
        if (pointers == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(18);
        }
        List list = ContainerUtil.map(pointers, pointer -> pointer.getUrl());
        if (list == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public Set<String> getAllFileUrls() {
        HashSet<String> compactAndSourceFiles = new HashSet<String>(ScriptingLibraryModel.getFileUrls(this.mySourceFilePointers));
        compactAndSourceFiles.addAll(ScriptingLibraryModel.getFileUrls(this.myCompactFilePointers));
        HashSet<String> hashSet = compactAndSourceFiles;
        if (hashSet == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(21);
        }
        return string;
    }

    public boolean containsFile(VirtualFile file) {
        return this.getSourceFiles().contains(file) || this.getCompactFiles().contains(file);
    }

    public boolean isEmpty() {
        return this.getSourceFiles().isEmpty() && this.getCompactFiles().isEmpty();
    }

    public String toString() {
        return this.myName + (this.isPredefined() ? " (Predefined)" : "");
    }

    public boolean isPredefined() {
        return this.myLibraryLevel == LibraryLevel.PREDEFINED;
    }

    public LibraryLevel getLibraryLevel() {
        return this.myLibraryLevel;
    }

    public ScriptingFrameworkDescriptor getFrameworkDescriptor() {
        return this.myFrameworkDescriptor;
    }

    public void setFrameworkDescriptor(ScriptingFrameworkDescriptor frameworkDescriptor) {
        this.myFrameworkDescriptor = frameworkDescriptor;
    }

    void setOriginalLibrary(@Nullable Library originalLibrary) {
        this.myOriginalLibrary = originalLibrary;
    }

    @Nullable
    public Library getOriginalLibrary() {
        return this.myOriginalLibrary;
    }

    public void setLibraryLevel(LibraryLevel libraryLevel) {
        assert (libraryLevel == LibraryLevel.PROJECT || libraryLevel == LibraryLevel.GLOBAL) : "Only Global or Project level is allowed here";
        if (libraryLevel != this.myLibraryLevel) {
            this.myLibraryLevel = libraryLevel;
            this.myOriginalLibrary = null;
        }
    }

    public void setAssociatedModules(Set<Module> modules) {
        this.myAssociatedModules = modules;
    }

    public boolean hasAssociatedModules() {
        return this.myAssociatedModules != null && !this.myAssociatedModules.isEmpty();
    }

    public boolean isAssociatedWith(Module module) {
        return this.myAssociatedModules != null && this.myAssociatedModules.contains(module);
    }

    public Set<Module> getAssociatedModules() {
        return this.myAssociatedModules;
    }

    public boolean isOnByDefault() {
        return this.myIsOnByDefault;
    }

    @NotNull
    public static ScriptingLibraryModel[] toArray(@NotNull Collection<ScriptingLibraryModel> collection) {
        if (collection == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(22);
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = collection.toArray(new ScriptingLibraryModel[0]);
        if (scriptingLibraryModelArray == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(23);
        }
        return scriptingLibraryModelArray;
    }

    public void addSignificantFiles(Collection<VirtualFile> result) {
        Set<VirtualFile> sourceFiles = this.getSourceFiles();
        if (!sourceFiles.isEmpty()) {
            result.addAll(sourceFiles);
        } else {
            result.addAll(this.getCompactFiles());
        }
    }

    public boolean shouldIndexSourcesWithoutMappings() {
        return true;
    }

    public void collectFilesWithGlobalDefinitions(@NotNull Collection<VirtualFile> result) {
        if (result == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(24);
        }
        this.addSignificantFiles(result);
    }

    @NotNull
    public List<VirtualFile> getDefaultMappings() {
        List<Object> list = this.myIsOnByDefault ? Collections.singletonList(null) : Collections.emptyList();
        if (list == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(25);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compactFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docUrls";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ScriptingLibraryModel";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileUrls";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compactFileUrls";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ScriptingLibraryModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointersFromUrls";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointersFromFiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFiles";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFilePointers";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFileUrls";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompactFilePointers";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileUrls";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFileUrls";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPointersFromUrls";
                break;
            }
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPointersFromFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSourceFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setSourceFileUrls";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setCompactFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCompactFileUrls";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFileUrls";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "collectFilesWithGlobalDefinitions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum LibraryLevel {
        PREDEFINED,
        GLOBAL,
        PROJECT;

    }
}

