/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInheritedTableDefinition;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.stubs.SqlDefinitionStubElementType;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlTableStub;
import com.intellij.util.NotNullFunction;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTableElementType
extends SqlDefinitionStubElementType<SqlTableDefinition> {
    public static NotNullFunction<String, SqlTableElementType> factory(@NotNull SqlReferenceElementType refType) {
        if (refType == null) {
            SqlTableElementType.$$$reportNull$$$0(0);
        }
        return name2 -> new SqlTableElementType((String)name2, refType);
    }

    public SqlTableElementType(@NonNls @NotNull String debugName, @NotNull SqlReferenceElementType refType) {
        if (debugName == null) {
            SqlTableElementType.$$$reportNull$$$0(1);
        }
        if (refType == null) {
            SqlTableElementType.$$$reportNull$$$0(2);
        }
        super(debugName, refType);
    }

    @NotNull
    public SqlTableStub createStub(@NotNull SqlTableDefinition psi, StubElement parentStub) {
        if (psi == null) {
            SqlTableElementType.$$$reportNull$$$0(3);
        }
        StringRef[][] ancestorRefs = null;
        if (psi instanceof SqlInheritedTableDefinition) {
            SqlInheritedTableDefinition inherited = (SqlInheritedTableDefinition)psi;
            Object[] methods = inherited.getInheritanceMethods();
            ancestorRefs = new StringRef[methods.length][];
            for (int i2 = 0; i2 < methods.length; ++i2) {
                List ancestors = inherited.getAncestors(methods[i2]);
                ancestorRefs[i2] = ancestors.isEmpty() ? StringRef.EMPTY_ARRAY : new StringRef[ancestors.size()];
                for (int j = 0; j < ancestors.size(); ++j) {
                    ancestorRefs[i2][j] = StringRef.fromString((String)((SqlReferenceExpression)ancestors.get(j)).getText());
                }
            }
        }
        SqlExpression expression = psi.getQueryExpression();
        SqlTableStub sqlTableStub = new SqlTableStub(parentStub, this, SqlTableElementType.asStringRef((PsiElement)psi.getNameElement()), expression == null ? null : StringRef.fromString((String)expression.getText()), ancestorRefs);
        if (sqlTableStub == null) {
            SqlTableElementType.$$$reportNull$$$0(4);
        }
        return sqlTableStub;
    }

    @Override
    public void serialize(@NotNull SqlNamedElementStub<SqlTableDefinition> stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            SqlTableElementType.$$$reportNull$$$0(5);
        }
        if (dataStream == null) {
            SqlTableElementType.$$$reportNull$$$0(6);
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(((SqlTableStub)stub).getExpressionText());
        SqlTableElementType.writeStringsArray(dataStream, ((SqlTableStub)stub).getAncestorTextRefs());
    }

    @NotNull
    public SqlTableStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            SqlTableElementType.$$$reportNull$$$0(7);
        }
        SqlTableStub sqlTableStub = new SqlTableStub(parentStub, this, dataStream.readName(), dataStream.readName(), SqlTableElementType.readStringsArray(dataStream));
        if (sqlTableStub == null) {
            SqlTableElementType.$$$reportNull$$$0(8);
        }
        return sqlTableStub;
    }

    private static void writeStringsArray(@NotNull StubOutputStream dataStream, @Nullable StringRef[][] refs) throws IOException {
        if (dataStream == null) {
            SqlTableElementType.$$$reportNull$$$0(9);
        }
        if (refs == null) {
            dataStream.writeVarInt(0);
        } else {
            dataStream.writeVarInt(refs.length);
            for (StringRef[] ref : refs) {
                SqlTableElementType.writeStrings(dataStream, ref);
            }
        }
    }

    private static void writeStrings(@NotNull StubOutputStream dataStream, @NotNull StringRef[] refs) throws IOException {
        if (dataStream == null) {
            SqlTableElementType.$$$reportNull$$$0(10);
        }
        if (refs == null) {
            SqlTableElementType.$$$reportNull$$$0(11);
        }
        dataStream.writeVarInt(refs.length);
        for (StringRef ref : refs) {
            dataStream.writeName(ref.getString());
        }
    }

    @NotNull
    private static StringRef[] readStrings(@NotNull StubInputStream dataStream) throws IOException {
        int len;
        if (dataStream == null) {
            SqlTableElementType.$$$reportNull$$$0(12);
        }
        if ((len = dataStream.readVarInt()) == 0) {
            if (StringRef.EMPTY_ARRAY == null) {
                SqlTableElementType.$$$reportNull$$$0(13);
            }
            return StringRef.EMPTY_ARRAY;
        }
        StringRef[] res2 = new StringRef[len];
        for (int i2 = 0; i2 < res2.length; ++i2) {
            res2[i2] = dataStream.readName();
        }
        if (res2 == null) {
            SqlTableElementType.$$$reportNull$$$0(14);
        }
        return res2;
    }

    @Nullable
    private static StringRef[][] readStringsArray(@NotNull StubInputStream dataStream) throws IOException {
        int len;
        if (dataStream == null) {
            SqlTableElementType.$$$reportNull$$$0(15);
        }
        if ((len = dataStream.readVarInt()) == 0) {
            return null;
        }
        StringRef[][] res2 = new StringRef[len][];
        for (int i2 = 0; i2 < res2.length; ++i2) {
            res2[i2] = SqlTableElementType.readStrings(dataStream);
        }
        return res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: 
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/SqlTableElementType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/SqlTableElementType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readStrings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "factory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 4: 
            case 8: 
            case 13: 
            case 14: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeStringsArray";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeStrings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readStrings";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readStringsArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

