/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.OptionTableWithPreviewPanel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeGenerationMainPanel;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsType;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsUtil;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.formatter.settings.SqlPreviewExamples;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlCodeStyleMainPanel
extends TabbedLanguageCodeStylePanel {
    private static final int STRIPE_WITH_COMBO_BOX_RELATIVE_HEIGHT = 32;
    private final JBCheckBox myInheritCb;
    private final JBCheckBox myDisableCb;
    private final JPanel myWrapper;
    protected ArrayList<CodeStyleAbstractPanel> myPanels;
    private static final int[] INT_0_3_VALUES = new int[]{0, 1, 2, 3};
    private static final String[] INT_0_3_NAMES = new String[]{"No", "1", "2", "3"};

    protected SqlCodeStyleMainPanel(@NotNull Language settingsLanguage, CodeStyleSettings currentSettings, CodeStyleSettings settings) {
        if (settingsLanguage == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(0);
        }
        super(settingsLanguage, currentSettings, settings);
        this.myInheritCb = new JBCheckBox("Inherit general SQL style");
        this.myDisableCb = new JBCheckBox("Disable formatting");
        this.myWrapper = new JPanel(new BorderLayout());
        SqlCodeStyleSettings initialSettings = this.getSqlSettings(this.getCurrentSettings());
        JComponent panel = super.getPanel();
        assert (panel != null);
        Color borderColor = JBColor.border();
        boolean settingsAreInherited = !this.isGeneric() && initialSettings.USE_GENERIC_STYLE;
        boolean settingsAreDisabled = initialSettings.DISABLE_FORMATTING;
        MyCheckBoxesListener checkBoxesListener = new MyCheckBoxesListener();
        this.myInheritCb.setBorder((Border)JBUI.Borders.emptyRight((int)8));
        this.myInheritCb.addChangeListener((ChangeListener)checkBoxesListener);
        this.myInheritCb.setSelected(settingsAreInherited);
        this.myInheritCb.setEnabled(!this.isGeneric());
        this.myInheritCb.setVisible(!this.isGeneric());
        this.myDisableCb.setBorder((Border)JBUI.Borders.emptyRight((int)8));
        this.myDisableCb.addChangeListener((ChangeListener)checkBoxesListener);
        this.myDisableCb.setSelected(settingsAreDisabled);
        JPanel cbStripe = new JPanel(new FlowLayout(0));
        cbStripe.add((Component)this.myInheritCb);
        cbStripe.add((Component)this.myDisableCb);
        JComponent dialectStripe = this.createDialectSelectorStripe(settings);
        JPanel topStripe = new JPanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)10), 0));
        topStripe.setPreferredSize(new Dimension(200, JBUIScale.scale((int)32)));
        topStripe.add((Component)cbStripe, "LEFT");
        if (dialectStripe != null) {
            topStripe.add((Component)dialectStripe, "RIGHT");
        }
        this.myWrapper.add((Component)panel, "Center");
        this.myWrapper.add((Component)topStripe, "North");
        if (!SystemInfo.isWindows) {
            this.myWrapper.setBorder(JBUI.Borders.customLine((Color)borderColor, (int)1, (int)0, (int)0, (int)0));
        }
        this.updateControlsAbility(settingsAreInherited, settingsAreDisabled);
    }

    protected abstract boolean isGeneric();

    @NotNull
    protected abstract Language getSettingLanguage();

    @NotNull
    protected abstract SqlLanguageDialect getPreviewDialect();

    @NotNull
    protected abstract Class<? extends SqlCodeStyleSettings> getSettingsClass();

    @Nullable
    protected abstract JComponent createDialectSelectorStripe(CodeStyleSettings var1);

    protected String getPreviewText() {
        this.getSettingsClass();
        return super.getPreviewText();
    }

    public void apply(CodeStyleSettings settings) throws ConfigurationException {
        CodeStyleSettings modelSettings;
        if (settings == null) {
            return;
        }
        SqlCodeStyleSettings s = this.getSqlSettings(settings);
        if (!(settings instanceof CodeStyleSchemesModel.ModelSettings) && (modelSettings = this.getModelSettings()) != null && SqlCodeStyleSettingsUtil.settingsActuallyDifferent(s, this.getSqlSettings(modelSettings))) {
            s.manuallyChanged();
        }
        super.apply(settings);
        this.applyMainCheckboxesState(s);
        DatabaseSettings.fireSettingsChanged();
    }

    private void applyMainCheckboxesState(SqlCodeStyleSettings settings) {
        boolean selectedInherited = this.myInheritCb.isSelected() && !this.isGeneric();
        boolean selectedDisabled = this.myDisableCb.isSelected();
        settings.USE_GENERIC_STYLE = selectedInherited;
        settings.DISABLE_FORMATTING = selectedDisabled;
        this.updateControlsAbility(selectedInherited, selectedDisabled);
    }

    private void updateControlsAbility(boolean inherited, boolean disabled) {
        this.myDisableCb.setEnabled(!inherited);
        boolean disable = inherited || disabled;
        JComponent panel = super.getPanel();
        if (panel != null) {
            UIUtil.setEnabled((Component)panel, (!disable ? 1 : 0) != 0, (boolean)true);
        }
    }

    protected void initTabs(CodeStyleSettings settings) {
        this.myPanels = new ArrayList();
        this.myPanels.add((CodeStyleAbstractPanel)new CasePanel(settings));
        this.myPanels.add((CodeStyleAbstractPanel)new QueriesPanel(settings));
        this.myPanels.add((CodeStyleAbstractPanel)new DdlPanel(settings));
        this.myPanels.add((CodeStyleAbstractPanel)new CodePanel(settings));
        this.myPanels.add((CodeStyleAbstractPanel)new ExpressionsPanel(settings));
        this.myPanels.add((CodeStyleAbstractPanel)new SqlIndentOptionsWrapper(settings));
        this.myPanels.add((CodeStyleAbstractPanel)new SqlWrappingAndBracesPanel(settings));
        this.myPanels.add(new SqlCodeGenerationMainPanel(settings));
        for (CodeStyleAbstractPanel panel : this.myPanels) {
            this.addTab(panel);
        }
    }

    public boolean isModified(CodeStyleSettings settings) {
        return super.isModified(settings) || this.getSqlSettings((CodeStyleSettings)settings).USE_GENERIC_STYLE != this.myInheritCb.isSelected() || this.getSqlSettings((CodeStyleSettings)settings).DISABLE_FORMATTING != this.myDisableCb.isSelected();
    }

    protected void resetImpl(CodeStyleSettings settings) {
        super.resetImpl(settings);
        SqlCodeStyleSettings s = this.getSqlSettings(settings);
        this.myInheritCb.setSelected(s.USE_GENERIC_STYLE);
        this.myDisableCb.setSelected(s.DISABLE_FORMATTING);
    }

    public JComponent getPanel() {
        return this.myWrapper;
    }

    @NotNull
    private SqlCodeStyleSettings getSqlSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(1);
        }
        SqlCodeStyleSettings sqlCodeStyleSettings = (SqlCodeStyleSettings)settings.getCustomSettings(this.getSettingsClass());
        if (sqlCodeStyleSettings == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(2);
        }
        return sqlCodeStyleSettings;
    }

    protected PsiFile createFileFromText(Project project, String text2) {
        PsiFile previewFile = super.createFileFromText(project, text2);
        previewFile.setName(this.getPreviewDialect().getID() + "-preview.sql");
        return previewFile;
    }

    private EditorHighlighter createSqlHighlighter(EditorColorsScheme scheme) {
        SqlLanguageDialect dialect = this.getPreviewDialect();
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, null, null);
        return new LexerEditorHighlighter(highlighter, scheme);
    }

    protected void applyLanguageSettings(Language lang, CodeStyleSettings rootSettings, CodeStyleSettings targetSettings) {
        SqlCodeStyleSettings source = SqlCodeStyles.pickSqlSettings((CodeStyleSettings)rootSettings, (Language)lang);
        SqlCodeStyleSettings target2 = SqlCodeStyles.pickSqlSettings((CodeStyleSettings)targetSettings, (Language)this.getSettingLanguage());
        SqlCodeStyleSettingsUtil.copyCodeStyleSettings(source, target2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsLanguage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSqlSettings";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCheckBoxesListener
    implements ChangeListener {
        private MyCheckBoxesListener() {
        }

        @Override
        public void stateChanged(@NotNull ChangeEvent e) {
            CodeStyleSettings settingsContainer;
            if (e == null) {
                MyCheckBoxesListener.$$$reportNull$$$0(0);
            }
            if ((settingsContainer = SqlCodeStyleMainPanel.this.getModelSettings()) == null) {
                return;
            }
            SqlCodeStyleSettings settings = (SqlCodeStyleSettings)settingsContainer.getCustomSettings(SqlCodeStyleMainPanel.this.getSettingsClass());
            boolean selectedInherited = SqlCodeStyleMainPanel.this.myInheritCb.isSelected();
            boolean selectedDisabled = SqlCodeStyleMainPanel.this.myDisableCb.isSelected();
            if (settings.USE_GENERIC_STYLE == selectedInherited && settings.DISABLE_FORMATTING == selectedDisabled) {
                return;
            }
            SqlCodeStyleMainPanel.this.applyMainCheckboxesState(settings);
            SqlCodeStyleMainPanel.this.somethingChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$MyCheckBoxesListener", "stateChanged"));
        }
    }

    public class ExpressionsPanel
    extends OptionsPanel {
        private static final String CORTEGE = "Cortege";
        private static final String BINARY_EXPRESSION = "Binary expression";
        private static final String ROUTINE_CALL = "Function or procedure call";
        private static final String CASE_CLAUSE = "CASE clause";

        public ExpressionsPanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.EXPRESSIONS_SETTINGS;
        }

        protected void initTables() {
            this.showSqlCustomOption("CORTEGE_SPACE_BEFORE_L_PAREN", "Add space before `(`", CORTEGE);
            this.showSqlCustomOption("CORTEGE_SPACE_WITHIN_PARENTHESES", "Space within parentheses", CORTEGE);
            this.showSqlCustomOption("CORTEGE_COMMA_1ST", "Place comma to begin", CORTEGE);
            this.showSqlCustomOption("CORTEGE_SPACE_BEFORE_COMMA", "Space before comma", CORTEGE);
            this.showSqlCustomOption("CORTEGE_SPACE_AFTER_COMMA", "Space after comma", CORTEGE);
            this.showSqlCustomOption("EXPR_SPACE_AROUND_OPERATOR", "Use spaces around operators", BINARY_EXPRESSION, SqlCodeStyleConst.NAMES_DONT_CHANGE_YES_NO, SqlCodeStyleConst.VALUES_AS_IS_ADD_REMOVE);
            this.showSqlCustomOption("EXPR_BINARY_OP_ALIGN", "Align operands in binary expressions", BINARY_EXPRESSION);
            this.showSqlCustomOption("EXPR_SPACE_WITHIN_PARENTHESES", "Space within parenthesized sub-expressions", BINARY_EXPRESSION);
            this.showSqlCustomOption("EXPR_CALL_SPACE_INSIDE_PARENTHESES", "Space within parentheses", ROUTINE_CALL);
            this.showSqlCustomOption("EXPR_CALL_SPACE_BEFORE_COMMA", "Space before comma", ROUTINE_CALL);
            this.showSqlCustomOption("EXPR_CALL_SPACE_AFTER_COMMA", "Space after comma", ROUTINE_CALL);
            this.showSqlCustomOption("EXPR_CASE_WHEN_WRAP", "Wrap WHEN", CASE_CLAUSE);
            this.showSqlCustomOption("EXPR_CASE_WHEN_INDENT", "Indent WHEN if wrapped", CASE_CLAUSE);
            this.showSqlCustomOption("EXPR_CASE_THEN_WRAP", "Wrap THEN", CASE_CLAUSE);
            this.showSqlCustomOption("EXPR_CASE_THEN_ALIGN", "Align THEN", CASE_CLAUSE);
            this.showSqlCustomOption("EXPR_CASE_ELSE_ALIGN_THEN", "Align ELSE under THEN when THEN aligned", CASE_CLAUSE);
            this.showSqlCustomOption("EXPR_CASE_END", "Align END", CASE_CLAUSE, SqlCodeStyleConst.EXPR_CASE_END_ALIGN_NAMES, SqlCodeStyleConst.EXPR_CASE_END_ALIGN_VALUES);
            this.showSqlCustomOption("EXPR_CASE_KEEP_NL_AFTER_THEN", "Keep new line after THEN, ELSE", CASE_CLAUSE);
            this.showSqlCustomOption("EXPR_CASE_COLLAPSE", "Collapse short clause", CASE_CLAUSE);
        }

        protected String getTabTitle() {
            return "Expressions";
        }
    }

    public class CodePanel
    extends OptionsPanel {
        private static final String COMMON = "Common";
        private static final String DECLARE = "Declared variables";
        private static final String ROUTINE_ARG = "Routine arguments";
        private static final String ROUTINE_BLOCK = "Routine statement";
        private static final String FORK = "IF \u2026 THEN \u2026 ELSE";
        private static final String LOOP = "Loops";

        public CodePanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.CODE_SETTINGS;
        }

        protected void initTables() {
            this.showSqlCustomOption("IMP_COMMON_WRAP_EVERY_STATEMENT", "Wrap every statement", COMMON);
            this.showSqlCustomOption("IMP_COMMON_KEEP_BLANK_LINES_IN_CODE", "Keep blank lines in code", COMMON, INT_0_3_NAMES, INT_0_3_VALUES);
            this.showSqlCustomOption("NEW_LINE_AROUND_SEMICOLON", "Put new line around semicolon", COMMON);
            this.showSqlCustomOption("IMP_DECLARE_CONTENT_WRAP", "Wrap section", DECLARE);
            this.showSqlCustomOption("IMP_DECLARE_EL_WRAP", "Wrap variables", DECLARE, SqlCodeStyleConst.EL_WRAP_NAMES, SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption("IMP_DECLARE_ALIGN_TYPE", "Align types", DECLARE);
            this.showSqlCustomOption("IMP_DECLARE_ALIGN_EQ", "Align assignments", DECLARE);
            this.showSqlCustomOption("IMP_DECLARE_ALIGN_DEFAULT", "Align expressions", DECLARE);
            this.showSqlCustomOption("ROUTINE_ARG_OPENING", "Place the opening parenthesis", ROUTINE_ARG, SqlCodeStyleConst.OPENING_NAMES_CRT, SqlCodeStyleConst.OPENING_VALUES_CRT);
            this.showSqlCustomOption("ROUTINE_ARG_CONTENT", "Place elements", ROUTINE_ARG, SqlCodeStyleConst.CONTENT_NAMES, SqlCodeStyleConst.CONTENT_VALUES);
            this.showSqlCustomOption("ROUTINE_ARG_CLOSING", "Place the closing parenthesis", ROUTINE_ARG, SqlCodeStyleConst.CLOSING_NAMES_FROM_BEGIN, SqlCodeStyleConst.CLOSING_VALUES_FROM_BEGIN);
            this.showSqlCustomOption("ROUTINE_ARG_WRAP", "Wrap elements", ROUTINE_ARG, SqlCodeStyleConst.EL_WRAP_NAMES, SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption("ROUTINE_ARG_COMMA", "Place comma", ROUTINE_ARG, SqlCodeStyleConst.EL_COMMA_NAMES, SqlCodeStyleConst.EL_COMMA_VALUES);
            this.showSqlCustomOption("ROUTINE_ARG_SPACE_WITHIN_PARENTHESES", "Put spaces within parentheses", ROUTINE_ARG);
            this.showSqlCustomOption("ROUTINE_ARG_ALIGN_TYPES", "Align types", ROUTINE_ARG);
            this.showSqlCustomOption("ROUTINE_AS_WRAP", "Wrap AS", ROUTINE_BLOCK);
            this.showSqlCustomOption("ROUTINE_PG_L_QUOTE_WRAP_BEFORE", "Wrap opening $$", ROUTINE_BLOCK);
            this.showSqlCustomOption("ROUTINE_PG_L_QUOTE_WRAP_AFTER", "Wrap the content after opening $$", ROUTINE_BLOCK);
            this.showSqlCustomOption("ROUTINE_PG_R_QUOTE_WRAP_BEFORE", "Wrap before closing $$", ROUTINE_BLOCK);
            this.showSqlCustomOption("ROUTINE_PG_R_QUOTE_WRAP_AFTER", "Wrap options after closing $$", ROUTINE_BLOCK);
            this.showSqlCustomOption("IMP_IF_THEN_WRAP_THEN", "Wrap THEN", FORK);
            this.showSqlCustomOption("IMP_IF_THEN_WRAP_ELSE", "Wrap ELSE", FORK);
            this.showSqlCustomOption("IMP_IF_THEN_WRAP_INNER", "Wrap inner code", FORK);
            this.showSqlCustomOption("IMP_IF_THEN_INDENT_THEN_ELSE", "Indent THEN and ELSE", FORK);
            this.showSqlCustomOption("IMP_IF_THEN_INDENT_END", "Indent END IF", FORK);
            this.showSqlCustomOption("IMP_IF_THEN_COLLAPSE", "Collapse when short", FORK);
            this.showSqlCustomOption("IMP_LOOP_LOOP_WRAP", "Wrap LOOP", LOOP);
            this.showSqlCustomOption("IMP_LOOP_LOOP_INDENT", "Indent LOOP", LOOP);
            this.showSqlCustomOption("IMP_LOOP_END_INDENT", "Indent END LOOP", LOOP);
            this.showSqlCustomOption("IMP_LOOP_COLLAPSE", "Collapse when short", LOOP);
        }

        protected String getTabTitle() {
            return "Code";
        }
    }

    public class DdlPanel
    extends OptionsPanel {
        private static final String TABLE = "CREATE/ALTER TABLE";
        private static final String CREATE_SCHEMA = "CREATE SCHEMA";
        private static final String CONSTRAINT = "CONSTRAINT";
        private static final String VIEW = "Views";
        private static final String POSTFIX_OPTION = "Postfix options";

        public DdlPanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.DDL_SETTINGS;
        }

        protected void initTables() {
            this.showSqlCustomOption("TABLE_OPENING", "Place the opening parenthesis", TABLE, SqlCodeStyleConst.OPENING_NAMES_CRT, SqlCodeStyleConst.OPENING_VALUES_CRT);
            this.showSqlCustomOption("TABLE_CONTENT", "Place elements", TABLE, SqlCodeStyleConst.CONTENT_NAMES, SqlCodeStyleConst.CONTENT_VALUES);
            this.showSqlCustomOption("TABLE_CLOSING", "Place the closing parenthesis", TABLE, SqlCodeStyleConst.CLOSING_NAMES_FROM_BEGIN, SqlCodeStyleConst.CLOSING_VALUES_FROM_BEGIN);
            this.showSqlCustomOption("TABLE_TYPES_ALIGN", "Align types", TABLE);
            this.showSqlCustomOption("TABLE_DEFAULTS_ALIGN", "Align defaults", TABLE);
            this.showSqlCustomOption("TABLE_NULLABILITIES_ALIGN", "Align nullabilities", TABLE);
            this.showSqlCustomOption("TABLE_COLLAPSE", "Collapse when short", TABLE);
            this.showSqlCustomOption("TABLE_ALTER_INSTRUCTION_WRAP", "Wrap alter instructions", TABLE, SqlCodeStyleConst.NAMES_DONT_CHANGE_YES_NO, SqlCodeStyleConst.VALUES_AS_IS_ADD_REMOVE);
            this.showSqlCustomOption("TABLE_ALTER_INSTRUCTION_ALIGN", "Align alter instructions", TABLE);
            this.showSqlCustomOption("CONSTRAINT_WRAP_1", "Wrap CONSTRAINT", CONSTRAINT);
            this.showSqlCustomOption("CONSTRAINT_WRAP_2", "Wrap KEY/CHECK", CONSTRAINT);
            this.showSqlCustomOption("CONSTRAINT_WRAP_3", "Wrap REFERENCES", CONSTRAINT);
            this.showSqlCustomOption("CONSTRAINT_WRAP_4", "Wrap cascade and deferrability", CONSTRAINT);
            this.showSqlCustomOption("CREATE_SCHEMA_CONTENT_INDENT", "Indent content", CREATE_SCHEMA);
            this.showSqlCustomOption("CREATE_SCHEMA_BLANK_LINES_MIN", "Minimum blank lines between declaration", CREATE_SCHEMA, INT_0_3_NAMES, INT_0_3_VALUES);
            this.showSqlCustomOption("CREATE_SCHEMA_BLANK_LINES_MAX", "Maximum blank lines between declaration", CREATE_SCHEMA, INT_0_3_NAMES, INT_0_3_VALUES);
            this.showSqlCustomOption("VIEW_WRAP_AS", "Wrap AS", VIEW);
            this.showSqlCustomOption("VIEW_WRAP_QUERY", "Wrap the beginning of the query", VIEW);
            this.showSqlCustomOption("VIEW_INDENT_QUERY", "Indent query", VIEW);
            this.showSqlCustomOption("POST_OPT_WRAP_1", "Wrap first option", POSTFIX_OPTION);
            this.showSqlCustomOption("POST_OPT_WRAP_2", "Wrap next option", POSTFIX_OPTION);
            this.showSqlCustomOption("POST_OPT_INDENT", "Indent options", POSTFIX_OPTION);
            this.showSqlCustomOption("POST_OPT_ALIGN", "Align options", POSTFIX_OPTION);
        }

        protected String getTabTitle() {
            return "DDL";
        }
    }

    public class QueriesPanel
    extends OptionsPanel {
        private static final String SECTION_QUERY = "Common";
        private static final String SECTION_INSERT = "INSERT statement and VALUES clause";
        private static final String SECTION_SET = "UPDATE statement";
        private static final String SECTION_WITH = "WITH clause";
        private static final String SECTION_SELECT = "SELECT clause";
        private static final String SECTION_FROM = "FROM clause";
        private static final String SECTION_WHERE = "WHERE and HAVING clauses";
        private static final String SECTION_ORDER = "GROUP BY and ORDER BY clauses";
        private static final String SECTION_SUBQUERY = "Subquery";

        public QueriesPanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.QUERIES_SETTINGS;
        }

        protected void initTables() {
            this.showSqlCustomOption("QUERY_SECTION_1ST_WORD_ALIGN", "Align the first word of clause", SECTION_QUERY, SqlCodeStyleConst.QUERY_SECTION_1ST_WORD_ALIGN_NAMES, SqlCodeStyleConst.QUERY_SECTION_1ST_WORD_ALIGN_VALUES);
            this.showSqlCustomOption("QUERY_EL_LINE", "Place clause elements on", SECTION_QUERY, SqlCodeStyleConst.EL_COMMON_LINE_NAMES, SqlCodeStyleConst.EL_COMMON_LINE_VALUES);
            this.showSqlCustomOption("QUERY_EL_COMMA", "Place comma", SECTION_QUERY, SqlCodeStyleConst.EL_COMMA_NAMES, SqlCodeStyleConst.EL_COMMA_VALUES);
            this.showSqlCustomOption("QUERY_IN_ONE_STRING", "Collapse short statement", SECTION_QUERY, SqlCodeStyleConst.QUERY_IN_ONE_STRING_NAMES, SqlCodeStyleConst.QUERY_IN_ONE_STRING_VALUES);
            this.showSqlCustomOption("QUERY_TRUE_INDENT", "Keep section elements under section header", SECTION_QUERY);
            this.showSqlCustomOption("QUERY_ALIGN_ELEMENTS", "Align section elements", SECTION_QUERY);
            this.showSqlCustomOption("QUERY_ALIGN_LINE_COMMENTS", "Align line comments at right of elements", SECTION_QUERY);
            this.showSqlCustomOption("INSERT_INTO_NL", "Place INTO on the new line", SECTION_INSERT, SqlCodeStyleConst.NAMES_DONT_CHANGE_YES_NO, SqlCodeStyleConst.VALUES_AS_IS_ADD_REMOVE);
            this.showSqlCustomOption("INSERT_TABLE_EL_LINE", "Place INTO clause elements on", SECTION_INSERT, SqlCodeStyleConst.EL_SECTION_LINE_NAMES, SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption("INSERT_VALUES_EL_LINE", "Place VALUES clause elements (rows) on", SECTION_INSERT, SqlCodeStyleConst.EL_SECTION_LINE_NAMES, SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption("INSERT_OPENING", "Place the opening parenthesis", SECTION_INSERT, SqlCodeStyleConst.OPENING_NAMES_CRT, SqlCodeStyleConst.OPENING_VALUES_CRT);
            this.showSqlCustomOption("INSERT_CONTENT", "Place columns or values", SECTION_INSERT, SqlCodeStyleConst.CONTENT_NAMES, SqlCodeStyleConst.CONTENT_VALUES);
            this.showSqlCustomOption("INSERT_CLOSING", "Place the closing parenthesis", SECTION_INSERT, SqlCodeStyleConst.CLOSING_NAMES_FROM_BEGIN, SqlCodeStyleConst.CLOSING_VALUES_FROM_BEGIN);
            this.showSqlCustomOption("INSERT_EL_WRAP", "Wrap columns or values", SECTION_INSERT, SqlCodeStyleConst.EL_WRAP_NAMES, SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption("INSERT_EL_COMMA", "Place comma", SECTION_INSERT, SqlCodeStyleConst.EL_COMMA_NAMES_C, SqlCodeStyleConst.EL_COMMA_VALUES_C);
            this.showSqlCustomOption("INSERT_SPACE_WITHIN_PARENTHESES", "Put spaces within parentheses", SECTION_INSERT);
            this.showSqlCustomOption("INSERT_COLLAPSE_MULTI_ROW_VALUES", "Collapse short multi-row values", SECTION_INSERT);
            this.showSqlCustomOption("SET_EL_LINE", "Place elements on", SECTION_SET, SqlCodeStyleConst.EL_SECTION_LINE_NAMES, SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption("SET_EL_WRAP", "Wrap elements", SECTION_SET, SqlCodeStyleConst.EL_WRAP_NAMES, SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption("SET_EL_COMMA", "Place comma", SECTION_SET, SqlCodeStyleConst.EL_COMMA_NAMES_C, SqlCodeStyleConst.EL_COMMA_VALUES_C);
            this.showSqlCustomOption("SET_ALIGN_EQUAL_SIGN", "Align `=`", SECTION_SET);
            this.showSqlCustomOption("WITH_EL_LINE", "Place elements on", SECTION_WITH, SqlCodeStyleConst.EL_SECTION_LINE_NAMES, SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption("WITH_EL_WRAP", "Wrap subqueries", SECTION_WITH, SqlCodeStyleConst.EL_WRAP_NAMES_2, SqlCodeStyleConst.EL_WRAP_VALUES_2);
            this.showSqlCustomOption("WITH_EL_COMMA", "Place comma", SECTION_WITH, SqlCodeStyleConst.EL_COMMA_NAMES_M, SqlCodeStyleConst.EL_COMMA_VALUES_M);
            this.showSqlCustomOption("WITH_ALIGN_AS", "Align AS", SECTION_WITH);
            this.showSqlCustomOption("SELECT_EL_LINE", "Place elements on", SECTION_SELECT, SqlCodeStyleConst.EL_SECTION_LINE_NAMES, SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption("SELECT_EL_WRAP", "Wrap elements", SECTION_SELECT, SqlCodeStyleConst.EL_WRAP_NAMES, SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption("SELECT_EL_COMMA", "Place comma", SECTION_SELECT, SqlCodeStyleConst.EL_COMMA_NAMES_C, SqlCodeStyleConst.EL_COMMA_VALUES_C);
            this.showSqlCustomOption("SELECT_NEW_LINE_AFTER_ALL_DISTINCT", "New line after ALL, DISTINCT", SECTION_SELECT);
            this.showSqlCustomOption("SELECT_KEEP_N_ITEMS_IN_LINE", "Keep elements on one line if \u2264", SECTION_SELECT, SqlCodeStyleConst.SELECT_KEEP_N_ITEMS_IN_LINE_NAMES, SqlCodeStyleConst.SELECT_KEEP_N_ITEMS_IN_LINE_VALUES);
            this.showSqlCustomOption("SELECT_USE_AS_WORD", "Use AS", SECTION_SELECT, SqlCodeStyleConst.SELECT_USE_AS_NAMES, SqlCodeStyleConst.SELECT_USE_AS_VALUES);
            this.showSqlCustomOption("SELECT_ALIGN_AS", "Align AS", SECTION_SELECT);
            this.showSqlCustomOption("FROM_EL_LINE", "Place elements on", SECTION_FROM, SqlCodeStyleConst.EL_SECTION_LINE_NAMES, SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption("FROM_EL_WRAP", "Wrap elements", SECTION_FROM, SqlCodeStyleConst.EL_WRAP_NAMES, SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption("FROM_EL_COMMA", "Place comma", SECTION_FROM, SqlCodeStyleConst.EL_COMMA_NAMES_C, SqlCodeStyleConst.EL_COMMA_VALUES_C);
            this.showSqlCustomOption("FROM_WRAP_JOIN_1", "Wrap the first JOIN", SECTION_FROM);
            this.showSqlCustomOption("FROM_WRAP_JOIN_2", "Wrap the next JOIN", SECTION_FROM);
            this.showSqlCustomOption("FROM_INDENT_JOIN", "Indent JOIN", SECTION_FROM);
            this.showSqlCustomOption("FROM_ONLY_JOIN_INDENT", "Place JOIN in join-only queries under", SECTION_FROM, SqlCodeStyleConst.FROM_ONLY_JOIN_INDENT_NAMES, SqlCodeStyleConst.FROM_ONLY_JOIN_INDENT_VALUES);
            this.showSqlCustomOption("FROM_ALIGN_JOIN_TABLES", "Align joined tables", SECTION_FROM);
            this.showSqlCustomOption("FROM_ALIGN_ALIASES", "Align table aliases", SECTION_FROM);
            this.showSqlCustomOption("FROM_WRAP_ON", "Wrap ON/USING", SECTION_FROM);
            this.showSqlCustomOption("FROM_PLACE_ON", "Place ON/USING under", SECTION_FROM, SqlCodeStyleConst.FROM_PLACE_ON_NAMES, SqlCodeStyleConst.FROM_PLACE_ON_VALUES);
            this.showSqlCustomOption("WHERE_EL_LINE", "Place elements on", SECTION_WHERE, SqlCodeStyleConst.EL_SECTION_LINE_NAMES, SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption("WHERE_EL_WRAP", "Wrap elements", SECTION_WHERE, SqlCodeStyleConst.EL_WRAP_NAMES, SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption("WHERE_EL_BOUND", "Place top-level AND/OR", SECTION_WHERE, SqlCodeStyleConst.EL_COMMA_NAMES, SqlCodeStyleConst.EL_COMMA_VALUES);
            this.showSqlCustomOption("ORDER_EL_LINE", "Place elements on", SECTION_ORDER, SqlCodeStyleConst.EL_SECTION_LINE_NAMES, SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption("ORDER_EL_WRAP", "Wrap elements", SECTION_ORDER, SqlCodeStyleConst.EL_WRAP_NAMES, SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption("ORDER_EL_COMMA", "Place comma", SECTION_ORDER, SqlCodeStyleConst.EL_COMMA_NAMES_C, SqlCodeStyleConst.EL_COMMA_VALUES_C);
            this.showSqlCustomOption("ORDER_ALIGN_ASC_DESC", "Align ASC/DESC", SECTION_ORDER);
            this.showSqlCustomOption("SUBQUERY_OPENING", "Place the opening parenthesis", SECTION_SUBQUERY, SqlCodeStyleConst.OPENING_NAMES_CRT, SqlCodeStyleConst.OPENING_VALUES_CRT);
            this.showSqlCustomOption("SUBQUERY_CONTENT", "Place subquery", SECTION_SUBQUERY, SqlCodeStyleConst.CONTENT_NAMES, SqlCodeStyleConst.CONTENT_VALUES);
            this.showSqlCustomOption("SUBQUERY_CLOSING", "Place the closing parenthesis", SECTION_SUBQUERY, SqlCodeStyleConst.CLOSING_NAMES_EGYPT, SqlCodeStyleConst.CLOSING_VALUES_EGYPT);
            this.showSqlCustomOption("SUBQUERY_PAR_SPACE_INSIDE", "Put spaces within parentheses", SECTION_SUBQUERY);
        }

        protected String getTabTitle() {
            return "Queries";
        }
    }

    public class CasePanel
    extends OptionsPanel {
        private static final String CASE_OPTIONS = "Word Case";
        private static final String QUOTATION_OPTIONS = "Quotation";

        public CasePanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.CASE_SETTINGS;
        }

        protected void initTables() {
            this.showSqlCustomOption("KEYWORD_CASE", "Keywords", CASE_OPTIONS, SqlCodeStyleConst.TOKEN_CASE_NAMES, SqlCodeStyleConst.TOKEN_CASE);
            this.showSqlCustomOption("TYPE_CASE", "Types", CASE_OPTIONS, SqlCodeStyleConst.TOKEN_CASE_NAMES_EXT, SqlCodeStyleConst.TOKEN_CASE_EXT);
            this.showSqlCustomOption("IDENTIFIER_CASE", "Identifiers", CASE_OPTIONS, SqlCodeStyleConst.TOKEN_CASE_NAMES, SqlCodeStyleConst.TOKEN_CASE);
            this.showSqlCustomOption("ALIAS_CASE", "Aliases", CASE_OPTIONS, SqlCodeStyleConst.ALIAS_CASE_NAMES, SqlCodeStyleConst.ALIAS_CASE_EXT);
            this.showSqlCustomOption("QUOTED_IDENTIFIER_CASE", "Quoted identifiers", CASE_OPTIONS, SqlCodeStyleConst.TOKEN_CASE_NAMES, SqlCodeStyleConst.TOKEN_CASE);
            this.showSqlCustomOption("QUOTE_IDENTIFIER", "Identifier quotation", QUOTATION_OPTIONS, SqlCodeStyleConst.QUOTE_OPTIONS_NAMES, SqlCodeStyleConst.QUOTE_OPTIONS);
        }

        protected String getTabTitle() {
            return "Case";
        }
    }

    public abstract class OptionsPanel
    extends OptionTableWithPreviewPanel
    implements SqlSettingsPanel {
        public OptionsPanel(CodeStyleSettings settings) {
            super(settings);
            this.init();
        }

        @Override
        public abstract SqlCodeStyleSettingsType getType();

        public Language getDefaultLanguage() {
            return SqlCodeStyleMainPanel.this.getPreviewDialect();
        }

        public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
            SqlCodeStyleSettingsType type = this.getType();
            return type.commonType != null ? type.commonType : LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC;
        }

        protected void customizeSettings() {
            this.resetDefaultNames();
        }

        private boolean isSettingHidden(@NotNull String settingName) {
            if (settingName == null) {
                OptionsPanel.$$$reportNull$$$0(0);
            }
            return ((SqlCodeStyleSettings)this.getSettings().getCustomSettings(SqlCodeStyleMainPanel.this.getSettingsClass())).isSettingHidden(settingName);
        }

        protected void showSqlCustomOption(String fieldName, String title, String groupName) {
            if (this.isSettingHidden(fieldName)) {
                return;
            }
            SqlCodeStyleMainPanel.this.getSettingsClass();
            this.showCustomOption(SqlCodeStyleMainPanel.this.getSettingsClass(), fieldName, title, groupName, new Object[0]);
        }

        protected void showSqlCustomOption(String fieldName, String title, String groupName, String[] names, int[] values2) {
            if (this.isSettingHidden(fieldName)) {
                return;
            }
            SqlCodeStyleMainPanel.this.getSettingsClass();
            this.showCustomOption(SqlCodeStyleMainPanel.this.getSettingsClass(), fieldName, title, groupName, new Object[]{names, values2});
        }

        protected String getPreviewText() {
            return SqlPreviewExamples.read((Language)SqlCodeStyleMainPanel.this.getPreviewDialect(), this.getType());
        }

        protected PsiFile createFileFromText(Project project, String text2) {
            return SqlCodeStyleMainPanel.this.createFileFromText(project, text2);
        }

        @Override
        public void updatePreviewText(@NotNull String text2) {
            if (text2 == null) {
                OptionsPanel.$$$reportNull$$$0(1);
            }
            this.setEditorText(text2, SqlCodeStyleMainPanel.this.isGeneric());
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.this.createSqlHighlighter(scheme);
        }

        public void apply(CodeStyleSettings settings) throws ConfigurationException {
            super.apply(settings);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settingName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$OptionsPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSettingHidden";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePreviewText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SqlWrappingAndBracesPanel
    extends TabbedLanguageCodeStylePanel.MyWrappingAndBracesPanel
    implements SqlSettingsPanel {
        protected String getTabTitle() {
            return "Wrapping";
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.WRAPPING_SETTINGS;
        }

        protected String getPreviewText() {
            return SqlPreviewExamples.read((Language)SqlCodeStyleMainPanel.this.getPreviewDialect(), this.getType());
        }

        protected int getRightMargin() {
            return 80;
        }

        SqlWrappingAndBracesPanel(CodeStyleSettings settings) {
            super((TabbedLanguageCodeStylePanel)SqlCodeStyleMainPanel.this, settings);
        }

        @Override
        public void updatePreviewText(@NotNull String text2) {
            if (text2 == null) {
                SqlWrappingAndBracesPanel.$$$reportNull$$$0(0);
            }
            this.setEditorText(text2, SqlCodeStyleMainPanel.this.isGeneric());
        }

        protected PsiFile createFileFromText(Project project, String text2) {
            return SqlCodeStyleMainPanel.this.createFileFromText(project, text2);
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.this.createSqlHighlighter(scheme);
        }

        protected void initTables() {
            this.addOption("KEEP_LINE_BREAKS", ApplicationBundle.message((String)"wrapping.keep.line.breaks", (Object[])new Object[0]), WRAPPING_KEEP);
            this.addOption("KEEP_FIRST_COLUMN_COMMENT", ApplicationBundle.message((String)"wrapping.keep.comment.at.first.column", (Object[])new Object[0]), WRAPPING_KEEP);
            this.showStandardOptions(new String[]{"KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT"});
        }

        protected void customizeSettings() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$SqlWrappingAndBracesPanel", "updatePreviewText"));
        }
    }

    private class SqlIndentOptionsWrapper
    extends TabbedLanguageCodeStylePanel.MyIndentOptionsWrapper
    implements SqlSettingsPanel {
        protected SqlIndentOptionsWrapper(CodeStyleSettings settings) {
            super((TabbedLanguageCodeStylePanel)SqlCodeStyleMainPanel.this, settings, (IndentOptionsEditor)new SmartIndentOptionsEditor());
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.INDENT_SETTINGS;
        }

        protected String getPreviewText() {
            return SqlPreviewExamples.read((Language)SqlCodeStyleMainPanel.this.getPreviewDialect(), this.getType());
        }

        @Override
        public void updatePreviewText(@NotNull String text2) {
            if (text2 == null) {
                SqlIndentOptionsWrapper.$$$reportNull$$$0(0);
            }
            this.setEditorText(text2, SqlCodeStyleMainPanel.this.isGeneric());
        }

        protected PsiFile createFileFromText(Project project, String text2) {
            return SqlCodeStyleMainPanel.this.createFileFromText(project, text2);
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.this.createSqlHighlighter(scheme);
        }

        protected CommonCodeStyleSettings.IndentOptions getIndentOptions(CodeStyleSettings settings) {
            return SqlCodeStyleMainPanel.this.getSqlSettings(settings).getCorrespondedIndentOptions();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$SqlIndentOptionsWrapper", "updatePreviewText"));
        }
    }

    protected static interface SqlSettingsPanel {
        public SqlCodeStyleSettingsType getType();

        public void updatePreviewText(@NotNull String var1);
    }
}

