/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModelDumper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.sql.formatter.model.PgRoutineInjectedBodyBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlInjectionRootBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlPgRoutineBlock;
import com.intellij.sql.formatter.model.SqlRealRootBlock;
import com.intellij.sql.formatter.model.SqlRootBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB?\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/intellij/sql/formatter/model/SqlFormattingModelMaker;", "", "text", "", "file", "Lcom/intellij/psi/PsiFile;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "mode", "Lcom/intellij/formatting/FormattingMode;", "interestingRange", "Lcom/intellij/openapi/util/TextRange;", "(Ljava/lang/CharSequence;Lcom/intellij/psi/PsiFile;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/formatting/FormattingMode;Lcom/intellij/openapi/util/TextRange;)V", "settingsClass", "Ljava/lang/Class;", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "(Ljava/lang/CharSequence;Lcom/intellij/psi/PsiFile;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Ljava/lang/Class;Lcom/intellij/formatting/FormattingMode;Lcom/intellij/openapi/util/TextRange;)V", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "getContext", "()Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "dumpIfNeeded", "", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "makeDomesticSubModel", "injectionHostBlock", "node", "Lcom/intellij/lang/ASTNode;", "makeModel", "Lcom/intellij/sql/formatter/model/SqlRootBlock;", "rootNode", "Companion", "intellij.database.sql.impl"})
public final class SqlFormattingModelMaker {
    @NotNull
    private final SqlFormattingContext context;
    private static boolean holdLastModelDump;
    @Nullable
    private static String theLastModelDump;
    public static final Companion Companion;

    @NotNull
    public final SqlFormattingContext getContext() {
        return this.context;
    }

    @NotNull
    public final SqlRootBlock makeModel(@NotNull ASTNode rootNode) {
        Intrinsics.checkParameterIsNotNull((Object)rootNode, (String)"rootNode");
        theLastModelDump = null;
        boolean injected = rootNode.getPsi().getUserData(FileContextUtil.INJECTED_IN_ELEMENT) != null;
        SqlRootBlock rootBlock = injected ? (SqlRootBlock)new SqlInjectionRootBlock() : (SqlRootBlock)new SqlRealRootBlock();
        rootBlock.setup$intellij_database_sql_impl(this.context, rootNode);
        if (this.context.getReformatting()) {
            rootBlock.grow();
            rootBlock.analyze();
            rootBlock.refine();
        }
        this.dumpIfNeeded(rootBlock);
        return rootBlock;
    }

    @NotNull
    public final SqlBlock makeDomesticSubModel(@NotNull SqlBlock injectionHostBlock, @NotNull ASTNode node) {
        SqlBlock sqlBlock;
        Intrinsics.checkParameterIsNotNull((Object)injectionHostBlock, (String)"injectionHostBlock");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (injectionHostBlock.getParent() instanceof SqlPgRoutineBlock) {
            SqlNodeBlock $this$withSetup$iv = new PgRoutineInjectedBodyBlock();
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup$intellij_database_sql_impl(injectionHostBlock, node);
            sqlBlock = $this$withSetup$iv;
        } else {
            sqlBlock = SqlFormattingModelFunKt.makeDefaultBlock(injectionHostBlock, node);
        }
        SqlBlock block = sqlBlock;
        return block;
    }

    private final void dumpIfNeeded(SqlBlock block) {
        if (holdLastModelDump) {
            holdLastModelDump = false;
            theLastModelDump = FormattingModelDumper.dumpFormattingModelToString((Block)block);
        }
    }

    public SqlFormattingModelMaker(@NotNull CharSequence text2, @NotNull PsiFile file, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode, @NotNull TextRange interestingRange) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        Intrinsics.checkParameterIsNotNull((Object)interestingRange, (String)"interestingRange");
        Class clazz = SqlCodeStyles.getSettingsClass((Language)file.getLanguage());
        Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"SqlCodeStyles.getSettingsClass(file.language)");
        Class settingsClass = clazz;
        this.context = new SqlFormattingContext(text2, file, settings, settingsClass, mode, interestingRange);
    }

    public SqlFormattingModelMaker(@NotNull CharSequence text2, @NotNull PsiFile file, @NotNull CodeStyleSettings settings, @NotNull Class<? extends SqlCodeStyleSettings> settingsClass, @NotNull FormattingMode mode, @NotNull TextRange interestingRange) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull(settingsClass, (String)"settingsClass");
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        Intrinsics.checkParameterIsNotNull((Object)interestingRange, (String)"interestingRange");
        this.context = new SqlFormattingContext(text2, file, settings, settingsClass, mode, interestingRange);
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/formatter/model/SqlFormattingModelMaker$Companion;", "", "()V", "holdLastModelDump", "", "getHoldLastModelDump", "()Z", "setHoldLastModelDump", "(Z)V", "theLastModelDump", "", "getTheLastModelDump", "()Ljava/lang/String;", "setTheLastModelDump", "(Ljava/lang/String;)V", "intellij.database.sql.impl"})
    public static final class Companion {
        public final boolean getHoldLastModelDump() {
            return holdLastModelDump;
        }

        public final void setHoldLastModelDump(boolean bl) {
            holdLastModelDump = bl;
        }

        @Nullable
        public final String getTheLastModelDump() {
            return theLastModelDump;
        }

        public final void setTheLastModelDump(@Nullable String string) {
            theLastModelDump = string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

