/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.database.Dbms;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.StringFun;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext$WhenMappings;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlFile;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\"\u0010D\u001a\u00020>2\u0006\u0010E\u001a\u00020F2\b\b\u0002\u0010G\u001a\u00020 2\b\b\u0002\u0010H\u001a\u00020 J \u0010D\u001a\u00020>2\u0006\u0010E\u001a\u00020F2\b\b\u0002\u0010G\u001a\u00020 2\u0006\u0010I\u001a\u00020.J\"\u0010D\u001a\u00020>2\u0006\u0010J\u001a\u00020.2\b\b\u0002\u0010G\u001a\u00020 2\b\b\u0002\u0010H\u001a\u00020 J\u0006\u0010K\u001a\u00020.J\b\u0010L\u001a\u00020.H\u0002J\u0011\u0010M\u001a\u00020 2\u0006\u0010N\u001a\u00020OH\u0086\u0004J\u000e\u0010P\u001a\u00020 2\u0006\u0010E\u001a\u00020FJ\u000e\u0010P\u001a\u00020 2\u0006\u0010J\u001a\u00020.J\u0010\u0010Q\u001a\u00020R2\b\b\u0002\u0010S\u001a\u00020 J\u0010\u0010T\u001a\u00020R2\b\b\u0002\u0010U\u001a\u00020 J\u0006\u0010V\u001a\u00020RJ\u0010\u0010W\u001a\u00020R2\b\b\u0002\u0010S\u001a\u00020 J\u0010\u0010X\u001a\u00020R2\b\b\u0002\u0010S\u001a\u00020 J*\u0010Y\u001a\u00020R2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u000e2\b\b\u0002\u0010U\u001a\u00020 2\b\b\u0002\u0010S\u001a\u00020 J\u0010\u0010]\u001a\u00020R2\b\b\u0002\u0010U\u001a\u00020 J\u0018\u0010]\u001a\u00020R2\b\b\u0002\u0010U\u001a\u00020 2\u0006\u0010S\u001a\u00020 J\u0016\u0010^\u001a\u00020 2\u0006\u0010\\\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020`J\u001e\u0010^\u001a\u00020 2\u0006\u0010a\u001a\u00020.2\u0006\u0010b\u001a\u00020.2\u0006\u0010_\u001a\u00020`J\u001e\u0010c\u001a\u00020 2\u0006\u0010d\u001a\u00020F2\u0006\u0010e\u001a\u00020F2\u0006\u0010_\u001a\u00020`J\u001e\u0010c\u001a\u00020 2\u0006\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020g2\u0006\u0010_\u001a\u00020`R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R'\u0010\u0018\u001a\u0018\u0012\u0006\b\u0001\u0012\u00020\u001a\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\"R\u0011\u0010)\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\"R\u0011\u0010+\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\"R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00100R\u0011\u00103\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00100R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u00107\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\"R\u0019\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010?\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010C\u00a8\u0006i"}, d2={"Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "", "text", "", "file", "Lcom/intellij/psi/PsiFile;", "settingsContainer", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "settingsClass", "Ljava/lang/Class;", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "mode", "Lcom/intellij/formatting/FormattingMode;", "interestingRange", "Lcom/intellij/openapi/util/TextRange;", "(Ljava/lang/CharSequence;Lcom/intellij/psi/PsiFile;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Ljava/lang/Class;Lcom/intellij/formatting/FormattingMode;Lcom/intellij/openapi/util/TextRange;)V", "com", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "getCom", "()Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialect;", "dialectSpecificBlocks", "", "Lcom/intellij/psi/tree/IElementType;", "Lkotlin/reflect/KClass;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getDialectSpecificBlocks", "()Ljava/util/Map;", "disabled", "", "getDisabled", "()Z", "getFile", "()Lcom/intellij/psi/PsiFile;", "getInterestingRange", "()Lcom/intellij/openapi/util/TextRange;", "justAdjust", "getJustAdjust", "klb", "getKlb", "knownDialect", "getKnownDialect", "lengthThresholdMax", "", "getLengthThresholdMax", "()I", "lengthThresholdMin", "getLengthThresholdMin", "margin", "getMargin", "getMode", "()Lcom/intellij/formatting/FormattingMode;", "reformatting", "getReformatting", "getSettingsClass", "()Ljava/lang/Class;", "getSettingsContainer", "()Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "singleIndent", "", "sql", "getSql", "()Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "getText", "()Ljava/lang/CharSequence;", "currIndentOf", "block", "Lcom/intellij/formatting/Block;", "absolute", "plus", "plusSpaces", "offset", "getIndentSize", "getRightMargin", "isDialect", "dbms", "Lcom/intellij/database/Dbms;", "isInPosition1", "makeAutoSpacing", "Lcom/intellij/formatting/Spacing;", "keepLB", "makeBreak", "space", "makeBreakSafeSpace", "makeNoSpace", "makeSafeSpacing", "makeSmartSpacing", "shape", "Lcom/intellij/sql/formatter/model/BlockShape;", "range", "makeSpace", "textContains", "char", "", "from", "till", "textContainsBetween", "block1", "block2", "node1", "Lcom/intellij/lang/ASTNode;", "node2", "intellij.database.sql.impl"})
public final class SqlFormattingContext {
    @NotNull
    private final SqlLanguageDialect dialect;
    private final boolean knownDialect;
    @NotNull
    private final SqlCodeStyleSettings sql;
    @NotNull
    private final CommonCodeStyleSettings com;
    private final boolean disabled;
    private final boolean reformatting;
    private final boolean justAdjust;
    private final int margin;
    private final boolean klb;
    private final int lengthThresholdMin;
    private final int lengthThresholdMax;
    @NotNull
    private final Map<? extends IElementType, KClass<? extends SqlBlock>> dialectSpecificBlocks;
    private final String singleIndent;
    @NotNull
    private final CharSequence text;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final CodeStyleSettings settingsContainer;
    @NotNull
    private final Class<? extends SqlCodeStyleSettings> settingsClass;
    @NotNull
    private final FormattingMode mode;
    @NotNull
    private final TextRange interestingRange;

    @NotNull
    public final SqlLanguageDialect getDialect() {
        return this.dialect;
    }

    public final boolean getKnownDialect() {
        return this.knownDialect;
    }

    @NotNull
    public final SqlCodeStyleSettings getSql() {
        return this.sql;
    }

    @NotNull
    public final CommonCodeStyleSettings getCom() {
        return this.com;
    }

    public final boolean getDisabled() {
        return this.disabled;
    }

    public final boolean getReformatting() {
        return this.reformatting;
    }

    public final boolean getJustAdjust() {
        return this.justAdjust;
    }

    public final int getMargin() {
        return this.margin;
    }

    public final boolean getKlb() {
        return this.klb;
    }

    public final int getLengthThresholdMin() {
        return this.lengthThresholdMin;
    }

    public final int getLengthThresholdMax() {
        return this.lengthThresholdMax;
    }

    @NotNull
    public final Map<? extends IElementType, KClass<? extends SqlBlock>> getDialectSpecificBlocks() {
        return this.dialectSpecificBlocks;
    }

    public final boolean textContainsBetween(@NotNull Block block1, @NotNull Block block2, char c2) {
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        TextRange textRange = block1.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"block1.textRange");
        int n = textRange.getEndOffset();
        TextRange textRange2 = block2.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"block2.textRange");
        return this.textContains(n, textRange2.getStartOffset(), c2);
    }

    public final boolean textContainsBetween(@NotNull ASTNode node1, @NotNull ASTNode node2, char c2) {
        Intrinsics.checkParameterIsNotNull((Object)node1, (String)"node1");
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node2");
        TextRange textRange = node1.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"node1.textRange");
        return this.textContains(textRange.getEndOffset(), node2.getStartOffset(), c2);
    }

    public final boolean textContains(@NotNull TextRange range, char c2) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        return this.textContains(range.getStartOffset(), range.getEndOffset(), c2);
    }

    public final boolean textContains(int from, int till, char c2) {
        if (from >= till) {
            return false;
        }
        return StringUtil.contains((CharSequence)this.text, (int)from, (int)till, (char)c2);
    }

    @NotNull
    public final Spacing makeBreak(boolean space) {
        Spacing spacing = Spacing.createSpacing((int)SqlUtilFun.toInt(space), (int)SqlUtilFun.toInt(space), (int)1, (boolean)true, (int)this.sql.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE);
        Intrinsics.checkExpressionValueIsNotNull((Object)spacing, (String)"Spacing.createSpacing(sp\u2026KEEP_BLANK_LINES_IN_CODE)");
        return spacing;
    }

    public static /* synthetic */ Spacing makeBreak$default(SqlFormattingContext sqlFormattingContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return sqlFormattingContext.makeBreak(bl);
    }

    @NotNull
    public final Spacing makeBreakSafeSpace() {
        Spacing spacing = Spacing.createSpacing((int)0, (int)1, (int)1, (boolean)true, (int)this.sql.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE);
        Intrinsics.checkExpressionValueIsNotNull((Object)spacing, (String)"Spacing.createSpacing(0,\u2026KEEP_BLANK_LINES_IN_CODE)");
        return spacing;
    }

    @NotNull
    public final Spacing makeAutoSpacing(boolean keepLB) {
        Spacing spacing = Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)keepLB, (int)(keepLB ? this.sql.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE : 0));
        Intrinsics.checkExpressionValueIsNotNull((Object)spacing, (String)"Spacing.createSpacing(0,\u2026ANK_LINES_IN_CODE else 0)");
        return spacing;
    }

    public static /* synthetic */ Spacing makeAutoSpacing$default(SqlFormattingContext sqlFormattingContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = sqlFormattingContext.klb;
        }
        return sqlFormattingContext.makeAutoSpacing(bl);
    }

    @NotNull
    public final Spacing makeSafeSpacing(boolean keepLB) {
        Spacing spacing = Spacing.createSafeSpacing((boolean)keepLB, (int)(keepLB ? this.sql.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE : 0));
        Intrinsics.checkExpressionValueIsNotNull((Object)spacing, (String)"Spacing.createSafeSpacin\u2026ANK_LINES_IN_CODE else 0)");
        return spacing;
    }

    public static /* synthetic */ Spacing makeSafeSpacing$default(SqlFormattingContext sqlFormattingContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = sqlFormattingContext.klb;
        }
        return sqlFormattingContext.makeSafeSpacing(bl);
    }

    @NotNull
    public final Spacing makeSpace(boolean space) {
        Spacing spacing = Spacing.createSpacing((int)SqlUtilFun.toInt(space), (int)SqlUtilFun.toInt(space), (int)0, (boolean)this.klb, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)spacing, (String)"Spacing.createSpacing(sp\u2026space.toInt(), 0, klb, 0)");
        return spacing;
    }

    public static /* synthetic */ Spacing makeSpace$default(SqlFormattingContext sqlFormattingContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return sqlFormattingContext.makeSpace(bl);
    }

    @NotNull
    public final Spacing makeSpace(boolean space, boolean keepLB) {
        Spacing spacing = Spacing.createSpacing((int)SqlUtilFun.toInt(space), (int)SqlUtilFun.toInt(space), (int)0, (boolean)keepLB, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)spacing, (String)"Spacing.createSpacing(sp\u2026ce.toInt(), 0, keepLB, 0)");
        return spacing;
    }

    public static /* synthetic */ Spacing makeSpace$default(SqlFormattingContext sqlFormattingContext, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return sqlFormattingContext.makeSpace(bl, bl2);
    }

    @NotNull
    public final Spacing makeNoSpace(boolean keepLB) {
        Spacing spacing = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)keepLB, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)spacing, (String)"Spacing.createSpacing(0, 0, 0, keepLB, 0)");
        return spacing;
    }

    public static /* synthetic */ Spacing makeNoSpace$default(SqlFormattingContext sqlFormattingContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = sqlFormattingContext.klb;
        }
        return sqlFormattingContext.makeNoSpace(bl);
    }

    @NotNull
    public final Spacing makeSmartSpacing(@NotNull BlockShape shape, @NotNull TextRange range, boolean space, boolean keepLB) {
        Spacing spacing;
        Intrinsics.checkParameterIsNotNull((Object)((Object)shape), (String)"shape");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        switch (SqlFormattingContext$WhenMappings.$EnumSwitchMapping$0[shape.ordinal()]) {
            case 1: {
                spacing = this.makeSpace(space);
                break;
            }
            case 2: {
                Spacing spacing2 = Spacing.createDependentLFSpacing((int)SqlUtilFun.toInt(space), (int)SqlUtilFun.toInt(space), (TextRange)range, (boolean)keepLB, (int)0);
                spacing = spacing2;
                Intrinsics.checkExpressionValueIsNotNull((Object)spacing2, (String)"Spacing.createDependentL\u2026oInt(), range, keepLB, 0)");
                break;
            }
            case 3: {
                spacing = SqlFormattingContext.makeBreak$default(this, false, 1, null);
                break;
            }
            default: {
                spacing = this.makeAutoSpacing(true);
            }
        }
        return spacing;
    }

    public static /* synthetic */ Spacing makeSmartSpacing$default(SqlFormattingContext sqlFormattingContext, BlockShape blockShape, TextRange textRange, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = sqlFormattingContext.klb;
        }
        return sqlFormattingContext.makeSmartSpacing(blockShape, textRange, bl, bl2);
    }

    @NotNull
    public final String currIndentOf(@NotNull Block block, boolean absolute, int plusSpaces) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        StringBuilder stringBuilder = new StringBuilder();
        TextRange textRange = block.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"block.textRange");
        return stringBuilder.append(this.currIndentOf(textRange.getStartOffset(), absolute, false)).append(StringFun.replicate$default(" ", plusSpaces, null, null, 6, null)).toString();
    }

    public static /* synthetic */ String currIndentOf$default(SqlFormattingContext sqlFormattingContext, Block block, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return sqlFormattingContext.currIndentOf(block, bl, n);
    }

    @NotNull
    public final String currIndentOf(@NotNull Block block, boolean absolute, boolean plus2) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        TextRange textRange = block.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"block.textRange");
        return this.currIndentOf(textRange.getStartOffset(), absolute, plus2);
    }

    public static /* synthetic */ String currIndentOf$default(SqlFormattingContext sqlFormattingContext, Block block, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return sqlFormattingContext.currIndentOf(block, bl, bl2);
    }

    @NotNull
    public final String currIndentOf(int offset, boolean absolute, boolean plus2) {
        int p1 = offset;
        int p2 = offset;
        while (p1 > 0 && this.text.charAt(p1 - 1) != '\n') {
            if (CharsKt.isWhitespace((char)this.text.charAt(--p1))) continue;
            p2 = p1;
        }
        CharSequence charSequence = this.text;
        boolean bl = false;
        String theIndent = ((Object)charSequence.subSequence(p1, p2)).toString();
        if (absolute && p2 < offset) {
            theIndent = theIndent + StringFun.replicate$default(" ", offset - p2, null, null, 6, null);
        }
        if (plus2) {
            theIndent = theIndent + this.singleIndent;
        }
        return theIndent;
    }

    public static /* synthetic */ String currIndentOf$default(SqlFormattingContext sqlFormattingContext, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        return sqlFormattingContext.currIndentOf(n, bl, bl2);
    }

    public final boolean isInPosition1(@NotNull Block block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        TextRange textRange = block.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"block.textRange");
        return this.isInPosition1(textRange.getStartOffset());
    }

    public final boolean isInPosition1(int offset) {
        if (offset == 0) {
            return true;
        }
        if (offset < 0) {
            throw (Throwable)new IllegalArgumentException("Negative offset " + offset);
        }
        if (offset > this.text.length()) {
            return false;
        }
        char c2 = this.text.charAt(offset - 1);
        return c2 == '\n' || c2 == '\r';
    }

    public final boolean isDialect(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        return this.dialect.getDbms() == dbms;
    }

    private final int getRightMargin() {
        return this.settingsContainer.getDefaultRightMargin();
    }

    public final int getIndentSize() {
        return this.sql.getCorrespondedIndentOptions().INDENT_SIZE;
    }

    @NotNull
    public final CharSequence getText() {
        return this.text;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final CodeStyleSettings getSettingsContainer() {
        return this.settingsContainer;
    }

    @NotNull
    public final Class<? extends SqlCodeStyleSettings> getSettingsClass() {
        return this.settingsClass;
    }

    @NotNull
    public final FormattingMode getMode() {
        return this.mode;
    }

    @NotNull
    public final TextRange getInterestingRange() {
        return this.interestingRange;
    }

    public SqlFormattingContext(@NotNull CharSequence text2, @NotNull PsiFile file, @NotNull CodeStyleSettings settingsContainer, @NotNull Class<? extends SqlCodeStyleSettings> settingsClass, @NotNull FormattingMode mode, @NotNull TextRange interestingRange) {
        SqlFile sqlFile;
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)settingsContainer, (String)"settingsContainer");
        Intrinsics.checkParameterIsNotNull(settingsClass, (String)"settingsClass");
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        Intrinsics.checkParameterIsNotNull((Object)interestingRange, (String)"interestingRange");
        this.text = text2;
        this.file = file;
        this.settingsContainer = settingsContainer;
        this.settingsClass = settingsClass;
        this.mode = mode;
        this.interestingRange = interestingRange;
        PsiFile psiFile = this.file;
        if (!(psiFile instanceof SqlFile)) {
            psiFile = null;
        }
        if ((sqlFile = (SqlFile)psiFile) == null || (sqlFile = sqlFile.getSqlLanguage()) == null) {
            SqlLanguageDialect sqlLanguageDialect = SqlDialects.getGenericDialect();
            sqlFile = sqlLanguageDialect;
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlLanguageDialect, (String)"SqlDialects.getGenericDialect()");
        }
        this.dialect = sqlFile;
        this.knownDialect = Intrinsics.areEqual((Object)this.dialect, (Object)SqlDialects.getGenericDialect()) ^ true;
        this.sql = (SqlCodeStyleSettings)this.settingsContainer.getCustomSettings(this.settingsClass);
        CommonCodeStyleSettings commonCodeStyleSettings = this.sql.getCorrespondedCommonSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCodeStyleSettings, (String)"sql.correspondedCommonSettings");
        this.com = commonCodeStyleSettings;
        this.disabled = this.sql.DISABLE_FORMATTING;
        this.reformatting = this.mode == FormattingMode.REFORMAT && !this.disabled;
        this.justAdjust = !this.reformatting && !this.disabled;
        this.margin = this.getRightMargin();
        this.klb = this.com.KEEP_LINE_BREAKS || this.justAdjust;
        this.lengthThresholdMin = this.margin * 3 / 5;
        this.lengthThresholdMax = this.margin;
        Map map2 = SqlFormattingModelFunKt.getDIALECT_SPECIFIC_BLOCKS().get(this.dialect.getDbms());
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        this.dialectSpecificBlocks = map2;
        this.singleIndent = StringFun.replicate$default(" ", this.getIndentSize(), null, null, 6, null);
    }
}

