/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sqlite;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.sqlite.SqliteTokens;
import com.intellij.sql.dialects.sqlite.SqliteTypes;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqliteDialect
extends SqlLanguageDialectEx {
    public static final SqliteDialect INSTANCE = new SqliteDialect();

    public SqliteDialect() {
        super("SQLite");
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.SQLITE;
        if (dbms == null) {
            SqliteDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            SqliteDialect.$$$reportNull$$$0(1);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            SqliteDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            SqliteDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            SqliteDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable PsiElement element2, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            SqliteDialect.$$$reportNull$$$0(5);
        }
        return type == ObjectKind.VIRTUAL_TABLE && expectedTypes.contains(ObjectKind.TABLE);
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element2 == null) {
            SqliteDialect.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            SqliteDialect.$$$reportNull$$$0(7);
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_SQLITE_MASTER.name, resolve) && !processor.executeTarget(LazyData.RE_SQLITE_MASTER, element2, (SqlType)SqlTableTypeBase.EMPTY_TABLE, false, ResolveState.initial())) {
            return false;
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            if (!SqliteDialect.processReservedEntitiesWithTypeSimple(LazyData.RE_OID, this.integerType(), name2, element2, resolve, processor, true, false)) {
                return false;
            }
            if (!SqliteDialect.processReservedEntitiesWithTypeSimple(LazyData.RE_ROWID, this.integerType(), name2, element2, resolve, processor, true, false)) {
                return false;
            }
            if (!SqliteDialect.processReservedEntitiesWithTypeSimple(LazyData.RE_ROWID2, this.integerType(), name2, element2, resolve, processor, true, false)) {
                return false;
            }
        }
        if (processor.isExpected(ObjectKind.COLLATION) && element2 instanceof SqlReferenceExpression) {
            for (DasObject function2 : LazyData.COLLATE_FUNCTIONS.values()) {
                if (SqliteDialect.processReservedEntitiesWithTypeSimple(function2, SqlTypeFactory.REFERENCE, name2, element2, resolve, processor, false, false)) continue;
                return false;
            }
        }
        return super.processReservedEntitiesWithType(name2, element2, resolve, processor);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    @NotNull
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            SqliteDialect.$$$reportNull$$$0(8);
        }
        switch (cat) {
            case INTEGER: {
                if ("integer" == null) {
                    SqliteDialect.$$$reportNull$$$0(9);
                }
                return "integer";
            }
            case BOOLEAN: {
                if ("integer" == null) {
                    SqliteDialect.$$$reportNull$$$0(10);
                }
                return "integer";
            }
            case REAL: {
                if ("real" == null) {
                    SqliteDialect.$$$reportNull$$$0(11);
                }
                return "real";
            }
            case STRING: {
                if ("text" == null) {
                    SqliteDialect.$$$reportNull$$$0(12);
                }
                return "text";
            }
            case BYTES: {
                if ("blob" == null) {
                    SqliteDialect.$$$reportNull$$$0(13);
                }
                return "blob";
            }
            case ARRAY: {
                if ("blob" == null) {
                    SqliteDialect.$$$reportNull$$$0(14);
                }
                return "blob";
            }
        }
        if ("numeric" == null) {
            SqliteDialect.$$$reportNull$$$0(15);
        }
        return "numeric";
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            SqliteDialect.$$$reportNull$$$0(16);
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"int")) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                SqliteDialect.$$$reportNull$$$0(17);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"char")) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                SqliteDialect.$$$reportNull$$$0(18);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"clob")) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                SqliteDialect.$$$reportNull$$$0(19);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"text")) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                SqliteDialect.$$$reportNull$$$0(20);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"blob")) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                SqliteDialect.$$$reportNull$$$0(21);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"real")) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                SqliteDialect.$$$reportNull$$$0(22);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"floa")) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                SqliteDialect.$$$reportNull$$$0(23);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"doub")) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                SqliteDialect.$$$reportNull$$$0(24);
            }
            return category;
        }
        SqlType.Category category = SqlType.Category.UNKNOWN;
        if (category == null) {
            SqliteDialect.$$$reportNull$$$0(25);
        }
        return category;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            SqliteDialect.$$$reportNull$$$0(26);
        }
        String string = super.getNormalizedTypeName(this.getDefaultTypeName(this.getTypeCategoryByName(name2)));
        if (string == null) {
            SqliteDialect.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Override
    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        return type != ObjectKind.PACKAGE && super.shallResolve(o, type);
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, TreePatternUtils.create(Arrays.asList(ObjectName.plain((String)"main"), ObjectName.plain((String)"temp")), ObjectKind.SCHEMA, new TreePatternNode.Group[0])));
        if (treePattern == null) {
            SqliteDialect.$$$reportNull$$$0(28);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            SqliteDialect.$$$reportNull$$$0(29);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern, dsNames, Arrays.asList(ObjectName.plain((String)"main"), ObjectName.plain((String)"temp")), true, SqlImportUtil.DATA_SOURCE, ObjectKind.SCHEMA);
        if (treePattern == null) {
            SqliteDialect.$$$reportNull$$$0(30);
        }
        return treePattern;
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 26: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 26: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/sqlite/SqliteDialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 26: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/sqlite/SqliteDialect";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTypeName";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 26: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(SqliteTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;
        static final TokenSet ourClosingTokens;
        static final Map<String, DasObject> COLLATE_FUNCTIONS;
        static final ReservedEntity RE_SQLITE_MASTER;
        static final ReservedEntity RE_OID;
        static final ReservedEntity RE_ROWID;
        static final ReservedEntity RE_ROWID2;
        private static final EnterHandlerDelegate ENTER_HANDLER;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqliteTypes.SQLITE_MATCH, SqliteTypes.SQLITE_REGEXP, SqliteTypes.SQLITE_GLOB, SqlTokens.SQL_OP_EQEQ, SqliteTypes.SQLITE_ISNULL, SqliteTypes.SQLITE_NOTNULL});
            ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQLITE_DOT_END})});
            COLLATE_FUNCTIONS = SqlDialectImplUtil.buildEntities(ObjectKind.COLLATION, "nocase", "rtrim", "binary");
            RE_SQLITE_MASTER = new ReservedEntity("sqlite_master", ObjectKind.TABLE);
            RE_OID = new ReservedEntity("OID", ObjectKind.COLUMN);
            RE_ROWID = new ReservedEntity("ROWID", ObjectKind.COLUMN);
            RE_ROWID2 = new ReservedEntity("_ROWID_", ObjectKind.COLUMN);
            ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_SEMICOLON}).mask(true, false))));
        }
    }
}

