/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mssql.MsElementTypes;
import com.intellij.sql.dialects.mssql.MsTokens;
import com.intellij.sql.dialects.mssql.MsTypes;
import com.intellij.sql.dialects.mssql.dataFlow.MsDFABuildingVisitor;
import com.intellij.sql.dialects.mssql.refactoring.MsExtractFunctionHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsDialect
extends SqlLanguageDialectEx {
    public static final MsDialect INSTANCE = new MsDialect();

    public MsDialect() {
        super("TSQL");
    }

    @Override
    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, "hierarchyid", "hierarchyid", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "xml", "xml", (SqlLanguageDialectEx)this);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.MSSQL;
        if (dbms == null) {
            MsDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            MsDialect.$$$reportNull$$$0(1);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            MsDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            MsDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            MsDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element2 == null) {
            MsDialect.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            MsDialect.$$$reportNull$$$0(6);
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_ACTION.name, resolve) && !processor.executeTarget(LazyData.RE_ACTION, element2, this.stringType(), false, ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_IDENTITY.name, resolve) && !processor.executeTarget(LazyData.RE_IDENTITY, element2, this.stringType(), false, ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_ROWGUID.name, resolve) && !processor.executeTarget(LazyData.RE_ROWGUID, element2, this.stringType(), false, ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_XML.name, resolve) && !processor.executeTarget(LazyData.RE_XML, element2, null, false, ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_ROWVERSION.name, resolve) && !processor.executeTarget(LazyData.RE_ROWVERSION, element2, null, false, ResolveState.initial())) {
            return false;
        }
        return super.processReservedEntitiesWithType(name2, element2, resolve, processor);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName) {
        ObjectKind type;
        PsiElement parent2;
        if (identifier == null) {
            MsDialect.$$$reportNull$$$0(7);
        }
        if (newElementName == null) {
            MsDialect.$$$reportNull$$$0(8);
        }
        Object object = (parent2 = identifier.getParent()) instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent2).getReferenceElementType().getTargetKind() : (type = parent2 instanceof SqlDefinition ? ((SqlDefinition)parent2).getKind() : null);
        if (type == ObjectKind.VARIABLE) {
            return newElementName.replace(' ', '_');
        }
        return super.quoteIdentifier(identifier, newElementName);
    }

    @Override
    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        if (type == SqlDbElementType.ANY && MsDialect.isExecArg(o)) {
            return false;
        }
        return MsElementTypes.Kinds.FILEGROUP != type && MsElementTypes.Kinds.FILE != type && super.shallResolve(o, type);
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        super.getParentDbTypes(result2, type);
        if (type == ObjectKind.INDEX) {
            result2.add((ObjectKind)ObjectKind.TABLE);
        }
        if (type == ObjectKind.ROUTINE) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return result2;
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            MsDialect.$$$reportNull$$$0(9);
        }
        return !this.getKeywords().contains(ref);
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            MsDialect.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        List<ObjectName> schemas2 = MsDialect.getSchemaNames(dataSource);
        ObjectName dbname = MsDialect.getDatabaseName(dataSource);
        DasNamespace namespace = MsDialect.getDefaultNamespace(dataSource, dbname);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, namespace.getKind() == ObjectKind.SCHEMA ? null : TreePatternUtils.create(schemas2, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                MsDialect.$$$reportNull$$$0(11);
            }
            return treePattern;
        }
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbname, TreePatternUtils.create(schemas2, ObjectKind.SCHEMA, new TreePatternNode.Group[0])))));
        if (treePattern == null) {
            MsDialect.$$$reportNull$$$0(12);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        TreePatternNode.Group[] schemas2 = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(MsDialect.getSchemaNames(dataSource), ObjectKind.SCHEMA, new TreePatternNode.Group[0])});
        TreePatternNode.Group[] databases = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(MsDialect.getDatabaseName(dataSource), ObjectKind.DATABASE, schemas2)});
        TreePattern treePattern = SqlDialectImplUtil.forcedContextExpandedToSchemas(dataSource, this.getDbms(), searchPath, schemas2, databases);
        if (treePattern == null) {
            MsDialect.$$$reportNull$$$0(13);
        }
        return treePattern;
    }

    @Override
    protected TreePattern createRefPattern(@NotNull TreePattern prev, @NotNull SqlReferenceExpression ref) {
        if (prev == null) {
            MsDialect.$$$reportNull$$$0(14);
        }
        if (ref == null) {
            MsDialect.$$$reportNull$$$0(15);
        }
        return SqlDialectImplUtil.refPatternExpandedToSchema(prev, ref, this);
    }

    @Override
    @NotNull
    public TreePattern srcFilePattern(@Nullable DbDataSource dataSource, @NotNull SearchPath searchPath) {
        if (searchPath == null) {
            MsDialect.$$$reportNull$$$0(16);
        }
        TreePattern treePattern = this.forcedContextPattern(dataSource, searchPath);
        if (treePattern == null) {
            MsDialect.$$$reportNull$$$0(17);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public ObjectKind unaliased(@NotNull ObjectKind kind) {
        if (kind == null) {
            MsDialect.$$$reportNull$$$0(18);
        }
        if (kind == ObjectKind.OBJECT_TYPE) {
            ObjectKind objectKind = ObjectKind.TABLE_TYPE;
            if (objectKind == null) {
                MsDialect.$$$reportNull$$$0(19);
            }
            return objectKind;
        }
        ObjectKind objectKind = super.unaliased(kind);
        if (objectKind == null) {
            MsDialect.$$$reportNull$$$0(20);
        }
        return objectKind;
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            MsDialect.$$$reportNull$$$0(21);
        }
        switch (cat) {
            case INTEGER: {
                return "int";
            }
            case REAL: {
                return "numeric";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "int";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "datetimeoffset";
            }
            case BYTES: {
                return "binary";
            }
            case TABLE: {
                return "table";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            MsDialect.$$$reportNull$$$0(22);
        }
        if ((name2 = super.getNormalizedTypeName(name2)).equals("integer")) {
            if ("int" == null) {
                MsDialect.$$$reportNull$$$0(23);
            }
            return "int";
        }
        if (name2.equals("dec")) {
            if ("decimal" == null) {
                MsDialect.$$$reportNull$$$0(24);
            }
            return "decimal";
        }
        if (name2.equals("binary varying")) {
            if ("varbinary" == null) {
                MsDialect.$$$reportNull$$$0(25);
            }
            return "varbinary";
        }
        if (name2.equals("double precision")) {
            if ("float" == null) {
                MsDialect.$$$reportNull$$$0(26);
            }
            return "float";
        }
        if (name2.equals("character")) {
            if ("char" == null) {
                MsDialect.$$$reportNull$$$0(27);
            }
            return "char";
        }
        if (name2.equals("char varying")) {
            if ("varchar" == null) {
                MsDialect.$$$reportNull$$$0(28);
            }
            return "varchar";
        }
        if (name2.equals("character varying")) {
            if ("varchar" == null) {
                MsDialect.$$$reportNull$$$0(29);
            }
            return "varchar";
        }
        if (name2.equals("national char")) {
            if ("nchar" == null) {
                MsDialect.$$$reportNull$$$0(30);
            }
            return "nchar";
        }
        if (name2.equals("national character")) {
            if ("nchar" == null) {
                MsDialect.$$$reportNull$$$0(31);
            }
            return "nchar";
        }
        if (name2.equals("national char varying")) {
            if ("nvarchar" == null) {
                MsDialect.$$$reportNull$$$0(32);
            }
            return "nvarchar";
        }
        if (name2.equals("national character varying")) {
            if ("nvarchar" == null) {
                MsDialect.$$$reportNull$$$0(33);
            }
            return "nvarchar";
        }
        if (name2.equals("national text")) {
            if ("ntext" == null) {
                MsDialect.$$$reportNull$$$0(34);
            }
            return "ntext";
        }
        if (name2.equals("rowversion")) {
            if ("timestamp" == null) {
                MsDialect.$$$reportNull$$$0(35);
            }
            return "timestamp";
        }
        String string = name2;
        if (string == null) {
            MsDialect.$$$reportNull$$$0(36);
        }
        return string;
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            MsDialect.$$$reportNull$$$0(37);
        }
        if ("money".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                MsDialect.$$$reportNull$$$0(38);
            }
            return category;
        }
        if ("smallmoney".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                MsDialect.$$$reportNull$$$0(39);
            }
            return category;
        }
        if ("datetimeoffset".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTERVAL;
            if (category == null) {
                MsDialect.$$$reportNull$$$0(40);
            }
            return category;
        }
        if ("sysname".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                MsDialect.$$$reportNull$$$0(41);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            MsDialect.$$$reportNull$$$0(42);
        }
        return category;
    }

    @Override
    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        MsDFABuildingVisitor msDFABuildingVisitor = new MsDFABuildingVisitor(this);
        if (msDFABuildingVisitor == null) {
            MsDialect.$$$reportNull$$$0(43);
        }
        return msDFABuildingVisitor;
    }

    @Override
    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return MsExtractFunctionHelper.INSTANCE;
    }

    public static boolean isExecArg(@Nullable SqlReferenceExpression o) {
        if (o == null) {
            return false;
        }
        PsiElement top = (PsiElement)SqlImplUtil.sqlParents((PsiElement)o).skipWhile(x -> x == o || x instanceof SqlNamedParameterValueExpression || x instanceof SqlExpressionList || x instanceof SqlFunctionCallExpression).first();
        return top instanceof SqlStatement;
    }

    private static ObjectName getDatabaseName(@Nullable DbDataSource dataSource) {
        return ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtil.getDatabaseName(SqlImportUtil.getConnectionConfig(dataSource)), (Object)"master")));
    }

    @NotNull
    private static List<ObjectName> getSchemaNames(@Nullable DbDataSource dataSource) {
        List schemas2 = ContainerUtil.newSmartList((Object)ObjectName.quoted((String)"dbo"));
        String username = SqlDialectImplUtil.getUserName(SqlImportUtil.getConnectionConfig(dataSource));
        if (username != null) {
            schemas2.add(ObjectName.plain((String)username));
        }
        List list = schemas2;
        if (list == null) {
            MsDialect.$$$reportNull$$$0(44);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 37: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 37: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mssql/MsDialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mssql/MsDialect";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "srcFilePattern";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "unaliased";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createDFAVisitor";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createRefPattern";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "srcFilePattern";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unaliased";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 37: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(MsTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final TokenSet ourClosingTokens;
        static final Set<IElementType> ourSupportedOperators;
        static final ReservedEntity RE_ACTION;
        static final ReservedEntity RE_IDENTITY;
        static final ReservedEntity RE_ROWGUID;
        static final ReservedEntity RE_XML;
        static final ReservedEntity RE_ROWVERSION;
        private static final EnterHandlerDelegate ENTER_HANDLER;
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlCommonTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{MsTypes.MSSQL_GO})});
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_OP_CONCAT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_BITWISE_NOT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT_LT, SqlElementTypes.SQL_OP_NOT_GT, SqlElementTypes.SQL_OP_PLUS_EQ, SqlElementTypes.SQL_OP_MINUS_EQ, SqlElementTypes.SQL_OP_MUL_EQ, SqlElementTypes.SQL_OP_DIV_EQ, SqlElementTypes.SQL_OP_MODULO_EQ, SqlElementTypes.SQL_OP_BITWISE_AND_EQ, SqlElementTypes.SQL_OP_BITWISE_OR_EQ, SqlElementTypes.SQL_OP_BITWISE_XOR_EQ});
            RE_ACTION = new ReservedEntity("$action", ObjectKind.COLUMN);
            RE_IDENTITY = new ReservedEntity("$IDENTITY", ObjectKind.COLUMN);
            RE_ROWGUID = new ReservedEntity("$ROWGUID", ObjectKind.COLUMN);
            RE_XML = new ReservedEntity("XML", ObjectKind.OBJECT_TYPE);
            RE_ROWVERSION = new ReservedEntity("rowversion", ObjectKind.OBJECT_TYPE);
            ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_SEMICOLON}).mask(true, false)), new SubstitutionDescriptorImpl(new IElementType[]{MsTypes.MSSQL_TRY, MsElementTypes.Misc.MSSQL_TRY_CATCH_STATEMENT}, "", "end try\nbegin catch\nend catch", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(MsTypes.MSSQL_TRY).opt(new IElementType[]{MsElementTypes.Misc.MSSQL_CATCH_CLAUSE, SqlElementTypes.SQL_SEMICOLON}).build()), new SubstitutionDescriptorImpl(new IElementType[]{MsTypes.MSSQL_CATCH, MsElementTypes.Misc.MSSQL_CATCH_CLAUSE}, "", "end catch", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, MsTypes.MSSQL_CATCH, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false))));
            MAJOR_CHILD_KINDS = Collections.singletonList(ObjectKind.TRIGGER);
        }
    }
}

